<?php
get_header();
$clinicmaster_option = getDZThemeReduxOption();

$page_title              = !empty($clinicmaster_option['page_title']) ? $clinicmaster_option['page_title']    : '';
$show_sidebar            =  isset($clinicmaster_option['show_sidebar']) ? $clinicmaster_option['show_sidebar'] : true;
$sidebar                 = !empty($clinicmaster_option['sidebar']) ? $clinicmaster_option['sidebar']          : '';
$layout                  = !empty($clinicmaster_option['layout']) ? $clinicmaster_option['layout']            : '';
$disable_ajax_pagination = !empty($clinicmaster_option['disable_ajax_pagination']) ? $clinicmaster_option['disable_ajax_pagination']  : '';
$sidebar_class 	= !empty($clinicmaster_option['sidebar_bg_color']) ? $clinicmaster_option['sidebar_bg_color']: '';



$queried_object_data = $wp_query;

$total_post_count = $wp_query->found_posts;
$page_title = (!empty($queried_object_data->query_vars['s'])) ? $page_title . '<span>' . $queried_object_data->query_vars['s'] . '</span>' : $page_title;
$padding_clas = '';
$layout = (!$show_sidebar) ? 'full' : $layout;
if ($layout == 'full' || !is_active_sidebar($sidebar) || !clinicmaster_is_theme_sidebar_active()) {
	$layout_class = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 ';
} else {
	if($sidebar_class != 'dz-medical'){
		$layout_class = ' col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12  ';
		$sid_class = 'col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12';
	}else{
		$padding_clas = 'p-0';
		$layout_class = 'col-xl-9 col-lg-12 m-b30 pe-xl-5 ';
		$sid_class = 'col-xl-3 col-lg-12 ';
	}
}

set_query_var('queried_object_data', $queried_object_data);
clinicmaster_get_banner();
?>

<div class="content-inner bg-light">
	<div class="container">
		<div class="row">
			<?php if ($show_sidebar && $layout == 'left' && is_active_sidebar($sidebar)  && clinicmaster_is_theme_sidebar_active()) {  ?>
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top @@dir m-b30 <?php echo esc_attr($sidebar_class .' '.$padding_clas); ?>">
						<?php dynamic_sidebar($sidebar); ?>
					</aside>
				</div>
			<?php } ?>

			<div class="<?php echo esc_attr($layout_class); ?>">
				<div class="row">
					<div class="col-lg-12 wow fadeInUp" data-wow-duration="2s" data-wow-delay="0.4s">
						<div class="search-bx m-b50">
							<?php if (!have_posts()) { ?>
								<div class="section-head text-center">
									<h4 class="dz-title">
										<?php esc_html_e('Nothing Found', 'clinicmaster'); ?>
									</h4>

									<p>
										<?php esc_html_e('If you are not happy with the results, please do another search.', 'clinicmaster'); ?>
									</p>
								</div>
							<?php } ?>
							<?php get_search_form(); ?>
							
						</div>
					</div>
				</div>

				<?php
				if (have_posts()) {
					if ($disable_ajax_pagination) {
						get_template_part('dz-inc/elements/search_page_ajax_posts_element');
					} else {
						get_template_part('dz-inc/elements/search_page_pagination_posts_element');
					}
				}
				?>
			</div>

			<?php if ($show_sidebar && $layout == 'right' && is_active_sidebar($sidebar)  && clinicmaster_is_theme_sidebar_active()) {  ?>
				<div class="<?php echo esc_attr($sid_class); ?>">
					<aside class="side-bar sticky-top @@dir m-b30  <?php echo esc_attr($sidebar_class .' '.$padding_clas); ?>">
						<?php dynamic_sidebar($sidebar); ?>
					</aside>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php
wp_reset_postdata();
get_footer();
?>