<?php 
  $post_id = get_the_ID();
  $categories = get_the_category($post_id);
  $related_post_on = clinicmaster_get_opt('related_post_on',false);
  $social_sharing = clinicmaster_get_opt('social_sharing_on_post');
  if ($categories) {
    
    $category_ids = array();
    
    foreach($categories as $individual_category){ 
      $category_ids[] = $individual_category->term_id;
	  
    }
    
    $args = array(
		'category__in'     => $category_ids,
		'post__not_in'     => array($post_id),
		'posts_per_page'   => 2,
		'ignore_sticky_posts' => 1,
		'orderby' => 'rand',		
    );
    $args['meta_query'] = array(
		array(
    'key' => '_thumbnail_id',
    'compare' => 'EXISTS'
		),
    );
    
    $related_query = new wp_query( $args );
    if( $related_query->have_posts() ) { 
      
     
    if($related_post_on){
    ?>
		<div class="row extra-blog style-1">
			<div class="widget-title">
				<h5 class="title">
					<?php echo esc_html__('Related Blogs','clinicmaster');?>
				</h5>
				
			</div>
		
			<?php 
			  $count=1;
			  while( $related_query->have_posts() ) {
				$related_query->the_post();
				$post_title = clinicmaster_trim(get_the_title(), 6);
				
				$excerpt = get_the_excerpt();
				$content = get_the_content();
				
				$post_desc = clinicmaster_short_description($excerpt, $content, 20);
					
				$author_name = get_the_author_meta('display_name', $post->post_author);
				$author_name = explode(" ",$author_name);
				$no_image_class = '';
				$class = ($count==1) ? 'm-sm-b30':'';
				if(!has_post_thumbnail())
				{
				  $no_image_class = 'no-image-box';	
				}	
			?>
			
				
				<div class="col-md-6 <?php echo esc_attr($class); ?>">
					
					<div class="dz-card blog-grid style-4">
						<?php if(has_post_thumbnail()) { ?>
							<div class="dz-media <?php echo esc_attr($no_image_class); ?>">					
								<?php the_post_thumbnail('medium'); ?>
							</div>
						<?php } ?>
						<div class="dz-info ">
							<div class="dz-meta">
								<ul>
									<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
								</ul>
							</div>
							<h5 class="dz-title">
								<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
							</h5>
							<?php 
							if(!empty($post_desc)){ ?>
							
								<p>
									<?php echo esc_html( $post_desc );?>
								</p>
							
							<?php } ?>
							<a href="<?php echo esc_url(get_permalink()); ?>" class="btn-link icon-link-hover-end"><?php echo esc_html__('Read More', 'clinicmaster'); ?> 
								<i class="feather icon-arrow-right"></i>
							</a>
						</div>
					</div>
					
				</div>
			<?php ++$count; } ?>
		</div>
		<?php
    } }
  }
wp_reset_postdata();?>