<?php
$query_args = array(
	'post_type' => 'dz_testimonial',
	'post_status' => 'publish',
	'posts_per_page'    => $testimonial_slider_3_element_no_of_posts,
	'orderby' => $testimonial_slider_3_element_orderby,
	'order' => $testimonial_slider_3_element_order,
	'ignore_sticky_posts' => true,
);

$testimonial_slider_3_element_image_preference = !empty($testimonial_slider_3_element_image_preference) ? $testimonial_slider_3_element_image_preference : 'all_posts';

if ($testimonial_slider_3_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($testimonial_slider_3_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}


if (!empty($testimonial_slider_3_element_posts_in_categories) && !empty($testimonial_slider_3_element_posts_in_categories[0])) {

	$testimonial_slider_3_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($testimonial_slider_3_element_posts_in_categories, 'testimonial_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_slider_3_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$allowed_html_tags = clinicmaster_allowed_html_tag();
$element_content = !empty($testimonial_slider_3_element_content) ? $testimonial_slider_3_element_content : 'content-inner'; 
$content_text_limit = $testimonial_slider_3_element_text_limit;
$query = new WP_Query($query_args);

if($testimonial_slider_3_element_style == 'style_2'){
	$addclass = 'bg-light';
	$addclass2 = 'bg-white';
	$addstyle = 'style-5';
}else{
	$addclass = 'gradient-primary';
	$addclass2 = 'bg-light';
	$addstyle = 'style-3';
    
}



if (!empty($query->have_posts())) {
?>
 
<section class="<?php echo esc_attr( $element_content .' '. $addclass ); ?>  overflow-hidden">
	<div class="container">
		<div class="section-head <?php echo $addstyle ; ?> row align-items-end justify-content-between m-b30">
			<?php if(!empty($testimonial_slider_3_element_title)){ ?>
				
				<div class="col-xl-5 col-lg-6 m-b10">
				<div class="sub-title wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s" style="visibility: visible; animation-duration: 0.8s; animation-delay: 0.2s; animation-name: fadeInUp;">
					
									<?php if(!empty($testimonial_slider_3_element_subtitle_icon['id'])){ ?>
										<img src="<?php echo esc_url($testimonial_slider_3_element_subtitle_icon['url']); ?>" alt="" srcset="">
									<?php } ?>
									<?php if(!empty($testimonial_slider_3_element_subtitle)){ echo $testimonial_slider_3_element_subtitle; }?>			

					</div>
					<h2 class="title m-b0"><?php echo esc_html($testimonial_slider_3_element_title); ?></h2>
				</div>
			<?php } ?>
			<div class="col-xl-6 col-lg-6 m-b10">
				<div class="float-xl-end">
					<div class="d-flex align-items-center m-b15">
					
						
							<div class="info-widget style-12 m-r10 <?php echo $addclass2; ?>">
								<?php if(!empty($testimonial_slider_3_element_gallery_img)){
									$gallery = $testimonial_slider_3_element_gallery_img;
									?>
									<div class="avatar-group">
									<?php foreach($gallery as $val){ ?>
											<?php echo wp_get_attachment_image( $val['id'], 'thumbnail','', ['class' => 'avatar rounded-circle avatar-md border border-white border-2']);  ?>
																
									<?php } ?>
									</div>
									<?php }
									if(!empty($testimonial_slider_3_element_gallery_text)){ ?>
									<div class="clearfix">
										<span class="font-20"><?php echo esc_html($testimonial_slider_3_element_gallery_text); ?></span>
									</div>
									<?php } ?>
							</div>
							<?php if(!empty($testimonial_slider_3_element_link)){ ?>
								<a href="<?php echo esc_url($testimonial_slider_3_element_link); ?>" class="btn btn-square btn-xl btn-primary btn-rounded">
								<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.75 21.25L21.25 8.75" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								<path d="M8.75 8.75H21.25V21.25" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
							</svg>
								</a>
							<?php } ?>
						
					</div>
					
					<div class="widget-rating3">
						<?php if(!empty($testimonial_slider_3_element_star_rating)){ ?>
						<ul class="star-list">
							<?php 
								$star_count = $testimonial_slider_3_element_star_rating;
								for($star=1;$star<=5;$star++){ 
										if($star<=$star_count){
									echo "<li><i class='fa fa-star'></i></li>";
									}
									else{
										echo "<li><i class='fa fa-star-o'></i></li>";
									}
								}		
							?>
							
						</ul>
						<?php } 
						if(!empty($testimonial_slider_3_element_rating)){ ?>
							<span class="rating">(<?php echo esc_html($testimonial_slider_3_element_rating); ?>)</span>
						<?php }
						if(!empty($testimonial_slider_3_element_rating_text)){ ?>
							<span class="text"><?php echo esc_html($testimonial_slider_3_element_rating_text); ?></span>
						<?php } ?>
					</div>
				</div> 
			</div> 
		</div>
	</div>
	<div class="container-left">
		<div class="swiper testimonial-swiper2 testimonial-wrapper2">
			<div class="swiper-wrapper">
				<?php

				while ($query->have_posts()) {
					$query->the_post();
					global $post;
					$post_id = $post->ID;
					$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
					$testimonial_designation = get_post_meta($post_id, 'testimonial_designation', true);	
					$rating_title = get_post_meta($post_id, 'testimonial_rating_title', true);	
					$youtube_text = get_post_meta($post_id, 'testimonial_youtube_text', true);	
					$youtube_link = get_post_meta($post_id, 'testimonial_youtube_link', true);	
					$testimonial_rating = get_post_meta($post_id, 'testimonial_rating', true);	
					$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);

				?>
				<div class="swiper-slide">
					<div class="testimonial-2 <?php echo ($testimonial_slider_3_element_style == 'style_2') ? 'list' : ''?>">
						
						<div class="testimonial-media">
							<?php if(has_post_thumbnail($post)){
								$img = get_the_post_thumbnail_url($post, 'medium'); 
								?>
								<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
								<?php if($testimonial_slider_3_element_style == 'style_2'){?>
								<a href="<?php echo esc_url($youtube_link); ?>" class="popup-youtube video-btn bg-primary">
									<i class="fa fa-play"></i>
								</a>
							<?php }} ?>
							<?php if($testimonial_slider_3_element_style == 'style_1' && !empty($youtube_text) && !empty($youtube_link)){ ?> 
							<div class="video-bx1 video-lg">
								<a href="<?php echo esc_url($youtube_link); ?>" class="popup-youtube video-btn bg-primary">
									<i class="fa fa-play"></i>
								</a>
								<span class="text-black"><?php echo esc_html($youtube_text); ?></span>
								<a href="javascript:void(0);" class="btn-link">
									<i class="feather icon-chevron-right"></i>
								</a>
							</div>
							<?php } ?>
						</div>
						<div class="testimonial-detail">
							<div class="testimonial-head">
								<?php if(!empty($testimonial_rating)){ ?>
									<ul class="star-list">
										<?php 
										$star_count = $testimonial_rating;
										for($star=1;$star<=5;$star++){ 
												if($star<=$star_count){
											echo "<li><i class='fa fa-star'></i></li>";
											}
											else{
												echo "<li><i class='fa fa-star-o'></i></li>";
											}
										}		
										?>
									</ul>	
									<?php } ?>
								<?php if(!empty($rating_title)){ ?>
									<h3 class="title"><?php echo esc_html($rating_title); ?> </h3>
								<?php } ?>
								
							</div>
							<?php if(!empty($short_description)){ ?>
							<div class="testimonial-contant">
								<div class="testimonial-text">
									<p><?php echo esc_html($short_description); ?></p>
								</div>
							</div>
							<?php } ?>
							
							<div class="testimonial-info">
							<?php if(has_post_thumbnail($post)){
								$img = get_the_post_thumbnail_url($post, 'thumbnail '); 
								?>
								<div class="dz-media">
									<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
								</div>
							<?php } ?>
									
								<div class="clearfix">
									<?php if(!empty($post_title)){ ?>
										<h5 class="testimonial-name"><?php echo esc_html($post_title); ?></h5>
									<?php }
									if(!empty($testimonial_designation)){ ?>
										<span class="testimonial-position"><?php echo esc_html($testimonial_designation); ?></span>
									<?php } ?>
								</div>		
									
							</div>		
						</div>
					</div>
				</div>
				<?php } ?>
				
			</div>
			<div class="slider__pagination testimonial-slider__pagination2">
				<div class="slider__current testimonial-slider__current">1</div>
				<div class="swiper-progress testimonial-pagination-swiper2"></div>
				<div class="slider__total testimonial-slider__total">1</div>
			</div>
		</div>
	</div>	
</section>

<?php } ?>