<?php
$query_args = array(
	'post_type' => 'dz_testimonial',
	'post_status' => 'publish',
	'posts_per_page'    => $testimonial_slider_1_element_no_of_posts,
	'orderby' => $testimonial_slider_1_element_orderby,
	'order' => $testimonial_slider_1_element_order,
	'ignore_sticky_posts' => true,
);

$testimonial_slider_1_element_image_preference = !empty($testimonial_slider_1_element_image_preference) ? $testimonial_slider_1_element_image_preference : 'all_posts';

if ($testimonial_slider_1_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($testimonial_slider_1_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}


if (!empty($testimonial_slider_1_element_posts_in_categories) && !empty($testimonial_slider_1_element_posts_in_categories[0])) {

	$testimonial_slider_1_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($testimonial_slider_1_element_posts_in_categories, 'testimonial_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_slider_1_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$allowed_html_tags = clinicmaster_allowed_html_tag();
$element_content = !empty($testimonial_slider_1_element_content) ? $testimonial_slider_1_element_content : 'content-inner-1'; 
$style = !empty($testimonial_slider_1_element_style) ? $testimonial_slider_1_element_style : 'style_1'; 
$bg_img = $testimonial_slider_1_element_bg_image;
$content_text_limit = $testimonial_slider_1_element_text_limit;
$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {
if($style == 'style_1'){
?>
	<section class="clearfix p-t50 bg-secondary bg-opacity-90 overflow-hidden overlay-secondary-light" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-repeat: no-repeat; background-position: right center; background-size: cover;"<?php } ?>>
		<div class="container">
			<div class="row content-wrapper style-2 justify-content-center">
				<div class="col-xl-6 col-lg-10 align-self-center m-b30 order-xl-1">
					<?php if(!empty($testimonial_slider_1_element_title) || !empty($testimonial_slider_1_element_subtitle)){ ?>
						<div class="section-head style-1 m-b30 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s">
							<?php if(!empty($testimonial_slider_1_element_subtitle)){ ?>
								<span class="sub-title text-primary sub-title-icon">
									<?php if(!empty($testimonial_slider_1_element_icon_img['id'])){ ?>
										<img src="<?php echo esc_url($testimonial_slider_1_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
									<?php } ?>
									<?php echo esc_html($testimonial_slider_1_element_subtitle); ?>
								</span>
							<?php } 
							if(!empty($testimonial_slider_1_element_title)){ ?>
							<h2 class="title text-white m-b0"><?php echo esc_html($testimonial_slider_1_element_title); ?></h2>
							<?php } ?>
						</div>
					<?php } ?>
					<div class="swiper-btn-center-lr wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.8s">
						<div class="swiper testimonial-swiper1">
							<div class="swiper-wrapper">
								<?php

								while ($query->have_posts()) {
									$query->the_post();
									global $post;
									$post_id = $post->ID;
									$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
									$testimonial_designation = get_post_meta($post_id, 'testimonial_designation', true);	
									$rating_title = get_post_meta($post_id, 'testimonial_rating_title', true);	
									$youtube_text = get_post_meta($post_id, 'testimonial_youtube_text', true);	
									$youtube_link = get_post_meta($post_id, 'testimonial_youtube_link', true);	
									$testimonial_rating = get_post_meta($post_id, 'testimonial_rating', true);	
									$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);

								?>
								<div class="swiper-slide">
									<div class="testimonial-1 shadow-md">
										<div class="dz-media">
											<div class="media-inner">
												<?php if(has_post_thumbnail($post)){
													$img = get_the_post_thumbnail_url($post, 'medium'); 
													?>
													<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
												<?php } ?>
												<?php if(!empty($youtube_link)){ ?>
													<a href="<?php echo esc_url($youtube_link); ?>" class="popup-youtube video-btn bg-primary">
														<i class="fa fa-play"></i>
													</a>
												<?php } ?>
											</div>
											<div class="testimonial-info">
												<?php if(!empty($post_title)){ ?>
													<h5 class="testimonial-name"><?php echo esc_html($post_title); ?></h5>
												<?php }
												if(!empty($testimonial_designation)){ ?>
													<span class="testimonial-position"><?php echo esc_html($testimonial_designation); ?></span>
												<?php } ?>
											</div>
										</div>
										<div class="testimonial-detail">
											<div class="testimonial-text">
												<?php if(!empty($rating_title)){ ?>
													<h3 class="title text-primary"><?php echo esc_html($rating_title); ?></h3>
												<?php }
												if(!empty($short_description)){ ?>
													<p><?php echo esc_html($short_description); ?></p>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
								
							</div>
						</div>
						<div class="swiper1-button-prev btn-prev">
							<svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M39.5833 25H10.4167" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M25 10.4165L10.4167 24.9998L25 39.5832" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</div>
						<div class="swiper1-button-next btn-next">
							<svg width="51" height="50" viewBox="0 0 51 50" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M10.6027 25H40.2902" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M25.4464 10.4165L40.2902 24.9998L25.4464 39.5832" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div class="content-media">
					<?php if(!empty($testimonial_slider_1_element_image['id'])){ ?>
						<div class="dz-media">
							<img src="<?php echo esc_url($testimonial_slider_1_element_image['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
						</div>
						<div class="circle-wrapper" data-bottom-top="transform: translateY(50px)" data-top-bottom="transform: translateY(-50px)">
							<span class="circle1">
								<span></span>
								<span></span>
								<span></span>
							</span>
							<span class="circle2">
								<span></span>
								<span></span>
								<span></span>
							</span>
						</div>
					<?php } ?>
						<div class="item1" data-bottom-top="transform: translateY(50px)" data-top-bottom="transform: translateY(-50px)">
							<div class="info-widget style-1 move-3">
							
								<?php if(!empty($testimonial_slider_1_element_gallery_img)){
									$gallery = $testimonial_slider_1_element_gallery_img;
									?>
									<div class="avatar-group">
									<?php foreach($gallery as $val){ ?>
											<?php echo wp_get_attachment_image( $val['id'], 'thumbnail','', ['class' => 'avatar rounded-circle avatar-sm border border-white border-']);  ?>
																
									<?php } ?>
									</div>
									<?php } 
									if(!empty($testimonial_slider_1_element_gallery_text) || !empty($testimonial_slider_1_element_counter_number)){ ?>
										<div class="clearfix ms-2">
											<?php if(!empty($testimonial_slider_1_element_counter_number)){ ?>
												<span class="number text-primary"><?php echo esc_html($testimonial_slider_1_element_counter_number); ?></span>
											<?php }
											if(!empty($testimonial_slider_1_element_gallery_text)){ ?>
												<span><?php echo esc_html($testimonial_slider_1_element_gallery_text); ?></span>
											<?php } ?>
										</div>
									<?php } ?>
								
							</div>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</section>
<?php }elseif($style == 'style_2'){ ?>	
	
	<section class="<?php echo esc_attr($element_content); ?> bg-light bg-opacity-50">
			<div class="container">
				<div class="row g-4 align-items-center content-wrapper style-19 m-b30">
					<div class="col-lg-6">
						<div class="swiper testimonial-thumb-swiper4">
							<div class="swiper-wrapper">
								<?php
									while ($query->have_posts()) {
										$query->the_post();
										global $post;
										$post_id = $post->ID;
										$youtube_text = get_post_meta($post_id, 'testimonial_youtube_text', true);	
										$youtube_link = get_post_meta($post_id, 'testimonial_youtube_link', true);	
										
								?>
								<div class="swiper-slide">
									<div class="content-media">
										<?php if(has_post_thumbnail($post)){
											$img = get_the_post_thumbnail_url($post, 'medium'); 
											?>
											<img src="<?php echo esc_url($img); ?>" class="radius-xl shadow-sm object-fit-cover" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
										<?php } ?>
										<?php if(!empty($youtube_link)){ ?>
										<div class="video-bx3 video-bx">
											<a href="<?php echo esc_url($youtube_link); ?>" class="popup-youtube video-btn">
												<i class="fa fa-play"></i>
											</a>
										</div>
										<?php } ?>
									</div>	
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
					<div class="col-lg-6 overflow-hidden">
						<?php if(!empty($testimonial_slider_1_element_title) || !empty($testimonial_slider_1_element_subtitle) ){ ?>
						<div class="section-head style-1 m-b30">
							<?php if(!empty($testimonial_slider_1_element_subtitle)){ ?>
								<span class="sub-title text-primary sub-title-icon">
									<?php if(!empty($testimonial_slider_1_element_icon_img['id'])){ ?>
										<img src="<?php echo esc_url($testimonial_slider_1_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
									<?php } ?>
										<?php echo esc_html($testimonial_slider_1_element_subtitle); ?>
								</span>
							<?php } ?>
							<?php if(!empty($testimonial_slider_1_element_title)){ ?>
								<h2 class="title"><?php echo esc_html($testimonial_slider_1_element_title); ?></h2>
							<?php } ?>
						</div>
						<?php } ?>
						<div class="swiper-btn-center-lr">
							<div class="swiper testimonial-swiper4">
								<div class="swiper-wrapper">
								<?php
									while ($query->have_posts()) {
										$query->the_post();
										global $post;
										$post_id = $post->ID;
										$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
										$testimonial_designation = get_post_meta($post_id, 'testimonial_designation', true);	
										$rating_title = get_post_meta($post_id, 'testimonial_rating_title', true);	
										$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
								?>
									<div class="swiper-slide">
										<div class="testimonial-4">
											<div class="testimonial-text">
												<div class="title-head">
													<div class="quote-icon">
														<img src="<?php echo esc_url(CLINICMASTER_URL.'assets/images/quotation.svg'); ?>" alt="">
													</div>
													<?php if(!empty($rating_title)){ ?>
														<h2 class="title"><?php echo esc_html($rating_title); ?></h2>
													<?php } ?>
												</div>
												<?php if(!empty($short_description)){ ?>
													<p><?php echo esc_html($short_description); ?></p>
												<?php } ?>
											</div>
											<div class="testimonial-detail">
												<?php if(has_post_thumbnail($post)){
													$img = get_the_post_thumbnail_url($post, 'thumbnail'); 
													?>
													<div class="dz-media">
														<img src="<?php echo esc_url($img); ?>" class="radius-xl shadow-sm object-fit-cover" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
													</div>
												<?php } ?>
												<div class="clearfix">
													<?php if(!empty($post_title)){ ?>
														<h5 class="testimonial-name"><?php echo esc_html($post_title); ?></h5>
													<?php }
													if(!empty($testimonial_designation)){ ?>
														<span class="testimonial-position"><?php echo esc_html($testimonial_designation); ?></span>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</div>
							</div>
							<div class="pagination-align">
								<div class="swiper4-button-prev btn-prev">
									<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M18.6284 12H5.37084" stroke="#031B4E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										<path d="M11.9995 5.37134L5.37072 12.0001L11.9995 18.6289" stroke="#031B4E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
									</svg>								
								</div>
								<div class="swiper4-button-next btn-next">
									<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M5.37158 12H18.6292" stroke="#031B4E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										<path d="M12.0005 5.37134L18.6293 12.0001L12.0005 18.6289" stroke="#031B4E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
									</svg>								
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	
	
	
<?php }
	} ?> 