<?php 
	if (
		$service_detail_1_element_selected_sidebar=='No_Sidebar' ||
		$service_detail_1_element_sidebar_layout == '' ||
		!is_active_sidebar( $service_detail_1_element_selected_sidebar ) ||
		!clinicmaster_is_theme_sidebar_active() 
	) 
	{
		$section_class = 'col-lg-12 single-inner order-lg-1';
	}else{
		$section_class = 'col-lg-8 single-inner order-lg-1';
	}
	$allowed_html_tag = clinicmaster_allowed_html_tag();
?>


<section class="content-inner service-single">
	<div class="container">
		<div class="row">
				<?php if ($service_detail_1_element_sidebar_layout == 'left' && 
					is_active_sidebar( $service_detail_1_element_selected_sidebar ) && 
					clinicmaster_is_theme_sidebar_active() ) 
					{ ?>
						<div class="col-lg-4 m-b30">
							<aside class="side-bar sticky-top left">
								<?php dynamic_sidebar( $service_detail_1_element_selected_sidebar ); ?>
							</aside>
						</div>
				<?php } ?>
			
				<div class="<?php echo esc_attr($section_class); ?>">
					<?php if(!empty($service_detail_1_element_image['id'])){ 
						$img = wp_get_attachment_image_url($service_detail_1_element_image['id'], 'large');
						?>
							<div class="single-media dz-media single-media height-sm radius-lg">
								<img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>" class="object-fit-cover">
							</div>
						<?php } ?>
					
					<div class="content-item">
					
						<?php if(!empty($service_detail_1_element_title)){ ?>
							<h2>
								<?php echo wp_kses($service_detail_1_element_title, 'string'); ?>
							</h2>
						<?php } ?>
						
						<?php if(!empty($service_detail_1_element_description)){ ?>
							<p>
								<?php echo wp_kses($service_detail_1_element_description, $allowed_html_tag); ?>
							</p>
						<?php } ?>
					</div>
					<div class="content-item">
						<?php if(!empty($service_detail_1_element_list_title)){ ?>
						<h3><?php echo esc_html($service_detail_1_element_list_title); ?></h3>
						<?php } 
						if(!empty($service_detail_1_element_list)){
							$item_arr = explode(',', $service_detail_1_element_list);
						?>
						<ul class="list-check text-secondary grid-2 m-b30">
							<?php foreach($item_arr as $val){ ?>
								<li><?php echo esc_html($val); ?></li>
							<?php } ?>
						</ul>			
						<?php } ?>
						
					</div>
					<?php if(!empty($service_detail_1_element_show_team) && $service_detail_1_element_show_team == 'yes'){ ?>
					<div class="content-item">
					<?php if(!empty($service_detail_1_element_team_title)){ ?>
					<h3><?php echo esc_html($service_detail_1_element_team_title); ?></h3>
					<?php } ?>
						<div class="row">
						<?php
						$num = 1;
						$query_args = array(
							'post_type'         => 'dz_team',
							'post_status'       => 'publish',
							'posts_per_page'    => 3,
							'order'             => 'desc',
							'orderby'           => 'date',
							'ignore_sticky_posts' => true,
						);
						$query = new WP_Query($query_args);
						if($query->have_posts()) { 
							while($query->have_posts())
							{ 	
								$query->the_post();
								global $post ;
								$post_id  = $post->ID;
								$post_title =  clinicmaster_trim($post->post_title, 8);
								$excerpt = $post->post_excerpt;
								$content = $post->post_content;
								$short_description = clinicmaster_short_description($excerpt, $content, 40);
								$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
								$team_social_data = clinicmaster_get_team_social_link($post_id);
								$class = ($num == 1) ? 'active' :'';
								
							?>
							<div class="col-xxl-4 col-sm-6">
								<div class="dz-team style-1 <?php echo esc_attr($class); ?>  box-hover">
									<?php if (has_post_thumbnail()) { ?>
									<div class="dz-media">
										<?php echo the_post_thumbnail('full'); ?>
										<?php  if(!empty($team_social_data['any_fill'] )){ ?>
											<ul class="dz-social">
											
												<?php foreach($team_social_data['data'] as $key => $value) {
													if(!empty($value['url'])){
												?>
													<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
												<?php }
													}
												?>	
											</ul>
										<?php } ?>
									</div>
									<?php } ?>
									<div class="dz-content">
										<div class="clearfix">
											<?php if( !empty($post_title) ){ ?>
											<h3 class="dz-name"><a href="<?php  echo esc_url(get_the_permalink($post)); ?>"><?php echo esc_html($post_title);  ?></a></h3>
											<?php }
											if( !empty($designation)){ ?> 
												<span class="dz-position"><?php echo esc_html($designation); ?></span>
											<?php } ?>
										</div>
									</div>
								</div>		
							
							</div>
							<?php $num++;
								}
							}
							?>
						</div>
					</div>
					<?php } 
					if(!empty($service_detail_1_element_show_faq) && $service_detail_1_element_show_faq == 'yes'){ 
						$no_of_posts = !empty($service_detail_1_element_no_of_posts) ? $service_detail_1_element_no_of_posts : 4;
						?>
					<div class="content-item">
						<?php if(!empty($service_detail_1_element_faq_title)){ ?>
							<h3><?php echo esc_html($service_detail_1_element_faq_title); ?></h3>
						<?php } ?>
						
						<?php
						$query_args = array(
							'post_type'         => 'dz_faq',
							'post_status'       => 'publish',
							'posts_per_page'    => $no_of_posts,
							'order'             => 'desc',
							'orderby'           => 'date',
							'ignore_sticky_posts' => true,
						);
						$query = new WP_Query($query_args);
						if($query->have_posts()) { ?>
						<div class="accordion dz-accordion style-1" id="accordionExample">
							<?php 
							$num = 1;
							while($query->have_posts())
							{ 	
								$query->the_post();
								global $post ;
								$post_id  = $post->ID;
								$post_title =  clinicmaster_trim($post->post_title, $service_detail_1_element_faq_title_text_limit);
								$excerpt = $post->post_excerpt;
								$content = $post->post_content;
								$short_description = clinicmaster_short_description($excerpt, $content, $service_detail_1_element_faq_text_limit);
									$active = ($num == 1) ? 'show' :'';
									$collapsed = ($num > 1) ? 'collapsed' :'';
								  ?>
									<div class="accordion-item wow fadeInUp" data-wow-delay="0.5s" data-wow-duration="0.8s">
									<?php if(!empty($post_title)){ ?>
										<h2 class="accordion-header">
											<button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo esc_attr($num); ?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($num); ?>">
												<?php echo esc_html($post_title); ?>
											</button>
										</h2>
									<?php } 
									if(!empty($short_description)){ ?>
										<div id="collapseOne<?php echo esc_attr($num); ?>" class="accordion-collapse collapse  <?php echo esc_attr($active); ?>" data-bs-parent="#accordionExample">
											<div class="accordion-body">
												<p><?php echo wp_kses($short_description, 'string'); ?></p>
											</div>
										</div>
									<?php } ?>
									
									</div>
								<?php $num++;
							} ?>	
							
						</div>
						<?php } ?>
					</div>
					<?php } ?>
				</div>
				
			<?php if ($service_detail_1_element_sidebar_layout == 'right' && 
			is_active_sidebar( $service_detail_1_element_selected_sidebar ) && 
			clinicmaster_is_theme_sidebar_active() ) 
			{ ?>
				<div class="col-lg-4 m-b30">
						<aside class="side-bar sticky-top right">
						<?php dynamic_sidebar( $service_detail_1_element_selected_sidebar ); ?>
						</aside>
				</div>
			<?php } ?>
					
		</div>
	</div>
</section>