<?php
$element_content = !empty($content_box_3_element_content) ? $content_box_3_element_content : '';
$style = !empty($content_box_3_element_style) ? $content_box_3_element_style : 'style_1';
if($style == 'style_1'){ 
?>
<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">
		<div class="row g-3 g-lg-4 align-items-center">
			<div class="col-lg-5">
				<div class="section-head style-1 mb-0">
					<?php if(!empty($content_box_3_element_subtitle)){ ?>
						<span class="sub-title text-primary sub-title-icon">
							<?php if(!empty($content_box_3_element_icon_img['id'])){ ?>
								<img src="<?php echo esc_url($content_box_3_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
							<?php } ?>
							<?php echo esc_html($content_box_3_element_subtitle); ?>
						</span>
					<?php } ?>
					<?php if(!empty($content_box_3_element_title)){ ?>
						<h2 class="title"><?php echo wp_kses($content_box_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
					<?php }
					if(!empty($content_box_3_element_description)){ ?>
						<p><?php echo wp_kses($content_box_3_element_description,clinicmaster_allowed_html_tag()); ?></p>
					<?php } ?>
				</div>
			</div>
			<div class="col-lg-7">
				<?php if(!empty($content_box_3_element_img['id'])){ ?>
				<div class="dz-media radius-lg height-sm ms-xl-4">
					<img src="<?php echo esc_url($content_box_3_element_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>" class="object-fit-cover">
				</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
<?php }elseif($style == 'style_2'){ ?>
<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-xl-6 col-lg-5 m-b30">
				<?php if(!empty($content_box_3_element_img['id'])){ ?>
				<div class="dz-media radius-md height-lg me-xl-4">
					<img src="<?php echo esc_url($content_box_3_element_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>" class="object-fit-cover">
				</div>
				<?php } ?>
			</div>
			<div class="col-xl-6 col-lg-7 m-b30">
				<div class="section-head style-1 mb-0">
					<?php if(!empty($content_box_3_element_subtitle)){ ?>
						<span class="sub-title text-primary sub-title-icon">
							<?php if(!empty($content_box_3_element_icon_img['id'])){ ?>
								<img src="<?php echo esc_url($content_box_3_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
							<?php } ?>
							<?php echo esc_html($content_box_3_element_subtitle); ?>
						</span>
					<?php } ?>
					<?php if(!empty($content_box_3_element_title)){ ?>
						<h2 class="title"><?php echo wp_kses($content_box_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
					<?php } 
					if(!empty($content_box_3_element_description)){ ?>
						<p class="m-b30"><?php echo wp_kses($content_box_3_element_description,clinicmaster_allowed_html_tag()); ?></p>
					<?php }
					if(!empty($content_box_3_element_feature_text)){ ?>
						<h3 class="font-24 m-b15"><?php echo esc_html($content_box_3_element_feature_text); ?></h3>
					<?php }
					if(!empty($content_box_3_element_feature_list)){
						$listing = explode(',', $content_box_3_element_feature_list);	?>
					<ul class="list-check text-secondary grid-2 fw-medium m-b30">
						<?php foreach($listing as $list){ ?>
							<li><?php echo esc_html($list); ?></li>
						<?php } ?>
					</ul>
					<?php } 
					if(!empty($content_box_3_element_description2)){ ?>
						<p class="m-b0"><?php echo esc_html($content_box_3_element_description2); ?></p>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php }elseif($style == 'style_3'){ 
$bg_img = $content_box_3_element_bg_img;
?>
<section class="<?php echo esc_attr($element_content); ?> clearfix">
	<div class="container">
		<div class="row content-bx style-9 g-0" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>);" <?php } ?>>
			<div class="col-xl-7 col-lg-9">
				
				<?php if(!empty($content_box_3_element_title)){ ?>
					<h2 class="title m-b15"><?php echo wp_kses($content_box_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
				<?php }
				if(!empty($content_box_3_element_description)){ ?>
					<p><?php echo wp_kses($content_box_3_element_description,clinicmaster_allowed_html_tag()); ?></p>
				<?php }
				if(!empty($content_box_3_element_button_text) && !empty($content_box_3_element_button_link['url'])){ 
					$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($content_box_3_element_button_link);
				?>
					<a href="<?php echo esc_url($content_box_3_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-lg btn-icon btn-primary m-t40">
						<?php echo esc_html($content_box_3_element_button_text); ?>
						<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
					</a>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
<?php }elseif($style == 'style_4' || $style == 'style_5'){
	 $element_style = '';
    
	 if( $style == 'style_5'){
		$element_style = 'content-wrapper style-37';  
        $btn_style = 'btn btn-icon btn-gradient btn-rounded';
        $btn_icon = 'd-none';
	}else{
		$btn_style = 'btn btn-lg btn-icon btn-primary';
        $btn_icon = 'right-icon';
		
	}

 $signechar_img = $content_box_3_element_signechar_img;
	?>
 <section class="<?php echo esc_attr($element_content . ' ' . $element_style ); ?> bg-light" >
	<div class="container">
		<div class="row align-items-center">
			<div class="col-xl-7 col-lg-6 m-b30 pe-xl-5">
				<div class="section-head style-1 m-b30">
					<?php if(!empty($content_box_3_element_title || $content_box_3_element_decoter_name )){ ?>
						<h2 class="title"><?php echo wp_kses($content_box_3_element_title, clinicmaster_allowed_html_tag()); ?></h2>
 						<h3 class="font-24 m-b20 wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.8s" style="visibility: visible; animation-duration: 0.8s; animation-delay: 0.4s; animation-name: fadeInUp;"><?php echo wp_kses($content_box_3_element_decoter_name, clinicmaster_allowed_html_tag()); ?></h3>
					<?php }
					if(!empty($content_box_3_element_subtitle)){ ?>
						<h3 class="text-primary font-24 m-b20"><?php echo esc_html($content_box_3_element_subtitle); ?></h3>
					<?php } 
					if(!empty($content_box_3_element_description)){ ?>
						<p class="fw-normal"><?php echo wp_kses($content_box_3_element_description,clinicmaster_allowed_html_tag()); ?></p>
					<?php } ?>
				</div>						
				<div class="row align-items-center g-4">
					<div class="col-sm-5 d-flex">
						<div class="text-center">
							<?php if(!empty($signechar_img['id'])){ ?>
								<img src="<?php echo esc_url($signechar_img['url']); ?>" alt="<?php echo esc_attr__('Signechar Image','clinicmaster'); ?>">
							<?php } ?>
							<?php if(!empty($content_box_3_element_signechar_text)){ ?>
								<span class="font-14 d-block"><?php echo esc_html($content_box_3_element_signechar_text); ?></span>
							<?php } ?>							
						</div>
					</div>
					<?php if(!empty($content_box_3_element_button_text) && !empty($content_box_3_element_button_link['url'])){
						$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($content_box_3_element_button_link);
						?>
					<div class="col-sm-6">
						<a href="<?php echo esc_url($content_box_3_element_button_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="<?php  echo esc_html($btn_style); ?>">
							<?php echo esc_html($content_box_3_element_button_text); ?>
							<span class="<?php echo esc_html( $btn_icon); ?>"><i class="feather icon-arrow-right"></i></span>
						</a>
					</div>
					<?php } ?>
				</div>
			</div>
			<?php if(!empty($content_box_3_element_img['id'])){ ?>
			<div class="col-xl-5 col-lg-6 m-b30">
				<div class="dz-media height-md radius-xl">
					<img src="<?php echo esc_url($content_box_3_element_img['url']); ?>" alt="<?php echo esc_attr__('Image', 'clinicmaster'); ?>">
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>
<?php } ?>