<?php 
$img = $content_box_2_element_img;
$bg_img = $content_box_2_element_bg_img;
$items = $content_box_2_element_item;
$element_content = !empty($content_box_2_element_content) ? $content_box_2_element_content : 'content-inner';
?>
<section class="<?php echo esc_attr($element_content); ?> overlay-secondary-dark background-blend-luminosity bg-img-fix overflow-hidden" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-repeat: no-repeat; background-position: right center; background-size: cover;"<?php } ?>>
		<div class="container">
			<div class="row content-wrapper style-7 justify-content-center align-items-center">
				<div class="col-xl-6 m-b30 order-xl-1">
					<?php if(!empty($content_box_2_element_title) || !empty($content_box_2_element_subtitle)){ ?>
					<div class="section-head style-1 m-b30">
						<?php if(!empty($content_box_2_element_subtitle)){ ?>
							<span class="sub-title text-primary sub-title-icon">
								<?php if(!empty($content_box_2_element_icon_img['id'])){ ?>
									<img src="<?php echo esc_url($content_box_2_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
								<?php } ?>
								<?php echo esc_html($content_box_2_element_subtitle); ?>
							</span>
						<?php } ?>
						<h2 class="title text-white m-b0 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s"><?php echo esc_html($content_box_2_element_title); ?></h2>
					</div>
					<?php } ?>
					<?php if(!empty($items) && is_array($items)){ ?>
					<div class="row row-wrapper">
						<?php 
						$count = 1;
						foreach($items as $item){ 
							$icon = $item['content_box_2_element_item_icon'];
							$title = $item['content_box_2_element_item_title'];
							$description = $item['content_box_2_element_item_description'];
							if($count < 10){
									$count = '0'.$count;
							}
							?>
							<div class="col-sm-6">
								<div class="icon-bx-wraper style-4 text-white wow fadeInUp" data-name="<?php echo esc_attr($count); ?>" data-wow-delay="0.4s" data-wow-duration="0.8s">
									<?php if(!empty($icon['value']) && is_array($icon)){ ?>
									<div class="icon-bx">
										<?php if( $icon['library'] == 'svg' && !empty($icon['value']['url'])){ 
											$response = wp_remote_get($icon['value']['url']);
											if (!is_wp_error($response)) {
												$svg_content = wp_remote_retrieve_body($response);
												echo '<span class="icon-cell">'.$svg_content.'</span>';
											}
										}else{ ?>
											<span class="icon-cell">
												<i class="<?php echo esc_attr($icon['value']); ?>"></i>
											</span>
										<?php } ?>
									</div>
									<?php }
									if(!empty($title) || !empty($description)){ ?>
									<div class="icon-content">
										<?php if(!empty($title)){ ?>
										<h3 class="dz-title"><?php echo esc_html($title); ?></h3>
										<?php } ?>
										<?php if(!empty($description)){ ?>
										<p><?php echo wp_kses($description, 'string'); ?></p>
										<?php } ?>
									</div>
									<?php } ?>
								</div>
							</div>
						<?php $count++;
						} ?>
					</div>
					<?php } ?>
				</div>
				<div class="col-xl-6 col-lg-9 m-b30 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s">
					<div class="content-media">
						<div class="row justify-content-center align-items-center">
							<?php if(!empty($img['id'])){ ?>
								<div class="col-sm-6">
									<div class="dz-media img1">
										<?php echo wp_get_attachment_image( $img['id'], 'full' );  ?>
										<?php if(!empty($content_box_2_element_pattern_img['id'])){ ?>
										<div class="item1">
											<?php echo wp_get_attachment_image( $content_box_2_element_pattern_img['id'], 'thumbnail' );  ?>
										</div>
										<?php } ?>
									</div>
								</div>
							<?php } ?>
							<div class="col-sm-6">
								<div class="item2 m-b25">
									<img src="<?php echo esc_url(CLINICMASTER_URL.'assets/images/pattern/line-curv.svg'); ?>" class="item-bg" alt="<?php echo esc_attr__('Pattern Image', 'clinicmaster'); ?>">
									<div class="word-rotate-wrapper1">
										<?php if(!empty($content_box_2_element_number)){ ?>
											<span class="content-text text-white">
												<span class="clearfix">
													<span class="counter">
														<?php echo esc_html($content_box_2_element_number); ?>
													</span>
													<span class="text-symbol">
														<?php if(!empty($content_box_2_element_symbol)){ 
															echo esc_html($content_box_2_element_symbol); 
														} ?>
													</span>
													<span class="text-year text-primary">
														<?php if(!empty($content_box_2_element_text)){ 
															echo esc_html($content_box_2_element_text); 
														} ?>
													</span>
												</span>
											</span>
										<?php } ?>
										<div class="word-rotate-box">
											<?php if(!empty($content_box_2_element_title)){ ?>
												<span class="word-rotate"><?php echo wp_kses($content_box_2_element_counter_title, clinicmaster_allowed_html_tag()); ?></span>
											<?php } ?>
										</div>	
									</div>	
								</div>
								<?php if(!empty($content_box_2_element_img2['id'])){ ?>
									<div class="dz-media">
										<?php echo wp_get_attachment_image( $content_box_2_element_img2['id'], 'clinicmaster_600x600' );  ?>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>