<?php 
$element_content = !empty($appointment_form_3_element_content) ? $appointment_form_3_element_content : 'content-inner';
$symbol = $appointment_form_3_element_symbol;
?>
<section class="<?php echo esc_attr($element_content); ?> bg-light pb-0 overflow-hidden">
	<div class="container">
		<div class="row content-wrapper style-17 align-items-end justify-content-center">
			<div class="col-xl-5 col-lg-12 order-xl-1 m-b30">
				<div class="content-info">
					<div class="form-wrapper style-2 bg-secondary">
						<div class="form-body">
							<?php if(!empty($appointment_form_3_element_title)){ ?>
							<div class="title-head">
								<h2 class="form-title m-b20"><?php echo esc_html($appointment_form_3_element_title); ?></h2>
							</div>
							<?php } ?>
							<?php if(!empty($appointment_form_3_element_contact_form)){ ?>
						
								<?php 
									$post = get_page_by_path($appointment_form_3_element_contact_form,OBJECT,'wpcf7_contact_form');
									if(!empty($post->ID)){
										echo do_shortcode('[contact-form-7 id="'.$post->ID.'"]');
									}
								?>
						
						<?php } ?>
							
						</div>
					</div>
				</div>
			</div>
			<div class="col-xl-7 col-lg-8 pe-xl-5">
				<div class="content-media">
				<?php if(!empty($appointment_form_3_element_img['id'])){ ?>
					<div class="dz-media">
						<img src="<?php echo esc_url($appointment_form_3_element_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
					</div>
					<div class="item1">
						<svg viewBox="0 0 694 694" fill="none" xmlns="http://www.w3.org/2000/svg">
							<circle cx="347" cy="347" r="346" stroke="var(--bs-primary)" stroke-opacity="0.1" stroke-width="2" stroke-dasharray="12 12"/>
							<circle cx="347" cy="347" r="296" stroke="var(--bs-primary)" stroke-opacity="0.2" stroke-width="2" stroke-dasharray="12 12"/>
							<circle cx="347" cy="347" r="244" stroke="var(--bs-primary)" stroke-opacity="0.3" stroke-width="2" stroke-dasharray="12 12"/>
							<circle cx="147.5" cy="206.5" r="6.5" fill="var(--bs-primary)"/>
							<circle opacity="0.3" cx="206.5" cy="30.5" r="4.5" fill="var(--bs-primary)"/>
							<circle opacity="0.6" cx="62.5" cy="433.5" r="2.5" fill="var(--bs-primary)"/>
							<ellipse opacity="0.6" cx="525" cy="109.5" rx="4" ry="3.5" fill="var(--bs-primary)"/>
							<circle cx="642.5" cy="361.5" r="3.5" fill="var(--bs-primary)"/>
							<ellipse opacity="0.3" cx="573" cy="606.5" rx="3" ry="2.5" fill="var(--bs-primary)"/>
						</svg>	
					</div>
				<?php } ?>
				<?php if(!empty($appointment_form_3_element_counter_number) || !empty($appointment_form_3_element_counter_text)){ ?>
					<div class="item2">
						<div class="info-widget style-10 move-3">
							<?php if(!empty($appointment_form_3_element_counter_number)){ ?>
							<span class="content-text text-primary"><span class="counter"><?php echo esc_html($appointment_form_3_element_counter_number);  ?></span><?php if(!empty($symbol)){ echo esc_html($symbol); } ?></span>
							<?php }
							if($appointment_form_3_element_counter_text){ ?>
								<h3 class="title m-b0"><?php echo wp_kses($appointment_form_3_element_counter_text, clinicmaster_allowed_html_tag()); ?></h3>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
					<div class="item3">
						<div class="dz-img-box style-1 move-4">
							<?php if(!empty($appointment_form_3_element_item_img['id'])){ ?>
							<div class="dz-media">
								<img src="<?php echo esc_url($appointment_form_3_element_item_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
							</div>
							<?php } ?>
							<div class="dz-content">
								<?php if(!empty($appointment_form_3_element_item_title)){ ?>
									<h3 class="title"><?php echo esc_html($appointment_form_3_element_item_title); ?></h3>
								<?php }
								if(!empty($appointment_form_3_element_item_description)){	?>
									<p><?php echo wp_kses($appointment_form_3_element_item_description,'string'); ?></p>
								<?php } ?>
								<?php if(!empty($appointment_form_3_element_item_text) && !empty($appointment_form_3_element_item_text_link)){ ?>
									<a href="<?php echo esc_url($appointment_form_3_element_item_text_link); ?>" class="btn-link"><?php echo esc_html($appointment_form_3_element_item_text); ?></a>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>