<?php

/* Single Pages Template */
function clinicmaster_page_template_options(){
	
	$page_templates = array(
		'landing' => array(
			array(
				'title' => esc_html__('ClinicMaster Home 1','clinicmaster'),
				'id'   => 'landing_style_1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/landing_style_1.png',
				'param'  => array()
			),
			array(
				'title' => esc_html__('ClinicMaster Home 2','clinicmaster'),
				'id'   => 'landing_style_2',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/landing_style_2.png',
				'param'  => array()
			),
			array(
				'title' => esc_html__('ClinicMaster Home 3','clinicmaster'),
				'id'   => 'landing_style_3',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/landing_style_3.png',
				'param'  => array()
			),
			array(
				'title' => esc_html__('ClinicMaster Home 4','clinicmaster'),
				'id'   => 'landing_style_4',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/landing_style_4.png',
				'param'  => array()
			),
			
		),
		'inner' => array(
			
		),
		'coming' => array(
			array(
				'title' => esc_html__('Comingsoon','clinicmaster'),
				'id'   => 'coming_style_1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/coming-soon.png',
				'param'  => array()
			)
		),
		'maintenance' => array(
			array(
				'title' => esc_html__('Maintenance','clinicmaster'),
				'id'   	=> 'maintenance_style_1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/site-down-for-maintain.png',
				'param'  => array()
			),
		),
		'error' => array(
			array(
				'title' => esc_html__('Error','clinicmaster'),
				'id'   => 'error_style_1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error-404.png',
				'param'  => array()
			)
		)
	);
	return $page_templates;
}

/* Single Post Layouts */
function clinicmaster_post_layouts_options(){

	$post_layouts = array(
		array(
			'id'   => 'standard',
			'layout_param' => array(
		    	'title' => esc_html__('Standard','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/standard-post.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'gutenberg',
			'layout_param' => array(
		    	'title' => esc_html__('Gutenberg','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/gutenberg.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'corner_post',
			'layout_param' => array(
		    	'title' => esc_html__('Corner Post','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/corner-image-post.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'post_header_image',
			'layout_param' => array(
		    	'title' => esc_html__('Header Image','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/post-header-image.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider_post_2',
			'layout_param' => array(
		    	'title' => esc_html__('Slider Post 2','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/slider-post-2.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'link_post',
			'layout_param' => array(
		    	'title' => esc_html__('Link Post','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/link-post.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'video_post',
			'layout_param' => array(
		    	'title' => esc_html__('Video Post','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/video-post.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'audio_post',
			'layout_param' => array(
		    	'title' => esc_html__('Audio Post','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/audio-post.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider_post_1',
			'layout_param' => array(
		    	'title' => esc_html__('Slider Post 1','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/slider-post-1.png'
		    ),
			'param'  => array()
		),
	);

	return $post_layouts;
}

/* Header Layouts Options */
function clinicmaster_header_style_options(){
	$header_styles = array(
		array(
			'id'   => 'header_1',
			'img_param' => array(
				'title' => esc_html__('Style - Header 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-1.jpg'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 1,
				'search' => 1,
				'call_to_action_button' => 1,
				'social_links' => 6,
				'top_bar' => 1,
				'extra_fields' => 0,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
				'star' => 0
			)
		),
		array(
			'id'   => 'header_2',
			'img_param' => array(
				'title' => esc_html__('Style - Header 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-2.jpg'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 1,
				'search' => 1,
				'call_to_action_button' => 1,
				'social_links' => 6,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
					'star' => 0
			)
		),
		array(
			'id'   => 'header_3',
			'img_param' => array(
				'title' => esc_html__('Style - Header 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-3.jpg'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 1,
				'search' => 1,
				'call_to_action_button' => 1,
				'social_links' => 6,
				'top_bar' => 1,
				'extra_fields' => 0,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
				'star' => 1
			)
		),
		array(
			'id'   => 'header_4',
			'img_param' => array(
				'title' => esc_html__('Style - Normal Header 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-4.png'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 1,
				'search' => 1,
				'call_to_action_button' => 1,
				'social_links' => 6,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
					'star' => 0
			)
		),
		array(
			'id'   => 'header_5',
			'img_param' => array(
				'title' => esc_html__('Style - Normal Header 5','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-5.png'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 1,
				'search' => 1,
				'call_to_action_button' => 1,
				'social_links' => 6,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
					'star' => 0
			)
		),
		array(
			'id'   => 'header_6',
			'img_param' => array(
				'title' => esc_html__('Style - Normal Header 6','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-6.png'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 0,
				'call_to_action_button' => 1,
				'social_links' => 0,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
				'star' => 0
			)
		),
       
		array(
			'id'   => 'header_7',
			'img_param' => array(
				'title' => esc_html__('Style - Header 7','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-7.png'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 0,
				'call_to_action_button' => 1,
				'social_links' => 0,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
				'star' => 0
			)
		),
	
		array(
			'id'   => 'header_8',
			'img_param' => array(
				'title' => esc_html__('Style - Header white 8','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-7.png'
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 0,
				'call_to_action_button' => 1,
				'social_links' => 0,
				'top_bar' => 0,
				'extra_fields' => 1,
				'extra_social_information' => 0,
				'informative_fields_header'	=> 0,
				'cart_img' => 1,
				'star' => 0
			)
		),
 

	);

	return $header_styles;
}
/* Footer Layouts Options */
function clinicmaster_footer_style_options(){
	$footer_styles = array(
		array(
			'id'   => 'footer_template_1',
			'img_param' => array(
				'title' => esc_html__('Footer 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-1.jpg',
			),
			'param'  => array(
				'social_link' => 0,
				'copyright'	=> 0,
				'powered_by'	=> 0,
				'sections'	=> 0,
				'bg_image'	=> 0,
				'extra_fields' => 0,
				'nav_menu' => 0,
				'widget_fields' => 0,
				'informative_field'	=> 0,
				'media_gallery'	=> 0,
				'theme_sidebar'	=> 0,
			)
		),
		array(
		 	'id'   => 'footer_template_2',
		 	'img_param' => array(
		 		'title' => esc_html__('Footer 2','clinicmaster'),
		 		'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-2.jpg',
		 	),
		 	'param'  => array(
		 		'social_link' => 1,
		 		'copyright'	=> 1,
		 		'powered_by'	=> 0,
		 		'sections'	=> 1,
		 		'bg_image'	=> 1,
		 		'extra_fields' => 1,
		 		'nav_menu' => 0,
		 		'widget_fields' => 1,
		 		'informative_field'	=> 0,
		 		'media_gallery'	=> 1,
		 		'theme_sidebar'	=> 0,
		
		
		 	)
		),

		array(
		 	'id'   => 'footer_template_3',
		 	'img_param' => array(
		 		'title' => esc_html__('Footer 3','clinicmaster'),
		 		'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-3.jpg',
		 	),
		 	'param'  => array(
		 		'social_link' => 1,
		 		'copyright'	=> 1,
		 		'powered_by'	=> 0,
		 		'sections'	=> 1,
		 		'bg_image'	=> 1,
		 		'extra_fields' => 0,
		 		'nav_menu' => 1,
		 		'widget_fields' => 0,
		 		'informative_field'	=> 0,
		 		'media_gallery'	=> 0,
		 		'theme_sidebar'	=> 0,

		 	)
		),
		array(
			'id'   => 'footer_template_4',
			'img_param' => array(
				'title' => esc_html__('Footer 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-4.jpg',
			),
			'param'  => array(
				'social_link' => 1,
				'copyright'	=> 1,
				'powered_by'	=> 0,
				'sections'	=> 1,
				'bg_image'	=> 1,
				'footer_image'	=> 1,
				'extra_fields' => 0,
				'nav_menu' => 1,
				'widget_fields' => 0,
				'informative_field'	=> 0,
				'media_gallery'	=> 0,
				'theme_sidebar'	=> 0,

			)
	   	),
		array(
			'id'   => 'footer_template_5',
			'img_param' => array(
				'title' => esc_html__('Footer 5','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-5.jpg',
			),
			'param'  => array(
				  'social_link' => 1,
				'copyright'	=> 1,
				'powered_by'	=> 1,
				'footer_form_title' => 1,
				 'map_embed_iframe' => 1,
				'select_box'  => 1,
				'sections'	=> 1,
				'bg_image'	=> 1,
				'footer_image'	=> 0,
				'extra_fields' => 0,
				'nav_menu' => 1,
				'widget_fields' => 0,
				'informative_field'	=> 0,
				'media_gallery'	=> 0,
				'theme_sidebar'	=> 0,

			)
		),  

		array(
			'id'   => 'footer_template_6',
			'img_param' => array(
				'title' => esc_html__('Footer 6','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-6.jpg',
			),
			'param'  => array(
				  'social_link' => 1,
				'copyright'	=> 1,
				'powered_by'	=> 1,
				'footer_form_title' => 1,
				 'map_embed_iframe' => 0,
				'select_box'  => 0,
				'sections'	=> 1,
				'bg_image'	=> 0,
				'footer_image'	=> 0,
				'extra_fields' => 0,
				'nav_menu' => 1,
				'widget_fields' => 0,
				'informative_field'	=> 0,
				'media_gallery'	=> 0,
				'theme_sidebar'	=> 0,
			)
		),  
	);

	return $footer_styles;
}

/* Sidebar Layouts Options*/
function clinicmaster_sidebar_layout_options(){

	$sidebar_layout = array(
		array(
			'id' => 'full',
			'sidebar_param' => array(
				'title' => esc_html__('Full Width','clinicmaster'),
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-full.png'),
			'param'  => array()
		),
		array(
			'id' => 'left',
			'sidebar_param' => array(
				'title' => esc_html__('Left Side','clinicmaster'),
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-left.png'),
			'param'  => array()
		),
		array(
			'id' => 'right',
			'sidebar_param' => array(
				'title' => esc_html__('Right Side','clinicmaster'),
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-right.png'),
			'param'  => array()
		)
	);

	return $sidebar_layout;
}

/* Post Box/Wrapper Style Options */
function clinicmaster_post_wrapper_options(){
	
	$post_wrapper_layout = array(
		array(
			'id'   => 'post_box_1',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-1.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_2',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-2.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_3',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-3.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_4',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-4.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_5',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 5','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-5.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_6',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 6','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-6.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_7',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 7','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-7.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_8',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 8','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-8.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_9',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 9','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-9.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_10',
			'img_param' =>  array(
				'title' => esc_html__('Post Box 10','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-10.png'
			),
			'param'  => array()
		)
	);

	return $post_wrapper_layout;
}

/* Post Listing Style Options */
function clinicmaster_post_listing_options(){
	// post listing/collage style
	$post_listing_layout = array(
		array(
			'id'   => 'post_listing_1',
			'listing_param' =>  array(
				'title' => esc_html__('Post Listing 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-1.png'),
			'param'  => array()
		),
		array(
			'id'   => 'post_listing_2',
			'listing_param' => array(
				'title' => esc_html__('Post Listing 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-2.png'),
			'param'  => array()
		),
		array(
			'id'   => 'team_listing_1',
			'listing_param' =>  array(
				'title' => esc_html__('Team Listing 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-3.png'),
			'param'  => array()
		),
		array(
			'id'   => 'portfolio_listing_1',
			'listing_param' =>  array(
				'title' => esc_html__('Portfolio Listing 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-4.png'),
			'param'  => array()
		),

		array(
			'id'   => 'service_listing_1',
			'listing_param' =>  array(
				'title' => esc_html__('Service Listing 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-5.png'),
			'param'  => array()
		)
	);

	return $post_listing_layout;
}

/* Post Tiles Style Options */
function clinicmaster_post_tiles_options(){

	$post_tile_layout = array(
		array(
			'id'   => 'post_tile_1',
			'img_param' =>  array(
				'title' => esc_html__('Post Tile 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-1.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_tile_2',
			'img_param' => array(
				'title' => esc_html__('Post Tile 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-2.png'
			),
			'param'  => array()
		)
	);

	return $post_tile_layout;
}

/* Page Banner Style Options */
function clinicmaster_page_banner_options(){
	$page_banner_style = array(
		array(
			'id'   => 'page_banner_big',
			'banner_param' => array(
		    	'title' => esc_html__('Fit to Screen','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-big.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_medium',
			'banner_param' => array(
		    	'title' => esc_html__('Banner Medium','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-medium.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_small',
			'banner_param' => array(
		    	'title' => esc_html__('Banner Small','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-small.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_custom',
			'banner_param' => array(
		    	'title' => esc_html__('Custom Height', 'clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/custom-banner.png'
		    ),
			'param'  => array()
		)
	);

	return $page_banner_style;
}

/* Post Tiles Style Options */

function clinicmaster_post_banner_options(){
	$post_banners = array(
		array(
			'id'   => 'post_banner_v1',
			'post_banner_param' => array(
				'title' => esc_html__('Post Banner 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v1.png'
			),
			'param'  => array(
				'limit' => array(2,5),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			'id'   => 'post_banner_v2',
			'post_banner_param' => array(
				'title' => esc_html__('Post Banner 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v2.png'
			),
			'param'  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			'id'   => 'post_banner_v3',
			'post_banner_param' => array(
				'title' => esc_html__('Post Banner 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v3.png'
			),
			'param'  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
			)    
		)
	);

	return $post_banners;
}

/* Theme Layout Options */
function clinicmaster_theme_layout_options(){
	$theme_layouts = array(
		array(
			'id'   => 'theme_layout_1',
			'img_param' => array(
				'title' => esc_html__('Full','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/full-width.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'theme_layout_2',
			'img_param' => array(
				'title' => esc_html__('Box','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/boxed.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'theme_layout_3',
			'img_param' => array(
				'title' => esc_html__('Frame','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/frame.png'
			),
			'param'  => array()
		)
	);

	return $theme_layouts;
}

/* Theme Color Background Options */
function clinicmaster_theme_color_background_options(){
	$theme_color_background = array(
		array(
			'id'   => '#96D055',
			'img_param' => array(
				'title' => esc_html__('Light Green','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/light_green.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#019444',
			'img_param' => array(
				'title' => esc_html__('Green','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/green.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#fb4848',
			'img_param' => array(
				'title' => esc_html__('Red','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/red.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#0086f0',
			'img_param' => array(
				'title' => esc_html__('Sky Blue','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/sky_blue.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#ffaf29',
			'img_param' => array(
				'title' => esc_html__('Yellowish Orange','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/yellowish_orange.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#8669d4',
			'img_param' => array(
				'title' => esc_html__('Medium Purple','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/medium_purple.png'
			),
			'param'  => array()      
		),
		array(
			'id'   => '#ef9f7e',
			'img_param' => array(
				'title' => esc_html__('Peachy Pink','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/peachy_pink.png'
			),
			'param'  => array()      
		)
	);

	return $theme_color_background;
}

/* Theme Image Background Options */
function clinicmaster_theme_image_background_options(){
	$theme_image_background = array(
		array(
			'id'   => 'bg_img_1',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg_img_1.jpg',
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_2',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg_img_2.jpg',
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_3',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg_img_3.jpg',
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_4',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg_img_4.jpg',
			'param'  => array()
		),
		
	);

	return $theme_image_background;
}

/* Theme Pattern Background Options */
function clinicmaster_theme_pattern_background_options(){
	$theme_pattern_background = array(
		array(
			'id'   => 'bg_pattern_1',
			'title' => esc_html__('Pattern Name 1','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_1.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_2',
			'title' => esc_html__('Pattern Name 2','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_2.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_3',
			'title' => esc_html__('Pattern Name 3','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_3.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_4',
			'title' => esc_html__('Pattern Name 4','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_4.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_5',
			'title' => esc_html__('Pattern Name 5','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_5.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_6',
			'title' => esc_html__('Pattern Name 6','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_6.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_7',
			'title' => esc_html__('Pattern Name 7','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_7.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_8',
			'title' => esc_html__('Pattern Name 8','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_8.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_9',
			'title' => esc_html__('Pattern Name 9','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_9.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_10',
			'title' => esc_html__('Pattern Name 10','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_10.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_11',
			'title' => esc_html__('Pattern Name 11','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_11.jpg',
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_12',
			'title' => esc_html__('Pattern Name 12','clinicmaster'),
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_12.jpg',
			'param' => array()
		)
	);

	return $theme_pattern_background;
}

/* theme color  Options */
function clinicmaster_theme_color_options(){
	$theme_color = array(
		array(
			'id'   => 'skin_1',
			'layout_param'=>array(
				'title' => esc_html__('Sky Blue','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/sky-blue.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_2',
			'layout_param'=>array(
				'title' => esc_html__('Light Pink','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/light-pink.png',
			),
			'param'  => array()
		),	
	
		
		array(
			'id'   => 'skin_3',
			'layout_param'=>array(
				'title' => esc_html__('Orange','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/orange.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_4',
			'layout_param'=>array(
				'title' => esc_html__('Dark Green','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/dark-green.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_5',
			'layout_param'=>array(
				'title' => esc_html__('Dark Pink','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/dark-pink.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_6',
			'layout_param'=>array(
				'title' => esc_html__('Blue','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/blue.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_7',
			'layout_param'=>array(
				'title' => esc_html__('Light Orange','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/light-orange.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_8',
			'layout_param'=>array(
				'title' => esc_html__('Light Green','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/light-green.png',
			),
			'param'  => array()
		),
		array(
			'id'   => 'skin_9',
			'layout_param'=>array(
				'title' => esc_html__('Green','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/green.png',
			),
			'param'  => array()
		),
		
	);

	return $theme_color;
}

/* Page Loader Options */
function clinicmaster_page_loader_options(){
	$page_loader = array(
		array(
			'title' => esc_html__('Loading 1','clinicmaster'),
			'id'   => 'loading1',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading1.gif',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 2','clinicmaster'),
			'id'   => 'loading2',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading2.gif',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 3','clinicmaster'),
			'id'   => 'loading3',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading3.gif',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 4','clinicmaster'),
			'id'   => 'loading4',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading4.svg',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 5','clinicmaster'),
			'id'   => 'loading5',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading5.svg',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 6','clinicmaster'),
			'id'   => 'loading6',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading6.svg',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 7','clinicmaster'),
			'id'   => 'loading7',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading7.svg',
			'param'  => array()
		),
		array(
			'title' => esc_html__('Loading 8','clinicmaster'),
			'id'   => 'loading8',
			'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading8.svg',
			'param'  => array()
		)
	);

	return $page_loader;
}


/* Sorting Options */
function clinicmaster_sort_by_options(){
	$sort_by = array(
		'date_asc'  => esc_html__('Date ASC', 'clinicmaster'),
		'date_desc'  => esc_html__('Date DESC', 'clinicmaster'),
		'title_asc'  => esc_html__('Title ASC', 'clinicmaster'),
		'title_desc'  => esc_html__('Title DESC', 'clinicmaster'),
		'most_visited'  => esc_html__('Most Visited', 'clinicmaster'),
	);

	return $sort_by;
}

/* Button Link Target Options */
function clinicmaster_link_target_options(){
	$link_target = array(
		'_blank' 	=>	esc_html__('Opens the link in a new tab.','clinicmaster'),
		'_parent' 	=> 	esc_html__('Opens the link in the parent frame.','clinicmaster'),
		'_self'		=>	esc_html__('Open the link in the current frame.','clinicmaster'),
		'_top'		=>	esc_html__('Opens the link in the top-most frame.','clinicmaster')
	);
	
	return $link_target;
}

/* Advertisement Banner Size Options */
function clinicmaster_adsence_size_options(){
	$adsence_size = array(
		'auto' => esc_html__('Auto', 'clinicmaster' ),
		'120 x 90' => esc_html__('120 x 90', 'clinicmaster'),
		'120 x 240' => esc_html__('120 x 240', 'clinicmaster'),
		'120 x 600' => esc_html__('120 x 600', 'clinicmaster'),
		'125 x 125' => esc_html__('125 x 125', 'clinicmaster'),
		'160 x 90' => esc_html__('160 x 90', 'clinicmaster'),
		'160 x 600' => esc_html__('160 x 600', 'clinicmaster'),
		'180 x 90' => esc_html__('180 x 90', 'clinicmaster'),
		'180 x 150' => esc_html__('180 x 150', 'clinicmaster'),
		'200 x 90' => esc_html__('200 x 90', 'clinicmaster'),
		'200 x 200' => esc_html__('200 x 200', 'clinicmaster'),
		'234 x 60' => esc_html__('234 x 60', 'clinicmaster'),
		'250 x 250' => esc_html__('250 x 250', 'clinicmaster'),
		'320 x 100' => esc_html__('320 x 100', 'clinicmaster'),
		'300 x 250' => esc_html__('300 x 250', 'clinicmaster'),
		'300 x 600' => esc_html__('300 x 600', 'clinicmaster'),
		'300 x 1050' => esc_html__('300 x 1050', 'clinicmaster'),
		'320 x 50' => esc_html__('320 x 50', 'clinicmaster'),
		'336 x 280' => esc_html__('336 x 280', 'clinicmaster'),
		'360 x 300' => esc_html__('360 x 300', 'clinicmaster'),
		'435 x 300' => esc_html__('435 x 300', 'clinicmaster'),
		'468 x 15' => esc_html__('468 x 15', 'clinicmaster'),
		'468 x 60' => esc_html__('468 x 60', 'clinicmaster'),
		'640 x 165' => esc_html__('640 x 165', 'clinicmaster'),
		'640 x 190' => esc_html__('640 x 190', 'clinicmaster'),
		'640 x 300' => esc_html__('640 x 300', 'clinicmaster'),
		'728 x 15' => esc_html__('728 x 15', 'clinicmaster'),
		'728 x 90' => esc_html__('728 x 90', 'clinicmaster'),
		'970 x 90' => esc_html__('970 x 90', 'clinicmaster'),
		'970 x 250' => esc_html__('970 x 250', 'clinicmaster'),
		'240 x 400' => esc_html__('240 x 400 - Regional ad sizes', 'clinicmaster'),
		'250 x 360' => esc_html__('250 x 360 - Regional ad sizes', 'clinicmaster'),
		'580 x 400' => esc_html__('580 x 400 - Regional ad sizes', 'clinicmaster'),
		'750 x 100' => esc_html__('750 x 100 - Regional ad sizes', 'clinicmaster'),
		'750 x 200' => esc_html__('750 x 200 - Regional ad sizes', 'clinicmaster'),
		'750 x 300' => esc_html__('750 x 300 - Regional ad sizes', 'clinicmaster'),
		'980 x 120' => esc_html__('980 x 120 - Regional ad sizes', 'clinicmaster'),
		'930 x 180' => esc_html__('930 x 180 - Regional ad sizes', 'clinicmaster')
	);

	return $adsence_size;
}

/* Social Link Options */
function clinicmaster_social_link_options(){
	
	$social_links = array(
	    'facebook' => array(
	        'id' => 'facebook',
	        'title' => esc_html__('Facebook', 'clinicmaster'),
	    ),
	    'twitter' => array(
	        'id' => 'twitter',
	        'title' => esc_html__('Twitter', 'clinicmaster'),
	    ),
	    'linkedin' => array(
	        'id' => 'linkedin',
	        'title' => esc_html__('Linkedin', 'clinicmaster'),
	    ),
	     'instagram' => array(
	        'id' => 'instagram',
	        'title' => esc_html__('Instagram','clinicmaster'),
	    ),
	    'behance' => array(
	        'id' => 'behance',
	        'title' => esc_html__('Behance','clinicmaster'),
	    ), 
	    'skype' => array(
	        'id' => 'skype',
	        'title' => esc_html__('Skype','clinicmaster'),
	    ), 
	    'pinterest' => array(
	        'id' => 'pinterest',
	        'title' => esc_html__('Pinterest','clinicmaster'),
	    ),
	    'vimeo' => array(
	        'id' => 'vimeo',
	        'title' => esc_html__('Vimeo','clinicmaster'),
	    ),
	    'youtube' => array(
	        'id' => 'youtube',
	        'title' => esc_html__('Youtube','clinicmaster'),
	    ), 
	    'tumblr' => array(
	        'id' => 'tumblr',
	        'title' => esc_html__('Tumblr','clinicmaster'),
	    ),
	     'rss' => array(
	        'id' => 'rss',
	        'title' => esc_html__('Rss','clinicmaster'),
	    ), 
	    'yelp' => array(
	        'id' => 'yelp',
	        'title' => esc_html__('Yelp','clinicmaster'),
	    ),
	    'tripadvisor' => array(
	        'id' => 'tripadvisor',
	        'title' => esc_html__('Tripadvisor','clinicmaster'),
	    ),
	    'blogger' => array(
	        'id' => 'blogger',
	        'title' => esc_html__('Blogger','clinicmaster'),
	    ),
	    'delicious' => array(
	        'id' => 'delicious',
	        'title' => esc_html__('Delicious','clinicmaster'),
	    ), 
	    'digg' => array(
	        'id' => 'digg',
	        'title' => esc_html__('Digg','clinicmaster'),
	    ),
	    'dribbble' => array(
	        'id' => 'dribbble',
	        'title' => esc_html__('Dribbble','clinicmaster'),
	    ),
	    'flickr' => array(
	        'id' => 'flickr',
	        'title' => esc_html__('Flickr','clinicmaster'),
	    ),
	    'lastfm' => array(
	        'id' => 'lastfm',
	        'title' => esc_html__('Lastfm','clinicmaster'),
	    ),
	    'paypal' => array(
	        'id' => 'paypal',
	        'title' => esc_html__('Paypal','clinicmaster'),
	    ), 
	    'reddit' => array(
	        'id' => 'reddit',
	        'title' => esc_html__('Reddit','clinicmaster'),
	    ),
	    'share' => array(
	        'id' => 'share',
	        'title' => esc_html__('Share','clinicmaster'),
	    ),
	    'soundcloud' => array(
	        'id' => 'soundcloud',
	        'title' => esc_html__('Soundcloud','clinicmaster'),
	    ),
	    'spotify' => array(
	        'id' => 'spotify',
	        'title' => esc_html__('Spotify','clinicmaster'),
	    ),
	    'stack-overflow' => array(
	        'id' => 'stack-overflow',
	        'title' => esc_html__('Stack Overflow','clinicmaster'),
	    ), 
	     'steam' => array(
	        'id' => 'steam',
	        'title' => esc_html__('Steam','clinicmaster'),
	    ),
	    'stumbleupon' => array(
	        'id' => 'stumbleupon',
	        'title' => esc_html__('Stumbleupon','clinicmaster'),
	    ),
	    'telegram' => array(
	        'id' => 'telegram',
	        'title' => esc_html__('Telegram','clinicmaster'),
	    ),
	    'twitch' => array(
	        'id' => 'twitch',
	        'title' => esc_html__('Twitch','clinicmaster'),
	    ),
	    'vk' => array(
	        'id' => 'vk',
	        'title' => esc_html__('VKontakte','clinicmaster'),
	    ),
	    'windows' => array(
	        'id' => 'windows',
	        'title' => esc_html__('Windows','clinicmaster'),
	    ), 
	     'wordpress' => array(
	        'id' => 'wordpress',
	        'title' => esc_html__('WordPress','clinicmaster'),
	    ),
	    'yahoo' => array(
	        'id' => 'yahoo',
	        'title' => esc_html__('Yahoo','clinicmaster'),
	    ) 

	);

	return $social_links;
}

/* Social Share Options */
function clinicmaster_social_share_options(){
	
	$social_share = array(
	    'facebook' => array(
	        'id' => 'facebook',
	        'title' => esc_html__('Facebook','clinicmaster'),
	    ),
	    'twitter' => array(
	        'id' => 'twitter',
	        'title' => esc_html__('Twitter','clinicmaster'),
	    ),
	    'linkedin' => array(
	        'id' => 'linkedin',
	        'title' => esc_html__('Linkedin','clinicmaster'),
	    ),
	   'pinterest' => array(
	        'id' => 'pinterest',
	        'title' => esc_html__('Pinterest','clinicmaster'),
	    ),
	   'tumblr' => array(
	        'id' => 'tumblr',
	        'title' => esc_html__('Tumblr','clinicmaster'),
	    ),
	   'digg' => array(
	        'id' => 'digg',
	        'title' => esc_html__('Digg','clinicmaster'),
	    ),
	    'reddit' => array(
	        'id' => 'reddit',
	        'title' => esc_html__('Reddit','clinicmaster'),
	    ),

	);

	return $social_share;
}

/* Button Link Target Options */
function clinicmaster_banner_type(){
	$banner_type = array(
		'image'  => esc_html__('Image Type Banner', 'clinicmaster'),
	);
	
	return $banner_type;
}

/* Page Banner Layout Style Options */
function clinicmaster_page_banner_layout_options(){
	// post listing/collage style
	$page_banner_layout = array(
		array(
			'id'   => 'banner_layout_1',
			'listing_param' =>  array(
				'title' => esc_html__('Banner Layout 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/banner-layout/banner1.jpg'),
			'param'  => array()
		),
		array(
			'id'   => 'banner_layout_2',
			'listing_param' => array(
				'title' => esc_html__('Banner Layout 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/banner-layout/banner2.jpg'),
			'param'  => array()
		),
		
		array(
			'id'   => 'banner_layout_3',
			'listing_param' =>  array(
				'title' => esc_html__('Banner Layout 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/banner-layout/banner3.jpg'),
			'param'  => array()
		),	
		array(
			'id'   => 'banner_layout_4',
			'listing_param' =>  array(
				'title' => esc_html__('Banner Layout 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/banner-layout/banner4.png'),
			'param'  => array()
		),	

		array(
			'id'   => 'banner_layout_5',
			'listing_param' =>  array(
				'title' => esc_html__('Banner Layout 5','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/banner-layout/banner5.png'),
			'param'  => array()
		),		
	);

	return $page_banner_layout;
}

/* Page Banner Layout Style Options */
function clinicmaster_post_related_layout_options(){
	// post listing/collage style
	$post_related_layout = array(
		array(
			'id'   => 'post_related_1',
			'listing_param' =>  array(
				'title' => esc_html__('Post Related 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/related-post/related-post-1.png'),
			'param'  => array()
		),
		array(
			'id'   => 'post_related_2',
			'listing_param' => array(
				'title' => esc_html__('Post Related 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/related-post/related-post-2.png'),
			'param'  => array()
		),
		array(
			'id'   => 'post_related_3',
			'listing_param' => array(
				'title' => esc_html__('Post Related 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/related-post/related-post-3.png'),
			'param'  => array()
		),
		array(
			'id'   => 'post_related_4',
			'listing_param' => array(
				'title' => esc_html__('Post Related 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/related-post/related-post-4.png'),
			'param'  => array()
		),
	);

	return $post_related_layout;
}


/* Theme Layout Options */
function clinicmaster_job_map_layout_options(){
	$theme_layouts = array(
		array(
			'id'   => 'default',
			'img_param' => array(
				'title' => esc_html__('Default','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/default.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'style1',
			'img_param' => array(
				'title' => esc_html__('Style 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/style_1.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'style2',
			'img_param' => array(
				'title' => esc_html__('Style 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/style_2.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'style3',
			'img_param' => array(
				'title' => esc_html__('Style 3','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/style_3.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'style4',
			'img_param' => array(
				'title' => esc_html__('Style 4','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/style_4.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'custom',
			'img_param' => array(
				'title' => esc_html__('Custom','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/job-map/custom.png'
			),
			'param'  => array()
		)
	);

	return $theme_layouts;
}

function clinicmaster_page_banner_style_options(){

	$banner_style = array(
		array(
			'id'   => 'style1',
			'img_param' =>  array(
				'title' => esc_html__('Banner Style 1','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/style_1.png'
			),
			'param'  => array()
		),
		array(
			'id'   => 'style2',
			'img_param' => array(
				'title' => esc_html__('Banner Style 2','clinicmaster'),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/style_2.png'
			),
			'param'  => array()
		)
	);

	return $banner_style;
}

/* Single Product Layouts */
function clinicmaster_product_layouts_options(){

	$products_layouts = array(
		array(
			'id'   => 'default',
			'layout_param' => array(
		    	'title' => esc_html__('Default','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/default.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'standard',
			'layout_param' => array(
		    	'title' => esc_html__('Standard','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/standard.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'exclusive',
			'layout_param' => array(
		    	'title' => esc_html__('Exclusive','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/exclusive.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'gallery',
			'layout_param' => array(
		    	'title' => esc_html__('Gallery','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/gallery.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider',
			'layout_param' => array(
		    	'title' => esc_html__('Slider','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/slider.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'full_width',
			'layout_param' => array(
		    	'title' => esc_html__('Full Width','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/product-layout/full_width.png'
		    ),
			'param'  => array()
		),
		
	);

	return $products_layouts;
}

function clinicmaster_shop_template_layouts_options(){

	$shop_layouts = array(
		array(
			'id'   => 'template_1',
			'layout_param' => array(
		    	'title' => esc_html__('Template 1','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/shop/template-1.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'template_2',
			'layout_param' => array(
		    	'title' => esc_html__('Template 2','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/shop/template-2.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'template_3',
			'layout_param' => array(
		    	'title' => esc_html__('Template 3','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/shop/template-3.png'
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'template_4',
			'layout_param' => array(
		    	'title' => esc_html__('Template 4','clinicmaster'),
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/shop/template-4.png'
		    ),
			'param'  => array()
		),
	);

return $shop_layouts;
}