<?php
$id = !empty($_GET['id']) ? $_GET['id'] : '';
$user_id = !empty($_GET['user_id']) ? $_GET['user_id'] : '';
$title = !empty($_GET['title']) ? $_GET['title'] : '';
$private = !empty($_GET['private']) ? $_GET['private'] : '';
$status = !empty($_GET['status']) ? $_GET['status'] : '';
$myticket = $getdata->get_user_ticket();

if (is_wp_error($myticket)) {
    // Log or handle the error gracefully
    error_log($myticket->get_error_message());
    return false;
}

?>
<div class="boxarea">
	<div class="card">
		<?php if(!empty($private)){ ?>
			<div class="card-header bg-danger">
				<h5 class="card-title"><i class="fa fa-lock mr-2"></i><?php echo esc_html__('Private Ticket ','clinicmaster').'#'.$id; ?></h5>
			</div>
		<?php }else{ ?>
			<div class="card-header bg-success">
				<h5 class="card-title"><i class="fa fa-user-circle mr-2"></i><?php echo esc_html__('Public Ticket ','clinicmaster').'#'.$id; ?></h5>
			</div>
		<?php } ?>
		<div class="card-body status-body">
			<h3 class="status-title"><?php echo esc_html($title); ?></h3>
			<?php if(in_array($status, [0, 1, 3] )){ ?>
				<span class="badge badge-outline-light"><?php echo esc_html__('Open', 'clinicmaster'); ?></span>
			<?php }else{ ?>
				<span class="badge badge-outline-light"><?php echo esc_html__('Closed', 'clinicmaster'); ?></span>
			<?php } ?>
		</div>
		<div class="ticket-editor"id="TicketDetailReplySec">
			<div class="card-header">
				<a href="javascript:void(0);" class="btn btn-post-reply mb-2 mr-2 TicketReplyBtn" data-reply-type="ticket-comment"><i class="fa fa-comment text-success mr-2"></i><?php echo esc_html__('POST A REPLY	', 'clinicmaster'); ?><span class="badge badge-light badge-pill ml-1"><?php echo esc_html__('R', 'clinicmaster'); ?></span></a>
			</div>

			<div class="card-body default-summernote ReplyCommentSec" style="display: none;">
			
				<form id="dexignzone-envato-ticket-reply-form" method="post" action="" accept-charset="UTF-8" enctype="multipart/form-data">
					<div class="verfication-alert text-center"><span class="verfication-txt"></span></div>
					<?php wp_nonce_field('submit_user_ticket_reply', 'submit_user_ticket_reply_nonce'); ?>
					<div class="row">
						<div class="col-md-12 form-group">
							<?php
								wp_editor(
									'',
									'ticket_reply', // Unique ID for the editor
									array(
										'textarea_name' => 'ticket_reply', // Name for the form field
										'media_buttons' => false, // Show media upload buttons
										'textarea_rows' => 10,   // Number of rows in the textarea
									)
								);
							?>
						</div>
						<div class="col-md-3 form-group">
							<div class="form-check">
								<input class="form-check-input" id="status" name="status" type="checkbox" value="2">
								<label class="form-check-label" for="status"><?php echo esc_html__('Close', 'clinicmaster'); ?></label>
							</div>
						</div>
						<input name="user_id" type="hidden" value="<?php echo esc_attr($user_id); ?>">
						<input name="ticket_id" type="hidden" value="<?php echo esc_attr($id); ?>">
						<input type="hidden"  name="action" value="submit_user_ticket_reply">
						<input name="type" type="hidden" value="2">
						<div class="summernote-btn col-md-12">
							<button type="submit" class="btn btn-green mb-2 mr-3"><?php echo esc_html__('Post Reply', 'clinicmaster'); ?></button>
						</div>
					</div>
				</form>
			
			</div>	
		</div>
		<?php if( isset($myticket) &&  !empty($myticket['data'])){ ?>					
		<div class="card-body msg-box  comment-sec">
			<?php foreach($myticket['data'] as $reply){
				$first_name = $reply['user']['first_name'].' '.$reply['user']['last_name'];
				?>
			<div class="media">
				<?php 
				 $user_img = 'https://support.w3itexperts.com/public/images/no-user.png';
				
				if(!empty($reply['user']['image'])){ 
					$user_img = 'https://support.w3itexperts.com/public/storage/user-images/'.$reply['user']['image'];
					
				} ?>
				<div class="text-center mr-3">
					<img class="align-self-start ticket-thumb rounded-circle" width="60" src="<?php echo esc_url($user_img); ?>" alt="DexignLab">
				</div>
				<div class="media-body chat-bx">
					<?php if(!empty($first_name)){ ?>
					<span class="text-black"><?php echo esc_html($first_name); ?></span>
					<?php } ?>
					<?php if($reply['private'] == 1 && $reply['type'] == 2){ ?>
						<span class="text-danger"><?php echo esc_html__('replied privately', 'clinicmaster'); ?></span>
					<?php }else{ ?>
						<span><?php echo esc_html__('replied', 'clinicmaster'); ?></span>
					<?php } 
					if($reply['parent_id'] == 0 && $reply['type'] == 1){ ?>
						<span><?php echo esc_html__('started the conversation', 'clinicmaster'); ?></span>
					<?php }
						$updated_at_obj = new DateTime($reply['created_at']); // Assuming $val['created_at'] is a valid datetime string.
						$time = $updated_at_obj->format('h:i A'); // Formats the time in 12-hour format with AM/PM.
						$date = $updated_at_obj->format('F d, Y'); // Formats the date as "Month day, Year".
						$from = $updated_at_obj->getTimestamp();
					?>
					
					<a href="javascript:void(0);" class="d-block conversation-date mt-1"> 
					<?php echo human_time_diff($from); ?><?php echo esc_html(' ago on '.$date); ?><?php echo esc_html__(' at ', 'clinicmaster'); ?><?php echo esc_html($time); ?>
					</a>
					<div class="media-body ticketContentContainer edit-content-14394">
						<div class="pt-3 pb-3 ticket-description-sec">
							<?php echo wp_kses(nl2br($reply['description']), clinicmaster_allowed_html_tag()); ?>
						</div>
					</div>
					<?php if(isset($reply['ticket_attachments']) && !empty($reply['ticket_attachments']) ){ ?>
							<div class="attached-area">
								<p class="mb-2 attached-title">
									<strong class="text-uppercase"><?php echo esc_html__('attached files:','clinicmaster'); ?></strong>
								</p>
								<?php foreach($reply['ticket_attachments'] as $attachment){
									$img = $attachment['attachment'];
									 $img_url = "https://support.w3itexperts.com/public/storage/ticket-images/".$img;
									
									?>
									<div class="row">
										<a href="<?php echo esc_url($img_url); ?>" target="_blank" class="col-md-12 ticket-image-popup"><i class="ti-clip"></i>
											<?php echo esc_html($img); ?>
										</a>
									</div>
								<?php } ?>
							</div>
						<?php } ?>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
</div>