<?php

get_header();
$clinicmaster_option = getDZThemeReduxOption();
$error_page_template    = !empty($clinicmaster_option['error_page_template']) ? $clinicmaster_option['error_page_template']	: '';
$error_page_title       = !empty($clinicmaster_option['error_page_title']) ? $clinicmaster_option['error_page_title']	: '';
$error_page_button_text = !empty($clinicmaster_option['error_page_button_text']) ? $clinicmaster_option['error_page_button_text']	: '';
$error_page_image 		= !empty($clinicmaster_option['error_page_image']) ? $clinicmaster_option['error_page_image'] : '';
$error_page_subtitle 	= !empty($clinicmaster_option['error_page_subtitle']) ? $clinicmaster_option['error_page_subtitle'] : '';
$error_page_pattern_image = !empty($clinicmaster_option['error_page_pattern_image']) ? $clinicmaster_option['error_page_pattern_image'] : '';

clinicmaster_get_banner();
		if($error_page_template == 'error_style_2'){
?>
		<section class="error-page style-1 content-inner-1 bg-light">
			<div class="container">
				<div class="row align-items-center g-5 justify-content-center">
					<div class="col-lg-6 col-md-9">
						<div class="dz-error-media">
							<?php if(!empty($error_page_image)){ ?>
								<img src="<?php echo esc_url($error_page_image); ?>" alt="<?php echo esc_attr('Image', 'clinicmaster'); ?>">
							<?php } ?>
							<?php if(!empty($error_page_pattern_image)){ ?>
							<div class="item1">
								<img src="<?php echo esc_url($error_page_pattern_image); ?>" alt="<?php echo esc_attr('Pattern Image', 'clinicmaster'); ?>">
								<svg width="234" height="220" viewBox="0 0 234 220" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M16.8986 163.335C-24.2798 77.0297 10.8709 -27.2904 157.814 7.29291C157.814 7.29291 250.039 33.9858 231.155 133.954C215.053 219.194 100.586 243.163 41.6752 194.874C26.1745 205.432 -13.9549 231.297 30.6519 184.225C25.2719 178.082 20.6185 171.131 16.8986 163.335Z" fill="var(--bs-primary)"/>
								</svg>
							</div>
							<?php } ?>
						</div>
					</div>      
					<div class="col-lg-6">
						<div class="inner-content text-center">
							<h2 class="dz-error data-name-primary" data-name="404"><?php echo wp_kses($error_page_title, 'string'); ?></h2>
							<p class="text"><?php echo wp_kses($error_page_subtitle, 'string'); ?></p>
							<a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow"><?php echo wp_kses($error_page_button_text, 'string'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</section>
		<?php }elseif($error_page_template == 'error_style_3'){ ?>
		<section class="error-page style-2 overflow-hidden content-inner-1">
			<div class="container">
				<div class="row align-items-center justify-content-center">
					<div class="col-md-7">
						<?php if(!empty($error_page_image)){ ?>
						<div class="dz-error-media">
							<img src="<?php echo esc_url($error_page_image); ?>" alt="<?php echo esc_attr('Image', 'clinicmaster'); ?>">
						</div>
						<?php } ?>
					</div>
					<div class="col-md-5">
						<div class="inner-content">
							<h2 class="dz-error"><?php echo wp_kses($error_page_title, 'string'); ?></h2>
							<p class="text"><?php echo wp_kses($error_page_subtitle, 'string'); ?></p>
							<a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow"><?php echo wp_kses($error_page_button_text,'string'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</section>
		
		<?php }elseif($error_page_template == 'error_style_4'){ ?>
		    
			<section class="error-page style-4 bg-light">
		<div class="container">
			<div class="inner-content text-center">
				<div class="error-media">
					<div class="error-text">
						<svg width="480" height="239" viewBox="0 0 480 239" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path class="move-4" d="M195.016 211.926C182.68 196.485 175.679 173.389 174.01 142.646C172.351 112.077 176.816 88.4475 187.407 71.7579C198 55.0721 214.148 46.1359 235.862 44.9573C257.573 43.779 274.598 50.9147 286.933 66.3557C299.268 81.8009 306.266 104.808 307.926 135.377C309.585 165.949 305.12 189.618 294.534 206.394C283.947 223.169 267.797 232.146 246.086 233.325C224.372 234.503 207.352 227.372 195.016 211.926Z" fill="#F4F8E9"></path>
							<path class="move-4" d="M195.016 211.926C182.68 196.485 175.679 173.389 174.01 142.646C172.351 112.077 176.816 88.4475 187.407 71.7579C198 55.0721 214.148 46.1359 235.862 44.9573C257.573 43.779 274.598 50.9147 286.933 66.3557C299.268 81.8009 306.266 104.808 307.926 135.377C309.585 165.949 305.12 189.618 294.534 206.394C283.947 223.169 267.797 232.146 246.086 233.325C224.372 234.503 207.352 227.372 195.016 211.926Z" stroke="var(--bs-primary)" stroke-width="10" stroke-miterlimit="10"></path>
							<path class="move-4" d="M269.567 189.321C274.361 178.176 276.119 160.79 274.837 137.168C273.546 113.373 269.916 96.2794 263.953 85.8895C257.989 75.4996 249.1 70.6257 237.291 71.2668C225.478 71.9079 217.171 77.7596 212.375 88.8191C207.573 99.8827 205.816 117.224 207.098 140.844C208.38 164.467 212.007 181.561 217.982 192.121C223.952 202.687 232.845 207.646 244.659 207.005C256.468 206.364 264.772 200.472 269.567 189.321Z" stroke="var(--bs-primary)" stroke-width="10" stroke-miterlimit="10"></path>
							<path class="move-4" d="M479.177 137.483L458.879 141.562L467.036 182.156L423.578 190.888L415.422 150.293L335.794 166.293L329.468 134.805L378.131 10.5093L430.436 0L451.35 104.089L471.647 100.011L479.177 137.483ZM396.547 56.353L373.544 119.722L407.892 112.82L396.547 56.353Z" fill="var(--bs-primary)"></path>
							<path class="move-4" d="M144.257 158.5L123.836 155.096L117.029 195.938L73.3058 188.65L80.1133 147.808L0 134.455L5.28031 102.775L94.9521 3.89844L147.576 12.6697L130.12 117.394L150.541 120.798L144.257 158.5ZM95.8664 53.2942L51.8392 104.346L86.3971 110.106L95.8664 53.2942Z" fill="var(--bs-primary)"></path>
						</svg>
					</div>
					<div class="error-wave">
						<svg width="630" height="99" viewBox="0 0 630 99" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M403.405 0H187.512V2.87869H403.405V0Z" fill="var(--bs-primary)"></path>
							<path d="M548.121 2.7839H516.962C516.807 2.7839 516.682 2.67829 516.682 2.54817V0.876358C516.682 0.746233 516.807 0.640625 516.962 0.640625H548.121C548.276 0.640625 548.402 0.746233 548.402 0.876358V2.54817C548.402 2.67829 548.276 2.7839 548.121 2.7839Z" fill="var(--bs-primary)"></path>
							<path d="M68.7854 2.88924H42.4435C42.3124 2.88924 42.2061 2.78286 42.2061 2.6518V0.967906C42.2061 0.836841 42.3124 0.730469 42.4435 0.730469H68.7854C68.9165 0.730469 69.0229 0.836841 69.0229 0.967906V2.6518C69.0229 2.78286 68.9165 2.88924 68.7854 2.88924Z" fill="var(--bs-primary)"></path>
							<path d="M525.186 46.904H498.686C498.598 46.904 498.527 46.8331 498.527 46.7457V45.6231C498.527 45.5358 498.598 45.4648 498.686 45.4648H525.186C525.273 45.4648 525.344 45.5358 525.344 45.6231V46.7457C525.344 46.8331 525.273 46.904 525.186 46.904Z" fill="#C4CEFE"></path>
							<path d="M630 4.91016H0V98.4409H630V4.91016Z" fill="#F4F8E9"></path>
							<path class="move-2" d="M101.297 48.8806H74.797C74.7096 48.8806 74.6387 48.8097 74.6387 48.7223V47.5997C74.6387 47.5123 74.7096 47.4414 74.797 47.4414H101.297C101.385 47.4414 101.455 47.5123 101.455 47.5997V48.7223C101.455 48.8097 101.385 48.8806 101.297 48.8806Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M174.067 48.8806H147.566C147.479 48.8806 147.408 48.8097 147.408 48.7223V47.5997C147.408 47.5123 147.479 47.4414 147.566 47.4414H174.067C174.154 47.4414 174.225 47.5123 174.225 47.5997V48.7223C174.225 48.8097 174.154 48.8806 174.067 48.8806Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M240.296 31.7868H213.796C213.709 31.7868 213.638 31.7159 213.638 31.6285V30.5059C213.638 30.4186 213.709 30.3477 213.796 30.3477H240.296C240.384 30.3477 240.455 30.4186 240.455 30.5059V31.6285C240.455 31.7159 240.384 31.7868 240.296 31.7868Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M277.963 50.6892H251.463C251.376 50.6892 251.305 50.6183 251.305 50.5309V49.4083C251.305 49.3209 251.376 49.25 251.463 49.25H277.963C278.051 49.25 278.122 49.3209 278.122 49.4083V50.5309C278.122 50.6183 278.051 50.6892 277.963 50.6892Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M370.899 50.6892H344.399C344.311 50.6892 344.24 50.6183 344.24 50.5309V49.4083C344.24 49.3209 344.311 49.25 344.399 49.25H370.899C370.986 49.25 371.057 49.3209 371.057 49.4083V50.5309C371.057 50.6183 370.986 50.6892 370.899 50.6892Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M474.872 49.6228H448.372C448.285 49.6228 448.214 49.5519 448.214 49.4645V48.3419C448.214 48.2545 448.285 48.1836 448.372 48.1836H474.872C474.96 48.1836 475.031 48.2545 475.031 48.3419V49.4645C475.031 49.5519 474.96 49.6228 474.872 49.6228Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M144.576 29.0173H118.075C117.988 29.0173 117.917 28.9464 117.917 28.859V27.7364C117.917 27.649 117.988 27.5781 118.075 27.5781H144.576C144.663 27.5781 144.734 27.649 144.734 27.7364V28.859C144.734 28.9464 144.663 29.0173 144.576 29.0173Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M329.615 28.3181H303.114C303.027 28.3181 302.956 28.2472 302.956 28.1598V27.0372C302.956 26.9498 303.027 26.8789 303.114 26.8789H329.615C329.702 26.8789 329.773 26.9498 329.773 27.0372V28.1598C329.773 28.2472 329.702 28.3181 329.615 28.3181Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M518.146 28.2087H491.646C491.558 28.2087 491.487 28.1378 491.487 28.0504V26.9278C491.487 26.8404 491.558 26.7695 491.646 26.7695H518.146C518.233 26.7695 518.304 26.8404 518.304 26.9278V28.0504C518.304 28.1378 518.233 28.2087 518.146 28.2087Z" fill="var(--bs-primary)"></path>
							<path class="move-2" d="M425.349 21.5017H398.849C398.761 21.5017 398.69 21.4308 398.69 21.3434V20.2208C398.69 20.1334 398.761 20.0625 398.849 20.0625H425.349C425.436 20.0625 425.507 20.1334 425.507 20.2208V21.3434C425.507 21.4311 425.436 21.5017 425.349 21.5017Z" fill="var(--bs-primary)"></path>
							</svg>
							
					</div>
				</div>
				<p class="text wow fadeInUp" data-wow-delay="0.4s" data-wow-duration="0.8s" style="visibility: visible; animation-duration: 0.8s; animation-delay: 0.4s; animation-name: fadeInUp;"><?php echo wp_kses($error_page_subtitle, 'string'); ?></p>
				<a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-primary btn-hover1"><?php echo wp_kses($error_page_button_text,'string'); ?></a>
				<div class="main-item move-3">
					<svg width="881" height="117" viewBox="0 0 881 117" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M406.271 8.27007C406.559 9.23319 407.1 10.0577 407.755 10.8106C408.024 11.1192 408.316 11.4081 408.597 11.706C410.166 13.5358 412.04 15.0152 414.042 16.3437C414.497 16.6456 414.967 16.9302 415.452 17.1829C419.05 19.0596 422.655 18.6997 426.124 16.9169C429.052 15.4126 431.311 13.1409 432.905 10.2353C434.178 7.91404 434.334 5.49759 433.682 3.00587C433.504 2.3251 433.149 1.68268 432.821 1.05038C432.373 0.187039 431.608 -0.111058 430.663 0.0358506C430.258 0.0989563 429.857 0.205147 429.459 0.310548C427.202 0.908982 424.949 1.52306 422.69 2.11306C418.801 3.12882 414.883 4.0186 410.935 4.77227C409.821 4.98476 408.706 5.20084 407.668 5.68364C407.39 5.81311 407.103 5.94584 406.865 6.13313C406.686 6.27363 406.541 6.48747 406.45 6.69794C406.33 6.97499 406.247 7.27669 406.208 7.57535C406.178 7.80145 406.206 8.05027 406.271 8.27007ZM415.05 6.03414C415.13 6.01885 415.227 6.08859 415.338 6.12616C415.156 6.40929 414.982 6.65936 414.828 6.92078C414.26 7.8866 414.322 8.91743 414.994 9.78663C415.45 10.3759 416.164 10.4113 416.673 9.84737C416.877 9.6206 417.028 9.34646 417.209 9.0982C417.304 8.96805 417.412 8.84735 417.608 8.60719C417.65 8.98133 417.67 9.2045 417.7 9.42633C417.766 9.90811 417.943 10.3503 418.24 10.7327C418.5 11.0667 418.922 11.094 419.232 10.8104C419.655 10.4226 419.901 9.94974 419.862 9.3639C419.859 9.3179 419.775 9.2774 419.672 9.18167C419.406 9.50811 419.143 9.83151 418.841 10.2015C418.72 10.0469 418.598 9.95637 418.57 9.84265C418.498 9.54861 418.447 9.2459 418.425 8.94387C418.405 8.67368 418.445 8.39955 418.44 8.12755C418.436 7.84274 418.36 7.57557 418.064 7.46061C417.76 7.34249 417.524 7.52877 417.336 7.72068C417.075 7.98874 416.853 8.29448 416.617 8.58695C416.408 8.84601 416.252 9.15715 415.928 9.32116C415.817 9.23398 415.717 9.18853 415.667 9.11114C415.284 8.51236 415.256 7.911 415.643 7.2885C415.964 6.77319 416.25 6.23708 416.579 5.6634C418.67 5.07835 420.814 4.46337 422.969 3.88552C423.565 3.72545 424.181 3.79992 424.92 3.9898C424.659 4.14784 424.513 4.22096 424.384 4.31747C423.849 4.71759 423.758 5.17373 424.084 5.7365C424.302 6.11075 424.634 6.33877 425.038 6.46667C425.331 6.5597 425.639 6.61223 425.93 6.71054C426.107 6.77027 426.266 6.88276 426.591 7.05554C426.278 7.15802 426.126 7.26037 425.991 7.24283C425.415 7.16825 424.842 7.06465 424.271 6.95835C423.935 6.8957 423.607 6.78186 423.269 6.73923C422.886 6.69086 422.61 6.82202 422.559 7.01449C422.485 7.29436 422.699 7.44666 422.836 7.63429C423.042 7.91518 423.376 8.09954 423.619 8.61046C422.216 7.82102 421.417 6.65216 420.261 5.64719C420.298 5.95732 420.262 6.15193 420.343 6.25755C420.987 7.0957 421.631 7.94375 422.531 8.53667C422.84 8.74061 423.193 8.88707 423.54 9.02453C423.74 9.1035 423.957 9.04466 424.096 8.86389C424.245 8.66883 424.162 8.474 424.036 8.30268C423.935 8.16612 423.806 8.04993 423.706 7.9127C423.622 7.79627 423.401 7.7434 423.518 7.46949C423.743 7.54137 423.962 7.61089 424.181 7.68097C424.638 7.8272 425.086 8.01843 425.553 8.10639C425.95 8.18097 426.372 8.16613 426.777 8.13081C426.962 8.11461 427.177 7.99144 427.305 7.85128C427.79 7.31921 427.723 6.46577 427.138 6.04417C426.812 5.80941 426.414 5.66902 426.041 5.504C425.831 5.4112 425.604 5.35484 425.233 5.23178C425.483 5.09915 425.595 5.04324 425.704 4.98059C425.823 4.9122 425.944 4.84606 426.053 4.76417C426.668 4.30308 426.706 3.90262 426.197 3.32522C426.116 3.23265 426.036 3.13815 425.916 2.99799C427.011 2.62082 428.046 2.26255 429.082 1.91046C429.174 1.8793 429.28 1.88774 429.426 1.873C429.526 2.08178 429.647 2.28561 429.722 2.50507C429.958 3.18833 430.029 3.89633 430.024 4.6176C430.015 5.90513 429.596 7.08197 429.129 8.26635C428.596 9.61452 427.755 10.6782 426.605 11.5537C425.453 12.4301 424.187 12.95 422.746 13.1127C421.742 13.2261 420.759 13.069 419.766 13.0399C418.413 13.0002 417.22 12.5472 416.101 11.8403C414.14 10.6026 412.506 9.02577 411.113 7.18547C411.652 6.85419 413.331 6.36205 415.05 6.03414ZM409.62 7.40369C409.726 7.5488 409.853 7.6722 409.92 7.82192C410.19 8.42485 410.611 8.92025 411.067 9.3792C412.544 10.8634 414.194 12.1205 416.058 13.1022C417.235 13.7221 418.467 14.0636 419.807 14.0276C420.356 14.0129 420.906 14.0491 421.455 14.051C424.233 14.0603 426.504 12.9224 428.413 10.9865C429.278 10.1095 429.712 8.98436 430.125 7.86669C430.88 5.81896 431.06 3.75987 430.076 1.72215C430.063 1.69515 430.077 1.655 430.081 1.57592C430.354 1.3586 430.666 1.16973 431.088 1.1127C431.467 1.48334 431.598 1.98448 431.766 2.45299C432.664 4.95427 432.575 7.37962 431.21 9.73241C430.056 11.7218 428.503 13.3185 426.62 14.635C425.127 15.6799 423.495 16.321 421.682 16.5414C420.069 16.7375 418.519 16.5433 417.074 15.8181C416.16 15.3595 415.257 14.8541 414.425 14.2657C412.492 12.901 410.763 11.2995 409.169 9.55985C408.686 9.0333 408.273 8.44353 407.834 7.87805C407.802 7.83643 407.82 7.75668 407.807 7.62045C408.389 7.46376 408.995 7.44014 409.62 7.40369ZM413.059 7.37095C412.836 7.49885 412.764 7.77929 412.904 7.9767C413.039 8.16861 413.363 8.24622 413.529 8.12676C413.715 7.99369 413.742 7.7164 413.591 7.4975C413.471 7.32382 413.238 7.26836 413.059 7.37095ZM421.951 10.2701C422.274 9.97179 422.351 9.43442 422.125 9.06254C421.975 8.81675 421.651 8.73858 421.419 8.89246C421.007 9.16615 420.9 9.86526 421.212 10.2405C421.371 10.4313 421.76 10.4469 421.951 10.2701Z" fill="var(--bs-primary)"></path>
						<path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M747.051 106.004C747.339 106.968 747.88 107.792 748.536 108.545C748.804 108.854 749.096 109.143 749.378 109.44C750.946 111.27 752.82 112.75 754.822 114.078C755.277 114.38 755.747 114.665 756.232 114.917C759.83 116.794 763.435 116.434 766.905 114.651C769.832 113.147 772.091 110.875 773.685 107.97C774.958 105.648 775.115 103.232 774.463 100.74C774.285 100.059 773.93 99.4171 773.602 98.7848C773.154 97.9214 772.389 97.6233 771.444 97.7702C771.038 97.8333 770.637 97.9395 770.239 98.0449C767.982 98.6434 765.73 99.2574 763.471 99.8474C759.582 100.863 755.664 101.753 751.715 102.507C750.601 102.719 749.486 102.935 748.449 103.418C748.17 103.547 747.884 103.68 747.645 103.868C747.467 104.008 747.321 104.222 747.23 104.432C747.11 104.709 747.027 105.011 746.988 105.31C746.959 105.536 746.986 105.785 747.051 106.004ZM755.83 103.769C755.91 103.753 756.007 103.823 756.118 103.861C755.936 104.144 755.762 104.394 755.609 104.655C755.04 105.621 755.103 106.652 755.774 107.521C756.23 108.11 756.944 108.146 757.453 107.582C757.658 107.355 757.808 107.081 757.989 106.833C758.084 106.702 758.192 106.582 758.388 106.342C758.43 106.716 758.451 106.939 758.481 107.161C758.546 107.642 758.723 108.085 759.021 108.467C759.28 108.801 759.703 108.828 760.012 108.545C760.435 108.157 760.681 107.684 760.642 107.098C760.639 107.052 760.555 107.012 760.453 106.916C760.187 107.242 759.923 107.566 759.622 107.936C759.5 107.781 759.378 107.691 759.35 107.577C759.278 107.283 759.227 106.98 759.205 106.678C759.186 106.408 759.225 106.134 759.221 105.862C759.216 105.577 759.14 105.31 758.844 105.195C758.54 105.077 758.304 105.263 758.117 105.455C757.855 105.723 757.633 106.029 757.397 106.321C757.188 106.58 757.032 106.892 756.709 107.056C756.597 106.968 756.497 106.923 756.448 106.846C756.064 106.247 756.036 105.645 756.423 105.023C756.744 104.508 757.031 103.971 757.359 103.398C759.45 102.813 761.595 102.198 763.749 101.62C764.346 101.46 764.962 101.534 765.701 101.724C765.44 101.882 765.293 101.955 765.164 102.052C764.629 102.452 764.538 102.908 764.865 103.471C765.082 103.845 765.415 104.073 765.818 104.201C766.112 104.294 766.419 104.347 766.71 104.445C766.887 104.505 767.046 104.617 767.371 104.79C767.058 104.892 766.906 104.995 766.771 104.977C766.195 104.903 765.623 104.799 765.051 104.693C764.715 104.63 764.387 104.516 764.05 104.474C763.667 104.425 763.39 104.556 763.339 104.749C763.265 105.029 763.479 105.181 763.617 105.369C763.823 105.65 764.156 105.834 764.399 106.345C762.996 105.555 762.197 104.387 761.041 103.382C761.078 103.692 761.042 103.886 761.123 103.992C761.768 104.83 762.411 105.678 763.311 106.271C763.62 106.475 763.973 106.621 764.321 106.759C764.52 106.838 764.737 106.779 764.876 106.598C765.025 106.403 764.943 106.208 764.816 106.037C764.715 105.9 764.586 105.784 764.486 105.647C764.402 105.531 764.181 105.478 764.298 105.204C764.524 105.276 764.743 105.345 764.962 105.415C765.418 105.562 765.866 105.753 766.334 105.841C766.73 105.915 767.152 105.901 767.558 105.865C767.742 105.849 767.957 105.726 768.085 105.586C768.57 105.054 768.504 104.2 767.918 103.779C767.593 103.544 767.195 103.403 766.821 103.238C766.611 103.146 766.385 103.089 766.014 102.966C766.263 102.834 766.376 102.778 766.484 102.715C766.603 102.647 766.725 102.58 766.834 102.499C767.449 102.037 767.487 101.637 766.978 101.06C766.896 100.967 766.817 100.873 766.696 100.732C767.791 100.355 768.826 99.9969 769.863 99.6448C769.955 99.6137 770.06 99.6221 770.207 99.6074C770.306 99.8162 770.427 100.02 770.503 100.239C770.738 100.923 770.81 101.631 770.804 102.352C770.795 103.64 770.377 104.816 769.909 106.001C769.377 107.349 768.535 108.413 767.385 109.288C766.234 110.164 764.967 110.684 763.526 110.847C762.522 110.96 761.539 110.803 760.546 110.774C759.193 110.735 758.001 110.282 756.881 109.575C754.92 108.337 753.286 106.76 751.893 104.92C752.432 104.589 754.112 104.096 755.83 103.769ZM750.4 105.138C750.507 105.283 750.634 105.407 750.701 105.556C750.97 106.159 751.391 106.655 751.848 107.114C753.324 108.598 754.974 109.855 756.838 110.837C758.015 111.457 759.247 111.798 760.587 111.762C761.136 111.747 761.686 111.784 762.235 111.785C765.013 111.795 767.284 110.657 769.193 108.721C770.058 107.844 770.493 106.719 770.905 105.601C771.661 103.553 771.84 101.494 770.856 99.4565C770.843 99.4295 770.857 99.3894 770.861 99.3103C771.134 99.093 771.446 98.9041 771.869 98.8471C772.248 99.2177 772.378 99.7189 772.546 100.187C773.445 102.689 773.355 105.114 771.99 107.467C770.836 109.456 769.283 111.053 767.401 112.369C765.907 113.414 764.276 114.055 762.463 114.276C760.85 114.472 759.3 114.278 757.854 113.552C756.94 113.094 756.038 112.588 755.205 112C753.273 110.635 751.543 109.034 749.949 107.294C749.466 106.768 749.053 106.178 748.614 105.612C748.582 105.571 748.6 105.491 748.588 105.355C749.17 105.198 749.775 105.175 750.4 105.138ZM753.839 105.105C753.617 105.233 753.545 105.514 753.684 105.711C753.819 105.903 754.143 105.981 754.31 105.861C754.495 105.728 754.522 105.451 754.371 105.232C754.251 105.058 754.018 105.003 753.839 105.105ZM762.731 108.004C763.054 107.706 763.132 107.169 762.905 106.797C762.756 106.551 762.431 106.473 762.199 106.627C761.788 106.901 761.68 107.6 761.992 107.975C762.151 108.166 762.54 108.181 762.731 108.004Z" fill="var(--bs-primary)"></path>
						<path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M20.0642 23.9783C19.9922 23.9669 19.924 23.9895 19.8762 24.0396C19.8226 24.0941 19.8052 24.1971 19.8385 24.2677C19.8577 24.3084 19.8874 24.3456 19.9235 24.3754C19.9694 24.413 20.0248 24.4386 20.0803 24.4453C20.1508 24.4536 20.2141 24.4298 20.2544 24.3794C20.2923 24.3326 20.2946 24.2773 20.2957 24.244C20.2965 24.2235 20.2947 24.1731 20.2857 24.154C20.2413 24.0606 20.1563 23.9929 20.0642 23.9783ZM0.833795 25.5536C1.38025 26.7547 2.23059 27.853 3.4337 28.9115C4.40114 29.76 5.55482 30.301 6.84329 30.4948C7.59153 30.6078 8.32991 30.6433 9.03817 30.6012C9.12569 30.5962 9.21387 30.5953 9.30949 30.594L9.28478 30.8089C9.26533 30.978 9.24264 31.1467 9.22076 31.3153C9.17349 31.6724 9.12474 32.0422 9.10016 32.409C8.98927 34.0691 9.39162 35.6205 10.2961 37.0201C10.5296 37.3815 10.8146 37.7995 11.1554 38.1597C11.3543 38.3703 11.5623 38.5648 11.7797 38.744C12.8227 39.6035 14.077 40.1025 15.5193 40.2298C16.6202 40.327 17.7083 40.0739 18.8453 39.4555C19.6801 39.0016 20.4209 38.3905 21.0476 37.6385C21.3247 37.3048 21.5048 37.0071 21.6131 36.7009C21.6649 36.5552 21.7435 36.3345 21.5607 36.1447C21.5076 36.0922 21.439 36.0628 21.3604 36.0626C21.2286 36.0624 21.0792 36.1417 20.9394 36.2856C20.8823 36.3447 20.8289 36.4074 20.7758 36.4701C20.741 36.5106 20.7063 36.5515 20.6702 36.5911C19.8819 37.4634 19.0165 38.1102 18.0259 38.5683C15.3401 39.8092 12.7453 38.5233 11.5692 36.6129C11.2005 36.0128 10.8016 35.2865 10.6397 34.4532C10.5425 33.9519 10.5003 33.4886 10.5119 33.037C10.5279 32.3843 10.6103 31.6917 10.7638 30.9196C10.7767 30.8566 10.7942 30.7942 10.8118 30.7317C10.8305 30.6654 10.8489 30.5989 10.8632 30.5319C10.9024 30.341 11.0079 30.2348 11.2394 30.1536C12.466 29.7236 13.5268 28.9831 14.4822 27.8897C14.6873 27.6544 14.8825 27.3909 15.0621 27.107C15.1816 26.9175 15.2823 26.7209 15.3887 26.5124C15.4277 26.4353 15.4678 26.357 15.5097 26.2773L15.5401 26.2684C15.6036 26.2492 15.6749 26.2267 15.7488 26.2162C16.3291 26.1324 16.9188 26.1667 17.5018 26.3188C18.3976 26.5518 19.2114 26.9279 19.9209 27.4364C20.2163 27.6487 20.5466 27.9165 20.7874 28.3105C20.6002 28.5956 20.5496 28.9058 20.5272 29.1495C20.5216 29.2084 20.5068 29.267 20.4913 29.3246C20.4551 29.4594 20.3798 29.5281 20.2482 29.5473C20.1935 29.5554 20.1379 29.5621 20.0827 29.5685C19.9675 29.5823 19.8519 29.5963 19.739 29.6214C19.4884 29.6766 19.3129 29.7904 19.2174 29.9591C19.123 30.1273 19.1169 30.3328 19.1995 30.5709C19.2443 30.6993 19.3208 30.8304 19.4216 30.9506C19.4776 31.0184 19.5525 31.056 19.6316 31.0587C19.6951 31.0613 19.792 31.0426 19.8942 30.9398C19.919 30.9148 19.9324 30.8809 19.931 30.8457L19.9182 30.4679C19.9929 30.4289 20.0718 30.4296 20.167 30.4303C20.2159 30.4308 20.2637 30.4309 20.3103 30.4262C20.9287 30.366 21.2643 30.0932 21.4318 29.5139C21.4521 29.4433 21.4671 29.3715 21.4821 29.2996C21.4976 29.2247 21.5127 29.1502 21.5357 29.0782C21.5382 29.0689 21.5477 29.0536 21.5576 29.0411C21.5908 29.0509 21.6195 29.0675 21.6281 29.0778C21.6771 29.1547 21.7099 29.2471 21.7449 29.3455L21.7718 29.4207C21.7868 29.4607 21.7991 29.5018 21.8112 29.5428C21.8338 29.6186 21.8567 29.6938 21.8909 29.7634C21.933 29.8485 22.0581 29.9595 22.1756 29.9407C22.2827 29.9225 22.4192 29.8537 22.4673 29.7447C22.6128 29.4192 22.6049 29.0481 22.4461 28.7261C22.2851 28.4005 21.99 28.1643 21.6378 28.0779C21.5829 28.0641 21.5284 28.0524 21.4819 28.0421C21.4451 27.9672 21.4094 27.8929 21.3748 27.8198C21.2811 27.6224 21.1925 27.4359 21.0799 27.2578C20.7514 26.7389 20.2629 26.3035 19.5431 25.8887C18.4622 25.2648 17.2857 24.9569 16.0463 24.9739C15.99 24.9746 15.9338 24.9735 15.8709 24.9727L15.8811 24.8961C15.9326 24.8943 15.979 24.8929 16.0251 24.896C16.9323 24.9619 17.8265 24.8264 18.7583 24.4827L19.0109 24.3904C19.1806 24.3289 19.3501 24.2667 19.5188 24.202C19.63 24.1584 19.7557 24.1097 19.8636 24.0341C19.9961 23.9411 20.1304 23.8499 20.2646 23.7589C20.6275 23.5115 21.0031 23.256 21.345 22.9675C22.1626 22.2773 23.1248 21.7507 24.2051 21.4018C26.002 20.8212 27.9113 20.7339 29.8809 21.1436C29.8927 21.1459 29.905 21.1494 29.9177 21.1538C29.1538 21.7102 28.3909 22.2653 27.6269 22.8187L27.0209 23.2556C26.7319 23.4633 26.4431 23.6715 26.1556 23.8814C26.0029 23.9922 25.8883 24.0898 25.7943 24.1878C25.724 24.2605 25.6887 24.4234 25.7469 24.5239C25.7959 24.6086 25.917 24.7344 26.0479 24.7277C26.2011 24.7205 26.3557 24.6801 26.4824 24.6136C27.3584 24.156 28.2858 23.6459 29.1329 23.0161C29.6423 22.6375 30.1545 22.2629 30.667 21.8889L31.1233 21.5554C31.1462 21.5384 31.1718 21.5247 31.1968 21.5115L31.1979 21.5111C32.2384 21.6827 34.2883 22.746 35.0347 23.4906C35.0164 23.5 34.9977 23.5082 34.979 23.5164L34.0643 23.8948C33.4347 24.1547 32.8051 24.4147 32.178 24.681C31.9781 24.7659 31.7871 24.8715 31.6021 24.9739L31.4067 25.081C31.3304 25.1219 31.2437 25.1683 31.1975 25.2523C31.1722 25.2981 31.0952 25.4564 31.1453 25.5878C31.1861 25.6966 31.3252 25.7975 31.4425 25.8057C31.5983 25.8164 31.7447 25.7765 31.8401 25.7412L32.0571 25.66C32.5608 25.471 33.0813 25.2755 33.5871 25.0645C33.9901 24.8963 34.3884 24.7174 34.7866 24.5383C35.0186 24.4339 35.2512 24.3298 35.4839 24.2274C35.564 24.1922 35.647 24.1645 35.7304 24.1362L35.7983 24.1219C35.8318 24.1445 35.8638 24.1651 35.8899 24.1912C36.8881 25.1431 37.6278 26.0087 38.2182 26.9163C38.4143 27.2179 38.6369 27.5059 38.8521 27.7849L39.0289 28.015C39.0984 28.106 39.1891 28.1942 39.3038 28.2831C39.4464 28.3924 39.6179 28.4094 39.775 28.3301C39.9399 28.2479 40.0323 28.0389 39.9896 27.844C39.965 27.7308 39.9311 27.5989 39.8668 27.4791C39.8069 27.3675 39.7481 27.2551 39.6895 27.1425C39.5169 26.8119 39.3386 26.47 39.1251 26.1546C38.1565 24.7244 36.9705 23.4671 35.584 22.4104C34.3272 21.4512 32.8694 20.7813 31.2512 20.4191C29.6737 20.0658 28.4418 19.9313 27.2574 19.9823C25.6372 20.0526 24.4203 20.2878 23.3114 20.745C23.3033 20.7484 23.2954 20.7516 23.287 20.7545C23.2901 20.7493 23.2934 20.7438 23.2965 20.7386C24.4181 18.746 24.4634 16.6437 23.4341 14.3104C23.161 13.8845 22.9553 13.4338 22.7562 12.9977C22.6147 12.6873 22.4683 12.3662 22.3007 12.0595C22.1782 11.8352 22.0443 11.6315 21.9033 11.455C21.7323 11.2409 21.5462 11.0361 21.3662 10.8382L21.2348 10.6934C20.7561 10.1624 20.152 9.78826 19.4386 9.57811C17.7649 9.08565 16.2401 9.03426 14.7769 9.42151C13.7353 9.69685 12.7666 10.2461 11.8974 11.0535C11.8566 11.091 11.8158 11.128 11.7749 11.165C11.7814 11.1259 11.788 11.0868 11.7962 11.048C12.1183 9.5227 12.0387 7.93423 11.5588 6.32569C11.2168 5.17922 10.6024 4.08187 9.68023 2.97046C9.14904 2.33063 8.50927 1.724 7.72836 1.11603C7.18366 0.691975 6.63814 0.422539 6.06076 0.291361C5.55564 0.177316 5.1113 0.299384 4.74015 0.654235C4.17628 1.19207 3.70639 1.85104 3.26137 2.72806C2.41346 4.39791 1.92631 6.02345 1.7718 7.69732C1.63917 9.13104 1.71048 10.4164 1.9883 11.6262C2.32676 13.0994 2.78852 14.2129 3.44073 15.1295C3.55701 15.2931 3.68735 15.4477 3.81349 15.5972C3.87008 15.6644 3.92709 15.732 3.98247 15.7997L4.08673 15.926L4.04743 15.9456C3.93114 16.0043 3.82404 16.0583 3.71464 16.1068C2.99301 16.4224 2.37525 16.8647 1.8785 17.4203C1.50735 17.8357 1.167 18.2628 0.867974 18.6898C0.394588 19.3656 0.114068 20.1585 0.0342479 21.0461C-0.101623 22.5707 0.167138 24.0872 0.833795 25.5536ZM12.4098 12.2065C12.9849 11.5277 13.7663 11.02 14.7328 10.6974C16.0693 10.2513 17.4974 10.2833 19.2275 10.7978C19.5534 10.8945 19.8468 11.0497 20.1015 11.2596C20.1539 11.3028 20.2048 11.3486 20.2544 11.3967L20.3512 11.4912C20.6251 11.7579 20.9086 12.0338 21.164 12.322C21.3357 12.5158 21.486 12.7391 21.6317 12.9551L21.7149 13.0784C21.7503 13.1301 21.7745 13.1881 21.7999 13.2464C21.8261 13.3068 21.8525 13.3669 21.8862 13.423C22.5124 14.4661 22.8834 15.5083 23.0207 16.6095C23.2269 18.2663 22.8581 19.6522 21.8922 20.8457C20.9745 21.9794 19.8507 22.8208 18.5518 23.3458C17.8272 23.6384 17.098 23.776 16.3845 23.7539L16.2902 23.7527C16.1637 23.7519 16.0514 23.751 15.9462 23.7025L15.9404 23.6617C15.9296 23.5877 15.9188 23.5114 15.9121 23.4348C15.8302 22.4636 15.5641 21.6572 15.0978 20.9689C14.7639 20.4761 14.5049 19.9277 14.2827 19.2427C14.2341 19.0916 14.1729 18.9438 14.1118 18.7966L14.0793 18.7187C13.6191 17.6035 12.8547 16.7808 11.8103 16.2732C11.5628 16.1532 11.3046 16.0516 11.0552 15.953L10.7775 15.8426C10.682 15.8036 10.5853 15.7688 10.4783 15.7302L10.4255 15.711C10.4356 15.6621 10.4428 15.6261 10.4562 15.5921C10.9815 14.2461 11.6205 13.1385 12.4098 12.2065ZM6.00837 1.4322C6.13492 1.50368 6.24742 1.56672 6.35884 1.63111C7.84626 2.49126 9.02331 3.74055 9.95482 5.45042C10.0538 5.63219 10.0503 5.76376 9.94265 5.91877C9.85054 6.05155 9.76236 6.18715 9.67416 6.32288C9.6065 6.42648 9.53896 6.53035 9.46968 6.63262C8.87339 7.51446 8.42377 8.2749 8.05357 9.02556C7.96227 9.21202 7.90339 9.41146 7.86274 9.56486C7.83181 9.68399 7.93404 9.8228 8.0194 9.86577C8.10232 9.90874 8.27008 9.91609 8.35436 9.82976C8.46632 9.71652 8.57451 9.58507 8.68431 9.42765C9.33166 8.49963 9.88566 7.52785 10.4221 6.58832L10.4301 6.57319C10.8616 7.96756 10.915 9.44519 10.5877 10.9654C10.5608 11.093 10.5037 11.1855 10.4019 11.2655C9.9224 11.647 9.50709 12.0978 9.10529 12.5338C8.95402 12.6979 8.80275 12.8619 8.64824 13.0226C8.56977 13.1037 8.49521 13.202 8.42039 13.3234C8.37123 13.4048 8.38258 13.5376 8.44349 13.6082C8.50535 13.6824 8.64905 13.7171 8.74009 13.6616C8.87636 13.5783 9.01156 13.4954 9.12703 13.385C9.32206 13.1994 9.51385 13.0104 9.70577 12.8217C9.88445 12.6461 10.0627 12.4702 10.2439 12.2973C10.051 13.0418 9.47117 14.9057 9.27128 15.4055L7.64379 15.273L7.64366 15.2717C7.63137 15.2097 7.61894 15.15 7.61489 15.0897C7.60409 14.9211 7.59586 14.7524 7.58708 14.5835C7.57357 14.3177 7.56021 14.0517 7.53765 13.7865C7.46094 12.8813 7.38056 11.9761 7.30047 11.0718L7.15651 9.44306C7.00362 7.69129 6.81846 6.25059 6.574 4.90923C6.40409 3.97974 6.24621 3.04823 6.08792 2.11647L6.00012 1.60086C5.9904 1.54371 5.9881 1.48521 5.98675 1.42029L6.00837 1.4322ZM2.53893 10.5621C3.3135 11.059 4.14089 11.4252 4.9422 11.7796C5.11548 11.8563 5.28849 11.9328 5.46082 12.0107C5.5971 12.0721 5.74377 12.1078 5.87046 12.1368C6.01673 12.1691 6.1503 12.1008 6.21999 11.9587C6.28806 11.8174 6.257 11.6664 6.12626 11.5748C5.9754 11.4675 5.8263 11.3751 5.683 11.3C5.23852 11.0675 4.79309 10.8369 4.34793 10.606C3.92641 10.3874 3.50488 10.1691 3.0839 9.94902C2.91967 9.86309 2.75841 9.77113 2.60484 9.68412L2.46695 9.60582C2.33918 8.42321 2.78893 5.75668 3.26272 4.79452C3.73435 5.40745 4.33104 5.84769 4.9538 6.28192C5.02404 6.33131 5.13154 6.40106 5.25283 6.43974C5.3448 6.46932 5.49243 6.44617 5.56495 6.36505C5.63289 6.28862 5.66193 6.1217 5.59629 6.0284C5.50823 5.90258 5.40289 5.78237 5.28268 5.67101C5.09036 5.49258 4.89641 5.31589 4.7026 5.13906C4.43734 4.89772 4.17235 4.65638 3.91169 4.41049L3.87049 4.37194C3.74569 4.25522 3.6278 4.14464 3.56608 4.01065C3.97288 2.91076 4.61806 1.8335 5.16586 1.31949C5.59076 3.64751 5.88856 6.0268 6.17678 8.32978C6.35654 9.76378 6.54185 11.246 6.75632 12.7004C6.90975 13.7421 7.00457 14.5445 7.06008 15.2802L4.85859 15.6319C3.5631 14.5545 2.58863 12.1113 2.53893 10.5621ZM1.52153 21.215C1.60405 20.5816 1.78395 20.061 2.0715 19.6233C2.99436 18.2202 4.18613 17.3768 5.71474 17.0454C6.4708 16.8811 7.23727 16.8066 7.99266 16.8233C9.13729 16.8489 10.2722 17.1099 11.3663 17.5989C12.0214 17.892 12.5536 18.3395 12.9468 18.9284C13.0524 19.0867 13.1491 19.251 13.2454 19.4149L13.3073 19.5197L13.151 19.7491C13.1221 19.7922 13.1218 19.8482 13.1502 19.8911L13.2673 20.0709C13.3555 20.2077 13.4436 20.3445 13.5401 20.4753C13.8567 20.9043 14.0809 21.4107 14.2256 22.0235C14.2611 22.1753 14.2903 22.3285 14.3196 22.4815C14.3467 22.6237 14.3737 22.7653 14.406 22.9061C14.4203 22.969 14.4334 23.0333 14.4461 23.0971C14.4911 23.3176 14.5371 23.5454 14.6407 23.7507C14.7192 23.906 14.7485 24.042 14.7386 24.2056C14.6545 25.5825 14.1538 26.6736 13.2077 27.5404C13.0083 27.7236 12.792 27.9158 12.5646 28.0822C11.6579 28.743 10.8901 29.0948 10.0753 29.2225C8.7336 29.4321 7.43946 29.3585 6.22959 29.0044C5.74243 28.8619 5.30281 28.6422 4.92316 28.3527C3.49274 27.2647 2.54393 26.0832 2.00477 24.7364C1.53328 23.5596 1.37066 22.3746 1.52153 21.215ZM3.06351 20.0539C3.13766 20.098 3.21586 20.1283 3.29919 20.1605C3.26637 20.2389 3.23679 20.3109 3.21248 20.3845C3.12875 20.6417 3.18493 20.8566 3.37442 21.0127C3.40521 21.038 3.43939 21.0621 3.4768 21.0841C3.70438 21.2175 3.98935 21.2448 4.25961 21.159C4.53027 21.0736 4.74703 20.8864 4.85441 20.6454C4.89736 20.5511 4.8694 20.4027 4.7939 20.3291C4.713 20.2548 4.57416 20.2224 4.4788 20.2571C4.39047 20.2895 4.31321 20.3371 4.23839 20.3832C4.2107 20.4007 4.18248 20.4179 4.15439 20.4341C4.03041 20.5045 3.95098 20.5343 3.85995 20.5049C3.869 20.4385 3.87806 20.3815 3.88562 20.3318C3.94573 19.9437 3.93019 19.9036 3.60658 19.6177L3.54837 19.5657C3.55553 19.5636 3.56405 19.5612 3.57391 19.5586C3.64657 19.5411 3.72085 19.5323 3.79203 19.5233L3.88711 19.5109C3.93033 19.5048 3.96693 19.4777 3.9857 19.4388C4.03729 19.3295 4.02257 19.2484 4.0011 19.1995C3.97962 19.1516 3.93182 19.088 3.82498 19.0533C3.47194 18.9418 3.07039 19.0912 2.89063 19.4011C2.75935 19.6258 2.83391 19.916 3.06351 20.0539ZM4.84603 18.7603C4.91829 18.8198 5.01891 18.8657 5.16383 18.8793C5.20286 18.8829 5.24162 18.8686 5.2689 18.8402C5.29618 18.8123 5.30915 18.7732 5.30402 18.7348L5.25149 18.3448C5.29728 18.3303 5.3367 18.3178 5.36804 18.317C5.53632 18.3114 5.70029 18.3163 5.85575 18.3312C6.26093 18.3703 6.56238 18.2285 6.75079 17.9099C6.77658 17.8656 6.81507 17.8239 6.86369 17.7713C6.8645 17.7702 6.86532 17.7693 6.86613 17.7683C6.89138 17.7899 6.90988 17.8054 6.9192 17.8209C6.94135 17.8587 6.95729 17.9063 6.97403 17.9568C6.98848 18.0007 7.00335 18.0447 7.02226 18.0864C7.05332 18.1544 7.12111 18.1988 7.20755 18.2109C7.30642 18.2245 7.40556 18.1924 7.45985 18.1291C7.69945 17.852 7.67568 17.4175 7.40826 17.1804C7.25727 17.0456 7.08885 16.9921 6.90881 17.0025C6.73607 17.0127 6.57655 17.091 6.45973 17.2225C6.4215 17.2658 6.37761 17.3172 6.35086 17.3814C6.24484 17.6339 6.08454 17.6936 5.76012 17.6028C5.60737 17.5602 5.42288 17.5492 5.21151 17.5696C4.98488 17.5916 4.80187 17.6963 4.69692 17.8647C4.58996 18.0354 4.57687 18.2482 4.65925 18.464C4.69423 18.5545 4.73974 18.6727 4.84603 18.7603ZM6.28793 18.5605C6.22932 18.6258 6.17542 18.6955 6.12356 18.7668C6.02483 18.9009 5.89477 18.9942 5.70217 19.0687C5.37776 19.1943 5.15248 19.3995 5.05091 19.6624C4.94854 19.9254 4.97773 20.2282 5.13399 20.5374C5.22137 20.7103 5.34386 20.884 5.49823 21.0537C5.54469 21.1048 5.59292 21.1506 5.64262 21.1915C5.94192 21.4382 6.29186 21.4987 6.60709 21.3498C7.08452 21.1586 7.41488 20.9163 7.70674 20.703C7.75874 20.6644 7.79574 20.6165 7.82856 20.5742C8.02967 20.3116 8.18324 19.4071 8.08356 19.1003C7.97119 18.7548 7.7405 18.4968 7.39677 18.3352C6.99267 18.1445 6.58871 18.2268 6.28793 18.5605ZM7.45444 19.6C7.39812 19.725 7.34573 19.8416 7.29724 19.9597C7.25767 20.0562 7.20904 20.1125 7.1349 20.1477C7.05062 20.188 6.9816 20.2234 6.88301 20.2712C6.71718 20.3514 6.63901 20.4463 6.45676 20.4734C6.25156 20.5039 6.11087 20.5751 5.93475 20.3749C5.82819 20.2538 5.75026 20.0923 5.67949 19.9371C5.64964 19.8708 5.67692 19.8023 5.76026 19.7335C5.81374 19.6892 5.87694 19.6506 5.94352 19.6221C6.21553 19.5059 6.44244 19.3239 6.61708 19.081C6.64355 19.0449 6.67124 19.0133 6.6992 18.9876C6.86991 18.8295 7.02901 18.823 7.21512 18.9653C7.37003 19.0836 7.45742 19.2354 7.51414 19.467C7.57087 19.6985 7.45444 19.6 7.45444 19.6ZM6.73715 19.4514C6.67354 19.4537 6.60992 19.4639 6.55144 19.4735L6.49026 19.4829C6.47338 19.485 6.45744 19.4907 6.44312 19.4991L6.39409 19.5264C6.35682 19.5471 6.32439 19.5656 6.29374 19.5866C6.1472 19.6854 6.09305 19.8531 6.15896 20.0041C6.18975 20.0747 6.2439 20.1526 6.31197 20.2085C6.34884 20.2389 6.38922 20.2626 6.43244 20.2753C6.5725 20.3175 6.72499 20.2883 6.84979 20.195C6.98755 20.0926 7.0679 19.9324 7.06628 19.7669C7.06479 19.6863 7.0259 19.6044 6.95905 19.5416C6.89746 19.4781 6.81494 19.4487 6.73715 19.4514ZM7.98794 18.2495C8.14569 18.3167 8.23009 18.4 8.28723 18.5479C8.3507 18.7133 8.51696 18.9137 8.94632 18.9262C9.05936 18.9293 9.17281 18.9286 9.30814 18.9278L9.31854 18.9279C9.20226 19.1346 9.0102 19.161 8.77749 19.1925C8.6916 19.2043 8.60679 19.2162 8.52818 19.2371C8.47605 19.2506 8.43822 19.2951 8.43295 19.3484C8.43133 19.3635 8.42851 19.3778 8.42608 19.3901C8.41797 19.4351 8.40325 19.5096 8.46336 19.5664C8.47754 19.5801 8.49157 19.5922 8.50602 19.6041C8.81585 19.8594 9.16187 19.7225 9.39458 19.6304C9.67645 19.519 9.83988 19.2967 9.86716 18.9869C9.89849 18.6338 9.72008 18.4051 9.37986 18.3582C9.25209 18.3407 9.12338 18.3339 8.98778 18.327L8.88257 18.321L8.86636 18.2847C8.83354 18.2103 8.80167 18.1387 8.76764 18.0688C8.6161 17.7547 8.35205 17.6523 8.02642 17.7792C7.95268 17.8085 7.8676 17.8909 7.85382 17.9873C7.84018 18.0781 7.8938 18.2091 7.98794 18.2495ZM8.97995 20.3386C8.89027 20.3235 8.75777 20.3736 8.71361 20.463C8.67944 20.5359 8.63825 20.6937 8.72118 20.7829C8.80964 20.8779 8.90743 20.9648 9.00508 21.0503L9.00142 21.0507C8.94848 21.0577 8.89459 21.0592 8.84097 21.0605C8.77709 21.0622 8.71307 21.0643 8.6504 21.0732C8.28992 21.1233 8.10841 21.296 8.04439 21.6513C8.03845 21.6841 8.03764 21.7187 8.03791 21.7536C8.03791 21.7709 8.03805 21.788 8.03589 21.8047C8.02319 21.8942 7.99834 21.9528 7.96188 21.979C7.92608 22.0053 7.86314 22.0106 7.77562 21.9952C7.61058 21.9666 7.48889 21.8682 7.34654 21.7192L7.31668 21.6867C7.2451 21.6061 7.12477 21.4724 6.92367 21.5352C6.86343 21.5539 6.81561 21.5991 6.79035 21.663C6.74565 21.7733 6.76943 21.9377 6.8506 22.082C6.91272 22.1921 6.99916 22.2916 7.10168 22.3762C7.35208 22.5826 7.69621 22.6976 8.00347 22.6561C8.36125 22.6076 8.58881 22.3988 8.66148 22.0521C8.67822 21.9726 8.68538 21.8914 8.69254 21.8045L8.69335 21.7956C8.74305 21.7936 8.79087 21.7923 8.83665 21.7907C9.0098 21.7856 9.15877 21.7808 9.31085 21.7561C9.63026 21.7033 9.83745 21.4639 9.83934 21.1462C9.83948 21.0778 9.82975 20.9047 9.73291 20.7852C9.53653 20.5435 9.27587 20.3883 8.97995 20.3386ZM6.22446 21.7867C6.10912 21.7583 5.97405 21.826 5.89342 21.8926C5.83913 21.9377 5.8059 21.9944 5.77753 22.0449C5.76335 22.0686 5.75027 22.0929 5.73338 22.1139C5.67828 22.1811 5.66125 22.1849 5.58264 22.1473C5.48432 22.1 5.38776 22.0477 5.27066 21.9845L5.11412 21.9003L4.96489 21.5808C4.94787 21.5433 4.91316 21.5167 4.87129 21.5085C4.83023 21.5012 4.78809 21.5139 4.75811 21.5425C4.73488 21.5647 4.71083 21.5833 4.68868 21.6011C4.62858 21.6487 4.5666 21.6982 4.54337 21.7785C4.46854 22.0391 4.54566 22.283 4.75459 22.4551C4.7685 22.4667 4.78282 22.4778 4.79767 22.4883C5.00148 22.6345 5.22244 22.7562 5.41153 22.8556C5.61682 22.9639 5.85075 22.9777 6.05267 22.8935C6.25715 22.8088 6.41246 22.6312 6.47918 22.4067C6.51295 22.2944 6.512 22.1586 6.47648 22.0427C6.44501 21.9394 6.34156 21.8145 6.22446 21.7867ZM14.7569 13.9739C14.7916 13.997 14.8259 14.0209 14.8698 14.0517L14.8636 14.0654C14.8286 14.1382 14.7989 14.2019 14.7777 14.2687C14.6789 14.5752 14.748 14.8437 14.9611 15.0193C15.0135 15.0626 15.0741 15.0998 15.1436 15.1314C15.5532 15.3156 15.982 15.3194 16.4189 15.1434C16.4671 15.1244 16.5559 15.0797 16.6015 15.0001C16.6096 14.986 16.6164 14.9681 16.6246 14.9529C16.6437 14.9962 16.6533 15.0401 16.6778 15.0829C16.8142 15.3205 16.977 15.5172 17.1638 15.671C17.4103 15.8743 17.6993 16.0041 18.0295 16.0598C18.2767 16.1017 18.5198 16.0609 18.6797 16.0188C18.8335 15.9794 18.9609 15.8697 19.0734 15.7731L19.1023 15.748C19.2607 15.6131 19.2175 15.4423 19.1914 15.3403C19.1908 15.3373 19.1902 15.3347 19.1893 15.3319C19.4133 15.2508 19.5706 15.1089 19.6927 14.9453C19.6694 15.0283 19.6901 15.1371 19.7478 15.196C19.7884 15.2375 19.8301 15.2762 19.8736 15.3121C20.147 15.5372 20.4775 15.6506 20.8207 15.6336C21.1947 15.615 21.5388 15.4426 21.7643 15.1596C21.9098 14.9774 21.9623 14.7795 21.9122 14.6018C21.8623 14.4257 21.7145 14.2833 21.4985 14.204C21.412 14.1719 21.3215 14.1498 21.2145 14.1239C21.2079 14.1224 21.2013 14.1208 21.1948 14.1193C21.1978 14.1126 21.2007 14.1059 21.2037 14.0993C21.2521 13.9908 21.2981 13.8887 21.3257 13.78C21.357 13.6548 21.3666 13.5133 21.355 13.3472C21.3439 13.1906 21.2382 13.065 21.0768 13.0173C20.6575 12.8932 20.3043 12.9183 19.9971 13.0937C19.775 13.2206 19.7183 13.4356 19.8446 13.6686C19.8684 13.7109 19.9128 13.7367 19.9601 13.7361L20.4354 13.7299C20.4314 13.7375 20.4267 13.7448 20.4235 13.7511L20.3851 13.8165C20.3586 13.8611 20.3324 13.9059 20.3111 13.9532C20.1419 14.3242 20.1759 14.5209 20.4737 14.7843C20.4714 14.784 20.4691 14.7835 20.4668 14.7831L20.4197 14.7759C20.3726 14.7696 20.3254 14.7614 20.2789 14.7535C20.1755 14.736 20.0689 14.7182 19.9591 14.7152C19.8927 14.7133 19.8373 14.7503 19.7942 14.7917C19.848 14.699 19.8958 14.604 19.936 14.5094C20.0404 14.2612 19.9938 13.9979 19.8052 13.7682C19.6151 13.5372 19.3769 13.39 19.0991 13.3218C19.1502 13.3117 19.2024 13.2937 19.2549 13.2653C19.7877 12.9792 20.1762 12.1791 20.0699 11.587C20.0265 11.3435 19.8705 11.1428 19.6425 11.0357C19.403 10.9235 19.1293 10.9353 18.8921 11.0675C18.7291 11.1587 18.6019 11.2964 18.4791 11.4295L18.4528 11.4579C18.377 11.5403 18.3153 11.632 18.2501 11.7293C18.2347 11.7525 18.2187 11.7763 18.2021 11.8006L18.11 11.7867C17.9941 11.7684 17.8908 11.7522 17.7868 11.7448C17.4647 11.7215 17.0628 11.7415 16.8113 12.1041C16.5594 12.4655 16.6792 12.8457 16.8117 13.1364C16.8363 13.1902 16.8702 13.2351 16.9112 13.2691C16.9524 13.3029 17.0008 13.3259 17.0528 13.3352C17.1572 13.3539 17.2648 13.3172 17.3476 13.2341C17.4081 13.1737 17.5926 12.9896 17.5322 12.7131C17.5197 12.6576 17.5059 12.603 17.4929 12.5502L17.4893 12.5359C17.5283 12.497 17.5833 12.491 17.6944 12.5057C17.7919 12.5185 17.9047 12.5375 18.001 12.5792C18.2932 12.7054 18.5568 12.6439 18.7838 12.3966C18.8402 12.3357 18.8947 12.2722 18.949 12.2089C19.0037 12.1453 19.0584 12.0818 19.1157 12.0204C19.1182 12.0174 19.1212 12.0146 19.1238 12.0115C19.1193 12.1602 19.0094 12.3553 18.6432 13.0027C18.6168 13.0499 18.6228 13.1086 18.6584 13.1493C18.7066 13.2041 18.7586 13.2432 18.8126 13.2733C18.6661 13.2578 18.5198 13.2412 18.3735 13.2235L18.1496 13.1969C18.1496 13.1969 18.1312 13.341 18.0848 13.3158C18.0409 13.2919 18.1052 13.1897 18.1052 13.1897C17.5207 13.0966 17.0698 13.2929 16.7654 13.7727C16.6057 14.0247 16.5302 14.2647 16.5256 14.4977C16.4935 14.4771 16.462 14.4522 16.4297 14.4416C16.3426 14.4131 16.2517 14.4127 16.1714 14.4122L16.0967 14.4112C16.0243 14.4083 15.9518 14.4056 15.8709 14.4035C15.8888 14.3734 15.9054 14.345 15.921 14.3162C16.0717 14.0339 16.0133 13.8035 15.7519 13.6369C15.6816 13.5916 15.6053 13.5564 15.529 13.5215C15.4807 13.4993 15.4324 13.4776 15.3863 13.452C15.3648 13.4402 15.3443 13.4269 15.3243 13.4124C15.3805 13.3822 15.4473 13.3745 15.5367 13.3665C15.6172 13.359 15.6804 13.3603 15.7436 13.361C15.8149 13.3621 15.8859 13.3629 15.9565 13.3567C16.0605 13.3472 16.1512 13.2906 16.205 13.2005C16.2631 13.1039 16.2702 12.9827 16.2242 12.877C16.1461 12.7 16.011 12.6003 15.8448 12.5966C15.5371 12.5893 15.1371 12.6169 14.7685 12.8945C14.5637 13.0479 14.4502 13.2599 14.4568 13.476C14.4631 13.6729 14.571 13.8496 14.7569 13.9739ZM18.9178 14.2893C18.9472 14.2901 18.9874 14.2995 19.0053 14.3321C19.0229 14.3644 19.0163 14.4106 18.9888 14.4559C18.9455 14.5264 18.8959 14.5946 18.8474 14.6634C18.847 14.5278 18.7909 14.3968 18.6865 14.3054C18.7634 14.2985 18.8428 14.2865 18.9178 14.2893ZM17.4968 14.0787L18.0232 14.2623C18.0051 14.2768 17.9844 14.2888 17.9674 14.3044C17.9046 14.3624 17.8531 14.4471 17.8299 14.5312C17.7843 14.6937 17.8615 14.8764 18.0078 14.9971C18.063 15.0426 18.128 15.0793 18.2004 15.1027C18.365 15.1561 18.5461 15.1196 18.6763 15.0201C18.6819 15.0333 18.6828 15.0479 18.6928 15.0588L18.7867 15.1615C18.5552 15.2033 18.3223 15.1928 18.0929 15.1307C17.8075 15.0536 17.5969 14.8567 17.4635 14.546C17.3873 14.3676 17.3974 14.217 17.4968 14.0787ZM20.8501 16.2876C20.7024 16.1139 20.5628 15.9496 20.4694 15.7495C20.4194 15.6439 20.3146 15.5778 20.1879 15.5739C20.0369 15.5692 19.8883 15.6515 19.8188 15.7791C19.6899 16.0151 19.6718 16.2464 19.7646 16.4663C19.7818 16.5077 19.8006 16.5488 19.8214 16.5929C19.435 16.5391 19.0602 16.5979 18.8485 17.039L18.8477 17.0376L18.5756 16.7154C18.5527 16.6878 18.5178 16.6708 18.4813 16.6696C18.445 16.6683 18.4097 16.6822 18.3839 16.7082C18.1162 16.9798 17.9944 17.2002 18.1654 17.525C18.2455 17.6776 18.3496 17.8126 18.4664 17.9153C18.474 17.9219 18.482 17.9288 18.4898 17.9353C18.6419 18.0607 18.814 18.1194 18.989 18.1055C19.1779 18.0909 19.3515 17.9935 19.491 17.824C19.5508 17.7519 19.604 17.6744 19.664 17.5863L19.7043 17.5289L19.7946 17.5479C19.9224 17.5757 20.0391 17.601 20.1574 17.6149C20.2814 17.6291 20.4433 17.6412 20.5984 17.6089C20.8627 17.5536 21.0616 17.3925 21.1444 17.1674C21.2267 16.9426 21.1786 16.6937 21.013 16.484C20.9601 16.4172 20.9048 16.3523 20.8501 16.2876ZM18.0417 16.1886C17.9007 16.1053 17.6892 16.0562 17.4781 16.2946C17.4455 16.3311 17.4178 16.3736 17.391 16.4165C17.3519 16.4772 17.326 16.5142 17.2953 16.5352C16.9064 16.1692 16.8186 16.1306 16.2396 16.1768C16.2637 16.1062 16.2841 16.0436 16.299 15.9796C16.3221 15.8826 16.3284 15.7824 16.3175 15.6906C16.304 15.5751 16.2334 15.4722 16.1288 15.4144C16.0246 15.3572 15.8992 15.3524 15.7936 15.4018C15.7247 15.4343 15.6314 15.4783 15.5771 15.5586L15.5016 15.6691C15.3994 15.8163 15.2936 15.9681 15.2316 16.1416C15.1318 16.4212 15.1681 16.7027 15.3326 16.9138C15.3669 16.9581 15.406 16.998 15.4481 17.0328C15.6148 17.17 15.8401 17.2357 16.0878 17.2152C16.1799 17.2071 16.2714 17.1912 16.3704 17.1732L16.4607 17.158L16.4779 17.1725C16.529 17.2166 16.5834 17.263 16.6403 17.3048C17.0185 17.5813 17.3876 17.5906 17.7686 17.3333C18.0122 17.168 18.1717 16.962 18.2439 16.721C18.3104 16.4983 18.2364 16.3039 18.0417 16.1886ZM38.4683 29.6084C38.2533 29.6816 38.0304 29.7907 37.7667 29.9511C37.6278 30.0359 37.4945 30.13 37.3615 30.2245C37.2089 30.3321 37.0513 30.4434 36.8896 30.5352C36.5174 30.7458 36.1285 30.9448 35.7527 31.1371L35.3758 31.3304C35.3333 31.3522 35.2861 31.367 35.2367 31.3828L35.2138 31.3905L35.1668 31.3573C35.1036 31.313 35.0459 31.2691 34.9862 31.2235C34.6022 30.9016 34.219 30.5786 33.8359 30.2556C33.0116 29.5607 32.1812 28.8643 31.3539 28.1808C30.9969 27.8877 30.6164 27.6141 30.2485 27.3496C30.1023 27.2445 29.9561 27.1391 29.8115 27.033C31.8023 27.4604 33.7925 27.8909 35.7826 28.3238C35.9438 28.3586 36.1041 28.3983 36.2647 28.438C36.4484 28.4836 36.6316 28.5288 36.8165 28.5675C36.9551 28.5964 37.108 28.6066 37.2984 28.5995C37.395 28.5964 37.5735 28.4986 37.5719 28.3674C37.5711 28.2658 37.5276 28.1227 37.4266 28.0559C37.3056 27.9717 37.1661 27.9174 37.0333 27.8688L36.5656 27.6961C36.1118 27.5279 35.6427 27.3536 35.1732 27.2033C33.6558 26.7163 32.0308 26.3107 30.0585 25.927C28.6298 25.6492 27.1742 25.4048 25.922 25.1974C24.8468 25.0194 23.4263 24.8241 21.9691 24.8926L21.9155 24.8955C21.7635 24.9028 21.6065 24.91 21.4513 24.9353C21.2299 24.9716 21.0744 25.1373 21.0813 25.3296C21.088 25.5089 21.1941 25.6461 21.3723 25.7061C21.4833 25.7437 21.63 25.7896 21.7851 25.8129C21.9646 25.8401 22.144 25.8687 22.3236 25.8974C22.8198 25.9766 23.3329 26.0584 23.843 26.1085C25.1653 26.237 26.5665 26.4388 28.3859 26.7621C28.431 26.7702 28.4756 26.7805 28.5229 26.7923L28.4741 27.0744C28.4664 27.1212 28.4845 27.1639 28.5222 27.1971L29.4387 27.906C30.1239 28.4355 30.804 28.9612 31.4802 29.4922C32.1407 30.0105 32.7966 30.5337 33.4504 31.0554L34.248 31.6906L34.2103 31.6995C33.0967 32.0057 31.899 32.1366 30.4405 32.1122C29.6508 32.0985 28.9526 32.0329 28.3085 31.9116C28.1658 31.7428 28.0248 31.5742 27.8841 31.4062C27.5533 31.0105 27.211 30.6012 26.8615 30.2122C26.0102 29.2644 25.1302 28.3141 24.2783 27.3951L24.208 27.3192C24.0512 27.1493 23.8715 27.0048 23.7008 26.8741C23.5898 26.7895 23.4534 26.7384 23.3475 26.7035C23.1637 26.6424 22.9702 26.719 22.8875 26.8858C22.8113 27.0385 22.8247 27.1877 22.9256 27.3061C22.9824 27.3722 23.0424 27.4355 23.1035 27.4973L23.6561 28.055C24.0386 28.4398 24.4215 28.8251 24.7973 29.2163C25.3956 29.8386 25.9869 30.4669 26.5783 31.0951L27.0451 31.5909C27.0799 31.6276 27.1128 31.6667 27.1473 31.7086C27.0091 31.6941 26.8719 31.6665 26.7298 31.638C26.4211 31.5763 26.1013 31.5122 25.7547 31.5881C25.713 31.5971 25.6784 31.6259 25.6625 31.6652C25.6466 31.7044 25.6512 31.749 25.6747 31.7843C25.7224 31.8552 25.7737 31.91 25.8264 31.9535C25.9507 32.0559 26.083 32.0947 26.1958 32.1277L26.2587 32.1465C27.4325 32.5156 28.4902 32.7445 29.4919 32.8455C31.314 33.0293 33.103 32.9229 34.8106 32.5294C35.6308 32.3402 36.4837 31.9997 37.417 31.4881C37.6689 31.3504 37.9163 31.2041 38.1635 31.058L38.2072 31.0318C38.481 30.8704 38.6914 30.6875 38.8504 30.4728C38.9068 30.3963 38.9767 30.2941 39.0162 30.1795C39.0761 30.0087 39.0372 29.8271 38.9152 29.7058C38.7895 29.5824 38.6312 29.5534 38.4683 29.6084ZM24.8163 33.5021C24.769 33.3917 24.6743 33.283 24.5705 33.2214C24.4662 33.1593 24.3167 33.1731 24.2219 33.2126C24.1149 33.2565 24.0473 33.41 24.0614 33.5128C24.0883 33.7165 24.1288 33.9196 24.1688 34.1217L24.1857 34.2073C24.1919 34.2382 24.1997 34.2688 24.2074 34.2996C24.2303 34.3921 24.2445 34.4551 24.2281 34.513C24.1368 34.5278 24.0494 34.4888 23.9179 34.4092C23.8676 34.3791 23.8214 34.3434 23.7744 34.3078C23.7289 34.2727 23.6837 34.2383 23.6356 34.2071C23.5566 34.1564 23.3722 34.0373 23.2027 34.2034C23.0434 34.359 23.1245 34.5567 23.151 34.6215C23.1798 34.6927 23.2096 34.766 23.2597 34.8293C23.3378 34.9287 23.4222 35.016 23.512 35.0899C23.7229 35.2636 23.9639 35.366 24.2328 35.396C24.4678 35.422 24.6857 35.3634 24.8464 35.2313C25.0085 35.0975 25.1076 34.8938 25.1257 34.6569C25.1346 34.5359 25.1381 34.3946 25.098 34.2632C25.0206 34.0126 24.9258 33.7568 24.8163 33.5021ZM22.2049 31.6732C22.1148 31.5255 21.9719 31.4545 21.8176 31.4774C21.6468 31.5023 21.5195 31.6238 21.4769 31.8021C21.4197 32.0443 21.4367 32.2926 21.5297 32.5615C21.5314 32.5671 21.5339 32.5729 21.537 32.5786L21.5511 32.6088C21.5661 32.6417 21.5847 32.6824 21.6132 32.7203C21.6433 32.7596 21.6759 32.7936 21.7107 32.8224C21.8281 32.919 21.9719 32.958 22.1285 32.9336C22.3282 32.9019 22.4981 32.7142 22.5149 32.5054C22.5265 32.3663 22.5118 32.2484 22.4714 32.1555C22.3963 31.9853 22.2989 31.8265 22.2049 31.6732ZM23.9114 31.7819C23.8409 31.8707 23.7272 32.0142 23.829 32.191C23.8424 32.2143 23.8601 32.2346 23.881 32.2519C23.9117 32.2772 23.9492 32.2958 23.9922 32.3065C24.0994 32.333 24.2296 32.3092 24.3328 32.2448C24.6741 32.0313 24.8914 31.7791 24.9971 31.4735C25.0702 31.2626 25.0243 31.1187 24.973 31.035C24.9201 30.9499 24.808 30.8409 24.5768 30.8072C24.5246 30.8 24.4715 30.7998 24.4179 30.7996C24.3849 30.7997 24.3518 30.8001 24.3187 30.7973C24.2883 30.7943 24.2576 30.7888 24.2261 30.7824L24.2201 30.73C24.208 30.6201 24.1965 30.5155 24.1748 30.413C24.1376 30.2372 24.0173 30.1082 23.8526 30.0695C23.5659 30.0014 23.3058 30.0304 23.0794 30.1564C23.0092 30.1963 22.9226 30.3121 22.9481 30.4186C22.9646 30.4858 23.0235 30.6106 23.1282 30.6542C23.2234 30.6933 23.3198 30.7168 23.4133 30.7393L23.4288 30.7435C23.493 31.3248 23.57 31.4209 24.1383 31.5371C24.1087 31.5778 24.0701 31.6159 24.0285 31.6572C23.9869 31.6972 23.9464 31.7379 23.9114 31.7819ZM21.6354 33.8168C21.6906 33.8622 21.7446 33.9058 21.7965 33.9472C21.9303 34.0537 22.0958 34.1431 22.2751 34.2057C22.7705 34.3782 23.2253 34.1593 23.4072 33.6611C23.4434 33.5609 23.4681 33.4531 23.4811 33.3397C23.5436 32.7931 23.513 32.2266 23.3879 31.6083C23.3693 31.5162 23.3256 31.4366 23.2877 31.3668C23.2738 31.3411 23.2603 31.3165 23.2488 31.2926C23.2293 31.2485 23.1854 31.2201 23.1378 31.2183C22.9372 31.2085 22.8024 31.3136 22.7682 31.5063C22.7315 31.7098 22.6905 32.1104 22.6905 32.1104C22.6905 32.1104 22.7761 32.344 22.7682 32.4535C22.7572 32.6093 22.7117 32.8224 22.6225 32.904C22.6031 33.0628 22.5846 33.211 22.5037 33.3199C22.1453 33.2867 21.7858 33.09 21.5443 32.7813C21.3117 32.4823 21.2194 32.1212 21.2831 31.764C21.3373 31.4636 21.508 31.1966 21.7912 30.9701C21.9549 30.8391 22.3097 30.8692 22.5023 31.0279C22.5255 31.0471 22.5426 31.0643 22.5612 31.0829C22.5951 31.1161 22.6291 31.1474 22.6682 31.1769C22.7338 31.2239 22.8296 31.2201 22.8905 31.1922C22.9575 31.1608 23.0261 31.0829 23.0231 30.9989C23.0128 30.6656 22.8552 30.4104 22.5765 30.2809C22.2527 30.1299 21.9325 30.1469 21.6747 30.3283C21.4725 30.4699 21.2133 30.6624 21.0008 30.8962C20.3963 31.564 20.4274 32.6195 21.0723 33.2996C21.2552 33.4927 21.4521 33.6657 21.6354 33.8168ZM18.633 33.5716C18.5528 33.7238 18.4714 33.8872 18.4319 34.0628C18.3903 34.2473 18.4215 34.4237 18.5203 34.5596C18.5481 34.5977 18.5806 34.6318 18.617 34.662C18.7164 34.7439 18.8461 34.7952 18.9944 34.8101C19.2426 34.8352 19.4971 34.7807 19.7501 34.6474C20.177 34.4222 20.515 34.088 20.7548 33.654C20.8559 33.4708 20.8393 33.2877 20.7124 33.176C20.5611 33.0534 20.4017 33.0501 20.2305 33.1549C20.1082 33.2312 19.9999 33.3281 19.8997 33.421C19.8359 33.4797 19.7745 33.542 19.7137 33.6045C19.6575 33.6621 19.6015 33.7196 19.5425 33.7742C19.4597 33.8511 19.3888 33.8989 19.3188 33.9235C19.3266 33.9094 19.3364 33.8931 19.3484 33.8734C19.3735 33.8325 19.3982 33.7914 19.4146 33.7483C19.4363 33.6902 19.4605 33.6331 19.4849 33.5757C19.5394 33.4466 19.5958 33.3127 19.6273 33.1704C19.6947 32.867 19.5764 32.6516 19.2844 32.548L19.2405 32.533C19.0919 32.4816 19.0238 32.4554 18.9971 32.3471C18.9861 32.303 18.9554 32.2654 18.9017 32.237C18.8831 32.2271 18.7861 32.1791 18.7006 32.2097C18.6197 32.2399 18.5203 32.305 18.4808 32.3993C18.3926 32.6141 18.4782 32.8714 18.6543 32.998C18.7255 33.0478 18.8017 33.083 18.8903 33.1238C18.8932 33.1249 18.8961 33.1264 18.8989 33.1277L18.8537 33.2004C18.771 33.3318 18.6975 33.4492 18.633 33.5716ZM22.5185 34.5292C22.4648 34.4924 22.3221 34.4064 22.1703 34.4145C22.1094 34.4173 21.9085 34.4511 21.8906 34.7582C21.8827 34.8962 21.8777 35.0345 21.872 35.2017C21.7973 35.1505 21.7329 35.11 21.6555 35.0879C21.5362 35.0542 21.3968 35.0457 21.2177 35.0611C21.1139 35.07 20.9753 35.1796 20.9619 35.295C20.9494 35.3962 20.9806 35.5413 21.0653 35.6213C21.139 35.6908 21.215 35.7566 21.2888 35.8175C21.3936 35.9039 21.4945 35.9802 21.5801 36.044C21.8971 36.2799 22.2843 36.2416 22.5224 35.9513C22.7942 35.6186 22.8597 35.2179 22.7117 34.7922C22.6732 34.6838 22.5966 34.5835 22.5185 34.5292Z" fill="var(--bs-primary)"></path>
						<path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M855.468 6.44747C855.573 6.40577 855.674 6.29347 855.781 6.1732C855.837 6.11112 855.893 6.04822 855.953 5.99153C856.132 5.82187 856.289 5.75573 856.45 5.74858C856.547 5.75425 856.635 5.79744 856.697 5.8714C856.755 5.94064 856.787 6.01826 856.806 6.09857C856.906 6.06334 857.016 6.0516 857.104 6.07819C857.39 6.16065 857.611 6.25095 857.799 6.36258C858.085 6.53318 858.356 6.7235 858.603 6.92866C859.735 7.86794 861.158 8.41661 862.953 8.60693C864.217 8.73907 865.584 8.6817 867.25 8.42147C867.455 8.38908 867.66 8.35385 867.865 8.31835L868.134 8.27206C868.946 8.13371 869.735 7.82786 870.548 7.33655C871.96 6.48216 873.21 5.35486 874.367 3.89039C874.711 3.45725 875.013 2.94314 875.293 2.31969C875.366 2.15705 875.441 1.99832 875.538 1.85201C875.645 1.69166 875.834 1.60689 876.02 1.61877C875.957 1.54035 875.901 1.44708 875.864 1.32777L875.835 1.23733L875.89 1.15865C876.074 0.892207 876.328 0.725646 876.573 0.564352C876.697 0.483503 876.821 0.403192 876.931 0.308845L877.001 0.25L877.561 0.311276C878.014 0.360811 878.456 0.409536 878.898 0.462986C879.097 0.486606 879.332 0.519676 879.562 0.584733C879.716 0.62806 879.869 0.757771 879.925 0.891395L880.019 1.106C880.3 1.75226 880.591 2.42119 880.771 3.12549C880.97 3.90537 880.998 4.67337 881 5.3226C881.003 6.91381 880.684 8.52432 880.049 10.1107C879.468 11.5603 878.655 12.8825 877.629 14.0396C876.157 15.7014 874.269 16.7186 872.016 17.0637C871.206 17.1879 870.383 17.25 869.542 17.25C867.822 17.25 866.027 16.9899 864.113 16.4663C863.393 16.2698 862.683 16.0433 862.082 15.8476C860.437 15.3115 858.957 14.4177 857.684 13.1898C856.481 12.028 855.734 10.8096 855.402 9.46307C855.262 8.89145 855.174 8.3035 855.089 7.73432L855.016 7.25016C854.993 7.10385 854.922 6.6606 855.468 6.44747ZM879.292 2.05568L879.307 2.14841C879.322 2.24195 879.336 2.32604 879.352 2.40864C879.586 3.60262 879.637 4.763 879.504 5.85872C879.271 7.78615 878.639 9.7287 877.57 11.7953C876.99 12.9162 876.127 13.8487 875.004 14.5663C873.948 15.2432 872.892 15.7612 871.803 16.1377C872.148 16.0795 872.464 16.0135 872.768 15.9364C874.523 15.4947 875.992 14.5632 877.134 13.1678C879.042 10.8386 880.04 8.21226 880.101 5.36106C880.125 4.22364 879.895 3.10416 879.403 1.95256L879.292 2.05568ZM877.477 1.02192C877.846 1.04621 878.228 1.07064 878.603 1.12963C878.647 1.13746 878.682 1.14137 878.717 1.13826C878.403 1.0778 878.093 1.04311 877.79 1.00855C877.647 0.992762 877.506 0.977105 877.366 0.959018L877.304 1.01098C877.361 1.0149 877.419 1.018 877.477 1.02192ZM876.387 2.58789C876.325 2.72542 876.265 2.86526 876.206 3.00523C876.044 3.38262 875.877 3.77323 875.647 4.127C874.474 5.93187 873.112 7.30281 871.484 8.31916C870.295 9.06125 869.221 9.48723 868.105 9.66189L867.544 9.75151C866.58 9.90713 865.584 10.0683 864.58 10.0777C864.361 10.0911 864.141 10.0973 863.92 10.0973C863.076 10.0973 862.228 10.0015 861.392 9.81116C859.735 9.43391 858.456 8.73907 857.482 7.68721C857.391 7.58895 857.292 7.4969 857.193 7.40498C857.109 7.32562 857.023 7.24706 856.942 7.16365C856.808 7.02516 856.691 6.89815 856.601 6.74644C856.547 6.82918 856.493 6.91206 856.437 6.99399C856.633 7.07227 856.706 7.23046 856.744 7.32481C856.753 7.34762 856.761 7.36962 856.773 7.38919C857.338 8.38597 857.899 9.38519 858.456 10.3874C858.835 11.0713 859.27 11.5359 859.825 11.8495C859.92 11.903 860.008 11.9706 860.094 12.0391L860.158 12.0885C860.619 12.4399 861.127 12.6153 861.623 12.5861C862.181 12.5625 862.685 12.7056 863.202 13.0184C863.749 13.3502 864.386 13.6096 865.152 13.8125C866.15 14.0782 867.055 14.0436 867.918 13.7064C868.697 13.402 869.367 13.2378 870.025 13.1884C871.033 13.1113 871.971 12.7238 872.814 12.0368C873.602 11.3937 874.296 10.9212 874.998 10.5493C875.172 10.4566 875.338 10.3331 875.499 10.2138C875.866 9.9425 876.092 9.61626 876.189 9.21539C876.291 8.79089 876.4 8.36721 876.519 7.94744C876.686 7.35396 876.839 6.81865 877.019 6.27538C877.172 5.80608 877.26 5.4704 877.086 5.09314C876.995 4.895 876.994 4.60805 877.083 4.39668C877.192 4.13874 877.337 3.89822 877.479 3.66566L877.61 3.44619C877.667 3.35346 877.764 3.33457 877.858 3.31418L878.069 3.28435L878.133 3.47372C878.158 3.52636 878.196 3.60505 878.178 3.70021C878.147 3.86204 878.108 3.99013 878.055 4.10338C877.854 4.5303 877.802 4.93036 877.893 5.36106C877.947 5.619 877.914 5.93889 877.794 6.31156C877.533 7.11884 877.303 8.0094 877.07 9.11389C876.859 10.1123 876.272 10.8677 875.324 11.3591C874.501 11.7868 873.731 12.2905 872.97 12.9006C872.179 13.5327 871.252 13.8981 870.215 13.9854C869.471 14.0491 868.74 14.2235 867.978 14.5207C867.42 14.7385 866.907 14.8516 866.41 14.8665C866.346 14.8681 866.282 14.8699 866.219 14.8699C865.193 14.8699 864.169 14.6181 863.094 14.105C862.953 14.0373 862.816 13.9603 862.684 13.8777C862.345 13.6655 861.985 13.5586 861.614 13.5586C861.591 13.5586 861.573 13.5586 861.553 13.5586C860.745 13.5586 860.149 13.1442 859.77 12.8315L859.64 12.7253C859.421 12.5468 859.195 12.362 858.972 12.1404C858.732 11.9015 858.484 11.6538 858.307 11.3582C857.674 10.3073 857.061 9.24603 856.449 8.18473L856.309 7.94434C856.634 9.67457 857.155 11.042 859.11 12.7033C860.285 13.7015 861.675 14.4146 863.242 14.8233C864.533 15.1598 865.84 15.3602 867.124 15.4176C869.341 15.5183 871.506 14.9585 873.739 13.7087C875.118 12.9374 876.093 11.9085 876.722 10.5627C877.467 8.96461 877.929 7.61959 878.175 6.33045C878.38 5.25984 878.39 4.12079 878.204 2.94476L878.089 2.23021L877.735 2.16731C877.352 2.09968 876.997 2.03665 876.644 1.96282C876.597 1.95337 876.52 1.93245 876.434 1.90195C876.47 1.97929 876.496 2.06311 876.488 2.16164C876.478 2.31969 876.443 2.46681 876.387 2.58789Z" fill="var(--bs-primary)"></path>
					</svg>							
				</div>
			</div>
		</div>
	</section>
		
		
		<?php }else{ ?>
		<section class="error-page style-1">
			<div class="container">
				<div class="inner-content text-center">
					<h2 class="dz-error" data-name="404"><?php echo wp_kses($error_page_title, 'string'); ?></h2>
					<p class="text"><?php echo wp_kses($error_page_subtitle, 'string'); ?></p>
					<a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow"><?php echo wp_kses($error_page_button_text,'string'); ?></a>
				</div>
			</div>
		</section>
		<?php } ?>
<?php
	get_footer();
?>