<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZWhychooseus extends Widget_Base 
{
	public function get_name() {
		return 'dz-why_chosse_us';
	}
	
	public function get_title() {
		return esc_html__('Why Choose Us',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'why_choose_us_element_sub_title',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Why Choose Us', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'why_choose_us_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Experience Real Results with Unmatched Support', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'why_choose_us_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Real Results, Real Support – The Trusted Choice for Patients.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'why_choose_us_element_large_img',
			[
				'label' 		=> esc_html__( 'Large Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'default'      => [
					  'url' =>	'https://clinicmaster.wprdx.com/fatloss/wp-content/uploads/2025/06/img2.png',
				   ],
				]
			);
			$this->add_control(
				'why_choose_us_element_small_img',
					[
						'label'       => esc_html__( 'Small Image', DZ_TH_DOMAIN ),
						'label_block' => true,
						'type'        => \Elementor\Controls_Manager::MEDIA,
						'default'     => [
							'url' => 'https://clinicmaster.wprdx.com/fatloss/wp-content/uploads/2025/06/img1.png',
						],
					]
			);
					
		
	
		
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
	
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'why_choose_us_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Consistency Programs', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'why_choose_us_element_item_description',
			[
				'label' 	=> esc_html__( 'Item Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Our programs ensure long-term success with personalized check-ins and adjustments.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'why_choose_us_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'why_choose_us_element_item_title' 		=> esc_html__( 'Consistency Programs', DZ_TH_DOMAIN ),
						 'why_choose_us_element_item_description' => esc_html__( 'Our programs ensure long-term success with personalized check-ins and adjustments..', DZ_TH_DOMAIN )
						],	
						[	
							'why_choose_us_element_item_title' 		=> esc_html__( 'Trusted Expertise', DZ_TH_DOMAIN ),
							'why_choose_us_element_item_description' => esc_html__( 'Our programs ensure long-term success with personalized check-ins and adjustments..', DZ_TH_DOMAIN )
					],
					
				],
			]
		);

		$this->end_controls_section();
		
       	$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'why_choose_us_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-2',
			]
		);
		
		$this->end_controls_section(); 


	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/why_choose_us_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}