<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZTestimonialSlider3 extends Widget_Base 
{
	
	public function get_name() {
		return 'dz-testimonial-slider-3';
	}
	
	public function get_title() {
		return esc_html__('Testimonial Slider 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-testimonial-carousel';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1' => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2' => esc_html__('Style 2',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'style_1',
				
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Latest News', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_subtitle_icon',
			[
				'label' 		=> esc_html__( 'Subtitle icon ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'What our patient say about us', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'testimonial_category'),true),
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->end_controls_section();
		
		
		/* Advance Section Start */
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_image_preference',
			[
				'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_image_preference_options_list(),				
				'default'		=>  'image_post_only',
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 6,
				'min'           => 0,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 20,
				'min'           => 0,
				'title'			=>  esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_orderby',
			[
				'label' 		=> esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_orderby_options_list2(),
				'default'		=> 'date' ,
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);
		
		$this->end_controls_section();
		/* Advance Section END */

		$this->start_controls_section(
			'gallery',
			[
				'label' => esc_html__( 'Gallery', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_gallery_img',
			[
				'label' 		=> esc_html__( 'Gallery Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_gallery_text',
			[
				'label' 		=> esc_html__( 'Gallery Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'Talk to over 215 doctor', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'rating',
			[
				'label' => esc_html__( 'Rating', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your rating', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_3_element_star_rating',
			[
				'label' => esc_html__( 'Star Rating', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'default' => 5,
			]
		);
		
		$this->end_controls_section(); 

		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_3_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				
			]
		);
		
		
		
		$this->end_controls_section(); 

	}
	
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/testimonial_slider_3_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleTestimonialSwiper2();
					}					
				});
			 </script>
			";
	}
	
	protected function content_template() 
	{

    }
}