<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZSchedule1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-schedule-1';
	}
	
	public function get_title() {
		return esc_html__('Schedule TimeTable ',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'schedule_1_element_tab',
			[
				'label'   => esc_html__('Select Section', DZ_TH_DOMAIN),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'  => [
						'title' => esc_html__('Left', DZ_TH_DOMAIN),
						'icon'  => 'fa fa-arrow-left',
					],
					'right' => [
						'title' => esc_html__('Right', DZ_TH_DOMAIN),
						'icon'  => 'fa fa-arrow-right',
					],
					'both'  => [
						'title' => esc_html__('Both', DZ_TH_DOMAIN),
						'icon'  => 'fa fa-columns',
					],
				],
				'default' => 'both',
				'toggle'  => true,
			]
		);
		$this->add_control(
			'schedule_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'About Us', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
					
				],
			]
		);
		$this->add_control(
			'schedule_1_element_icon_img',
			[
				'label' 		=> esc_html__( 'Subtitle Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
					'schedule_1_element_img_style' => 'style-1',
					'schedule_1_element_img_style' => 'style-2',
					'schedule_1_element_img_style' => 'style-3'
				],
			]
		);
		
		$this->add_control(
			'schedule_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'World Class Patient Facilities Designed for You', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
				],
			]
		);
		
		
		$this->add_control(
			'schedule_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Experience the future of healthcare. Our state-of-the-art facilities are equipped with the latest technology, ensuring you receive the world`s best quality treatment. Here, cutting-edge tools meet unparalleled expertise, providing a comfortable and effective path to optimal health.', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
				],
			]
		);
		$this->add_control(
			'schedule_1_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
					'schedule_1_element_img_style' => ['style-1' , 'style-2' , 'style-4' ],
				],
			]
		);
		$this->add_control(
			'schedule_1_element_img_style',
			[
				'label'   => esc_html__('Select Style', DZ_TH_DOMAIN),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__('Style 1', DZ_TH_DOMAIN),
					'style-2' => esc_html__('Style 2', DZ_TH_DOMAIN),
					'style-3' => esc_html__('Style 3', DZ_TH_DOMAIN),
					'style-4' => esc_html__('Style 4', DZ_TH_DOMAIN),
				],
				'default' => 'style-1',
			]
		);
		

		$this->add_control(
			'schedule_1_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
				],
			]
		);

		$this->add_control(
			'schedule_1_element_left_img',
			[
				'label' 		=> esc_html__( 'Left Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition'   => [
					'schedule_1_element_img_style' => 'style-4',
				],
			]
		);


		$this->add_control(
			'schedule_1_padding_switch',
			[
				'label' => esc_html__('Image Padding', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('On', DZ_TH_DOMAIN),
				'label_off' => esc_html__('Off', DZ_TH_DOMAIN),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
					'schedule_1_element_img_style' => 'style-1',
					'schedule_1_element_img_style' => 'style-2',
				],
			]
		);
		
		$this->add_control(
			'schedule_1_element_video_img',
			[
				'label' 		=> esc_html__( 'Video call Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
					'schedule_1_element_img_style' => 'style-1'
				],
			]
		);
		$this->add_control(
			'schedule_1_element_video_title',
			[
				'label' 		=> esc_html__( 'Video Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Video Call Support', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['left', 'both'],
					'schedule_1_element_img_style' => 'style-1'
				],
			]
		);
		$this->add_control(
			'schedule_1_element_contact_us',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
					'schedule_1_element_img_style' => 'style-1',
					'schedule_1_element_img_style' => 'style-2'
				],
			]
		);
		$this->add_control(
			'schedule_1_element_contact_icon_img',
			[
				'label' 		=> esc_html__( 'Contact Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'schedule_1_element_contact_us' => 'yes',
				],'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
					'schedule_1_element_img_style' => 'style-1',
					'schedule_1_element_img_style' => 'style-2'
				],
				
			]
		);
		
		 $this->add_control(
			'schedule_1_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your number', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( '10', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_img_style' => 'style-4',
				],
			]
		);
        $this->add_control(
			'schedule_1_element_counter_text',
			[
				'label' 		=> esc_html__( 'Counter Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Years Experienced', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_img_style' => 'style-4',
				],
			]
		);
		
		$this->add_control(
			'schedule_1_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Appointment', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
				],
			]
		);
		$this->add_control(
			'schedule_1_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
				'condition'   => [
					'schedule_1_element_tab' => ['right', 'both'],
				],
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'schedule_1_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Comprehensive Specialties', DZ_TH_DOMAIN ),

			]
		);
		
		
		$this->add_control(
			'schedule_1_element_item',
			[
				'label' 		=> esc_html__( 'Points', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				
				'default' 		=> [
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Comprehensive Specialties', DZ_TH_DOMAIN ),
					],	
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Research and Development', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Emergency Services', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Advanced Imaging Services', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Intensive Care Units (ICUs)', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Rehabilitation Services', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Telemedicine Facilities', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Patient-Centric Approach', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Multidisciplinary Team', DZ_TH_DOMAIN ),
					],
					[	
						'schedule_1_element_item_title' 		=> esc_html__( 'Health Information Technology', DZ_TH_DOMAIN ),
					],
				],
			]
		);
		
		$this->end_controls_section();
	
	
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'schedule_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
	
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/schedule_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}