<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPricingTable5 extends Widget_Base 
{
	public function get_name() {
		return 'dz-pricign-table-5';
	}
	
	public function get_title() {
		return esc_html__('Pricing Table 5',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-price-table';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_5_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose Your Perfect Plan', DZ_TH_DOMAIN ),
			]
		);
		
    
		
		$this->add_control(
			'pricing_table_5_element_description',
			[
				'label' 	=> esc_html__( 'Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_5_element_plan_1',
			[
				'label' 		=> esc_html__( 'Plan Duration 1 Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Monthly',
			]
		);
		$this->add_control(
			'pricing_table_5_element_plan_2',
			[
				'label' 		=> esc_html__( 'Plan Duration 2 Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Yearly',
			]
		);



		
		
		$this->end_controls_section();
		
		
			$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater = new \Elementor\Repeater();

		
		
		
		$repeater->add_control(
			'pricing_table_5_element_item_price',
			[
				'label' 		=> esc_html__( 'Plan 1 Price ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$49', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater->add_control(
			'pricing_table_5_element_item_price_2',
			[
				'label' 		=> esc_html__( 'Plan 2 Price', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$999', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'pricing_table_5_element_item_title',
			[
				'label' 		=> esc_html__( 'Plan Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Post Pregnancy', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'pricing_table_5_element_plantag',
			[
				'label' 		=> esc_html__( 'Plan Tag (for top)', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'PROFESSIONAL', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_5_box_description',
			[
				'label' 		=> esc_html__( 'Plan  Description ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'For most businesses that want to otpimize web queries ', DZ_TH_DOMAIN ),
			]
		);
	
	
		$repeater->add_control(
			'pricing_table_5_element_item_content',
			[
				'label' => esc_html__( 'Plan point list', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' 	=> true,
				'placeholder' => esc_html__( 'Type your content here', DZ_TH_DOMAIN ),
				'default' 		=> '<li>'.esc_html__( 'with 7 day free trail', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Nutrition Strategies', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Health diet plan', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Motivation program', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24/7 Support', DZ_TH_DOMAIN ).'</li>',
			]
		);
		$repeater->add_control(
			'pricing_table_5_element_item_button_text',
			[
				'label' 		=> esc_html__( 'Plan Button text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_5_element_item_button_link',
			[
				'label' 		=> esc_html__( 'Plan Button link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> 'https://clinicmaster.wprdx.com/dieting/price-table/',
			]
		);
		$this->add_control(
			'pricing_table_5_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),			
				'default' 		=> [
					[
						'pricing_table_5_element_item_price' => '$20',
						'pricing_table_5_element_item_price_2' => '$999',
						'pricing_table_5_element_item_title' => esc_html__( 'Post Pregnancy', DZ_TH_DOMAIN ),
						'pricing_table_5_box_description' => esc_html__( 'For most businesses that want to otpimize web queries', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_text' =>esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_link' => 'https://clinicmaster.wprdx.com/dieting/price-table/',
						'pricing_table_5_element_plantag' => esc_html__( 'POPULAR', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_content' => '<li>'.esc_html__( 'with 7 day free trail', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Nutrition Strategies', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Health diet plan', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Motivation program', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24/7 Support', DZ_TH_DOMAIN ).'</li>',
					],
					
					[
						'pricing_table_5_element_item_price' => '$100',
						'pricing_table_5_element_item_price_2' => '$1599',
						'pricing_table_5_element_item_title' => esc_html__( 'Weight Loss', DZ_TH_DOMAIN ),
						'pricing_table_5_box_description' => esc_html__( 'For most businesses that want to otpimize web queries', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_text' =>esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_link' => 'https://clinicmaster.wprdx.com/dieting/price-table/',
						'pricing_table_5_element_plantag' => esc_html__( 'MOST POPULAR', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_content' => '<li>'.esc_html__( 'with 7 day free trail', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Nutrition Strategies', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Health diet plan', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Motivation program', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24/7 Support', DZ_TH_DOMAIN ).'</li>',
					],
					
					[
						'pricing_table_5_element_item_price' => '$50',
						'pricing_table_5_element_item_price_2' => '$1049',
						'pricing_table_5_element_item_title' => esc_html__( 'Body Sculpting', DZ_TH_DOMAIN ),
						'pricing_table_5_box_description' => esc_html__( 'For most businesses that want to otpimize web queries', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_text' =>esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_button_link' => 'https://clinicmaster.wprdx.com/dieting/price-table/',
						'pricing_table_5_element_plantag' => esc_html__( 'PROFESSIONAL', DZ_TH_DOMAIN ),
						'pricing_table_5_element_item_content' => '<li>'.esc_html__( 'with 7 day free trail', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Nutrition Strategies', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Health diet plan', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Motivation program', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( '24/7 Support', DZ_TH_DOMAIN ).'</li>',
					],
					
					
				],
			]
		);
		$this->end_controls_section();

	
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_5_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/pricing_table_5_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){	
						handlePricingTabs();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}