<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZImageGallery extends Widget_Base 
{
	public function get_name() {
		return 'dz-image-gallery';
	}
	
	public function get_title() {
		return esc_html__('Image Gallery',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-photo-library';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'image_gallery_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					'style_3' => esc_html__( 'Style 3', DZ_TH_DOMAIN ),
					'style_4' => esc_html__( 'Style 4', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);

		$this->add_control(
			'image_gallery_element_background_color',
			[
				'label' 		=> esc_html__( 'Background Color', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				 'condition' => [
					'image_gallery_element_style' => array('style_4'),
				],
				  
			]
		);

		
		$this->add_control(
			'image_gallery_subtitle_element',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'   => esc_html__('Our Service', DZ_TH_DOMAIN),
				'condition' => [
					'image_gallery_element_style' => array('style_4'),
				],
			]
		);

		$this->add_control(
			'image_gallery_subtitle_icon_element',
			[
				'label' 		=> esc_html__( 'Subtitle Icon', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				 'condition' => [
					'image_gallery_element_style' => array('style_4'),
				],
			]
		);
		
		$this->add_control(
			'image_gallery_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__('Patient Skin Success Stories Before and After Results', DZ_TH_DOMAIN),
				'condition' => [
					'image_gallery_element_style' => array('style_2','style_3','style_4'),
				],
			]
		);
		
		$this->add_control(
			'image_gallery_element_img_gallery',
			[
				'label' 		=> esc_html__( 'Image Gallery', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
				
			]
		);

		$this->add_control(
			'image_gallery_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-1',
				'condition' => [
					'image_gallery_element_style' => array('style_2','style_3','style_4'),
				],
			]
		);
		$this->add_control(
			'image_gallery_element_css_class',
			[
				'label' 		=> esc_html__( 'Css Class', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your css class', DZ_TH_DOMAIN ),
				'default'   => '',
				'condition' => [
					'image_gallery_element_style' => array('style_2','style_3'),
				],
				
			]
		);
		
		$this->end_controls_section();

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/image_gallery_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleCompareSwiper();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}