<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner7 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-7';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 7',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster-banner' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);


		
		$this->add_control(
			'home_banner_7_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Lose Weight, Gain Confidence', DZ_TH_DOMAIN ),
			]
		);

		
		$this->add_control(
			'home_banner_7_element_description',
			[
				'label' 	=> esc_html__( 'Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);

	

		$this->add_control(
			'home_banner_7_element_bg_img',
			[
				'label'        => esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block'  => true,
				'type'         => Controls_Manager::MEDIA,
				'default'      => [
					'url' => 'https://clinicmaster.wprdx.com/fatloss/wp-content/uploads/2025/06/banner-1.webp',
				],
			]
		);


		$this->add_control(
			'home_banner_7_element_img',
			[
				'label' 		=> esc_html__( 'Banner Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'default'      => [
					'url' => 'https://clinicmaster.wprdx.com/fatloss/wp-content/uploads/2025/06/1.png',
				],
			]
			);

	
		$this->add_control(
			'home_banner_7_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'View all servises', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_7_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		

       $this->add_control(
			'home_banner_7_element_youtube_button_taxt',
			[
				'label' 		=> esc_html__( 'YouTube Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Watch Highlight', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_7_element_youtube_button_link',
			[
				'label' 		=> esc_html__( 'YouTube Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
				'default'   => 'https://www.youtube.com/watch?v=SIjZbiGqafI',
			]
		); 


		
		$this->end_controls_section();
		

		$this->start_controls_section(
			'Banner icons images',
			[
				'label' => esc_html__( 'Banner icons', DZ_TH_DOMAIN ),
			]
		);
	
   
   
		$this->add_control(
			'home_banner_7_element_icon_1',
			[
				'label' 		=> esc_html__( 'Icon Image 1', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);
   
		$this->add_control(
			'home_banner_7_element_icon_2',
			[
				'label' 		=> esc_html__( 'Icon Image 2 ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);
		$this->add_control(
			'home_banner_7_element_icon_3',
			[
				'label' 		=> esc_html__( 'Icon Image 3 ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);


    	$this->end_controls_section();		
	
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_7_element.php',$settings);
				
		
	}
	
	protected function content_template() 
	{

    }
}