<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-1';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Medical & Health Care ', DZ_TH_DOMAIN ).'<span class="text-primary">'.esc_html('Services', DZ_TH_DOMAIN).'</span>',
			]
		);
		
		
		$this->add_control(
			'home_banner_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Your health is our top priority. Schedule an appointment with us today', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_1_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_1_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'home_banner_1_element_small_img',
			[
				'label' 		=> esc_html__( 'Small Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_1_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_1_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			
			]
		);
		$this->add_control(
			'home_banner_1_element_button_text2',
			[
				'label' 		=> esc_html__( 'YouTube Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your youtube text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Watch Highlight', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_1_element_button_link2',
			[
				'label' 		=> esc_html__( 'YouTube Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your youtube link', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'contact',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_1_element_contact_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_1_element_email_text',
			[
				'label' 		=> esc_html__( 'Email Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your email text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Have a Question?', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_1_element_email',
			[
				'label' 		=> esc_html__( 'Email', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your email', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'info@example.com', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_1_progress_bar',
			[
				'label' => esc_html__( 'Progress Bar', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%'],
				'range' => [
					
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 82,
				],
				
			]
		);
		
		
		$this->add_control(
			'home_banner_1_element_text2',
			[
				'label' 		=> esc_html__( 'Text 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Successfully diagnosis', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_1_element_text_link2',
			[
				'label' 		=> esc_html__( 'Text Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section(); 

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_1_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						setTimeout(function(){
							handleProgressChart();
						}, 1000); 
					}					
				});
			 </script>
			";
		
		
		
		
	}
	
	protected function content_template() 
	{

    }
}