<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZCounterBox2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-counter-box-2';
	}
	
	public function get_title() {
		return esc_html__('Counter Box 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-counter';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_2_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1' => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2' => esc_html__('Style 2',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'style_1',
				
			]
		);
		$this->add_control(
			'counter_box_2_element_background_color',
			[
				'label' 		=> esc_html__( 'Background Color', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'counter_box_2_element_service_background',
			[
				'label' 		=> esc_html__( 'Service Background', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
				
			]
		);
		
      

		$this->add_control(
			'counter_box_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'We Care About Your Dental Health', DZ_TH_DOMAIN ),
			]
		);
		

      

		
		$this->add_control(
			'counter_box_2_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'counter_box_2_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'counter_box_2_element_youtube_text',
			[
				'label' 		=> esc_html__( 'Youtube Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Play Video', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_youtube_link',
			[
				'label' 		=> esc_html__( 'Youtube Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'default' => 'https://www.youtube.com/watch?v=YwYoyQ1JdpQ',
			]
		);
		$this->add_control(
			'counter_box_2_element_youtube_bg_img',
			[
				'label' 		=> esc_html__( 'Youtube Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		
		$this->add_control(
			'counter_box_2_element_feauter',
			[
				'label' 	=> esc_html__( 'Feauters (Comma Separated)', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'separator'	=>  'default',
				'rows'		=>  5,
				'default' => esc_html__( 'Teeth Whitening, Modern Anesthetic, Quality Brackets, Root Canal', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_2_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'service_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_2_element_service_bg_img',
			[
				'label' 		=> esc_html__( 'Service Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
     	$this->add_control(
			'counter_box_2_element_icon_box_section',
			[
				'label' 		=> esc_html__( 'Icon Box Section ', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Add class/Remove class', DZ_TH_DOMAIN ),
				
			]
		);
     	$this->add_control(
			'counter_box_2_element_grediant',
			[
				'label' 		=> esc_html__( 'Icon Box Gradient ', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Add class/Remove class', DZ_TH_DOMAIN ),
				
			]
		);
		

		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'gallery',
			[
				'label' => esc_html__( 'Gallery', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_small_img',
			[
				'label' 		=> esc_html__( 'Small Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'counter_box_2_element_gallery_img',
			[
				'label' 		=> esc_html__( 'Gallery Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		$this->add_control(
			'counter_box_2_element_gallery_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Patient recovers', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '150k', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'rating',
			[
				'label' => esc_html__( 'Rating', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_2_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your rating', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_2_element_star_rating',
			[
				'label' => esc_html__( 'Star Rating', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'default' => 5,
			]
		);
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->add_control(
			'counter_box_2_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=>  7,
				'min'           => 0,
				'title'			=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_2_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'	 	=>  8,
				'min'           => 0,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_2_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'counter_box_2_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'counter_box_2_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Specialists', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'counter_box_2_element_item_number',
			[
				'label' 	=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your counder number', DZ_TH_DOMAIN ),
				'default' => '200',
				
			]
		);
		
		$repeater->add_control(
			'counter_box_2_element_item_symbol',
			[
				'label' 	=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => '+',
				
			]
		);
		
		
		
		$this->add_control(
			'counter_box_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'default' 		=> [
					[
						'counter_box_2_element_item_title' 		=> esc_html__( 'Happy Patients', DZ_TH_DOMAIN ),
						'counter_box_2_element_item_number' 	=> '45',
						'counter_box_2_element_item_symbol' 	=>'K',
					],
					[
						'counter_box_2_element_item_title' 		=> esc_html__( 'Specialists', DZ_TH_DOMAIN ),
						'counter_box_2_element_item_number' 	=> '200',
						'counter_box_2_element_item_symbol' 	=>'+',
					],
					[
						'counter_box_2_element_item_title' 		=> esc_html__( 'Winning Awards', DZ_TH_DOMAIN ),
						'counter_box_2_element_item_number' 	=> '150',
						'counter_box_2_element_item_symbol' 	=>'+',
					],
					
				],
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'counter_box_2_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/counter_box_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}