<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox7 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-7';
	}
	
	public function get_title() {
		return esc_html__('Content Box 7',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_7_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'What is Cosmetic Dermatology ?', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_7_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_7_element_feature_title',
			[
				'label' 		=> esc_html__( 'Feature Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your feature title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Benefits of Cosmetic Dermatology', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_7_element_feature_description',
			[
				'label' 	=> esc_html__( 'Enter Feature Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Feature Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Feature Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_7_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'contact_box_7_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Enhanced Appearance', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'contact_box_7_element_item_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Helps improve the overall aesthetic appeal of the skin, making it look more youthful and refreshed.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_7_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'contact_box_7_element_item_title' 		=> esc_html__( 'Enhanced Appearance', DZ_TH_DOMAIN ),
						'contact_box_7_element_item_description' => esc_html__( 'Helps improve the overall aesthetic appeal of the skin, making it look more youthful and refreshed.', DZ_TH_DOMAIN ),
						
					],	
					[	
						'contact_box_7_element_item_title' 		=> esc_html__( 'Boost in Confidence', DZ_TH_DOMAIN ),
						'contact_box_7_element_item_description' => esc_html__( 'Many individuals experience an increase in self-esteem and confidence after cosmetic treatments.', DZ_TH_DOMAIN ),
						
					],	
					[	
						'contact_box_7_element_item_title' 		=> esc_html__( 'Addressing Skin Imperfections', DZ_TH_DOMAIN ),
						'contact_box_7_element_item_description' => esc_html__( 'Effective in treating acne scars, pigmentation issues, and other skin imperfections.', DZ_TH_DOMAIN ),
						
					],	
					
				],
			]
		);
		
		
		$this->end_controls_section();
		
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_7_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}