<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-2';
	}
	
	public function get_title() {
		return esc_html__('Content Box 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_2_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Why Choose Us', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_2_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		
		
		$this->add_control(
			'content_box_2_element_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Why Choose Us for Your Health care Needs', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_2_element_img',
			[
				'label' 	=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'content_box_2_element_img2',
			[
				'label' 	=> esc_html__( 'Image 2', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
			]
		); 
		
		$this->add_control(
			'content_box_2_element_pattern_img',
			[
				'label' 	=> esc_html__( 'Pattern Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
			]
		);
		
		
		$this->add_control(
			'content_box_2_element_bg_img',
			[
				'label' 	=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'content_box_2_element_counter_title',
			[
				'label' 	=> esc_html__( 'Counter Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'SpeciaYears', DZ_TH_DOMAIN ) .' <br>'. esc_html__( 'Experiencedlists', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_2_element_number',
			[
				'label' 	=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your counder number', DZ_TH_DOMAIN ),
				'default' => '20',
				
			]
		);
		
		$this->add_control(
			'content_box_2_element_symbol',
			[
				'label' 	=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => '+',
				
			]
		);
		$this->add_control(
			'content_box_2_element_text',
			[
				'label' 	=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => esc_html__( 'Year', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'content_box_2_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'More Experience', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'content_box_2_element_item_description',
			[
				'label' 	=> esc_html__( 'Description', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => esc_html__( 'We offer a wide range of health services to meet all your needs.', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'content_box_2_element_item_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,	
			]
		); 
		
		
		
		
		$this->add_control(
			'content_box_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'content_box_2_element_item_title' 		=> esc_html__( 'More Experience', DZ_TH_DOMAIN ),
						'content_box_2_element_item_description' 	=> esc_html__( 'We offer a wide range of health services to meet all your needs.', DZ_TH_DOMAIN ),
					],
					[
						'content_box_2_element_item_title' 		=> esc_html__( 'Seamless care', DZ_TH_DOMAIN ),
						'content_box_2_element_item_description' 	=> esc_html__( 'We offer a wide range of health services to meet all your needs.', DZ_TH_DOMAIN ),
					],
					[
						'content_box_2_element_item_title' 		=> esc_html__( 'The right answers?', DZ_TH_DOMAIN ),
						'content_box_2_element_item_description' 	=> esc_html__( 'We offer a wide range of health services to meet all your needs.', DZ_TH_DOMAIN ),
					],
					[
						'content_box_2_element_item_title' 		=> esc_html__( 'Unparalleled expertise', DZ_TH_DOMAIN ),
						'content_box_2_element_item_description' 	=> esc_html__( 'We offer a wide range of health services to meet all your needs.', DZ_TH_DOMAIN ),
					],
					
					
				],
			]
		);
		
		$this->end_controls_section();
	
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_2_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		$this->add_control(
			'content_box_2_element_show_date',
			[
				'label' 		=> esc_html__( 'Show Date', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default'	 =>  'yes',
			]
		);
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}