<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;
class DZContactBox6 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-box-6';
	}
	
	public function get_title() {
		return esc_html__('Contact Box 6',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_6_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'All Locations', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_6_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', DZ_TH_DOMAIN ),
			]
		);
		$default_address = esc_html__( 'London Eye, London, United Kingdom', DZ_TH_DOMAIN );
		$this->add_control(
			'address',
			[
				'label' => esc_html__( 'Location', 'elementor' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
					'categories' => [
						TagsModule::POST_META_CATEGORY,
					],
				],
				'ai' => [
					'active' => false,
				],
				'placeholder' => $default_address,
				'default' => $default_address,
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'contact',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_6_element_contact_address_text',
			[
				'label' 	=> esc_html__( 'Address Taxt', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Office Address:', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_6_element_contact_address',
			[
				'label' 	=> esc_html__( 'Address', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( '234 Oak Drive, Villagetown, USA', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_6_element_contact_hours_text',
			[
				'label' 	=> esc_html__( 'Hours Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Working Hours:', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_6_element_contact_hours',
			[
				'label' 	=> esc_html__( 'Working Hours', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Mon-Thu: 8:00am-5:00pm', DZ_TH_DOMAIN ). '<br>'. esc_html__( 'Fri: 8:00am-1:00pm', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'contact_box_6_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'United State', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'contact_box_6_element_item_map_img',
			[
				'label' 	=> esc_html__( 'Map Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
				
			]
		);
		
		$repeater->add_control(
			'contact_box_6_element_item_country_flag',
			[
				'label' 	=> esc_html__( 'Country Flag', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::MEDIA,
				
			]
		);
		$repeater->add_control(
			'contact_box_6_element_item_address',
			[
				'label' 	=> esc_html__( 'Address', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( '123 Health Way, Suite 456 Goodland, 78910 United States', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'contact_box_6_element_item_phone_num',
			[
				'label' 	=> esc_html__( 'Phone Number', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your number', DZ_TH_DOMAIN ),
				'default' => esc_html__( '+0 123-456-7890', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'contact_box_6_element_item_link_text',
			[
				'label' 	=> esc_html__( 'Link Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Get Directions ', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'contact_box_6_element_item_link',
			[
				'label' 	=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'default' =>  'https://www.google.com/maps/',
			]
		);
		
		$this->add_control(
			'contact_box_6_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'contact_box_6_element_item_title' 		=> esc_html__( 'United State', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_phone_num' 		=> esc_html__( '+0 123-456-7890', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_address' 		=> esc_html__( '123 Health Way, Suite 456 Goodland, 78910 United States', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_link_text' 	=> esc_html__( 'Get Directions ', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_link' 	    => 'https://www.google.com/maps/',
					],	
					[	
						'contact_box_6_element_item_title' 		=> esc_html__( 'Canada', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_phone_num' 		=> esc_html__( '+0 123-456-7890', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_address' 		=> esc_html__( '123 Health Way, Suite 456 Goodland, 78910 United States', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_link_text' 	=> esc_html__( 'Get Directions ', DZ_TH_DOMAIN ),
						'contact_box_6_element_item_link' 	    => 'https://www.google.com/maps/',
					],	
					
				],
			]
		);
		
		
		$this->end_controls_section();
		
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'contact_box_6_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_box_6_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}