<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContactBox4 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-box-4';
	}
	
	public function get_title() {
		return esc_html__('Contact Box 4',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_4_element_css_class',
			[
				'label' 	=> esc_html__( 'Class', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your css class', DZ_TH_DOMAIN ),
				'default' => 'bg-light' ,
			]
		);
		
		$this->add_control(
			'contact_box_4_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-1',
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'contact_box_4_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Address', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'contact_box_4_element_item_description',
			[
				'label' 	=> esc_html__( 'Description', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => esc_html__( '1247/Plot No. 39, 15th Phase, Colony, Kukatpally, Hyderabad', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'contact_box_4_element_item_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,	
			]
		); 
		
		
		
		
		$this->add_control(
			'contact_box_4_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'contact_box_4_element_item_title' 		=> esc_html__( 'Address', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> esc_html__( '1247/Plot No. 39, 15th Phase, Colony, Kukatpally, Hyderabad', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_4_element_item_title' 		=> esc_html__( 'Call Us', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> esc_html__( '+0 123-456-7890', DZ_TH_DOMAIN ). '</br>'. esc_html__( '+0 987-654-3210', DZ_TH_DOMAIN ),
					],
					[
						'contact_box_4_element_item_title' 		=> esc_html__( 'Send us a Mail', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> esc_html__( 'info@example.com', DZ_TH_DOMAIN ).'</br>'.esc_html__( 'clinicmaster@example.com', DZ_TH_DOMAIN ),
					],
					[
						'contact_box_4_element_item_title' 		=> esc_html__( 'Opening Time', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> esc_html__( 'Mon-Thu: 8:00am-5:00pm', DZ_TH_DOMAIN ).'</br>'.esc_html__( 'Fri: 8:00am-1:00pm', DZ_TH_DOMAIN ),
					],
				],
			]
		);
	
		$this->end_controls_section();
		
	
		
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_box_4_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}