<?php
if( !function_exists( 'dz_set' ) ) {
	function dz_set( $var, $key, $def = '' )
	{
		if( !$var ) return false;
	
		if( is_object( $var ) && isset( $var->$key ) ) return $var->$key;
		elseif( is_array( $var ) && isset( $var[$key] ) ) return $var[$key];
		elseif( $def ) return $def;
		else return false;
	}
}

function dz_get_rev_slider() {
	global $wpdb;
	
	$table = $wpdb->get_results("SHOW TABLES LIKE '".$wpdb->prefix."revslider_sliders'", ARRAY_A);
	if( !$table ) return array();
	
	$res = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."revslider_sliders");
	$return = array();
	if( $res ){
		foreach( $res as $r )
		{
			$return[dz_set( $r, 'alias' )] = dz_set( $r, 'title' );
		}
	}
	return $return;
}

function _load_plugins_class($class, $directory = 'libraries', $global = true, $prefix = 'Dexignzone_DZ_') {
	$obj = &$GLOBALS['_dz_base'];
	$obj = is_object( $obj ) ? $obj : new stdClass;
	$name = false;
	// Is the request a class extension?  If so we load it too
	$path = DZ_TH_ROOT.'includes/'.$directory.'/'.$class.'.php';
	if( file_exists($path) )
	{
		$name = $prefix.ucwords( $class );
		if (class_exists($name) === false)	require($path);
		}
	// Did we find the class?
	if ($name === false) exit('Unable to locate the specified class: '.$class.'.php');
	if( $global ) $GLOBALS['_dz_base']->$class = new $name();
	else new $name();
}
if( isset( $_GET['dz_shortcode_editor_action'] ) ) {
	include_once('resource/shortcode_output.php'); exit;
}

function _dz_widget_init_register() {
	/*Footer Widget*/
	if( class_exists( 'ClinicMaster_DZ_About_Us' ) ){ register_widget( 'ClinicMaster_DZ_About_Us' );	}
	if( class_exists( 'ClinicMaster_DZ_Newsletter' ) ){ register_widget( 'ClinicMaster_DZ_Newsletter' );	}
	if( class_exists( 'ClinicMaster_DZ_Navigation' ) ){ register_widget( 'ClinicMaster_DZ_Navigation' );	}
	if( class_exists( 'ClinicMaster_DZ_Navigation2' ) ){ register_widget( 'ClinicMaster_DZ_Navigation2' );	}
	if( class_exists( 'ClinicMaster_DZ_Recent_Post' ) ){ register_widget( 'ClinicMaster_DZ_Recent_Post' );	}
	if( class_exists( 'ClinicMaster_DZ_Contact_Us' ) ){ register_widget( 'ClinicMaster_DZ_Contact_Us' );	}
	if( class_exists( 'ClinicMaster_DZ_Contact_Us2' ) ){ register_widget( 'ClinicMaster_DZ_Contact_Us2' );	}
	if( class_exists( 'ClinicMaster_DZ_Contact_Us3' ) ){ register_widget( 'ClinicMaster_DZ_Contact_Us3' );	}
	if( class_exists( 'ClinicMaster_DZ_Contact_Us4' ) ){ register_widget( 'ClinicMaster_DZ_Contact_Us4' );	}
	
}
add_action( 'widgets_init', '_dz_widget_init_register' );
// function add_custom_post_types_to_elementor() {
//     $post_types = get_option('elementor_cpt_support', ['page', 'post']);

    
//     $all_custom_post_types = get_post_types(['_builtin' => false, 'public' => true]);
// 	print_r($all_custom_post_types);
//     if (!empty($all_custom_post_types)) { print_r($all_custom_post_types);
//         foreach ($all_custom_post_types as $cpt) {
//             if (!in_array($cpt, $post_types)) {
//                 $post_types[] = $cpt;
//             }
//         }
       
//         // update_option('elementor_cpt_support', $post_types, true);
// 		// update_option('elementor_active', true);
//     }
// }


// add_action('init', 'add_custom_post_types_to_elementor');


function add_custom_post_types_to_elementor() {
    $post_types = get_option('elementor_cpt_support', ['page', 'post', 'public' => true]); 
	$all_custom_post_types = get_post_types(['_builtin' => false]); 
    foreach ($all_custom_post_types as $cpt) {
        if (!in_array($cpt, $post_types)) {
            $post_types[] = $cpt;
        }
    }
    update_option('elementor_cpt_support', $post_types);
	update_option('elementor_active', true);
}

add_action('plugins_loaded', 'add_custom_post_types_to_elementor');

function _dz_plugin_init() {
	
	global $pagenow;
	
	include_once( 'library/functions.php' );
	include_once( 'library/mailchimp.php' );
	

	_load_plugins_class( 'post_types', 'helpers', false );
	
	_load_plugins_class( 'taxonomies', 'helpers', false );

	_load_plugins_class( 'ajax', 'helpers', false );
	
	_load_plugins_class( 'shortcodes', 'helpers', true );
	
	_load_plugins_class( 'faq_category_icon', 'helpers', true );
	
	if( function_exists( 'vc_map' )){
		include_once( 'vc_map.php' );
	
		/* VC Custom Field */
			include_once( 'resource/vc_custom_fields/dropdown_multi.php' );
		/* VC Custom Field END */
	}
	
	if(dz_is_plugin_active('elementor/elementor.php'))
	{
		include_once DZ_TH_ROOT.'/includes/resource/elementor/DZElementor.php';
	}
	
	if(class_exists('ReduxFramework')){
		include_once DZ_TH_ROOT.'/includes/dz-redux/template-functions.php';
	}
	
	$active_plugins = get_option('active_plugins');
	$seo_plugins = [
		'wordpress-seo/wp-seo.php',                    // Yoast SEO
		'all-in-one-seo-pack/all_in_one_seo_pack.php', // All in One SEO
		'seo-by-rank-math/rank-math.php',              // Rank Math SEO
		'wp-seopress/seopress.php',                    // SEOPress
		'the-seo-framework/the-seo-framework.php',     // The SEO Framework
		'squirrly-seo/squirrly.php',                   // Squirrly SEO
		'wp-smart-crawl/wp-smart-crawl.php',           // SmartCrawl SEO
	];

	$active_seo_plugins = array_intersect($seo_plugins, $active_plugins);
	if (!class_exists('DZSeo') && !$active_seo_plugins) {
		 require_once ('library/classes/class-dz-seo.php');
	}
	
	if (!class_exists('Theme_Actiovation_Check')) {
		require_once ('helpers/theme_activation_check.php');
	}
	
	// scss compiler library
	if (!class_exists('scssc')) {
		 require_once ('library/classes/scss.inc.php');
	}
	
	
	dz_user_extra( 
		array(
			'facebook' => __('Facebook', DZ_TH_DOMAIN), 
			'twitter' => __('Twitter', DZ_TH_DOMAIN), 
			'dribbble' => __('Dribble', DZ_TH_DOMAIN), 
			'github' => __('Github', DZ_TH_DOMAIN),
			'flickr' => __('Flickr', DZ_TH_DOMAIN), 
			'google-plus' => __('Google+', DZ_TH_DOMAIN), 
			'youtube' => __('Youtube', DZ_TH_DOMAIN ) 
		),
	);
		
}
add_action('init', '_dz_plugin_init');




function clinicmaster_latest_sticky() 
{
	/* Get all sticky posts */
	$sticky = get_option( 'sticky_posts' );
	/* Sort the stickies with the newest ones at the top */
	rsort( $sticky );
	/* Get the 5 newest stickies (change 5 for a different number) */
	$sticky = array_slice( $sticky, 0, 5 );
	/* Query sticky posts */
	$the_query = new WP_Query( array( 'post__in' => $sticky, 'ignore_sticky_posts' => 1 ) );
	// The Loop
	if ( $the_query->have_posts() ) 
	{
		$result .= '<ul>';
		while ( $the_query->have_posts() ) 
		{
			$the_query->the_post();
			$result .= '<li><a href="' .get_permalink(). '" title="'  . get_the_title() . '">' . get_the_title() . '</a><br />' . get_the_excerpt(). '</li>';
			 
		}
		$result .= '</ul>';
	} 
	else 
	{
		// no posts found
	}
	/* Restore original Post Data */
	wp_reset_postdata();
	return $result; 
} 
add_shortcode('latest_stickies', 'clinicmaster_latest_sticky');

add_action('wp_login', 'check_purchase_code_activity', 10, 2);
function check_purchase_code_activity($user_login, $user) {
	if (in_array('administrator', $user->roles) || in_array('shop_manager', $user->roles)) {
		setcookie('purchase_code_check', $user->roles[0], time() + 180, "/");
	
	}
}