<?php

/* Single Pages Template */
function page_template_options(){
	
	$page_templates = array(
		"landing" => array(
			array(
				"title"     => "Default Page",
				"id"    => "landing_default",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/page-template/template-1.png',
				"param"  => array()
			),
			array(
				"title"     => "Default Page",
				"id"    => "landing_style_2",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/page-template/template-2.png',
				"param"  => array()
			)
		),
		"inner" => array(
			array(
				"title"     => "About Us",
				"id"    => "landing_style_3",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/page-template/template-3.png',
				"param"  => array()
			),
			array(
				"title"     => "Default Page",
				"id"    => "landing_style_4",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/page-template/template-4.png',
				"param"  => array()
			)
		),
		"coming" => array(
			array(
				"title"     => "Comingsoon 1",
				"id"    => "coming_style_1",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/comming-soon/template-1.png',
				"param"  => array()
			),
			array(
				"title"     => "Comingsoon 2",
				"id"    => "coming_style_2",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/comming-soon/template-2.png',
				"param"  => array()
			),
			array(
				"title"     => "Comingsoon 3",
				"id"    => "coming_style_3",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/comming-soon/template-3.png',
				"param"  => array()
			)
		),
		"maintenance" => array(
			array(
				"title"     => "Maintenance 1",
				"id"    => "maintenance_style_1",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/maintinance/template-1.png',
				"param"  => array()
			),
			array(
				"title"     => "Maintenance 2",
				"id"    => "maintenance_style_2",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/maintinance/template-2.png',
				"param"  => array()
			),
			array(
				"title"     => "Maintenance 3",
				"id"    => "maintenance_style_3",
				"img"    => get_template_directory_uri() . '/dz-inc/assets/images/maintinance/template-3.png',
				"param"  => array()
			)
		),
		"error" => array(
			array(
				"title"     => "Error 1",
				"id"    => "error_style_1",
				"img"    => "image_path",
				"param"  => array()
			),
			array(
				"title"     => "Error 2",
				"id"    => "error_style_2",
				"img"    => "image_path",
				"param"  => array()
			)
		),
	);
	return $page_templates;
}

/* Single Post Layouts */
function post_layouts_options(){

	$post_layouts = array(
		array(
			"id"    => "post_style_1",
			'layout_param' => array(
		    	'title' => 'Layout 1',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-1.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_2",
			'layout_param' => array(
		    	'title' => 'Layout 2',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-2.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_3",
			'layout_param' => array(
		    	'title' => 'Layout 3',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-3.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_4",
			'layout_param' => array(
		    	'title' => 'Layout 4',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-4.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_5",
			'layout_param' => array(
		    	'title' => 'Layout 5',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-5.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_6",
			'layout_param' => array(
		    	'title' => 'Layout 6',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-6.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_7",
			'layout_param' => array(
		    	'title' => 'Layout 7',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-7.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "post_style_8",
			'layout_param' => array(
		    	'title' => 'Layout 8',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/layout-8.png'
		    ),
			"param"  => array()
		),
	);

	return $post_layouts;
}

/* Header Layouts Options */
function header_style_options(){
	$header_styles = array(
		array(
			"title" => 'Header 1',
			"id"    => "dz_header_1",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-1.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5)
				'social_links' => 3
			)
		),
		array(
			"title" => 'Header 2',
			"id"    => "dz_header_2",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-2.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)
		),
		array(
			"title" => 'Header 3',
			"id"    => "dz_header_3",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-3.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 4',
			"id"    => "dz_header_4",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-4.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 5
			)    
		),
		array(
			"title" => 'Header 5',
			"id"    => "dz_header_5",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-5.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 6',
			"id"    => "dz_header_6",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-6.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 7',
			"id"    => "dz_header_7",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-7.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 8',
			"id"    => "dz_header_8",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-8.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 9',
			"id"    => "dz_header_9",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-9.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 10',
			"id"    => "dz_header_10",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-10.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 11',
			"id"    => "dz_header_11",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-11.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		),
		array(
			"title" => 'Header 12',
			"id"    => "dz_header_12",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-12.png',
			"param"  => array(
				"class" => "",
				'social_link' => true,
				'search' => true,
				'call_to_action_button' => 1, //(0 - 2-3-4-5) ,
				'social_links' => 2
			)    
		)
	);

	return $header_styles;
}

/* Foote Layouts Options */
function footer_style_options(){
	$footer_styles = array(
		array(
			"title" => 'Footer 1',
			"id"    => "footer_template_1",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-1.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 2',
			"id"    => "footer_template_2",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-2.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 3',
			"id"    => "footer_template_3",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-3.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 4',
			"id"    => "footer_template_4",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-4.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 5',
			"id"    => "footer_template_5",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-5.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 6',
			"id"    => "footer_template_6",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-6.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 7',
			"id"    => "footer_template_7",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-7.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 8',
			"id"    => "footer_template_8",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-8.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 9',
			"id"    => "footer_template_9",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-9.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 10',
			"id"    => "footer_template_10",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-10.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 11',
			"id"    => "footer_template_11",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-11.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 12',
			"id"    => "footer_template_12",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-12.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 13',
			"id"    => "footer_template_13",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-13.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		),
		array(
			"title" => 'Footer 14',
			"id"    => "footer_template_14",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer_templates/footer-template-14.png',
			"param"  => array(
				'social_link' => true,
				'credit_info'	=> true,
				'sections'	=> 2 //(0-1-2-3-4)
			)
		)
	);

	return $footer_styles;
}

/* Sidebar Layouts Options*/
function sidebar_layout_options(){

	$sidebar_layout = array(
		array(
			'id' => 'sidebar_full',
			'sidebar_param' => array(
				'title' => 'Full Width',
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-full.png'),
			"param"  => array()
		),
		array(
			'id' => 'sidebar_left',
			'sidebar_param' => array(
				'title' => 'Left Side',
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-left.png'),
			"param"  => array()
		),
		array(
			'id' => 'sidebar_right',
			'sidebar_param' => array(
				'title' => 'Right Side',
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-right.png'),
			"param"  => array()
		),
		array(
			'id' => 'sidebar_both',
			'sidebar_param' => array(
				'title' => 'Both Side',
				'img' 	=> get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar.png'),
			"param"  => array()
		)
	);

	return $sidebar_layout;
}

/* Post Box/Wrapper Style Options */
function post_wrapper_options(){
	
	$post_wrapper_layout = array(
		array(
			"id"    => "post_box_1",
			"img_param" =>  array(
				"title" => 'Post Box 1',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-1.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_2",
			"img_param" =>  array(
				"title" => 'Post Box 2',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-2.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_3",
			"img_param" =>  array(
				"title" => 'Post Box 3',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-3.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_4",
			"img_param" =>  array(
				"title" => 'Post Box 4',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-4.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_5",
			"img_param" =>  array(
				"title" => 'Post Box 5',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-5.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_6",
			"img_param" =>  array(
				"title" => 'Post Box 6',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-6.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_7",
			"img_param" =>  array(
				"title" => 'Post Box 7',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-7.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_8",
			"img_param" =>  array(
				"title" => 'Post Box 8',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-8.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_9",
			"img_param" =>  array(
				"title" => 'Post Box 9',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-9.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_box_10",
			"img_param" =>  array(
				"title" => 'Post Box 10',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-10.png'
			),
			"param"  => array()
		)
	);

	return $post_wrapper_layout;
}

/* Post Listing Style Options */
function post_listing_options(){
	// post listing/collage style
	$post_listing_layout = array(
		array(
			"id"    => "post_listing_1",
			"listing_param" =>  array(
				"title" => 'Post Listing 1',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-1.png'),
			"param"  => array()
		),
		array(
			"id"    => "post_listing_2",
			"listing_param" => array(
				"title" => 'Post Listing 2',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-2.png'),
			"param"  => array()
		),
		array(
			"id"    => "post_listing_3",
			"listing_param" =>  array(
				"title" => 'Post Listing 3',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-3.png'),
			"param"  => array()
		),
		array(
			"id"    => "post_listing_4",
			"listing_param" =>  array(
				"title" => 'Post Listing 4',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-4.png'),
			"param"  => array()
		),

		array(
			"id"    => "post_listing_5",
			"listing_param" =>  array(
				"title" => 'Post Listing 5',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-5.png'),
			"param"  => array()
		)
	);

	return $post_listing_layout;
}

/* Post Tiles Style Options */
function post_tiles_options(){

	$post_tile_layout = array(
		array(
			"id"    => "post_tile_1",
			"img_param" =>  array(
				"title" => 'Post Tile 1',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-1.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "post_tile_2",
			"img_param" => array(
				"title" => 'Post Tile 2',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-2.png'
			),
			"param"  => array()
		)
	);

	return $post_tile_layout;
}

/* Page Banner Style Options */
function page_banner_options(){
	$page_banner_style = array(
		array(
			"id"    => "page_banner_big",
			'banner_param' => array(
		    	'title' => 'Fit to Screen',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-big.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "page_banner_medium",
			'banner_param' => array(
		    	'title' => 'Banner Medium',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-medium.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "page_banner_small",
			'banner_param' => array(
		    	'title' => 'Banner Small',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-small.png'
		    ),
			"param"  => array()
		),
		array(
			"id"    => "page_banner_custom",
			'banner_param' => array(
		    	'title' => 'Custom Height',
		    	'img' => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-small.png'
		    ),
			"param"  => array()
		)	
	);

	return $page_banner_style;
}


/* Posts Banners
"param"  => array(
			'limit' => array(3,12),
			'category' => true,
			'type' => array('all','featured', 'most-visited', 'most-liked')
			'post_with' => array('all', 'images-only','without')
			)
limit : array(3,12) : limit select box value start from 3 and end with 12 
array(3) : limit will be 3 fix with disable input box : hint limit is fixed for this 
array(3,15,3) : limit select box values start from 3 and end with 15 with steps 3 like (3,6,9,12,15)  
*/
/* Post Banner Options */

function post_banner_options(){
	$post_banners = array(
		array(
			"id"    => "post_banner_v1",
			"post_banner_param" => array(
				"title" => 'Post Banner 1',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v1.png'
			),
			"param"  => array(
				'limit' => array(2,5),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			"id"    => "post_banner_v2",
			"post_banner_param" => array(
				"title" => 'Post Banner 2',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v2.png'
			),
			"param"  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			"id"    => "post_banner_v3",
			"post_banner_param" => array(
				"title" => 'Post Banner 3',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v3.png'
			),
			"param"  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
			)    
		)
	);

	return $post_banners;
}

/* Theme Layout Options */
function theme_layout_options(){
	$theme_layouts = array(
		array(
			"id"    => "theme_layout_1",
			"img_param" => array(
				"title" => 'Full',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/full-width.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "theme_layout_2",
			"img_param" => array(
				"title" => 'Box',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/boxed.png'
			),
			"param"  => array()
		),
		array(
			"id"    => "theme_layout_3",
			"img_param" => array(
				"title" => 'Frame',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/frame.png'
			),
			"param"  => array()
		)
	);

	return $theme_layouts;
}

/* Theme Color Background Options */
function theme_color_background_options(){
	$theme_color_background = array(
		array(
			"id"    => "bg_color_1",
			"img_param" => array(
				"title" => 'Orange',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg1.jpg'
			),
			"param"  => array()      
		),
		array(
			"id"    => "bg_color_2",
			"img_param" => array(
				"title" => 'Red',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg2.jpg'
			),
			"param"  => array()      
		),
		array(
			"id"    => "bg_color_3",
			"img_param" => array(
				"title" => 'Color Name',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg3.jpg'
			),
			"param"  => array()      
		),
		array(
			"id"    => "bg_color_4",
			"img_param" => array(
				"title" => 'Color Name',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg4.jpg'
			),
			"param"  => array()      
		),
		array(
			"id"    => "bg_color_5",
			"img_param" => array(
				"title" => 'Color Name',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg5.jpg'
			),
			"param"  => array()      
		),
		array(
			"id"    => "bg_color_6",
			"img_param" => array(
				"title" => 'Color Name',
				"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg6.jpg'
			),
			"param"  => array()      
		)
	);

	return $theme_color_background;
}

/* Theme Image Background Options */
function theme_image_background_options(){
	$theme_image_background = array(
		array(
			"id"    => "bg_img_1",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg1.jpg',
			"param"  => array()
		),
		array(
			"id"    => "bg_img_2",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg2.jpg',
			"param"  => array()
		),
		array(
			"id"    => "bg_img_3",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg3.jpg',
			"param"  => array()
		),
		array(
			"id"    => "bg_img_4",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg4.jpg',
			"param"  => array()
		)
	);

	return $theme_image_background;
}

/* Theme Pattern Background Options */
function theme_pattern_background_options(){
	$theme_pattern_background = array(
		array(
			"id"    => "bg_pattern_1",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg1.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_2",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg2.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_3",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg3.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_4",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg4.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_5",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg5.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_6",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg6.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_7",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg7.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_8",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg8.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_9",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg9.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_10",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg10.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_11",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg11.jpg',
			"param" => array()
		),
		array(
			"id"    => "bg_pattern_12",
			"title" => "Pattern Name",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg12.jpg',
			"param" => array()
		)
	);

	return $theme_pattern_background;
}

/* Page Loader Options */
function page_loader_options(){
	$page_loader = array(
		array(
			"title" => 'Loading 1',
			"id"    => "loading_1",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading1.svg',
			"param"  => array()
		),
		array(
			"title" => 'Loading 2',
			"id"    => "loading_2",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading2.svg',
			"param"  => array()
		),
		array(
			"title" => 'Loading 3',
			"id"    => "loading_3",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading3.svg',
			"param"  => array()
		),
		array(
			"title" => 'Loading 4',
			"id"    => "loading_4",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading4.svg',
			"param"  => array()
		),
		array(
			"title" => 'Loading 5',
			"id"    => "loading_5",
			"img"   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading5.svg',
			"param"  => array()
		)
	);

	return $page_loader;
}

/* Sorting Options */
function sort_by_options(){
	$sort_by = array(
		'date_asc'  => esc_html__('Date ASC', 'dexignlab'),
		'date_desc'  => esc_html__('Date DESC', 'dexignlab'),
		'title_asc'  => esc_html__('Title ASC', 'dexignlab'),
		'title_desc'  => esc_html__('Title DESC', 'dexignlab'),
		'featured'  => esc_html__('Featured', 'dexignlab'),
		'most_visited'  => esc_html__('Most Visited', 'dexignlab'),
		'most_liked'  => esc_html__('Most Liked', 'dexignlab'),
	);

	return $sort_by;
}

/* Button Link Target Options */
function link_target_options(){
	$link_target = array(
		'_blank' 	=>	'Opens the link in a new tab.',
		'_parent' 	=> 	'Opens the link in the parent frame.',
		'_self'		=>	'Open the link in the current frame.',
		'_top'		=>	'Opens the link in the top-most frame.'
	);
	
	return $link_target;
}

/* Advertisement Banner Size Options */
function adsence_size_options(){
	$adsence_size = array(
		'auto' => esc_html__( 'Auto', 'dexignlab' ),
		'120 x 90' => esc_html__('120 x 90', 'dexignlab'),
		'120 x 240' => esc_html__('120 x 240', 'dexignlab'),
		'120 x 600' => esc_html__('120 x 600', 'dexignlab'),
		'125 x 125' => esc_html__('125 x 125', 'dexignlab'),
		'160 x 90' => esc_html__('160 x 90', 'dexignlab'),
		'160 x 600' => esc_html__('160 x 600', 'dexignlab'),
		'180 x 90' => esc_html__('180 x 90', 'dexignlab'),
		'180 x 150' => esc_html__('180 x 150', 'dexignlab'),
		'200 x 90' => esc_html__('200 x 90', 'dexignlab'),
		'200 x 200' => esc_html__('200 x 200', 'dexignlab'),
		'234 x 60' => esc_html__('234 x 60', 'dexignlab'),
		'250 x 250' => esc_html__('250 x 250', 'dexignlab'),
		'320 x 100' => esc_html__('320 x 100', 'dexignlab'),
		'300 x 250' => esc_html__('300 x 250', 'dexignlab'),
		'300 x 600' => esc_html__('300 x 600', 'dexignlab'),
		'300 x 1050' => esc_html__('300 x 1050', 'dexignlab'),
		'320 x 50' => esc_html__('320 x 50', 'dexignlab'),
		'336 x 280' => esc_html__('336 x 280', 'dexignlab'),
		'360 x 300' => esc_html__('360 x 300', 'dexignlab'),
		'435 x 300' => esc_html__('435 x 300', 'dexignlab'),
		'468 x 15' => esc_html__('468 x 15', 'dexignlab'),
		'468 x 60' => esc_html__('468 x 60', 'dexignlab'),
		'640 x 165' => esc_html__('640 x 165', 'dexignlab'),
		'640 x 190' => esc_html__('640 x 190', 'dexignlab'),
		'640 x 300' => esc_html__('640 x 300', 'dexignlab'),
		'728 x 15' => esc_html__('728 x 15', 'dexignlab'),
		'728 x 90' => esc_html__('728 x 90', 'dexignlab'),
		'970 x 90' => esc_html__('970 x 90', 'dexignlab'),
		'970 x 250' => esc_html__('970 x 250', 'dexignlab'),
		'240 x 400' => esc_html__('240 x 400 - Regional ad sizes', 'dexignlab'),
		'250 x 360' => esc_html__('250 x 360 - Regional ad sizes', 'dexignlab'),
		'580 x 400' => esc_html__('580 x 400 - Regional ad sizes', 'dexignlab'),
		'750 x 100' => esc_html__('750 x 100 - Regional ad sizes', 'dexignlab'),
		'750 x 200' => esc_html__('750 x 200 - Regional ad sizes', 'dexignlab'),
		'750 x 300' => esc_html__('750 x 300 - Regional ad sizes', 'dexignlab'),
		'980 x 120' => esc_html__('980 x 120 - Regional ad sizes', 'dexignlab'),
		'930 x 180' => esc_html__('930 x 180 - Regional ad sizes', 'dexignlab')
	);

	return $adsence_size;
}

/* Social Link Options */
function social_link_options(){
	
	$social_links = array(
	    'facebook' => array(
	        'id' => 'facebook',
	        'title' => 'Facebook',
	    ),
	    'twitter' => array(
	        'id' => 'twitter',
	        'title' => 'Twitter',
	    ),
	    'linkedin' => array(
	        'id' => 'linkedin',
	        'title' => 'Linkedin',
	    ),
	    'instagram' => array(
	        'id' => 'instagram',
	        'title' => 'Instagram',
	    ),
	    'google' => array(
	        'id' => 'google',
	        'title' => 'Google',
	    ),
	    'skype' => array(
	        'id' => 'skype',
	        'title' => 'Skype',
	    ),
	    'pinterest' => array(
	        'id' => 'pinterest',
	        'title' => 'Pinterest',
	    ),
	    'vimeo' => array(
	        'id' => 'vimeo',
	        'title' => 'Vimeo',
	    ),
	    'youtube' => array(
	        'id' => 'youtube',
	        'title' => 'Youtube',
	    ),
	    'tumblr' => array(
	        'id' => 'tumblr',
	        'title' => 'Tumblr',
	    ),
	    'rss' => array(
	        'id' => 'rss',
	        'title' => 'Rss',
	    ),
	    'yelp' => array(
	        'id' => 'yelp',
	        'title' => 'Yelp',
	    ),
	    'tripadvisor' => array(
	        'id' => 'tripadvisor',
	        'title' => 'Tripadvisor',
	    )
	);

	return $social_links;
}