<?php
include_once( 'helpers/functions.php' );
class Dexignzone_DZ_Base extends Dexignzone_DZ_Functions
{
	public $path = '';
	public $url = '';
	public $inc = '';
	public $inc_url = '';
	public $page_settings;
	function __construct()
	{
		$this->path = get_template_directory().'/';
		$this->url = get_template_directory_uri().'/';
		$this->inc = $this->path.'includes/';
		$this->inc_url = $this->url.'includes/';
		parent::__construct();
	}
	function __set_attrib( $attr = array() )
	{
		$res = ' ';
		foreach( $attr as $k => $v )
		{
			$res .= $k.'="'.$v.'" ';
		}
		return $res;
	}
	
	function option( $key = '' )
	{
		$theme_options = get_option( DZ_TH_DOMAIN.'_theme_options' );
		
		if( $key ) return dz_set( $theme_options, $key );
		
		return $theme_options;
	}
	
	function includes( $path = '', $url = false )
	{
		$child = get_stylesheet_directory().'/';
		if( file_exists( $child.$path ) ) {
			if( $url ) return get_stylesheet_directory_uri().'/'.$path;
			else return $child.$path;
		}
		
		if( $url ) return get_template_directory_uri().'/'.$path;
		else return $this->path.$path;
	}
	
	function get_meta( $key = '', $id = '' )
	{
		global $post, $post_type;
		$post_type = $post->post_type;
		
		$id = ( $id ) ? $id : dz_set( $post, 'ID' );
		
		$key = ( $key ) ? $key : '_dz_'.$post_type.'_settings';
		$meta = get_post_meta( $id, $key, true );
		
		return ( $meta ) ? $meta : false;
	}
	
	function set_meta_key( $post_type )
	{
		if( ! $post_type ) return;
		
		return '_dz_'.$post_type.'_settings';
		
	}
	
	function get_term_meta( $key = '' )
	{
		$object = get_queried_object();		
		$key = ( $key ) ? $key.$object->term_id : '_dz_'.$object->taxonomy.'_settings'.$object->term_id;
		$meta = get_option( $key );
		
		return ( $meta ) ? $meta : false;
	}
	
	function set_term_key( $post_type )
	{
		if( ! $post_type ) return;
		
		return '_dz_'.$post_type.'_settings';
		
	}
	
	function page_template( $tpl )
	{
		$page = get_pages(array('meta_key' => '_wp_page_template','meta_value' => $tpl));
		if($page) return current( (array)$page);
		else return false;
	}
	
	function user_extra( $extras = array() )
	{
		$this->extras = $extras;
		
		add_filter('user_contactmethods', array( $this, 'newuserfilter' ) );
		
	}
	function newuserfilter($old)
	{
		$array = $this->extras;
		
		$new = array_merge($array, $old);
		return $new;
	}
	
	function first_last( $current, $cols )
	{
		$current++;
		if( $current == 1 ) return ' first';
		else if( (( $current ) % $cols ) == 0 ) return ' last';
		else if( ( ( $current - 1 ) % $cols ) == 0 ) return ' first';
	}

	/**
	 * Get theme option based on its id.
	 *
	 * @param  string $opt_id Required. the option id.
	 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
	 *                         If not set, false will be used
	 *
	 * @return mixed
	 */
	function dexignlab_get_opt( $opt_id, $default = false ) {
		$opt_name = dexignlab_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}

		global ${$opt_name};
		if ( ! isset( ${$opt_name} ) || ! isset( ${$opt_name}[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || $options[ $opt_id ] === '' ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && $value === '' ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}

	/**
	 * Get theme option based on its id.
	 *
	 * @param  string $opt_id Required. the option id.
	 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
	 *                         If not set, false will be used
	 *
	 * @return mixed
	 */
	function dexignlab_get_page_opt( $opt_id, $default = false ) {
		$page_opt_name = dexignlab_get_page_opt_name();
		if ( empty( $page_opt_name ) ) {
			return $default;
		}
		$id = get_the_ID();
		if ( ! is_archive() && is_home() ) {
			if ( ! is_front_page() ) {
				$page_for_posts = get_option( 'page_for_posts' );
				$id             = $page_for_posts;
			}
		}

		return $options = ! empty($id) ? get_post_meta( intval( $id ), $opt_id, true ) : $default;
	}

	/**
	 * Get theme option based on its id.
	 *
	 * @param  string $opt_id Required. the option id.
	 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
	 *                         If not set, false will be used
	 *
	 * @return mixed
	 */
	function dexignlab_get_post_opt( $opt_id, $default = false ) {
		$post_opt_name = dexignlab_get_post_opt_name();
		if ( empty( $post_opt_name ) ) {
			return $default;
		}
		$id = get_the_ID();
		if ( ! is_archive() && is_home() ) {
			if ( ! is_front_page() ) {
				$page_for_posts = get_option( 'page_for_posts' );
				$id             = $page_for_posts;
			}
		}

		return $options = ! empty($id) ? get_post_meta( intval( $id ), $opt_id, true ) : $default;
	}

	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function dexignlab_get_opt_name() {
		return apply_filters( 'dexignlab_opt_name', 'dsx_theme_options' );
	}


	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function dexignlab_get_page_opt_name() {
		return apply_filters( 'dexignlab_page_opt_name', 'dsx_page_options' );
	}

	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function dexignlab_get_post_opt_name() {
		return apply_filters( 'dexignlab_post_opt_name', 'dz_post_options' );
	}
}
$GLOBALS['_dz_base'] = new Dexignzone_DZ_Base;