<?php 
$bg_img = $team_slider_1_element_bg_img;

$query_args = array(
	'post_type' => 'dz_team',
	'post_status' => 'publish',
	'posts_per_page'    => $team_slider_1_element_no_of_posts,
	'orderby' => $team_slider_1_element_orderby,
	'order' => $team_slider_1_element_order,
	'ignore_sticky_posts' => true,
);



if (!empty($team_slider_1_element_posts_in_categories) && !empty($team_slider_1_element_posts_in_categories[0])) {

	$team_slider_1_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($team_slider_1_element_posts_in_categories, 'team_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'team_category',
		'field' => 'id',
		'terms' => $team_slider_1_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$element_content = !empty($team_slider_1_element_content) ? $team_slider_1_element_content : 'content-inner'; 
$content_text_limit = $team_slider_1_element_text_limit;
$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {

?>
<section class="<?php echo esc_attr($element_content); ?>" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-position: right top; background-repeat: no-repeat; background-size: 100%;"<?php } ?>>
	<div class="container">
		<div class="row align-items-center">
			<div class="col-xl-6 order-xl-1 m-b30">
				<?php if(!empty($team_slider_1_element_title) || !empty($team_slider_1_element_description)){ ?>
				<div class="section-head style-3">
					<?php if(!empty($team_slider_1_element_title)){ ?>
						<h2 class="title"><?php echo esc_html($team_slider_1_element_title); ?></h2>
					<?php } 
					if(!empty($team_slider_1_element_description)){ ?>
						<p class="m-b0"><?php echo wp_kses($team_slider_1_element_description,'string'); ?></p>
					<?php } ?>
				</div>
				<?php } ?>
				<div class="swiper dz-team-swiper1-thumb">
					<div class="swiper-wrapper">
						<?php
							
							while ($query->have_posts()) {
								$query->the_post();
								global $post;
								$post_id = $post->ID;
								$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
								$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
								$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
								$team_social_data = clinicmaster_get_team_social_link($post_id);
								
							?>
							<div class="swiper-slide">
								<div class="dz-team style-3">
									<div class="dz-body">
										<?php if (has_post_thumbnail()) { ?>
										<div class="dz-media">
											<?php echo the_post_thumbnail('full'); ?>
										</div>
										<?php } ?>
										<div class="dz-content">
											<h3 class="dz-name"><a href="<?php  echo esc_url(get_the_permalink($post)); ?>"><?php echo esc_html($post_title); ?></a></h3>
											<?php if(!empty($designation)){ ?>
											<span class="dz-position"><?php echo esc_html($designation); ?></span>
											<?php } ?>
										</div>
									</div>
									<div class="dz-footer">
									
										<?php  if(!empty($team_social_data['any_fill'] )){ ?>
											<ul class="dz-social">
											
												<?php foreach($team_social_data['data'] as $key => $value) {
													
													if(!empty($value['url'])){
												?>
													<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
												<?php }
													}
												?>	
											</ul>
										<?php } ?>
										
									</div>
								</div>
							</div>
							<?php } ?>
						
					</div>
				</div>
			</div>
			<div class="col-xl-6">
				<div class="swiper dz-team-swiper1 me-md-4">
					<div class="swiper-wrapper">
						<?php
						$data = array(
								'team_social_facebook' => 'facebook',
								'team_social_twitter' => 'x-twitter',
								'team_social_instagram' => 'instagram',
								'team_social_linkdin' => 'linkedin',
								'team_social_youtube' => 'youtube',
								);
							while ($query->have_posts()) {
								$query->the_post();
								global $post;
								$post_id = $post->ID;
								$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
								$short_description = clinicmaster_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
								$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
								$skils = clinicmaster_get_post_meta(get_the_id(), 'genaral_skils');
								$team_social_data = clinicmaster_get_team_social_link($post_id);
							?>
						<div class="swiper-slide">
							<div class="dz-team style-4">
								<?php if (has_post_thumbnail()) { ?>
										<div class="dz-media">
											<?php echo the_post_thumbnail('full'); ?>
										</div>
										<?php } ?>
								<?php  if(!empty($team_social_data['any_fill'] )){ ?>
									<ul class="dz-social">
									
										<?php foreach($team_social_data['data'] as $key => $value) {
											$data_class = $data[$value['key']];
											if(!empty($value['url'])){
										?>
											<li><a href="<?php echo esc_url($value['url']); ?>"  class="<?php echo esc_attr($data_class); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
										<?php }
											}
										?>	
									</ul>
								<?php } ?>
								<?php if(!empty($skils)){ 
								$item = explode(',', $skils);
								?>
								<div class="item1">
									<ul class="list-check-try fw-medium text-secondary">
										<?php foreach($item as $val){ ?>
										<li><?php echo esc_html($val); ?></li>
										<?php } ?>
									</ul>
								</div>
								<?php } ?>
								<div class="item2">
									<div class="info-widget style-3">
										<div class="widget-head">
											<?php if (has_post_thumbnail()) { ?>
												<div class="widget-media">
													<?php echo the_post_thumbnail('full'); ?>
												</div>
											<?php } ?>
											<div class="widget-content">
													<h6 class="dz-name"><?php echo esc_html($post_title); ?></h6>
											<?php if(!empty($designation)){ ?>
											<span class="sub-title text-primary"><?php echo esc_html($designation); ?></span>
											<?php } ?>
											</div>
										</div>
										<?php if(!empty($short_description)){ ?>
										<p><?php echo esc_html($short_description); ?></p>
										<?php } ?>
									</div>
								</div>
							</div>	
						</div>
						<?php } ?>
					</div>
					<div class="slider__pagination team-pagination-swiper team-pagination-wrapper m-t5">
						<div class="swiper-button team-swiper-prev btn btn-light btn-square radius-sm">
							<i class="feather icon-arrow-left"></i>
						</div>
						<div class="slider__current team-slider__current">1</div>
						<div class="swiper-progress team-progressbar-swiper"></div>
						<div class="slider__total team-slider__total">1</div>
						<div class="swiper-button team-swiper-next btn btn-light btn-square radius-sm">
							<i class="feather icon-arrow-right"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php } ?>