<?php
$blog_view = "team_listing_1";
$page_no = 1;
$post_type = 'dz_team';

$query_args = array(
	'post_type' 		=> $post_type,
	'post_status' 		=> 'publish',
	'posts_per_page'   	=> $team_listing_1_element_no_of_posts,
	'order' 			=> $team_listing_1_element_order,
	'ignore_sticky_posts' => true,
);

if ($team_listing_1_element_orderby == 'views_count') {
	$query_args['meta_key']	= '_views_count';
} else {
	$query_args['orderby']	= $team_listing_1_element_orderby;
}


if (!empty($team_listing_1_element_posts_in_categories) && !empty($team_listing_1_element_posts_in_categories[0])) {

	$team_listing_1_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($team_listing_1_element_posts_in_categories, 'team_category');

	$query_args['tax_query'][] = array(
		'taxonomy' 	=> 'team_category',
		'field' 	=> 'id',
		'terms' 	=> $team_listing_1_element_posts_in_categories1,
		'operator' 	=> 'IN'
	);

	$team_listing_1_element_posts_in_categories = implode(',', $team_listing_1_element_posts_in_categories);
}


if ($team_listing_1_element_only_featured_posts == 'yes') {
	$query_args['meta_key'] 	= 'featured_post';
	$query_args['meta_value'] 	= 1;
	$query_args['meta_compare'] = 'LIKE';
}

$query = new WP_Query($query_args);

$blog_view_container = '';
if ($team_listing_1_element_pagination_style == 'load_more') {
	$blog_view_container = $blog_view . "_LoadMoreContainer";
}

$style = !empty($team_listing_1_element_style) ? $team_listing_1_element_style :'style_1';
$class_color = ($style == 'style_2') ? 'bg-light gradient-bottom-light' :'';
$element_content = !empty($team_listing_1_element_content) ? $team_listing_1_element_content : 'content-inner';

global $clinicmaster_query_result;
$clinicmaster_query_result['posts'] = $query->posts;
$clinicmaster_query_result['posts_per_page'] = $team_listing_1_element_no_of_posts;
$clinicmaster_query_result['current_page'] = $page_no;
$clinicmaster_query_result['title_text_limit'] = $team_listing_1_element_text_limit;
$clinicmaster_query_result['blog_view_container'] = $blog_view_container;
$clinicmaster_query_result['element_style'] = $style;

$max_num_pages = $query->max_num_pages;	
if ($query->have_posts()) {
?>	
	<section class="<?php echo esc_attr($element_content .' '. $class_color); ?>">
		<div class="container">
			
			<div class="section-head style-1 text-center">
				<?php if(!empty($team_listing_1_element_subtitle)){ ?>
					<span class="sub-title text-primary sub-title-icon">
						<?php if(!empty($team_listing_1_element_icon_img['id'])){ ?>
							<img src="<?php echo esc_url($team_listing_1_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
						<?php } ?>
						<?php echo esc_html($team_listing_1_element_subtitle); ?>
					</span>
				<?php } ?>
				<?php if(!empty($team_listing_1_element_title)){ ?>
				<h2 class="title m-b10"><?php echo wp_kses($team_listing_1_element_title, clinicmaster_allowed_html_tag()); ?></h2>
				<?php }  ?>
			</div>

			<div <?php if (!empty($blog_view_container)) { ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?> class="row ">
				<?php get_template_part('dz-inc/elementor/ajax/team_listing_1_ajax'); ?>
				
			</div>
			<?php
			if ($team_listing_1_element_pagination_style == 'load_more') {
				$blog_view_btn = $blog_view . "_LoadMoreBtn";
				$blog_view_container = $blog_view . "_LoadMoreContainer";

				if (1 < $max_num_pages) {
			?>
					<!-- Pagination start -->
					<div class="reload-btn text-center mb-4">
						<a href="javascript:void(0);" class="btn btn-lg btn-icon btn-primary loadmore-btn dz-load-more" 
						id="<?php echo esc_attr($blog_view_btn); ?>" 
						data-ajax-container="<?php echo esc_js($blog_view_container); ?>" 
						data-post-type="<?php echo esc_js($post_type); ?>" 
						data-blog-view="<?php echo esc_js($blog_view); ?>" 
						data-max-num-pages="<?php echo esc_js($max_num_pages); ?>" 
						data-posts-per-page="<?php echo esc_js($team_listing_1_element_no_of_posts); ?>" 
						data-only-featured-post="<?php echo esc_js($team_listing_1_element_only_featured_posts) ?>" 
						data-post-order="<?php echo esc_js($team_listing_1_element_order) ?>" 
						data-image-preference="" 
						data-show-column=""
						data-element-style=="<?php echo esc_js($style) ?>" 
						data-post-order-by="<?php echo esc_js($team_listing_1_element_orderby) ?>" 
						data-posts-in-categories="<?php echo esc_js($team_listing_1_element_posts_in_categories); ?>" 
						data-title-text-limit="<?php echo esc_js($team_listing_1_element_text_limit); ?>" >
							<?php echo esc_html__('Load More', 'clinicmaster'); ?>
							<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
						</a>
					</div>
					<!-- Pagination End -->
			<?php
				}
			}
			?>
		</div>
	</section>
<?php 
wp_enqueue_style('team', get_template_directory_uri() . '/assets/css/team.css');

} ?>