<?php
$blog_view = "product_listing_1";
$page_no = 1;
$post_type = 'product';
$query_args = array(
	'post_type'         => $post_type,
	'post_status'       => 'publish',
	'posts_per_page'    => $product_listing_1_element_no_of_posts,
	'order'             => $product_listing_1_element_order,
	'orderby'           => $product_listing_1_element_orderby,
	'ignore_sticky_posts' => true,
	
);


$product_listing_1_element_image_preference = !empty($product_listing_1_element_image_preference) ? $product_listing_1_element_image_preference : 'all_posts';

if ($product_listing_1_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' 		=> '_thumbnail_id',
			'compare' 	=> 'EXISTS'
		),
	);
} elseif ($product_listing_1_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' 		=> '_thumbnail_id',
			'compare' 	=> 'Not EXISTS'
		),
	);
}



if (!empty($product_listing_1_element_posts_in_categories) && !empty($product_listing_1_element_posts_in_categories[0])) {

	$query_args['tax_query'][] = array(
		'taxonomy' => 'product_cat',
		'field' => 'slug',
		'terms' => $product_listing_1_element_posts_in_categories,
		'operator' => 'IN',
	);
	$product_listing_1_element_posts_in_categories = implode(',', $product_listing_1_element_posts_in_categories);
} else {
	$product_listing_1_element_posts_in_categories = '';
}


$category_arr = array();
if (!empty($product_listing_1_element_posts_in_categories)) {
	$cat_ids = clinicmaster_get_cat_id_by_slug($product_listing_1_element_posts_in_categories, 'product_cat');
	$cat_ids_comma_seperated = implode(',', $cat_ids);
	$category_arr = get_terms(array(
		'taxonomy'    => 'product_cat',
		'include'     => $cat_ids_comma_seperated,
		'hide_empty'  => false, /* Not return that didn't have any post in it's category */
		'orderby'     => 'include',
		'order'       => $product_listing_1_element_order,
	));
}
$query = new WP_Query($query_args);

$blog_view_container = '';
if ($product_listing_1_element_pagination_style == 'load_more') {
	$blog_view_container = $blog_view . "_LoadMoreContainer";
}

global $clinicmaster_query_result;
$clinicmaster_query_result['posts'] = $query->posts;
$clinicmaster_query_result['posts_per_page'] = $product_listing_1_element_no_of_posts;
$clinicmaster_query_result['title_text_limit'] = $product_listing_1_element_text_limit;
$clinicmaster_query_result['current_page'] = $page_no;
$clinicmaster_query_result['show_column'] = $product_listing_1_element_cols;
$clinicmaster_query_result['blog_view_container'] = $blog_view_container;
$max_num_pages = $query->max_num_pages;
$element_content = !empty($product_listing_1_element_content) ? $product_listing_1_element_content : 'content-inner';
if ($query->have_posts()) {
	$query->the_post();

?>
	
<section class="<?php echo esc_attr($element_content); ?> bg-light">
	<div class="container">
		<?php if(!empty($product_listing_1_element_title) || !empty($product_listing_1_element_description)){ ?>
			<div class="section-head style-3 m-b30 text-center">
				<?php if(!empty($product_listing_1_element_title)){ ?>
					<h2 class="title"><?php echo wp_kses($product_listing_1_element_title, clinicmaster_allowed_html_tag()); ?></h2>
				<?php } ?>
				<?php if(!empty($product_listing_1_element_description)){ ?>
					<p><?php echo wp_kses($product_listing_1_element_description, 'string'); ?></p>
				<?php } ?>
			</div>
		<?php } ?>
		<?php if (!empty($category_arr) && (!empty($product_listing_1_element_category) && ($product_listing_1_element_category == 'yes'))) { ?>
		<div class="site-filters clearfix style-1">
			<ul class="filters justify-content-center" data-bs-toggle="buttons">
				<li class="active">
					<input type="radio">
					<a class="btn" href="javascript:void(0);"><?php echo esc_html__('All Products', 'clinicmaster'); ?></a>
				</li>
				<?php foreach ($category_arr as $cat_data){ ?>
					<li data-filter="<?php echo '.data-' . esc_attr($cat_data->slug).' '; ?>" >
						<input type="radio">
						<a class="btn" href="javascript:void(0);"><?php echo esc_html($cat_data->name); ?> </a>
					</li>
				<?php } ?>	
			</ul>			
		</div>
		<?php } ?>
		<div class="clearfix">
			<ul class="masonry row" <?php if (!empty($blog_view_container)) { ?> id="<?php echo esc_attr($blog_view_container) ?>" <?php } ?>>
				<?php get_template_part('dz-inc/elementor/ajax/product_listing_1_ajax'); ?>
			</ul>
		</div>
		<?php
			if ($product_listing_1_element_pagination_style == 'load_more') {
				$blog_view_btn = $blog_view . "_LoadMoreBtn";
				$blog_view_container = $blog_view . "_LoadMoreContainer";

				if (1 < $max_num_pages) {

			?>
					<!-- Pagination start -->
					<div class="reload-btn col-12 text-center">
						<a href="javascript:void(0);" class="btn btn-lg btn-icon btn-primary loadmore-btn dz-load-more" id="<?php echo esc_attr($blog_view_btn); ?>" data-ajax-container="<?php echo esc_js($blog_view_container); ?>" data-post-type="<?php echo esc_js($post_type); ?>" data-blog-view="<?php echo esc_js($blog_view); ?>" data-max-num-pages="<?php echo esc_js($max_num_pages); ?>" data-posts-per-page="<?php echo esc_js($product_listing_1_element_no_of_posts); ?>" data-post-order="<?php echo esc_js($product_listing_1_element_order) ?>" data-post-order-by="<?php echo esc_js($product_listing_1_element_orderby) ?>" data-show-column="<?php echo esc_js($product_listing_1_element_cols); ?>" data-image-preference="<?php echo esc_js($product_listing_1_element_image_preference); ?>" data-title-text-limit="<?php echo esc_js($product_listing_1_element_text_limit); ?>" data-posts-in-categories="<?php echo esc_js($product_listing_1_element_posts_in_categories); ?>">
							<?php echo esc_html__('Load More', 'clinicmaster'); ?>
							<span class="right-icon dz-load"><i class="feather icon-refresh-ccw"></i></span>
						</a>
					</div>
					<!-- Pagination End -->
			<?php
				}
			}
		?>
				
	</div>
</section>
<?php } ?>