<?php


$query_args = array(
	'post_type'         => 'post',
	'post_status'       => 'publish',
	'posts_per_page'    => $post_slider_1_element_no_of_posts,
	'orderby'           => $post_slider_1_element_orderby,
	'order'             => $post_slider_1_element_order,
	'ignore_sticky_posts' => true,
);

$post_slider_1_element_image_preference = !empty($post_slider_1_element_image_preference) ? $post_slider_1_element_image_preference : 'all_posts';

if ($post_slider_1_element_image_preference == 'image_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'EXISTS'
		),
	);
} elseif ($post_slider_1_element_image_preference == 'text_post_only') {
	$query_args['meta_query'] = array(
		array(
			'key' => '_thumbnail_id',
			'compare' => 'Not EXISTS'
		),
	);
}

if ($post_slider_1_element_only_featured_posts == 'true') {
	$query_args['meta_key'] = 'featured_post';
	$query_args['meta_value'] = 1;
	$query_args['meta_compare'] = 'LIKE';
}
if (!empty($post_slider_1_element_posts_in_categories) && !empty($post_slider_1_element_posts_in_categories[0])) {

	$post_slider_1_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($post_slider_1_element_posts_in_categories, 'category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'category',
		'field' => 'id',
		'terms' => $post_slider_1_element_posts_in_categories1,
		'operator' => 'IN'
	);
}

$query = new WP_Query($query_args);

if ($query->have_posts()) {


?>
<section class="content-inner bg-light">
	<div class="container">
		<div class="section-head style-1 m-b30 row align-items-end">
		<?php if(!empty($post_slider_1_element_title)){ ?>
			<div class="col-md-7">
				<h2 class="title m-b0"><?php echo wp_kses($post_slider_1_element_title, clinicmaster_allowed_html_tag()); ?></h2>
			</div>
		<?php } ?>
		<?php if(!empty($post_slider_1_element_btn_text) && !empty($post_slider_1_element_link['url'])){ ?>
			<div class="col-md-5 text-sm-end d-md-block d-none">
				<a href="<?php echo esc_url($post_slider_1_element_link['url']); ?>" class="btn btn-icon btn-primary btn-shadow">
					<?php echo esc_html($post_slider_1_element_btn_text); ?>
					<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
				</a>
			</div>
		<?php } ?>
		</div>
		<div class="row content-wrapper style-15">
			<div class="col-lg-5 m-b30">
				<div class="swiper blog-vertical-swiper content-media">
					<div class="swiper-wrapper">
						<?php
							while ($query->have_posts()) {
								$query->the_post();
								global $post;
								if (has_post_thumbnail()) { ?>
									<div class="swiper-slide">
										<div class="dz-media radius-md">
										<?php the_post_thumbnail('clinicmaster_600x600'); ?>
										</div>
									</div>
								<?php } 
							} ?>
					</div>
				</div>
			</div>
			<div class="col-lg-7 m-b30">
				<div class="swiper blog-vertical-swiper-thumb content-info">
					<div class="swiper-wrapper">
						<?php
							while ($query->have_posts()) {
								$query->the_post();
								global $post;
								$post_id = $post->ID;
								$content_text_limit = $post_slider_1_element_text_limit;
								$post_title = clinicmaster_trim(get_the_title(), $content_text_limit);

								$excerpt = get_the_excerpt();
								$content = get_the_content();
								$short_description = clinicmaster_short_description($excerpt, $content, $post_slider_1_element_desc_limit);

						?>
						<div class="swiper-slide">
							<div class="dz-card style-3 blog-half">
								<div class="dz-info">
									
									<div class="dz-meta">
										<ul>
											<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
										</ul>
									</div>
									
									<?php if(!empty($post_title)){ ?>
										<h3 class="dz-title">
											<a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html($post_title); ?></a>
										</h3>
									<?php } ?>
									<?php if(!empty($short_description)){ ?>
										<p><?php echo esc_html($short_description); ?></p>
									<?php } ?>
								</div>
								<?php if (has_post_thumbnail()) { ?>
									<div class="dz-media">
										<?php
										the_post_thumbnail('medium');
										?>
									</div>
								<?php } ?>
								
							</div>
						</div>
						<?php } ?>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php }
