<?php 

$category_arr = array();
if (!empty($faq_listing_2_element_posts_in_categories) || !empty($faq_listing_2_element_posts_in_categories[0])) {

	$cat_ids = clinicmaster_get_cat_id_by_slug($faq_listing_2_element_posts_in_categories, 'faq_category');

	$cat_ids_comma_seperated = implode(',', $cat_ids);

	$category_arr = get_terms(array(
		'taxonomy'    => 'faq_category',
		'include'     => $cat_ids_comma_seperated,
		'hide_empty'  => false, /* Not return that didn't have any post in it's category */
		'orderby'     => 'include',
		'order'       => $faq_listing_2_element_order,
	));
}

?>


<section class="content-inner-1">
	<div class="container">
		<?php if(!empty($faq_listing_2_element_title) || !empty($faq_listing_2_element_description)){ ?>
		<div class="section-head style-1 m-b30 text-center">
			<?php if(!empty($faq_listing_2_element_title)){ ?>
				<h2 class="title"><?php echo esc_html($faq_listing_2_element_title); ?></h2>
			<?php }
			if(!empty($faq_listing_2_element_description)){ ?>	
				<p><?php echo wp_kses($faq_listing_2_element_description,'string'); ?></p>
			<?php } ?>
		</div>
		<?php } ?>
		<div class="row justify-content-center">
			<?php if(!empty($faq_listing_2_element_search) && ($faq_listing_2_element_search == 'yes')){ ?>
			<div class="col-xl-6 col-lg-8 m-b40">
				<div class="search_widget faq-head">
					<form class="dzSearch">
						<div class="form-group">
							<div class="input-group mb-0">
								<input name="dzSearch" type="search" class="form-control dz-search-input" placeholder="Type your question here">
								<div class="input-group-addon">
									<button name="dzSearch" value="search" class="btn ">
										<i class="icon feather icon-search"></i>
										<span class="spinner-border search-icon text-primary w-50 h-50" role="status"></span>
									</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
			<?php } ?>
			<div class="col-xl-10">
				<ul class="nav nav-pills nav-pills-outline m-b50 justify-content-center" id="pills-tab" role="tablist">
				
					<?php $count = 1;
						if (!empty($category_arr)) {

							foreach ($category_arr as $type) {
								$meta = get_term_meta($type->term_id);
								$active = $count == 1 ? 'active' : '';


						?>
								
					<li class="nav-item" role="presentation">
						<button class="nav-link outline  <?php echo esc_attr($active) ?>" id="<?php echo esc_attr($type->slug . '-pill') ?>" data-bs-toggle="pill" data-bs-target="#<?php echo esc_attr($type->slug) ?>" type="button" role="tab" aria-controls="<?php echo esc_attr($type->slug) ?>" aria-selected="true"><?php echo esc_html($type->name);  ?></button>
					</li>
						<?php
								$count++;
							}
						} ?>
					
				</ul>
				<div class="tab-content dz-search-item" id="pills-tabContent">
					<?php if (!empty($category_arr)) {
					$cat_count = 1;
					foreach ($category_arr as $cat) {


					$active = ($cat_count == 1) ? 'active show' : '';
					
					?>
					<div class="tab-pane fade <?php echo esc_attr($active) ?>" id="<?php echo esc_attr($cat->slug) ?>" role="tabpanel" aria-labelledby="<?php echo esc_attr($cat->slug . '-pill') ?>" tabindex="0">
						<div class="accordion dz-accordion style-1" id="accordionExample<?php echo esc_attr($cat_count); ?>">
								<?php
									$post_type = 'dz_faq';
									$query_args = array(
										'post_type'         => $post_type,
										'post_status'       => 'publish',
										'posts_per_page'    => $faq_listing_2_element_no_of_posts,
										'order'             => $faq_listing_2_element_order,
										'orderby'           => $faq_listing_2_element_orderby,
										'ignore_sticky_posts' => true,
									);

									$query_args['tax_query'][] = array(
										'taxonomy' => 'faq_category',
										'field' => 'slug',
										'terms' => array(0 => $cat->slug),
										'include_children' => true,
										'operator' => 'IN',

									);
									$query = new WP_Query($query_args);
								if($query->have_posts()) {
							
									$num = $cat_count;
									while($query->have_posts())
									{ 	
										$query->the_post();
										global $post ;
										$post_id  = $post->ID;
										$post_title =  clinicmaster_trim($post->post_title, 8);
										$excerpt = $post->post_excerpt;
										$content = $post->post_content;
										$short_description = clinicmaster_short_description($excerpt, $content, $faq_listing_2_element_text_limit);
											$active = ($num == 1) ? 'show' :'';
											$collapsed = ($num > 1) ? 'collapsed' :'';
										  ?>
											<div class="accordion-item ">
											<?php if(!empty($post_title)){ ?>
												<h2 class="accordion-header">
													<button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo esc_attr($num); ?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($num); ?>">
														<?php echo esc_html($post_title); ?>
													</button>
												</h2>
											<?php } 
											if(!empty($short_description)){ ?>
												<div id="collapseOne<?php echo esc_attr($num); ?>" class="accordion-collapse collapse  <?php echo esc_attr($active); ?>" data-bs-parent="#accordionExample">
													<div class="accordion-body">
														<p><?php echo wp_kses($short_description, 'string'); ?></p>
													</div>
												</div>
											<?php } ?>
											
											</div>
										<?php $num++;
									} 
								}
							?>
						</div>
					</div>
					<?php  $cat_count++;
					}
						
					} ?>
				</div>
			</div>
		</div>
	</div>
</section>