<?php 
$element_content = !empty($contact_box_7_element_content) ? $contact_box_7_element_content : 'content-inner';
$bg_img = $contact_box_7_element_bg_image;
?>

<section class="<?php echo esc_attr($element_content); ?>" <?php if(!empty($bg_img['id'])){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>); background-repeat: no-repeat; background-position: right center; background-size: cover;"<?php } ?>>
	<div class="container">
		<?php if(!empty($contact_box_7_element_title) || !empty($contact_box_7_element_subtitle)){ ?>
		<div class="section-head style-1 text-center m-b30">
			<?php if(!empty($contact_box_7_element_subtitle)){ ?>
				<span class="sub-title text-primary sub-title-icon">
					<?php if(!empty($contact_box_7_element_icon_img['id'])){ ?>
						<img src="<?php echo esc_url($contact_box_7_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
					<?php } ?>
					<?php echo esc_html($contact_box_7_element_subtitle); ?>
				</span>
			<?php } ?>
			<?php if(!empty($contact_box_7_element_title)){ ?>
				<h2 class="title m-b0 wow fadeInUp" data-wow-delay="0.2s" data-wow-duration="0.8s"><?php echo esc_html($contact_box_7_element_title); ?></h2>
			<?php } ?>
		</div>
		<?php } ?>
		
		<div class="row justify-content-center content-wrapper style-3">
			<?php foreach($contact_box_7_element_item as $val){
			$title = $val['contact_box_7_element_item_title'];
			$desc = $val['contact_box_7_element_item_desc'];
			$img = $val['contact_box_7_element_item_img'];
			?>
			<div class="col-md-4 col-sm-6">
				<div class="icon-bx-wraper style-11 m-b20 text-center">
					<div class="icon-bx">
						<span class="icon-cell">
							<?php if(!empty($img['id'])){ ?>
							<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr__('Icon Image', 'clinicmaster'); ?>" />
							<?php } ?>
						</span>
					</div>
					<div class="icon-content">
						<?php
						if(!empty($title)){ ?>
							<h3 class="title m-b10"><?php echo esc_html($title); ?></h3>
						<?php } 
						if(!empty($desc)){ ?>
							<p><?php echo esc_html($desc); ?><p>
						<?php } ?>
					</div>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>