<?php
$current_page = $GLOBALS['clinicmaster_query_result']['current_page'];
$posts_per_page = $GLOBALS['clinicmaster_query_result']['posts_per_page'];
$side_bar = $GLOBALS['clinicmaster_query_result']['side_bar'];
$show_date = $GLOBALS['clinicmaster_query_result']['show_date'];
$title_text_limit = $GLOBALS['clinicmaster_query_result']['title_text_limit'];
$element_style = $GLOBALS['clinicmaster_query_result']['element_style'];
$current_post_number =  (($current_page * $posts_per_page) - $posts_per_page) + 1;
$blog_view_container = !empty($GLOBALS['clinicmaster_query_result']['blog_view_container']) && $GLOBALS['clinicmaster_query_result']['blog_view_container'];
$posts = $GLOBALS['clinicmaster_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */


foreach ($posts as $post) {
	
	$post_layout = clinicmaster_dzbase()->get_meta('post_layout');
	$post_id  = $post->ID;
	$post_title =  clinicmaster_trim($post->post_title, $title_text_limit);
	$excerpt = get_the_excerpt();
	$content = get_the_content();
	$short_description = clinicmaster_short_description($excerpt, $content, 24, '.');
	/* implement post layout icons on listing post */
	$post_setting = get_post_meta($post_id, '_post_settings', true);
	$author_name = get_the_author_meta('display_name', $post->post_author);

	$is_featured_post = isset($post_setting['is_featured_post']) ? $post_setting['is_featured_post'] : 0;


	$views_arr = get_post_meta($post_id, '_views_count');
	$views = (isset($views_arr[0])) ? $views_arr[0] : 0;

	$no_image_class = (!has_post_thumbnail()) ? 'no-image-box' : '';
	$media_class = ($post_layout == 'video_post') ? 'video-bx style-2 overlay-black-light' : '';
	$post_type_video	= clinicmaster_dzbase()->get_meta('post_type_video');

	if($element_style == 'style_1'){ ?>
		<div id="post-<?php the_ID(); ?>" <?php echo post_class('dz-card style-2 blog-half m-b35'); ?>>
			<?php if(has_post_thumbnail()) { ?>
				<div class="dz-media">
					<?php the_post_thumbnail('medium'); ?>
				</div>
			<?php } ?>
			<div class="dz-info">
				<div class="dz-meta">
					<ul>
						<?php if (!empty($show_date)) { ?>
							<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
						<?php } ?>
						<li class="post-author">
							<?php echo esc_html__('By ', 'clinicmaster'); ?> <a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>"><?php echo esc_html($author_name); ?></a>
						</li>
						<li class="post-comments"><?php comments_number( '0 COMMENT', '1 COMMENT', '% COMMENTS' ); ?></li>
					</ul>
				</div>
				<?php if(!empty($post_title)){ ?>
					<h3 class="dz-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo wp_kses($post_title, clinicmaster_allowed_html_tag()); ?></a></h3>
				<?php }
				if(!empty($short_description)){ ?>
					<p><?php echo esc_html($short_description); ?></p>
				<?php } ?>
				<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-primary btn-rounded btn-hover2 btn-shadow">
					<?php echo esc_html__('Read More','clinicmaster'); ?>
					<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
				</a>
			</div>
		</div>
<?php }elseif($element_style == 'style_2'){ ?>
<div id="post-<?php the_ID(); ?>" <?php echo post_class('col-xl-12 col-md-12 m-b30'); ?>>
	<div class="dz-card style-4 blog-half">
		<?php if(has_post_thumbnail()) { ?>
			<div class="dz-media">
				<?php the_post_thumbnail('medium'); ?>
			</div>
		<?php } ?>
		<div class="dz-info">
			<div class="dz-meta">
				<ul>
					<?php if (!empty($show_date)) { ?>
						<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
					<?php } ?>
					<li class="post-author"><?php echo esc_html__('By ', 'clinicmaster'); ?> <a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>"><?php echo esc_html($author_name); ?></a></li>
				</ul>
			</div>
				<?php if(!empty($post_title)){ ?>
					<h3 class="dz-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo wp_kses($post_title, clinicmaster_allowed_html_tag()); ?></a></h3>
				<?php }
				if(!empty($short_description)){ ?>
					<p><?php echo esc_html($short_description); ?></p>
				<?php } ?>
			
			<a href="<?php echo esc_url(get_permalink()); ?>" class="btn-link icon-link-hover-end">
				<?php echo esc_html__('Read More','clinicmaster'); ?> <i class="feather icon-arrow-right"></i>
			</a>
		</div>
	</div>
</div>

<?php }elseif($element_style == 'style_3'){ ?>
<div id="post-<?php the_ID(); ?>" <?php echo post_class('col-12 m-b30'); ?>>
	<div class="dz-card style-1 blog-half blog-half-2">
		<?php if(has_post_thumbnail()) { ?>
			<div class="dz-media">
				<?php the_post_thumbnail('medium'); ?>
			</div>
		<?php } ?>
		<div class="dz-info">
			<?php if(!empty($post_title)){ ?>
				<h3 class="dz-title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo wp_kses($post_title, clinicmaster_allowed_html_tag()); ?></a></h3>
			<?php }
			if(!empty($short_description)){ ?>
				<p><?php echo esc_html($short_description); ?></p>
			<?php } ?>
			<div class="info-bottom">
				<div class="dz-meta">
					<ul>
					<?php if (!empty($show_date)) { ?>
						<li class="post-date"><?php echo esc_html(get_the_date()); ?></li>
					<?php } ?>
					<li class="post-author"><?php echo esc_html__('By ', 'clinicmaster'); ?> <a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>"><?php echo esc_html($author_name); ?></a></li>
					</ul>
				</div>
				<a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-square btn-secondary rounded-circle">
					<i class="feather icon-arrow-up-right"></i>
				</a>
			</div>
		</div>
	</div>
</div>

<?php }
	
}
wp_reset_postdata();
?>