<?php

$theme = wp_get_theme();
$theme_name = $theme->name;
require_once( CLINICMASTER_ROOT . 'dz-inc/admin/templates/token_verification.php' );
$verification = new DexignZone_Purchase_Code_Verification();
$verfied_status = $verification->check_theme_activated();


?>

<div class="wrap welcome-wrap dz-wrap">
	<div class="dz-welcome-inner">
		<nav class="dz-nav-tab-wrapper nav-tab-wrapper">
			<a class="nav-tab " href="#">
				<?php echo esc_html__( 'Introduction', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab" href="<?php echo admin_url( 'admin.php?page=dz-plugins' ) ?>">
				<?php echo esc_html__( 'Plugins', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab" href="<?php echo admin_url( 'admin.php?page=dz-system-status' ) ?>">
				<?php echo esc_html__( 'System Status', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab nav-tab-active" href="<?php echo admin_url( 'admin.php?page=dz-theme-verification' ) ?>">
				<?php echo esc_html__( 'Theme Verification', 'clinicmaster' ); ?>
			</a>
			
		</nav>
	</div>
<div class="dz-demo-wrapper ">
	<div class="feature-section theme-browser rendered">
		<div class="dexignzone-envato-registration-form-wrap">
			<?php if( !$verfied_status ){ ?>
			<h3 class="text-center"><?php esc_html_e( "Activate your Licence", "clinicmaster" ); ?></h3>
			<p class="text-center"><?php esc_html_e( "Welcome and thank you for Choosing clinicmaster Theme!
	The clinicmaster theme needs to be activated to enable demo import installation and customer support service.", "clinicmaster" ); ?></p>	
			<a href="<?php echo esc_url( 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-' ); ?>" target="_blank"><?php esc_html_e( "How to find purchase code?", "clinicmaster" ); ?></a>
			<form id="dexignzone-envato-registration-form" class="dexignzone-envato-registration-form" method="post">
				<?php wp_nonce_field( 'clinicmaster_theme_verify^%&^%', 'dexignzone_verify_nonce' ); ?>
				<div class="form-fields">
					<div class="dexignzone-input-group">
						<input type="text" name="dexignzone_registration_email" value="" required placeholder="<?php esc_attr_e( 'Enter E-mail address', 'clinicmaster' ); ?>">
						<input type="text" name="dexignzone_purchase_code" value="" required placeholder="<?php esc_attr_e( 'Enter your theme purchase code', 'clinicmaster' ); ?>">
					</div>
					<div class="submit-group">
						<input type="submit" name="submit" id="submit" class="button clinicmaster-btn" value="<?php esc_attr_e( 'Activate', 'clinicmaster' ); ?>" />
						<span class="process-loader"><img src="<?php echo esc_url( CLINICMASTER_URL . 'dz-inc/admin/images/loader.gif' ); ?>" alt="<?php esc_attr_e( 'Loader', 'clinicmaster' ) ?>" /></span>
					</div>
				</div>	

				<div class="verfication-alert text-center"><span class="verfication-txt"></span></div>
				
			</form>
			<?php }else{ ?>
			<div class="theme-activated-wrap text-center">
				<h3><?php esc_html_e( 'Thank you!', 'clinicmaster' ) ?></h3>
				<p><strong><?php esc_html_e( 'Your theme\'s license is activated successfully.', 'clinicmaster' ) ?></strong></p>
			</div>
			<?php } ?>
			<div class="registration-token-instruction">
				<p class="text-center"><?php printf( '%1$s <a href="%2$s" target="_blank">%3$s</a>',
					esc_html__( 'You can always buy more licences for this product:', 'clinicmaster' ),
					esc_url( 'https://themeforest.net/user/dexignzone/portfolio' ),
					esc_html__( 'ThemeForest DexignZone', 'clinicmaster' )
					); ?>
				</p>
			</div>
		</div>
	</div>
</div>