<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPricingTable2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-pricign-table-2';
	}
	
	public function get_title() {
		return esc_html__('Pricing Table 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Flexible Pricing Plans', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_2_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		
		$this->end_controls_section();
		
		
			$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_2_element_plan_yearly',
			[
				'label' 		=> esc_html__( 'Yearly Tab', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Yearly',
			]
		);
		$this->add_control(
			'pricing_table_2_element_plan_monthly',
			[
				'label' 		=> esc_html__( 'Monthly Tab', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Monthly',
			]
		);
		
		$repeater = new \Elementor\Repeater();

		
		$repeater->add_control(
			'pricing_table_2_element_item_yearly_price',
			[
				'label' 		=> esc_html__( 'Yearly Price ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$1049', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater->add_control(
			'pricing_table_2_element_item_munth_price',
			[
				'label' 		=> esc_html__( 'Monthly Price ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your price', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '$49', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater->add_control(
			'pricing_table_2_element_item_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'PROFESSIONAL', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_2_element_item_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$repeater->add_control(
			'pricing_table_2_element_item_feature_text',
			[
				'label' 		=> esc_html__( 'Feature Text ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Offered Services', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_2_element_item_content',
			[
				'label' => esc_html__( 'Content', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' 	=> true,
				'placeholder' => esc_html__( 'Type your content here', DZ_TH_DOMAIN ),
				'default' 		=> '<li>'.esc_html__( 'Dental cleanings', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental examinations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'X-rays', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Fluoride treatments', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental sealants', DZ_TH_DOMAIN ).'</li>',
			]
		);
		$repeater->add_control(
			'pricing_table_2_element_item_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'pricing_table_2_element_item_button_link',
			[
				'label' 		=> esc_html__( 'Button Taxt ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> 'http://nitesh-pc/products/clinicmaster/dentist/pricing-table/',
			]
		);
		$this->add_control(
			'pricing_table_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),			
				'default' 		=> [
					[
						'pricing_table_2_element_item_yearly_price' => '$1049',
						'pricing_table_2_element_item_munth_price' => '$49',
						'pricing_table_2_element_item_feature_text' => esc_html__( 'Offered Services', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_button_text' =>esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_button_link' => 'http://nitesh-pc/products/clinicmaster/dentist/pricing-table/',
						'pricing_table_2_element_item_text' => esc_html__( 'PROFESSIONAL', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_content' => '<li>'.esc_html__( 'Dental cleanings', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental examinations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'X-rays', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Fluoride treatments', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental sealants', DZ_TH_DOMAIN ).'</li>',
					],
					
					[
						'pricing_table_2_element_item_yearly_price' => '$1099',
						'pricing_table_2_element_item_munth_price' => '$99',
						'pricing_table_2_element_item_feature_text' => esc_html__( 'Offered Services', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_button_text' =>esc_html__( 'Choose Plans', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_button_link' => 'http://nitesh-pc/products/clinicmaster/dentist/pricing-table/',
						'pricing_table_2_element_item_text' => esc_html__( 'FAMILY PACK', DZ_TH_DOMAIN ),
						'pricing_table_2_element_item_content' => '<li>'.esc_html__( 'Dental cleanings', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental examinations', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'X-rays', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Fluoride treatments', DZ_TH_DOMAIN ).'</li><li>'.esc_html__( 'Dental sealants', DZ_TH_DOMAIN ).'</li>',
					],
					
					
				],
			]
		);
		$this->end_controls_section();

	
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'pricing_table_2_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/pricing_table_2_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handlePricingTabs();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}