<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZMarquee extends Widget_Base 
{
	public function get_name() {
		return 'dz-marquee';
	}
	
	public function get_title() {
		return esc_html__('Marquee',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-slider';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'marquee_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					'style_3' => esc_html__( 'Style 3', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'marquee_element_feature_list',
			[
				'label' 	=> esc_html__( 'Enter Description. (Comma Seperated)', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'	 =>   esc_html__( 'Accessories,Haircare,Nailcare,Beautycare,Bodycare,Skincare,Accessories,Haircare,Nailcare,Beautycare,Bodycare,Skincare', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/marquee_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}