<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZAppointmentForm1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-appointment-form-1';
	}
	
	public function get_title() {
		return esc_html__('Appointment Form 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'appointment_form_1_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					'style_3' => esc_html__( 'Style 3', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'appointment_form_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Make An ', DZ_TH_DOMAIN ).'<span>'.esc_html__( 'Appointment ', DZ_TH_DOMAIN ).'</span> <br>'.esc_html__( 'Apply For Treatments ', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'You Can React Us Anytime', DZ_TH_DOMAIN ),
				'condition' => [
					'appointment_form_1_element_style' => array('style_3','style_1'),
				],
			]
		);
		
		$this->add_control(
			'appointment_form_1_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		$this->add_control(
			'appointment_form_1_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'appointment_form_1_element_style' => ['style_1', 'style_2'],
				],
			]
		);
		$this->add_control(
			'appointment_form_1_element_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Appointment Now', DZ_TH_DOMAIN ),
				'condition' => [
					'appointment_form_1_element_style' => 'style_1',
				],
			]
		);
		
		$this->add_control(
		'appointment_form_1_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);
		
		$this->add_control(
			'appointment_form_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				'condition' => [
					'appointment_form_1_element_style' => ['style_1', 'style_3'],
				],
			]
		);
		
		$this->end_controls_section();
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/appointment_form_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}