<?php
/*About Us*/

class ClinicMaster_DZ_About_Us extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'ClinicMaster_DZ_About_Us', /* Name */esc_html__('ClinicMaster About Us','clinicmaster'), array( 'description' => esc_html__('Show the information about company', 'clinicmaster' )) );
	}
	
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		$title = apply_filters( 'widget_title', $instance['title'] );
		/* if(strpos($before_widget,'footer-sidebar-3')){
			$before_widget = str_replace('col-lg-4 col-md-6 col-sm-6 col-12','col-xl-6 col-lg-4 col-md-6 col-sm-6 col-12',$before_widget);
		} */
		$clinicmaster_option = getDZThemeReduxOption();
		$footer_style                 = !empty($clinicmaster_option['footer_style']) ? $clinicmaster_option['footer_style']	: '';
		$footer_card_image    = !empty($clinicmaster_option['footer_card_image']) ? $clinicmaster_option['footer_card_image']:''; 
		$footer_star_rating    = !empty($clinicmaster_option['footer_star_rating']) ? $clinicmaster_option['footer_star_rating']:''; 
		echo wp_kses($before_widget,$allowed_html_tags); 
		
		?>
						
						
						
		
		<div class=" widget_about me-2">
			<?php if(!empty($title)){ ?>
				<?php echo wp_kses($before_title.$title.$after_title, $allowed_html_tags); ?>
			<?php } ?>
			<?php if(!empty($instance['image'])){ ?>
			<div class="footer-logo logo-white">
				<a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($instance['image']); ?>" alt="<?php echo esc_attr__('Logo','clinicmaster'); ?>"></a> 
			</div>
			<?php }
			if(!empty($instance['about_content'])){ ?>
				<p><?php echo wp_kses($instance['about_content'],$allowed_html_tags); ?></p>
			<?php }?>
			<?php if($footer_style == 'footer_template_3' && !empty($footer_star_rating )){ ?>
				<div class="widget-rating2">
					
					<div class="clearfix">
						<?php //if(!empty($footer_card_image['id'])){ ?>
							<!-- <img src="<?php echo esc_url($footer_card_image['url']); ?>" alt="<?php echo esc_attr__('Image', 'clinicmaster'); ?>">-->
						<?php //} ?>
						<?php if(!empty($footer_star_rating)){ ?>
							<?php echo wp_kses($footer_star_rating, clinicmaster_allowed_html_tag());?>
						<?php } ?>
						
					</div>
				</div>
			
			<?php } ?>
		</div>
		<?php echo wp_kses($after_widget,$allowed_html_tags);
	}
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['about_content'] = $new_instance['about_content'];
		$instance['image'] = $new_instance['image'];
		return $instance;
	}
	
	/** @see WP_Widget::form */
	function form($instance)
	{
		
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$image = isset($instance['image']) ? esc_attr($instance['image']) : get_template_directory_uri().'/assets/images/logo-dark.png';
		$about_content = isset($instance['about_content']) ? $instance['about_content'] : '<span class="text-primary">'.esc_html__('ClinicMaster','clinicmaster').'</span>' . esc_html__(' Ipsum Dolor Sit Amet, Consectetuer Adipiscing Elit, Sed Diam Nonummy Nibh Euismod Tincidunt Ut Laoreet Dolore Agna Aliquam Erat . Wisi Enim Ad Minim Veniam, Quis Tation. Sit Amet, Consec Tetuer. Ipsum Dolor', 'clinicmaster');
		
		?>
		
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('About us', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('image')); ?>"><?php esc_html_e('Image Url:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('image')); ?>" name="<?php echo esc_attr($this->get_field_name('image')); ?>" type="text" value="<?php echo esc_attr($image); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('about_content')); ?>"><?php esc_html_e('About Content', 'clinicmaster'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('about_content')); ?>" name="<?php echo esc_attr($this->get_field_name('about_content')); ?>" ><?php echo wp_kses($about_content, $allowed_html_tags); ?></textarea>
           
        </p>
		
		
	<?php 
	}
}

class ClinicMaster_DZ_Newsletter  extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'ClinicMaster_DZ_Newsletter', /* Name */esc_html__('ClinicMaster Newsletter','clinicmaster'), array( 'description' => esc_html__('Show the newsletter', 'clinicmaster' )) );
	}
	
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		$title = apply_filters( 'widget_title', $instance['title'] );
		$styleclass = 'style-1';
		$html = '<i class="dzmaster-message"></i>';
		 if(strpos($before_widget,'footer-sidebar-1')){
			$styleclass = 'style-3';
			$html = esc_html__('Send', 'clinicmaster');
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-xl-3 col-lg-12 col-sm-12 ', $before_widget);
		} 
		
		echo wp_kses($before_widget,$allowed_html_tags); 
		
		?>
		
		<div class=" widget_about me-2">
			<?php if(!empty($title)){ ?>
				<?php echo wp_kses($before_title.$title.$after_title, $allowed_html_tags); ?>
			<?php } ?>
			<?php if(!empty($instance['desc'])){ ?>
				<p><?php echo esc_html($instance['desc']); ?></p>
			<?php }?>
			<form class="dzSubscribe dz-subscription <?php echo esc_attr($styleclass); ?>" >
				<div class="dzSubscribeMsg dz-subscription"></div>
				<div class="form-group">
					<div class="input-group mb-0">
						<input name="dzEmail" required="required" type="email" class="form-control form-btn-square" placeholder="<?php echo esc_attr__('Your Email Address', 'clinicmaster'); ?>">
						<div class="input-group-addon">
							<button name="submit" value="Submit" type="submit" class="btn">
								<?php echo wp_kses($html, $allowed_html_tags); ?>
							</button>
						</div>
					</div>
				</div>
			</form>
		</div>
		
		<?php echo wp_kses($after_widget,$allowed_html_tags);
	}
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['desc'] = $new_instance['desc'];
		return $instance;
	}
	
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('Important Updates Waiting for you', 'clinicmaster');
		$desc = isset($instance['desc']) ? $instance['desc'] : esc_html__('Get our latest and best contents right into your inbox', 'clinicmaster');
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		
		?>
       
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Our Newsletter', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
		
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"><?php esc_html_e('Desc', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Desc', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>" type="text" value="<?php echo esc_attr($desc); ?>" />
        </p>
	
	<?php 
	}
}

/*Footer Nevigation*/
class ClinicMaster_DZ_Navigation extends WP_Widget
  {
    
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Navigation', /* Name */esc_html__('ClinicMaster Navigation','clinicmaster'), array( 'description' => esc_html__('Show the Navigation', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
	$count = 1;	
      extract( $args );
		$menu_items = array();
		$page_object = get_queried_object();
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		if(strpos($before_widget,'footer-sidebar-3')){
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-xl-2 col-md-3 col-6 ', $before_widget);
		}
		if(strpos($before_widget,'footer-sidebar-2')){
			$before_widget = str_replace('col-xl-3 col-lg-6 col-sm-12', 'col-xl-2 col-md-3 col-6 ', $before_widget);
		}
		if(strpos($before_widget,'footer-sidebar-1')){
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-xl-3 col-md-4 col-sm-6 ', $before_widget);
		}
		if(strpos($before_widget,'footer-sidebar-4')){
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-md-4 col-md-3 col-6 ', $before_widget);
		}
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		
		echo wp_kses($before_widget, $allowed_html_tags); ?>		
		<div class="widget_services style-1">
		<?php
		if(!empty($title)){
			echo wp_kses($before_title.$title.$after_title, $allowed_html_tags); 
		}			
		if(!empty($instance['selected_menu'])){	  
			$menu_items = wp_get_nav_menu_items($instance['selected_menu']);  
		}
		
		?>
		
		<ul>
			<?php 
			foreach($menu_items as $menu_item){ 
				$title = '';
				
				if(!empty($menu_item->post_title)){
					$title = $menu_item->post_title; 
				}else if(!empty($menu_item->title)){
					$title = $menu_item->title;
				}
				
				$classes =  (!empty($page_object->post_title) && ($title == $page_object->post_title )) ? 'active' : ' ';
			?>
			<li  class="<?php echo esc_attr($classes) ?>">
			  <a href="<?php echo esc_url($menu_item->url); ?>"><span><?php echo esc_html($title); ?></span></a>
			</li>
			<?php $count++; 
			} ?>
		</ul>
		</div>
		<?php
		
		 echo wp_kses($after_widget, $allowed_html_tags);
      
    }
    
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
      $instance = $old_instance;
      
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['selected_menu'] = strip_tags($new_instance['selected_menu']);
     
      
      return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
      $title = ($instance) ? esc_attr($instance['title']) : esc_html__('Our Stores', 'clinicmaster');
      $selected_menu = !empty( $instance['selected_menu'] ) ? $instance['selected_menu'] : "";
     
    ?>
    
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
      <input placeholder="<?php esc_attr_e('Menu', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
    </p>
    <p>
      <label for="<?php echo esc_attr( $this->get_field_id( 'Select Menu' ) ); ?>"><?php esc_html_e( 'Select Menu:', 'clinicmaster' ); ?></label> 
      <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'selected_menu' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'selected_menu' ) ); ?>">
				<?php 
					
					$all_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
					foreach (  $all_menus as $menu ) {	
					$selected = ($selected_menu == $menu->slug )?  ' selected="selected" ':'';
				?>
					<option value="<?php echo esc_attr($menu->slug);?>" <?php echo esc_attr($selected); ?> ><?php echo  esc_html($menu->name); ?></option>
          <?php 
          }
          
        ?>
      </select>
    </p>
   
    
    
		<?php 
    }
    
  }

  
/*Latest Post*/
  class ClinicMaster_DZ_Recent_Post extends WP_Widget
  {
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Recent_Post', /* Name */esc_html__('ClinicMaster Recent Post','clinicmaster'), array( 'description' => esc_html__('Show the footer recent posts sidebar', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
      extract( $args );
	 
	  
      $title =  apply_filters( 'widget_title', $instance['title'] );
	  $query_string = '';
	  $allowed_html_tags = clinicmaster_allowed_html_tag();
	
	
	echo wp_kses($before_widget,  $allowed_html_tags); ?>
		<div class="widget recent-posts-entry wow fadeInUp" data-wow-delay="0.3s" data-wow-duration="0.5s" style="visibility: visible; animation-duration: 0.5s; animation-delay: 0.3s; animation-name: fadeInUp;">
			<?php echo wp_kses($before_title.$title.$after_title,$allowed_html_tags);  
			
				$query_string .= isset( $instance['number'] ) ? 'posts_per_page='.$instance['number'] : '';
				$query_string .= isset( $instance['cat'] ) ?'&cat='.$instance['cat'] : '';					  
				$text_limit = isset( $instance['text_limit'] ) ? $instance['text_limit'] : '6';	
				?>
				<div class="widget-post-bx">
				<?php 
				$this->posts_data($query_string, $text_limit);   ?>
				
						
			</div>
		</div>
    
		<?php echo wp_kses($after_widget,  $allowed_html_tags);
    }
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
      $instance = $old_instance;
      
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['number'] = $new_instance['number'];
      $instance['text_limit'] = $new_instance['text_limit'];
      $instance['cat'] = $new_instance['cat'];
      
      return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
      $title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Recent Posts', 'clinicmaster');
      $number = ( $instance ) ? esc_attr($instance['number']) : 3;
      $text_limit = ( $instance ) ? esc_attr($instance['text_limit']) : 10;
	  $cat = ( $instance ) ? esc_attr($instance['cat']) : ''; 
	  $allowed_html_tags = clinicmaster_allowed_html_tag();
	  ?>
		
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'clinicmaster'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
    </p>
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'clinicmaster'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
    </p>
	<p>
      <label for="<?php echo esc_attr($this->get_field_id('text_limit')); ?>"><?php esc_html_e('Text Limit:', 'clinicmaster'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('text_limit')); ?>" name="<?php echo esc_attr($this->get_field_name('text_limit')); ?>" type="text" value="<?php echo esc_attr( $text_limit ); ?>" />
    </p>
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'clinicmaster'); ?></label>
      <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'clinicmaster'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
    </p>
    
		<?php 
    }
    
    function posts_data($query_string, $text_limit)
    {
	$query = new WP_Query($query_string);
	if( $query->have_posts() ){
			?>
	<!-- Title -->
		
		<?php while( $query->have_posts() ){
			global $post;
			
			$query->the_post(); ?>
		<!-- Widget Post -->
				<div class="widget-post clearfix">
					<?php if( has_post_thumbnail() ){ ?>
					<div class="dz-media">
						<?php the_post_thumbnail('thumbnail'); ?> 
					</div>
					<?php } ?>
					<div class="dz-info">
						<div class="dz-meta">
							<ul>
								<li class="post-date"> <?php echo esc_html(get_the_date()); ?> </li>
							</ul>
						</div>
						<h5 class="title"><a href="<?php echo esc_url( get_the_permalink( $post->ID ) );?>"><?php echo clinicmaster_trim($post->post_title,$text_limit); ?></a></h5>
					</div>
				</div>
			<?php } ?>
	
    

    <?php  }
      wp_reset_postdata();
    }
  }

/*Contact Us*/
class ClinicMaster_DZ_Contact_Us extends WP_Widget
  {
    
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Contact_Us', /* Name */esc_html__('ClinicMaster Contact Address','clinicmaster'), array( 'description' => esc_html__('Show Address', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
      extract( $args );
      $allowed_html_tags = clinicmaster_allowed_html_tag();
      $title = apply_filters( 'widget_title', $instance['title'] );
      
      $before_widget = str_replace('substitute-class','widget_getintuch',$before_widget);
      $before_widget = str_replace('service_menu_nav','',$before_widget);
      $before_widget = str_replace('bg-secondary','',$before_widget);
		echo wp_kses($before_widget, $allowed_html_tags);
	
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		?>
				
			<?php echo wp_kses($before_title.$title.$after_title,  $allowed_html_tags); ?>
			
			<div class="widget_contact" <?php if(!empty($instance['bg_image'])){ ?> style="background-image:url(<?php echo esc_url($instance['bg_image']); ?>);" <?php } ?>>
				<div class="widget-content">
					<?php if(!empty($instance['image'])){ ?>
						<img src="<?php echo esc_url($instance['image']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
					<?php } ?>
					<?php if(!empty($instance['content'])){ ?>
						<h4 class="title">
							<?php echo wp_kses($instance['content'],'string'); ?>
						</h4>
					<?php } ?>
					<?php if(!empty($instance['phone_number'])){ ?>
					<div class="phone-number">
						<a href="tel:<?php echo esc_attr($instance['phone_number']); ?>"><?php echo esc_html($instance['phone_number']); ?></a>
					</div>
					<?php } ?>
					<?php if(!empty($instance['email'])){ ?>
					<div class="email">
						<a href="mailto:<?php echo esc_attr($instance['email']); ?>"><?php echo esc_html($instance['email']); ?></a>
					</div>
					<?php } ?>
					<?php if(!empty($instance['button_text']) && !empty($instance['button_link'])){ ?>
						<div class="link-btn">
							<a href="<?php echo esc_url($instance['button_link']); ?>" class="btn btn-lg btn-white btn-rounded btn-hover2 btn-shadow"><?php echo esc_html($instance['button_text']); ?><span class="right-icon"><i class="feather icon-arrow-right"></i></span></a>
						</div>
					<?php } ?>
				</div>
			</div>
			
		
		<?php		  
		  echo wp_kses($after_widget, $allowed_html_tags);
    }
    
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['image'] = $new_instance['image'];
		$instance['bg_image'] = $new_instance['bg_image'];
		$instance['content'] = $new_instance['content'];
		$instance['phone_number'] = $new_instance['phone_number'];
		$instance['email'] = $new_instance['email'];
		$instance['button_text'] = $new_instance['button_text'];
		$instance['button_link'] = $new_instance['button_link'];
		return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('', 'clinicmaster');
		$content = isset($instance['content']) ? esc_attr($instance['content']) : esc_html__('Do you need any help?', 'clinicmaster');
		$bg_image = isset($instance['bg_image']) ? esc_attr($instance['bg_image']) : get_template_directory_uri().'/assets/images/background/bg3.png';
		$image = !empty($instance['image']) ? $instance['image'] : get_template_directory_uri().'/assets/images/question.png';
		$phone_number = isset($instance['phone_number']) ? esc_attr($instance['phone_number']) : '+91 12345 678 98';
		$email = isset($instance['email']) ? esc_attr($instance['email']) : 'info@kinixthemes.com';
		$button_text = isset($instance['button_text']) ? esc_attr($instance['button_text']) : esc_html__('Contact Us', 'clinicmaster');
		$button_link = isset($instance['button_link']) ? esc_url($instance['button_link']) : '';
		$allowed_html_tags = clinicmaster_allowed_html_tag();
    ?>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('image')); ?>"><?php esc_html_e(' Image Url here:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e(' Image url', 'clinicmaster'); ?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('image')); ?>" name="<?php echo esc_attr($this->get_field_name('image')); ?>" type="text" value="<?php echo esc_attr($image); ?>" />
        </p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Place', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('bg_image')); ?>"><?php esc_html_e('Background Image', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Background Image', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('bg_image')); ?>" name="<?php echo esc_attr($this->get_field_name('bg_image')); ?>" type="text" value="<?php echo esc_attr($bg_image); ?>" />
		</p>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_number')); ?>"><?php esc_html_e('Phone Number:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your phone number', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_number')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" type="text" value="<?php echo esc_attr($phone_number); ?>" />
        </p>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your email', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Contents:', 'clinicmaster'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses($content, $allowed_html_tags); ?></textarea>
		</p>		
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('button_text')); ?>"><?php esc_html_e('Button Text:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Enter Your text', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('button_text')); ?>" name="<?php echo esc_attr($this->get_field_name('button_text')); ?>" type="text" value="<?php echo esc_attr($button_text); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('button_link')); ?>"><?php esc_html_e('Button Link:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Enter your url', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('button_link')); ?>" name="<?php echo esc_attr($this->get_field_name('button_link')); ?>" type="text" value="<?php echo esc_attr($button_link); ?>" />
		</p>		
		<?php 
    }
    
  }
 
 
 /*Footer Nevigation*/
class ClinicMaster_DZ_Navigation2 extends WP_Widget
  {
    
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Navigation2', /* Name */esc_html__('ClinicMaster Navigation 2','clinicmaster'), array( 'description' => esc_html__('Show the Navigation', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
	$count = 1;	
      extract( $args );
		$menu_items = array();
		$page_object = get_queried_object();
		$title = apply_filters( 'widget_title', $instance['title'] );
		$before_widget = str_replace('bg-secondary','',$before_widget);
		
		
		if(strpos($before_widget,'footer-sidebar-1') || strpos($before_widget,'footer-sidebar-2') || strpos($before_widget,'footer-sidebar-3')){
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-xl-2 col-md-3 col-6 ', $before_widget);
		}
		if(strpos($before_widget,'footer-sidebar-2')){
			$before_widget = str_replace('col-xl-3 col-lg-6 col-sm-12', 'col-xl-2 col-md-3 col-6 ', $before_widget);
		}
		
		
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		
		echo wp_kses($before_widget, $allowed_html_tags); ?>		
		<div class="widget_services">
		<?php
		if(!empty($title)){
			echo wp_kses($before_title.$title.$after_title, $allowed_html_tags); 
		}			
		if(!empty($instance['selected_menu'])){	  
			$menu_items = wp_get_nav_menu_items($instance['selected_menu']);  
		}
		
		?>
		
		<ul class="list-hover1">
			<?php 
			foreach($menu_items as $menu_item){ 
				$title = '';
				if(!empty($menu_item->post_title)){
					$title = $menu_item->post_title; 
				}else if(!empty($menu_item->title)){
					$title = $menu_item->title;
				}
				
				$classes =  (!empty($page_object->post_title) && $title == $page_object->post_title ) ? 'active' : ' ';
			?>
			<li  class="<?php echo esc_attr($classes) ?>">
			  <a href="<?php echo esc_url($menu_item->url); ?>"><span><?php echo esc_html($title); ?></span></a>
			</li>
			<?php $count++; 
			} ?>
		</ul>
		</div>
		<?php
		
		 echo wp_kses($after_widget, $allowed_html_tags);
      
    }
    
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
      $instance = $old_instance;
      
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['selected_menu'] = strip_tags($new_instance['selected_menu']);
     
      
      return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
      $title = ($instance) ? esc_attr($instance['title']) : esc_html__('Our Stores', 'clinicmaster');
      $selected_menu = !empty( $instance['selected_menu'] ) ? $instance['selected_menu'] : "";
     
    ?>
    
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
      <input placeholder="<?php esc_attr_e('Menu', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
    </p>
    <p>
      <label for="<?php echo esc_attr( $this->get_field_id( 'Select Menu' ) ); ?>"><?php esc_html_e( 'Select Menu:', 'clinicmaster' ); ?></label> 
      <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'selected_menu' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'selected_menu' ) ); ?>">
				<?php 
					
					$all_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
					foreach (  $all_menus as $menu ) {	
					$selected = ($selected_menu == $menu->slug )?  ' selected="selected" ':'';
				?>
					<option value="<?php echo esc_attr($menu->slug);?>" <?php echo esc_attr($selected); ?> ><?php echo  esc_html($menu->name); ?></option>
          <?php 
          }
          
        ?>
      </select>
    </p>
   
    
    
		<?php 
    }
    
  }




/*Contact Us 2*/
class ClinicMaster_DZ_Contact_Us2 extends WP_Widget
  {
    
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Contact_Us2', /* Name */esc_html__('ClinicMaster Contact Address 2','clinicmaster'), array( 'description' => esc_html__('Show Address', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
      extract( $args );
      $allowed_html_tags = clinicmaster_allowed_html_tag();
      $title = apply_filters( 'widget_title', $instance['title'] );
      
      $before_widget = str_replace('substitute-class','widget_getintuch',$before_widget);
      $before_widget = str_replace('service_menu_nav','',$before_widget);
      $before_widget = str_replace('bg-secondary','',$before_widget);
      $before_widget = str_replace('bg-secondary','',$before_widget);
	  
		echo wp_kses($before_widget, $allowed_html_tags);
	
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		?>
				
			<?php echo wp_kses($before_title.$title.$after_title,  $allowed_html_tags); ?>
			
			<div class="widget_contact widget_contact_light">
				<div class="widget-content">
					<?php if(!empty($instance['image'])){ ?>
						<img src="<?php echo esc_url($instance['image']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
					<?php } ?>
					<?php if(!empty($instance['content'])){ ?>
						<h4 class="title">
							<?php echo wp_kses($instance['content'],'string'); ?>
						</h4>
					<?php } ?>
					<?php if(!empty($instance['phone_number'])){ ?>
					<div class="phone-number">
						<a href="tel:<?php echo esc_attr($instance['phone_number']); ?>"><?php echo esc_html($instance['phone_number']); ?></a>
					</div>
					<?php } ?>
					<?php if(!empty($instance['email'])){ ?>
					<div class="email">
						<a href="mailto:<?php echo esc_attr($instance['email']); ?>"><?php echo esc_html($instance['email']); ?></a>
					</div>
					<?php } ?>
					<?php if(!empty($instance['button_text']) && !empty($instance['button_link'])){ ?>
						<div class="link-btn">
							<a href="<?php echo esc_url($instance['button_link']); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow"><?php echo esc_html($instance['button_text']); ?><span class="right-icon"><i class="feather icon-arrow-right"></i></span></a>
						</div>
					<?php } ?>
						
				</div>
			</div>
			
		
		<?php		  
		  echo wp_kses($after_widget, $allowed_html_tags);
    }
    
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['image'] = $new_instance['image'];
		
		$instance['content'] = $new_instance['content'];
		$instance['phone_number'] = $new_instance['phone_number'];
		$instance['email'] = $new_instance['email'];
		$instance['button_text'] = $new_instance['button_text'];
		$instance['button_link'] = $new_instance['button_link'];
		return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('', 'clinicmaster');
		$content = isset($instance['content']) ? esc_attr($instance['content']) : esc_html__('Do you need any help?', 'clinicmaster');
		$image = !empty($instance['image']) ? $instance['image'] : get_template_directory_uri().'/assets/images/question2.png';
		$phone_number = isset($instance['phone_number']) ? esc_attr($instance['phone_number']) : '+91 12345 678 98';
		$email = isset($instance['email']) ? esc_attr($instance['email']) : 'info@kinixthemes.com';
		$button_text = isset($instance['button_text']) ? esc_attr($instance['button_text']) : esc_html__('Contact Us', 'clinicmaster');
		$button_link = isset($instance['button_link']) ? esc_url($instance['button_link']) : '';
		$allowed_html_tags = clinicmaster_allowed_html_tag();
    ?>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('image')); ?>"><?php esc_html_e(' Image Url here:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e(' Image url', 'clinicmaster'); ?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('image')); ?>" name="<?php echo esc_attr($this->get_field_name('image')); ?>" type="text" value="<?php echo esc_attr($image); ?>" />
        </p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Place', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_number')); ?>"><?php esc_html_e('Phone Number:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your phone number', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_number')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" type="text" value="<?php echo esc_attr($phone_number); ?>" />
        </p>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your email', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Contents:', 'clinicmaster'); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses($content, $allowed_html_tags); ?></textarea>
		</p>		
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('button_text')); ?>"><?php esc_html_e('Button Text:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Enter Your text', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('button_text')); ?>" name="<?php echo esc_attr($this->get_field_name('button_text')); ?>" type="text" value="<?php echo esc_attr($button_text); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('button_link')); ?>"><?php esc_html_e('Button Link:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Enter your url', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('button_link')); ?>" name="<?php echo esc_attr($this->get_field_name('button_link')); ?>" type="text" value="<?php echo esc_attr($button_link); ?>" />
		</p>		
		<?php 
    }
    
  }
  
  
  /*Contact Us 2*/
class ClinicMaster_DZ_Contact_Us3 extends WP_Widget
  {
    
    /** constructor */
    function __construct()
    {
      parent::__construct( /* Base ID */'ClinicMaster_DZ_Contact_Us3', /* Name */esc_html__('ClinicMaster Contact Address 3','clinicmaster'), array( 'description' => esc_html__('Show Address', 'clinicmaster' )) );
    }
    
    /** @see WP_Widget::widget */
    function widget($args, $instance)
    {
      extract( $args );
      $allowed_html_tags = clinicmaster_allowed_html_tag();
      $title = apply_filters( 'widget_title', $instance['title'] );
      
     /*  $before_widget = str_replace('substitute-class','widget_getintuch',$before_widget);
      $before_widget = str_replace('service_menu_nav','',$before_widget);
      $before_widget = str_replace('bg-secondary','',$before_widget);
      $before_widget = str_replace('bg-secondary','',$before_widget); */
		if(strpos($before_widget,'footer-sidebar-1')){
			$before_widget = str_replace('col-xl-3 col-sm-12', 'col-xl-3 col-md-4 col-sm-12 ', $before_widget);
		}
		echo wp_kses($before_widget, $allowed_html_tags);
	
		$allowed_html_tags = clinicmaster_allowed_html_tag();
		?>
				
			<?php echo wp_kses($before_title.$title.$after_title,  $allowed_html_tags); 
			if(!empty($instance['phone_number_text']) || !empty($instance['phone_number']) || !empty($instance['time_text']) || !empty($instance['time'])){ ?>
			<div class="widget_get_in_touch">
				<ul>
					<?php if(!empty($instance['phone_number_text']) && !empty($instance['phone_number'])){ ?>
						<li>
							<div class="widget-head">
								<i class="feather icon-phone-call"></i>
								<span class="title">
									<?php echo esc_html($instance['phone_number_text']);  ?>
								</span>
							</div>
							<span class="widget-text">
								<?php echo esc_html($instance['phone_number']);  ?>								
							</span>
						</li>
					<?php } ?>
					<?php if(!empty($instance['time_text']) && !empty($instance['time'])){ ?>
						<li>
							<div class="widget-head">
								<i class="feather icon-clock"></i>
								<span class="title">
									<?php echo esc_html($instance['time_text']);  ?>
								</span>
							</div>
							<span class="widget-text">
								<?php echo esc_html($instance['time']);  ?>
							</span>
						</li>
					<?php } ?>
				</ul>
			</div>
		<?php		
			}		
		  echo wp_kses($after_widget, $allowed_html_tags);
    }
    
    
    /** @see WP_Widget::update */
    function update($new_instance, $old_instance)
    {
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['phone_number_text'] = $new_instance['phone_number_text'];
		$instance['phone_number'] = $new_instance['phone_number'];
		$instance['time_text'] = $new_instance['time_text'];
		$instance['time'] = $new_instance['time'];
		
		return $instance;
    }
    
    /** @see WP_Widget::form */
    function form($instance)
    {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : esc_html__('get in Touch', 'clinicmaster');
		$phone_number_text = isset($instance['phone_number_text']) ? esc_attr($instance['phone_number_text']) : 'Call Us';
		$phone_number = isset($instance['phone_number']) ? esc_attr($instance['phone_number']) : '+91 12345 678 98';
		$time_text = isset($instance['time_text']) ? esc_attr($instance['time_text']) : 'Opening Time';
		$time = isset($instance['time']) ? esc_attr($instance['time']) : 'Mon -Sat: 7:00 - 17:00';
		
		$allowed_html_tags = clinicmaster_allowed_html_tag();
    ?>
		 
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'clinicmaster'); ?></label>
			<input placeholder="<?php esc_attr_e('Place', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_number_text')); ?>"><?php esc_html_e('Phone Number Text:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your phone number text', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_number_text')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_number_text')); ?>" type="text" value="<?php echo esc_attr($phone_number_text); ?>" />
        </p>
		 <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_number')); ?>"><?php esc_html_e('Phone Number:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your phone number', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_number')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" type="text" value="<?php echo esc_attr($phone_number); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('time_text')); ?>"><?php esc_html_e('Time Text:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your time text', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('time_text')); ?>" name="<?php echo esc_attr($this->get_field_name('time_text')); ?>" type="text" value="<?php echo esc_attr($time_text); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('time')); ?>"><?php esc_html_e('Time:', 'clinicmaster'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter your time', 'clinicmaster');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('time')); ?>" name="<?php echo esc_attr($this->get_field_name('time')); ?>" type="text" value="<?php echo esc_attr($time); ?>" />
        </p>
			
			
		<?php 
    }
    
  }