<?php 	
$maintenance_img 			  = clinicmaster_get_opt('maintenance_background_image');
$maintenance_title            = clinicmaster_get_opt('maintenance_title');
$maintenance_desc             = clinicmaster_get_opt('maintenance_desc');
$maintenance_page_subscribe   = clinicmaster_get_opt('maintenance_page_subscribe');
$maintenance_social_links     = clinicmaster_get_opt('maintenance_social_links');
$maintenance_social_links_on  = clinicmaster_get_opt('maintenance_social_links_on');
$maintenance_icon             = clinicmaster_get_opt('maintenance_icon');
$social_link_target           = clinicmaster_get_opt('social_link_target');
$copyright_text      		  = clinicmaster_get_opt('footer_template_1_footer_copyright_text');
 
?>

<section class="under-construct-wrapper">
	<div class="row align-items-center">
		<div class="col-lg-6">
			<div class="under-construct-logo">
				<?php do_action( 'clinicmaster_get_logo','site_logo');  ?>
			</div>	
			<div class="dz-content">
				<?php if (!empty($maintenance_title)) { ?>
					<h2 class="dz-title">
						<?php echo wp_kses($maintenance_title, clinicmaster_allowed_html_tag()); ?>
					</h2>
				<?php } 
				if (!empty($maintenance_desc)) { ?>
					<p><?php echo wp_kses($maintenance_desc, 'string'); ?></p>
				<?php } ?>
				<?php if(!empty($maintenance_page_subscribe)){ ?>
				<form class="dzSubscribe dz-subscription style-3">
					<div class="dzSubscribeMsg dz-subscription"></div>
					<div class="form-group">
						<div class="input-group mb-0">
							<input name="dzEmail" required="required" type="email" class="form-control" placeholder="Your Email Address">
							<div class="input-group-addon">
								<button name="submit" value="Submit" type="submit" class="btn btn-primary btn-hover1">
									<span class="btn-text"><?php echo esc_html__('Subscribe Now', 'clinicmaster'); ?></span>
									<span class="btn-icon">
										<i class="fa-solid fa-paper-plane"></i>
									</span>
								</button>
							</div>
						</div>
					</div>
				</form>
				<?php } ?>
				<?php if (!empty($maintenance_social_links_on)) { ?>
				<div class="dz-social-icon style-4">
					<ul class="social-list mt-3">
						<?php echo clinicmaster_get_social_icons('header', ' ', $maintenance_social_links, false); ?>
					</ul>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php if(!empty($maintenance_img['url'])){
			$file_info = wp_check_filetype( $maintenance_img['url'] );
			$image_extension = $file_info['ext'];
			?>
		<div class="col-lg-6">
			<?php if($image_extension == 'svg'){
				$response = wp_remote_get($maintenance_img['url']);
				if (!is_wp_error($response)) {
					$svg_content = wp_remote_retrieve_body($response);
					echo '<div class="construct-media">'.$svg_content.'</div>';
				}
			}else{ ?>
			<div class="construct-media">
				<img src="<?php echo esc_url($maintenance_img['url']) ?>" alt="<?php echo esc_attr__('Image', 'clinicmaster'); ?>">
			</div>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
	<?php if(!empty($copyright_text)){ ?>
		<p class="copyright-text text-center mb-0 mt-4"><?php echo wp_kses($copyright_text, clinicmaster_allowed_html_tag()); ?></p>
	<?php } ?>
</section>

