<?php 
global $post;
$post_id = $post->ID;
$post_title = $post->post_title;
$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
$team_social_data = clinicmaster_get_team_social_link($post_id);
$element_content = !empty($team_detail_1_element_content) ? $team_detail_1_element_content : 'content-inner';
$style = !empty($team_detail_1_element_style) ? $team_detail_1_element_style : 'style_1';
if($style == 'style_1'){ 
?>
		<section class="<?php echo esc_attr($element_content); ?>">
			<div class="container">
				<div class="row">
					<div class="col-lg-4 m-b30">
						<aside class="side-bar sticky-top">
						<?php if(!empty($post_id)){ ?>
							<div class="widget">
								<div class="dz-team style-5">
									<?php if (has_post_thumbnail()) { ?>
										<div class="dz-media">
											<?php echo the_post_thumbnail('full'); ?>
										</div>
									<?php } ?>
									<?php  if(!empty($team_social_data['any_fill'] )){ ?>
										<ul class="dz-social">
										
											<?php foreach($team_social_data['data'] as $key => $value) {
												if(!empty($value['url'])){
											?>
												<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
											<?php }
												}
											?>	
										</ul>
									<?php } ?>
									
								</div>
							</div>
						<?php } ?>
							<div class="widget widget_schedule bg-secondary text-white">
								<?php if(!empty($team_detail_1_element_text)){ ?>
								<div class="widget-title">
									<h4 class="title text-white"><?php echo esc_html($team_detail_1_element_text); ?></h4>
								</div>
								<?php }
								if(!empty($team_detail_1_element_schedule)){ ?>
									<table class="table table-border-bottom m-b0">
										<?php foreach($team_detail_1_element_schedule as $schedule){ 
										
										$week = $schedule['team_detail_1_element_schedule_week'];
										$time = $schedule['team_detail_1_element_schedule_time'];
										if(!empty($week) && !empty($time)){
									?>
										<tr>
											<th><?php echo esc_html($week); ?></th>
											<td class="text-end"><?php echo esc_html($time); ?></td>
										</tr>
										<?php  }
									} ?>
									</table>
								<?php } ?>
							</div>
							<?php if(!empty($team_detail_1_element_contact)){ ?>
							<div class="widget widget_info bg-light">
							<?php foreach($team_detail_1_element_contact as $con){ 
								$icon = $con['team_detail_1_element_contact_icon'];
								$text = $con['team_detail_1_element_contact_text'];
								$value = $con['team_detail_1_element_contact_value'];
							?>
								<div class="icon-bx-wraper style-1 m-b20">
									<?php if(!empty($icon['value'])){ ?>
									<div class="icon-bx bg-primary">
										<span class="icon-cell">
											<?php 
											if(!empty($icon['value']['id']) && ($icon['library'] == 'svg') ){ 
												echo wp_get_attachment_image( $icon['value']['id'], 'thumbnail' ); 
											}elseif(!empty($icon['value'])){ ?>
												<i class="<?php echo esc_attr($icon['value']); ?>"></i>
											<?php } ?>
											
										</span>
									</div>
									<?php }
										if(!empty($text) || !empty($value)){ ?>	
										<div class="icon-content">
											<?php if(!empty($text)){ ?>	
												<h5 class="dz-title fw-semibold"><?php echo esc_html($text); ?></h5>
											<?php } ?>
											<?php if(!empty($value)){ ?>	
												<p class="fw-normal"><?php echo esc_html($value); ?></p>
											<?php } ?>
										</div>
									<?php } ?>
								</div>
							<?php } ?>
							</div>
							<?php } ?>
						</aside>
					</div>
					<div class="col-lg-8 ps-xl-5 m-b30">
						<div class="section-head style-1 mb-30">
							<?php if(!empty($post_title)){ ?>
								<h2 class="titlev fw-semibold m-b0"><?php echo esc_html($post_title); ?></h2>
							<?php } ?>
							<?php if(!empty($team_detail_1_element_education)){ ?>
								<p class="text-primary m-b20 fw-normal font-16"><?php echo esc_html($team_detail_1_element_education); ?></p>
							<?php } ?>
							<?php if(!empty($team_detail_1_element_description)){ ?>
							<p class="fw-normal m-b0"><?php echo wp_kses($team_detail_1_element_description, 'string') ?></p>
							<?php } ?>
						</div>
						<?php if(!empty($team_detail_1_element_item)){ ?>
							<table class="table table-striped table-striped-rounded m-b40">
								<?php foreach($team_detail_1_element_item as $item){
								$text = $item['team_detail_1_element_item_text'];
								$value = $item['team_detail_1_element_item_value'];
									?>
									<tr>
									<?php if(!empty($text)){ ?>
										<th><?php echo esc_html($text); ?></th>
									<?php } 
										if(!empty($value)){ ?>
											<td><?php echo wp_kses($value, clinicmaster_allowed_html_tag()) ?></td>
									<?php } ?>
									</tr>
								<?php } ?>
							</table>
						<?php } ?>
						<?php if($team_detail_1_element_feature_text){ ?>
							<h3 class="font-20 m-b15"><?php echo esc_html($team_detail_1_element_feature_text); ?></h3>
						<?php } ?>
						<?php if(!empty($team_detail_1_element_skils)){ ?>
						<ul class="list-check-circle list-light text-secondary fw-medium grid-2 m-b40">
						<?php foreach($team_detail_1_element_skils as $val){ ?>
							<li><?php echo esc_html($val['team_detail_1_element_feature_list']); ?></li>
						<?php } ?>
						
						</ul>
						<?php } ?>
						<div class="form-wrapper style-1">
							<div class="form-body bg-white shadow-sm border">
								<?php if(!empty($team_detail_1_element_title)){ ?>
								<div class="title-head">
									<h2 class="form-title m-b0"><?php echo wp_kses($team_detail_1_element_title,clinicmaster_allowed_html_tag()); ?></h2>
								</div>
								<?php } ?>
								<?php if(!empty($team_detail_1_element_contact_form)){ ?>
									
										<?php 
											$form = get_page_by_path($team_detail_1_element_contact_form,OBJECT,'wpcf7_contact_form');
											if(!empty($form->ID)){
												echo do_shortcode('[contact-form-7 id="'.$form->ID.'"]');
											}
										?>
									
								<?php } ?>
							</div>
							
						</div>
					</div>
				</div>
			</div>
		</section>
<?php }elseif($style == 'style_2'){  ?>

<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">
		<div class="row">
			<div class="col-lg-6 m-b30">
				<aside class="side-bar sticky-top">
					<div class="widget">
						<div class="dz-team style-6">
							<?php if (has_post_thumbnail()) { ?>
								<div class="dz-media">
									<?php echo the_post_thumbnail('ful'); ?>
								</div>
							<?php } ?>
							<?php  if(!empty($team_social_data['any_fill'] )){ ?>
								<ul class="dz-social">
								
									<?php foreach($team_social_data['data'] as $key => $value) {
										if(!empty($value['url'])){
									?>
										<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
									<?php }
										}
									?>	
								</ul>
							<?php } ?>
							<?php if(!empty($team_detail_1_element_counter_number) || !empty($team_detail_1_element_counter_text)){ ?>
							<div class="item1">
								<div class="info-widget style-10 move-3">
									<?php if(!empty($team_detail_1_element_counter_number)){ ?>
									<span class="content-text text-primary"><span class="counter"><?php echo esc_html($team_detail_1_element_counter_number); if(!empty($team_detail_1_element_counter_symbol)){  ?></span><?php echo esc_html($team_detail_1_element_counter_symbol); ?></span> <?php } ?>
									<?php }
									if(!empty($team_detail_1_element_counter_text)){ ?>
									<h3 class="title m-b0"><?php echo wp_kses($team_detail_1_element_counter_text, clinicmaster_allowed_html_tag()) ?></h3>
									<?php } ?>
								</div>
							</div>
							<?php } ?>
						</div>
					</div>
				</aside>
			</div>
			<div class="col-lg-6">
				<div class="section-head style-1 mb-30">
					<?php if(!empty($post_title)){ ?>
						<h2 class="titlev fw-semibold m-b0"><?php echo esc_html($post_title); ?></h2>
					<?php } ?>
					<?php if(!empty($team_detail_1_element_education)){ ?>
						<p class="text-primary m-b20 fw-normal small"><?php echo esc_html($team_detail_1_element_education); ?></p>
					<?php } ?>
					<?php if(!empty($team_detail_1_element_description)){ ?>
						<p class="fw-normal small"><?php echo wp_kses($team_detail_1_element_description, 'string') ?></p>
					<?php } ?>
				</div>
				<?php if(!empty($team_detail_1_element_item)){ ?>
					<table class="table table-border-bottom m-b40">
						<?php foreach($team_detail_1_element_item as $item){
						$text = $item['team_detail_1_element_item_text'];
						$value = $item['team_detail_1_element_item_value'];
							?>
							<tr>
							<?php if(!empty($text)){ ?>
								<th><?php echo esc_html($text); ?></th>
							<?php } 
								if(!empty($value)){ ?>
									<td><?php echo wp_kses($value, clinicmaster_allowed_html_tag()) ?></td>
							<?php } ?>
							</tr>
						<?php } ?>
					</table>
				<?php } ?>
				<?php if($team_detail_1_element_feature_text){ ?>
						<h3 class="font-20 m-b25"><?php echo esc_html($team_detail_1_element_feature_text); ?></h3>
					<?php } ?>
					<?php if(!empty($team_detail_1_element_skils)){
						foreach($team_detail_1_element_skils as $val){ ?>
							<div class="progress-wrap m-b35">
								<div class="progress-info">
									<span class="title"><?php echo esc_html($val['team_detail_1_element_feature_list']); ?></span>
									<?php if(!empty($val['team_detail_1_element_feature_number'])){ ?>
									<span class="progress-value"><?php echo esc_html($val['team_detail_1_element_feature_number'].'%'); ?></span>
									<?php } ?>
								</div>
								<?php if(!empty($val['team_detail_1_element_feature_number'])){ ?>
								<div class="progress" role="progressbar" aria-label="Radiant Skin Dermatology" aria-valuenow="<?php echo esc_attr($val['team_detail_1_element_feature_number']); ?>" aria-valuemin="0" aria-valuemax="100">
									<div class="progress-bar" style="width: <?php echo esc_attr($val['team_detail_1_element_feature_number'].'%'); ?>"></div>
								</div>
								<?php } ?>
							</div>
							
					<?php } 
					} ?>
			
				
			</div>
		</div>
	</div>
</section>
<?php } ?>