<?php 


$query_args = array(
	'post_type' => 'dz_service',
	'post_status' => 'publish',
	'posts_per_page'    => $service_slider_1_element_no_of_posts,
	'orderby' => $service_slider_1_element_orderby,
	'order' => $service_slider_1_element_order,
	'ignore_sticky_posts' => true,
);



if (!empty($service_slider_1_element_posts_in_categories) && !empty($service_slider_1_element_posts_in_categories[0])) {

	$service_slider_1_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($service_slider_1_element_posts_in_categories, 'service_category');

	$query_args['tax_query'][] = array(
		'taxonomy' => 'service_category',
		'field' => 'id',
		'terms' => $service_slider_1_element_posts_in_categories1,
		'operator' => 'IN'
	);
}
$element_content = !empty($service_slider_1_element_content) ? $service_slider_1_element_content : 'content-inner-2'; 
$element_style = !empty($service_slider_1_element_element_style) ? $service_slider_1_element_element_style : 'style_1'; 
$mb_class = (!empty($service_slider_1_element_btn_text2) && !empty($service_slider_1_element_btn_link2)) ? 'm-b30' : ''; 

$query = new WP_Query($query_args);

if (!empty($query->have_posts())) {

if($element_style == 'style_1'){
?>
	
<section class="<?php echo esc_attr($element_content); ?> bg-light">
	<div class="container">
		<?php if(!empty($service_slider_1_element_title) || !empty($service_slider_1_element_description)){ ?>
		<div class="section-head style-3 m-b30 text-center">
			<?php if(!empty($service_slider_1_element_title)){ ?>
				<h2 class="title"><?php echo wp_kses($service_slider_1_element_title, clinicmaster_allowed_html_tag()); ?></h2>
			<?php } 
			if(!empty($service_slider_1_element_description)){ ?>
				<p class="m-100"><?php echo wp_kses($service_slider_1_element_description,'string'); ?></p>
			<?php } ?>
		</div>
		<?php } ?>
		
		<div class="dz-flex-wrapper <?php echo esc_attr($mb_class); ?> swiper dz-flex-swiper">
			<div class="swiper-wrapper">
				<?php
					$num = 1;
					while ($query->have_posts()) {
						$query->the_post();
						global $post;
						$post_id = $post->ID;
						$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
						$service_author_img = clinicmaster_get_post_meta(get_the_id(), 'service_author_image');
						$service_author_name = clinicmaster_get_post_meta(get_the_id(), 'service_author_name');
						$genaral_available_doctors = clinicmaster_get_post_meta(get_the_id(), 'genaral_available_doctors');
						$post_img = get_the_post_thumbnail_url($post,'medium');
						$active_cla = ($num == 1) ? 'active' : '';
					?>
				<div class="dz-flex-item swiper-slide <?php echo esc_attr($active_cla); ?>">
					<div class="dz-flex-head" 	<?php if(!empty($post_img)){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);"<?php } ?>>
						<a href="<?php  echo esc_url(get_the_permalink($post)); ?>" class="btn btn-square btn-lg btn-white btn-shadow btn-rounded">
							<i class="feather icon-arrow-up-right"></i>
						</a>
						<h3 class="title"><?php echo esc_html($post_title); ?></h3>
					</div>
					<div class="dz-flex-info">
						<div class="dz-flex-inner">
							<div class="dz-media">
								<?php if (has_post_thumbnail()) { ?>
									<?php echo the_post_thumbnail('medium'); ?>
								<?php } ?>
								<?php if(!empty($service_slider_1_element_btn_text) && !empty($service_slider_1_element_btn_link['url'])){
									$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_slider_1_element_btn_link);
									?>
								<a href="<?php echo esc_url($service_slider_1_element_btn_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-primary">
									<i class="feather icon-calendar m-r5"></i>
									<?php echo esc_html($service_slider_1_element_btn_text); ?>
								</a>
								<?php } ?>
							</div>
							<div class="dz-info">
								<div class="dz-info-top">
									<h3 class="dz-title"><?php echo esc_html($post_title); ?></h3>
									<?php echo wp_kses(get_the_excerpt(), clinicmaster_allowed_html_tag()); ?>
								</div>
								<div class="item1">
									<div class="info-widget style-14">
										<div class="info-widget-profile">
											<?php if(!empty($service_author_img['id'])){ ?>
												<div class="widget-media">
													<?php echo wp_get_attachment_image( $service_author_img['id'],'thumbnail');  ?>
													
												</div>
											<?php } ?>
											<div class="widget-content">
											<?php if(!empty($service_author_name)){ ?>
												<h6 class="title mb-0"><?php echo esc_html($service_author_name); ?></h6>
											<?php } ?>
											<?php if(!empty($genaral_available_doctors)){ ?>
												<p class="text mb-0"><?php echo esc_html($genaral_available_doctors); ?></p>
											<?php } ?>
											</div>
										</div>
										<a href="<?php  echo esc_url(get_the_permalink($post)); ?>" class="btn btn-lg btn-square btn-primary rounded-circle">
											<i class="feather icon-arrow-up-right"></i>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>						
				<?php $num++;
				} ?>
			</div>
		</div>
		<?php if(!empty($service_slider_1_element_btn_text2) && !empty($service_slider_1_element_btn_link2['url'])){
				$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_slider_1_element_btn_link2);
			?>
		<div class="dz-separator style-3">
			<a href="<?php echo esc_url($service_slider_1_element_btn_link2['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn separator-badge"><?php echo esc_html($service_slider_1_element_btn_text2); ?></a>
		</div>
		<?php } ?>
	</div>
</section>
<?php 

}elseif($element_style == 'style_2'){ ?>

<section class="<?php echo esc_attr( $element_content); ?> bg-light">
	<div class="container">
		
		
		<div class="row">
			<div class="col-md-5">
				<?php if(!empty($service_slider_1_element_title) || !empty($service_slider_1_element_description)){ ?>
				<div class="section-head style-3 m-b30 text-center">
					<?php if(!empty($service_slider_1_element_title)){ ?>
						<h2 class="title"><?php echo wp_kses($service_slider_1_element_title, clinicmaster_allowed_html_tag()); ?></h2>
					<?php } 
					if(!empty($service_slider_1_element_description)){ ?>
						<p class="m-100"><?php echo wp_kses($service_slider_1_element_description,'string'); ?></p>
					<?php } ?>
				</div>
				<?php } ?>	
				<nav>
				  <div class="nav nav-tabs" id="nav-tab" role="tablist">
					<?php
					$ncount = 1;
					while ($query->have_posts()) {
						$query->the_post();
						global $post;
						$post_id = $post->ID;
						$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
					
						$active_cla = ($ncount == 1) ? 'active' : '';
					?>
						<button class="nav-link <?php echo esc_attr($active_cla); ?>" id="nav-home-tab<?php echo esc_attr($ncount); ?>" data-bs-toggle="tab" data-bs-target="#nav-home<?php echo esc_attr($ncount); ?>" type="button" role="tab" aria-controls="nav-home<?php echo esc_attr($ncount); ?>" aria-selected="true"><?php echo esc_html($post_title);  ?></button>
					<?php $ncount++;
					} ?>
				  </div>
				</nav>
			</div>
			<div class="col-md-7">
				<div class="tab-content" id="nav-tabContent">
					<?php
					$num = 1;
					while ($query->have_posts()) {
						$query->the_post();
						global $post;
						$post_id = $post->ID;
						$post_title = !empty($post->post_title) ? clinicmaster_trim( $post->post_title,7) : '';
						$service_author_img = clinicmaster_get_post_meta(get_the_id(), 'service_author_image');
						$service_author_name = clinicmaster_get_post_meta(get_the_id(), 'service_author_name');
						$genaral_available_doctors = clinicmaster_get_post_meta(get_the_id(), 'genaral_available_doctors');
						$post_img = get_the_post_thumbnail_url($post,'medium');
						$active_cla = ($num == 1) ? 'show active' : 'fade';
					?>
				  <div class="tab-pane fade  <?php echo esc_attr($active_cla); ?>" id="nav-home<?php echo esc_attr($num); ?>" role="tabpanel" aria-labelledby="nav-home-tab<?php echo esc_attr($num); ?>" tabindex="0">
					
						<div class="dz-flex-head" 	<?php if(!empty($post_img)){ ?> style="background-image: url(<?php echo esc_url($post_img); ?>);"<?php } ?>>
							<a href="<?php  echo esc_url(get_the_permalink($post)); ?>" class="btn btn-square btn-lg btn-white btn-shadow btn-rounded">
								<i class="feather icon-arrow-up-right"></i>
							</a>
							<h3 class="title"><?php echo esc_html($post_title); ?></h3>
						</div>
						<div class="dz-flex-info">
							<div class="dz-flex-inner">
								<div class="dz-media">
									<?php if (has_post_thumbnail()) { ?>
										<?php echo the_post_thumbnail('medium'); ?>
									<?php } ?>
									<?php if(!empty($service_slider_1_element_btn_text) && !empty($service_slider_1_element_btn_link['url'])){ 
										$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_slider_1_element_btn_link);
									?>
									<a href="<?php echo esc_url($service_slider_1_element_btn_link['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn btn-primary">
										<i class="feather icon-calendar m-r5"></i>
										<?php echo esc_html($service_slider_1_element_btn_text); ?>
									</a>
									<?php } ?>
								</div>
								<div class="dz-info">
									<div class="dz-info-top">
										<h3 class="dz-title"><?php echo esc_html($post_title); ?></h3>
										<?php echo wp_kses(get_the_excerpt(), clinicmaster_allowed_html_tag()); ?>
									</div>
									<div class="item1">
										<div class="info-widget style-14">
											<div class="info-widget-profile">
												<?php if(!empty($service_author_img['id'])){ ?>
													<div class="widget-media">
														<?php echo wp_get_attachment_image( $service_author_img['id'],'thumbnail');  ?>
														
													</div>
												<?php } ?>
												<div class="widget-content">
												<?php if(!empty($service_author_name)){ ?>
													<h6 class="title mb-0"><?php echo esc_html($service_author_name); ?></h6>
												<?php } ?>
												<?php if(!empty($genaral_available_doctors)){ ?>
													<p class="text mb-0"><?php echo esc_html($genaral_available_doctors); ?></p>
												<?php } ?>
												</div>
											</div>
											<a href="<?php  echo esc_url(get_the_permalink($post)); ?>" class="btn btn-lg btn-square btn-primary rounded-circle">
												<i class="feather icon-arrow-up-right"></i>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php if(!empty($service_slider_1_element_btn_text2) && !empty($service_slider_1_element_btn_link2['url'])){
						$anchor_attribute =  clinicmaster_elementor_get_anchor_attribute($service_slider_1_element_btn_link2);
						?>
							<div class="dz-separator style-3">
								<a href="<?php echo esc_url($service_slider_1_element_btn_link2['url']); ?>" <?php echo esc_attr($anchor_attribute); ?> class="btn separator-badge"><?php echo esc_html($service_slider_1_element_btn_text2); ?></a>
							</div>
						<?php } ?>
					</div>						
				
					<?php $num++;
					} ?>
				 
				</div>
			</div>
		</div>

		
	</div>
</section>


<?php
} 
}
