<?php
// Ensure settings exist
$element_content = !empty($service_listing_2_element_content) ? $service_listing_2_element_content :'content-inner';
?>


<section class="<?php echo esc_attr($element_content); ?> bg-white">
    <div class="container">
        <div class="section-head style-1 m-b30 text-center">
            <?php if (!empty($about_us_2_element_title)) { ?>
                <h2 class="title m-b0"><?php echo ($about_us_2_element_title); ?></h2>
            <?php } ?>
        </div>
        
        <div class="swiper dummy-swiper dummy-wrapper ">
            <div class="swiper-wrapper">
                <?php foreach ($form_fields as $item): ?>
                    <div class="swiper-slide">
                        <?php
                        $button_text = !empty($item['button_text']) ? esc_html($item['button_text']) : 'Default Button';
                        $button_url = !empty($item['button_link']['url']) ? esc_url($item['button_link']['url']) : '#';
                        $background_image = !empty($item['listing_background_image']['url']) 
                            ? esc_url($item['listing_background_image']['url']) 
                            : get_template_directory_uri() . '/wp-content/uploads/2025/04/default.png'; 
                        ?>

                        <div class="dummy-box">
                            <div class="dummy-media">
                                <img src="<?php echo $background_image; ?>" alt="Baby Care Timeline">
                            </div>  
                            <div class="month-number">
                                <?php if (!empty($button_text) && !empty($button_url)) { ?>    
                                    <a href="<?php echo $button_url; ?>" class="timeline-number"><?php echo $button_text; ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>
