<?php
$element_content = !empty($content_box_6_element_content) ? $content_box_6_element_content : 'content-inner-2';
$img_class = !empty($content_box_6_element_img_class) ? $content_box_6_element_img_class : '';
$image_align = !empty($content_box_6_element_image_align) ? $content_box_6_element_image_align : 'left' 
?>
<section class="<?php echo esc_attr($element_content); ?> clearfix">
	<div class="container">
		<div class="row align-items-center">
			<?php if(!empty($content_box_6_element_img['id']) && ($image_align == 'left')){ ?>
				<div class="col-lg-6">
					<div class="dz-media m-b30 me-xl-5 <?php echo esc_attr($img_class); ?>">
						<img src="<?php echo esc_url($content_box_6_element_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
					</div>
				</div>
			<?php } ?>
			<div class="col-lg-6">
				<div class="section-head style-1 m-b30">
					<?php if(!empty($content_box_6_element_title)){ ?>
						<h2 class="title fw-semibold"><?php echo esc_html($content_box_6_element_title); ?></h2>
					<?php }
					if(!empty($content_box_6_element_description)){	?>
						<p class="m-b30"><?php echo wp_kses($content_box_6_element_description,'string'); ?></p>
					<?php }
					if(!empty($content_box_6_element_feature_title)){	?>
						<h3 class="font-28 m-b10"><?php echo esc_html($content_box_6_element_feature_title); ?></h3>
					<?php }
					if(!empty($content_box_6_element_feature_description)){ ?>
						<p><?php echo wp_kses($content_box_6_element_feature_description,'string'); ?></p>
					<?php } ?>
				</div>
			</div>
			<?php if(!empty($content_box_6_element_img['id']) && ($image_align == 'right')){ ?>
				<div class="col-lg-6">
					<div class="dz-media m-b30 me-xl-5 <?php echo esc_attr($img_class); ?>">
						<img src="<?php echo esc_url($content_box_6_element_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</section>