<?php // Admin Page
if( ! class_exists( 'Wp_Admin_Page' ) ){
	class Wp_Admin_Page {
		
		public $ticket_api_url = 'https://support.w3itexperts.com/apis/get-customer-tickets';
		public $product_id = '56013148';
		function __construct(){
			
			add_action( 'after_switch_theme', array( $this, 'clinicmaster_theme_activation_redirect' ) ); 
			
			/* Theme purchase code verification and activation */
			add_action( 'wp_ajax_clinicmaster_theme_verify',   array( $this,'clinicmaster_theme_verification' ) );
			add_action( 'wp_ajax_nopriv_clinicmaster_theme_verify',  array( $this,'clinicmaster_theme_verification' ) );
			/* Create Support Ticket */
			add_action( 'wp_ajax_support_form_action',   array( $this,'support_form_action' ) );
			add_action( 'wp_ajax_nopriv_support_form_action',  array( $this,'support_form_action' ) );
			
			/* User Ticket Reply */
			add_action( 'wp_ajax_submit_user_ticket_reply',   array( $this,'submit_user_ticket_reply' ) );
			add_action( 'wp_ajax_nopriv_submit_user_ticket_reply',  array( $this,'submit_user_ticket_reply' ) );
			
		}
		

		public function support_token_api_call( $api_url, $args ) {
		
			if(empty($api_url)){  return; }
			
			$response         = wp_remote_post( esc_url_raw( $api_url ), $args );	
			$response_code    = wp_remote_retrieve_response_code( $response );
			$response_message = wp_remote_retrieve_response_message( $response );
				
			
			if ( empty( $response_code ) && is_wp_error( $response ) ) {
				return $response;
			} 
			
			if ( 200 !== $response_code && ! empty( $response_message ) ) {
				return new WP_Error( $response_code, $response_message );
			}
			if ( 200 !== $response_code ) {
				return new WP_Error( $response_code, esc_html__( 'An unknown API error occurred.', 'clinicmaster' ) );
			}
			
			$data = wp_remote_retrieve_body( $response ); 
			
			if ( null === $data ) {
				return new WP_Error( 'api_error', esc_html__( 'An unknown API error occurred.', 'clinicmaster' ) );
			} 
			
			$data = json_decode( $data, true );
			return $data;
		}
		
		public function support_form_action(){
			
			$nonce = $_POST['support_form_nonce'];	
			if ( ! wp_verify_nonce( $nonce, 'support_form_action' ) ) {
				wp_die ( esc_html__( 'Busted', 'clinicmaster' ) );
			}
			
			$api_url = 'https://support.w3itexperts.com/apis/save-ticket-responce';
			
			
			$ticket_subject_title = !empty($_POST['ticket_subject_title']) ? sanitize_text_field( $_POST['ticket_subject_title'] ) : '';
			$ticket_subject_id = !empty($_POST['ticket_subject_id']) ? sanitize_text_field( $_POST['ticket_subject_id'] ) : '';
			$ticket_description = !empty($_POST['ticket_description']) ? sanitize_text_field( $_POST['ticket_description'] ) : '';
			$purchase_code = !empty($_POST['purchase_code']) ? sanitize_text_field( $_POST['purchase_code'] ) : '';
		
			if ( empty( $ticket_subject_id ) ) {
				wp_send_json(array( 'error_message' => esc_html__( 'Ticket Subject is required.', 'clinicmaster' ) ));
			}
			
			if ( empty( $ticket_description ) ) {
				wp_send_json(array( 'error_message' => esc_html__( 'Description is required.', 'clinicmaster' ) ));
			}
			
			if ( empty( $purchase_code ) ) {
				wp_send_json(array( 'error_message' => esc_html__( 'Verify Your Purchase code.', 'clinicmaster' ) ));
			}
			
			$args = array(
				//'sslverify' => false,
				'body'       => array(
					'product_id'		 => $this->product_id,
					'purchase_code'	     => $purchase_code,
					'description' 		 => $ticket_description,
					'ticket_subject_id'  => $ticket_subject_id,
					'title'          	 => $ticket_subject_title,
					'domain_name'        => $_SERVER['HTTP_HOST'], 
					
				)
			);
			
			if ( isset( $_FILES['support_image'] ) && ! empty( $_FILES['support_image']['name'][0] ) ) {
				$args['body']['image'] = $_FILES['support_image'];
			}
			
			
			$data = $this->support_token_api_call($api_url, $args);
			
			
			if( isset( $data['status'] ) && ( $data['status'] == true )) {
				//update_option( 'verified_code', $purchase_code );
				wp_send_json(array( 
					'status' => 'success',
					'message' => $data['message'],
					'url' => admin_url( 'admin.php?page=dz-my-ticket' ),
					)
				);
			}else{
				wp_send_json( array( 
						'status' => $data['status'], 
						'error_message' => $data['message'], 
					)
				);
			}
			wp_die('finshed');
			
		}
		
		public function submit_user_ticket_reply() {
			
			$nonce = $_POST['submit_user_ticket_reply_nonce'];	
			
			if ( ! wp_verify_nonce( $nonce, 'submit_user_ticket_reply' ) ) {
				wp_die ( esc_html__( 'Busted', 'clinicmaster' ) );
			}
			
			$api_url = 'https://support.w3itexperts.com/apis/submit-ticket-reply';
			
			$ticket_reply = !empty($_POST['ticket_reply']) ? esc_html( $_POST['ticket_reply'] ) : '';
			if ( empty( $ticket_reply ) ) {
				wp_send_json( array( 'error_message' => esc_html__( 'Description is required.', 'clinicmaster' ) ));
			}
			
			$user_id = !empty($_POST['user_id']) ? sanitize_text_field($_POST['user_id']) : '';
			$status = !empty($_POST['status']) ? sanitize_text_field($_POST['status']) : '';
			$type = !empty($_POST['type']) ? sanitize_text_field($_POST['type']) : '';
			$ticket_id = !empty($_POST['ticket_id']) ? sanitize_text_field($_POST['ticket_id']) : '';

			
			// Prepare API request body
			$body = [
				'product_id'	=> $this->product_id,
				'ticket_reply' => $ticket_reply,
				'user_id'      => $user_id,
				'status'       => $status,
				'type'         => $type,
				'ticket_id'    => $ticket_id,
			];
			
			if (isset($_FILES['ticket_reply_attach']) && !empty($_FILES['ticket_reply_attach']['name'][0])) {
				$body['ticket_reply_attach'] = $_FILES['ticket_reply_attach'];
			} 
			
			$args = [
				'headers'   => [
						'Content-Type' => 'application/x-www-form-urlencoded',
					],
				'body'    => $body,
			];
			
			$data = $this->support_token_api_call($api_url, $args);
			if( isset( $data['status'] ) && ( $data['status'] == true )) {
				wp_send_json( array( 
					'status' => 'success',
					'message' => $data['message'],
					)
				);
			}else{
				wp_send_json( array( 
					'status' => $data['status'], 
					'error_message' => $data['message'], 
					)
				);
			}
			wp_die('finshed');
		}
		
		public function get_user_ticket() {
			$purchase_code = get_option( 'verified_code' );
			$args = array(
				//'sslverify' => false,
				'body'       => array(
					'purchase_code'	     => $purchase_code,
					'domain_name'        => $_SERVER['HTTP_HOST'],
					
				)
			);
			
			if(!empty($_GET['id']) && !empty($_GET['user_id'])){
				$ticket_id = $_GET['id'];
				$user_id = $_GET['user_id'];
				 $this->ticket_api_url = 'https://support.w3itexperts.com/apis/get-customer-ticket-detail';
				
				$args['body']['ticket_id'] = $ticket_id;
				$args['body']['user_id'] = $user_id;
				$args['body']['product_id'] = $this->product_id; 
			}
			return $this->support_token_api_call($this->ticket_api_url, $args);
			
		}	
		

		public function clinicmaster_theme_verification(){
			
		
			$nonce = $_POST['dexignzone_verify_nonce'];	
			if ( ! wp_verify_nonce( $nonce, 'clinicmaster_theme_verify^%&^%' ) ) {
				wp_die ( esc_html__( 'Busted', 'clinicmaster' ) );
			}		
			require_once( CLINICMASTER_ROOT . 'dz-inc/admin/templates/token_verification.php' );
			$verfy_obj = new DexignZone_Purchase_Code_Verification();
			$status = $verfy_obj->verify_token();
			wp_send_json($status);
			
			wp_die('finshed');
		}
		
		
		
		public function clinicmaster_theme_activation_redirect(){
			
			if( isset( $_GET['activated'] ) ) {
				if ( wp_redirect( admin_url( 'admin.php?page=dz-theme-verification' ) ) ) {
					exit;
				}
			}
		}
	
	}
	new Wp_Admin_Page();
}
