<?php $purchase_code = get_option( 'verified_code' ); 
	$theme = wp_get_theme();
	$text_domain = sanitize_text_field( $theme->get( 'TextDomain' ) ); 
?>
<div class="wrap welcome-wrap dz-wrap">
	<div class="dz-welcome-inner">
		<nav class="dz-nav-tab-wrapper nav-tab-wrapper">
			<a class="nav-tab " href="<?php echo admin_url( 'admin.php?page='.$text_domain ); ?>">
				<?php echo esc_html__( 'Introduction', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab" href="<?php echo admin_url( 'admin.php?page=dz-plugins' ) ?>">
				<?php echo esc_html__( 'Plugins', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab" href="<?php echo admin_url( 'admin.php?page=dz-system-status' ) ?>">
				<?php echo esc_html__( 'System Status', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab " href="<?php echo admin_url( 'admin.php?page=dz-theme-verification' ) ?>">
				<?php echo esc_html__( 'Theme Verification', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab nav-tab-active" href="<?php echo admin_url( 'admin.php?page=dz-support-ticket' ) ?>">
				<?php echo esc_html__( 'Support Ticket', 'clinicmaster' ); ?>
			</a>
			<a class="nav-tab " href="<?php echo admin_url( 'admin.php?page=dz-my-ticket' ) ?>">
				<?php echo esc_html__( 'My Tickets', 'clinicmaster' ); ?>
			</a>
		</nav>
	</div>
	<div class="dz-demo-wrapper ">
		<div class="feature-section theme-browser rendered">
			<div class="dexignzone-envato-support-form-wrap">
				<h3><?php esc_html_e('Support Ticket', 'clinicmaster'); ?></h3>
				<form id="dexignzone-envato-support-form" class="dexignzone-envato-support-form" enctype="multipart/form-data">
					<?php wp_nonce_field('support_form_action', 'support_form_nonce'); ?>
					<div class="form-fields">
						<div class="dexignzone-input-group">
							<select id="ticket_subject_id" name="ticket_subject_id">
								<option value=""><?php esc_html_e('Select Ticket Subject', 'clinicmaster'); ?></option>
								<option value="1"><?php echo esc_html__('Request for demo images', 'clinicmaster'); ?></option>
								<option value="2" ><?php echo esc_html__('Responsive issue', 'clinicmaster'); ?></option>
								<option value="3"><?php echo esc_html__('Design / Setup issue', 'clinicmaster'); ?></option>
								<option value="4" ><?php echo esc_html__('I want custom work - Paid', 'clinicmaster'); ?></option>
								<option value="5" ><?php echo esc_html__('Wrong purchase, want to replace with ...', 'clinicmaster'); ?></option>
								<option value="6" ><?php echo esc_html__('Request for WP Theme Setup on customer server', 'clinicmaster'); ?></option>
								<option value="7"><?php echo esc_html__('Installation Issue', 'clinicmaster'); ?></option>
								<option value="8"><?php echo esc_html__('Not Satisfied, Missing Pages/Functionality, Buggy', 'clinicmaster'); ?></option>
								<option value="9"><?php echo esc_html__('New Project Requirements', 'clinicmaster'); ?></option>
								<option value="10"><?php echo esc_html__('Improvement Suggestions', 'clinicmaster'); ?></option>
							</select>
							<input type="hidden" name="purchase_code" value="<?php echo esc_attr($purchase_code); ?>">
							<input type="hidden" id="ticket_subject_title" name="ticket_subject_title" value="Request for demo images">
							<input type="hidden"  name="action" value="support_form_action">
							<textarea name="ticket_description" id="ticket_description"  rows="5" cols="72" placeholder="<?php esc_attr_e( 'Enter your Description', 'clinicmaster' ); ?>"></textarea>
							<!-- Image Upload -->
							<!--<div class="image-field">
								<input multiple="" accept=".xls,.xlt,.xlm,.xlsx,.xlsm,.xltx,.xltm,.xlsb,.xla,.xlam,.xll,.xlw,.csv,.doc,.dot,.wbk,.docx,.docm,.dotx,.dotm,.docb,.txt,.jpg,.jpeg,.gif,.png,.jpe,.jif,.jfif,.jfi,.webp,.tiff,.tif,.psd,.svg,.svgz,.psd,.mp4,.mov,.wmv,.flv,.avi,.avchd,.webm,.mkv,.f4v,.swf,.mpeg-2,.mpg,.mp2,.mpeg,.mpe,.mpv,.ogg,.m4p,.m4v,.pdf,.zip" name="support_image[]" type="file" width="48" height="48">
							</div>-->
						</div>
						<div class="submit-group">
							<button type="submit" class="dz-btn-submit"><?php echo esc_html__('Submit', 'clinicmaster'); ?>
								<span class="process-loader"><img src="<?php echo esc_url( CLINICMASTER_URL . 'dz-inc/admin/images/loader.gif' ); ?>" alt="<?php esc_attr_e( 'Loader', 'clinicmaster' ) ?>" /></span>
							</button>
						</div>
					</div>
					<div class="verfication-alert text-center"><span class="verfication-txt"></span></div>
				</form>
			</div>
		</div>
	</div>
</div>
