<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner5 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-5';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 5',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster-banner' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);


		
		$this->add_control(
			'home_banner_5_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Skincare is Like A Workout For Your Skin', DZ_TH_DOMAIN ),
			]
		);
 
       
        $this->add_control(
			'home_banner_5_element_subtitle',
			[
				'label' 		=> esc_html__( 'SubTitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 => esc_html__( 'Gynecology', DZ_TH_DOMAIN ),

			]
		);
		
		 
		
		
		$this->add_control(
			'home_banner_5_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Experienced staff is dedicated to improving our patients’ dental health and enhancing', DZ_TH_DOMAIN ),
			]
		);

	

		$this->add_control(
			'home_banner_5_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
			);


		$this->add_control(
			'home_banner_5_element_social',
			[
				'label' => esc_html__( 'Show Social', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'home_banner_5_element_fun_fact',
			[
				'label' 		=> esc_html__( 'Fun Fact Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'LET’S TALK', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_5_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_5_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'home_banner_5_element_youtube_taxt',
			[
				'label' 		=> esc_html__( 'YouTube Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'More Collection Explore', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_5_element_youtube_link',
			[
				'label' 		=> esc_html__( 'YouTube Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
				'default'   => 'https://www.youtube.com/watch?v=YwYoyQ1JdpQ',
			]
		);
		
		$this->end_controls_section();
		
	





	
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_5_element.php',$settings);
				echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleTextChar();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}