<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox8 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-8';
	}
	
	public function get_title() {
		return esc_html__('Content Box 8',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'content_box_8_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dental Implants', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'content_box_8_element_item_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => '<p>'.esc_html__( 'Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry1s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', DZ_TH_DOMAIN ).'</p><p>'.esc_html__( 'Standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ', DZ_TH_DOMAIN ).'</p>',
			]
		);
		
		
		
		
		$repeater->add_control(
			'content_box_8_element_item_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'content_box_8_element_item_align',
			[
				'label' => esc_html__( 'Image Position', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-left',
					],
					
					'right' => [
						'title' => esc_html__( 'Right', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				
			]
		);
		$repeater->add_control(
			'content_box_8_element_item_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'View All Details ', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'content_box_8_element_item_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		
		
		$this->add_control(
			'content_box_8_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'content_box_8_element_item_title' 		=> esc_html__( 'Dental Implants', DZ_TH_DOMAIN ),
						'content_box_8_element_item_description' 	=> '<p>'.esc_html__( 'Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry1s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', DZ_TH_DOMAIN ).'</p><p>'.esc_html__( 'Standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ', DZ_TH_DOMAIN ).'</p>',
						'content_box_8_element_item_button_text' 		=> esc_html__( 'View All Details ', DZ_TH_DOMAIN ),
						'content_box_8_element_item_align' => 'right',
						'content_box_8_element_item_button_link' => '',
						
					],
					[	
						'contact_box_4_element_item_title' 		=> esc_html__( 'Orthodontics', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> '<p>'.esc_html__( 'Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry1s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', DZ_TH_DOMAIN ).'</p><p>'.esc_html__( 'Standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ', DZ_TH_DOMAIN ).'</p>',
						'content_box_8_element_item_button_text' 		=> esc_html__( 'View All Details ', DZ_TH_DOMAIN ),
						'content_box_8_element_item_align' => 'left',
						'content_box_8_element_item_button_link' => '',
					],
					[
						'contact_box_4_element_item_title' 		=> esc_html__( 'Pediatric Dentistry', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> '<p>'.esc_html__( 'Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry1s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', DZ_TH_DOMAIN ).'</p><p>'.esc_html__( 'Standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ', DZ_TH_DOMAIN ).'</p>',
						'content_box_8_element_item_button_text' 		=> esc_html__( 'View All Details ', DZ_TH_DOMAIN ),
						'content_box_8_element_item_align' => 'right',
						'content_box_8_element_item_button_link' => '',
					],
					[
						'contact_box_4_element_item_title' 		=> esc_html__( 'Root Canals', DZ_TH_DOMAIN ),
						'contact_box_4_element_item_description' 	=> '<p>'.esc_html__( 'Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry1s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', DZ_TH_DOMAIN ).'</p><p>'.esc_html__( 'Standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ', DZ_TH_DOMAIN ).'</p>',
						'content_box_8_element_item_button_text' 		=> esc_html__( 'View All Details ', DZ_TH_DOMAIN ),
						'content_box_8_element_item_align' => 'left',
						'content_box_8_element_item_button_link' => '',
					],
				],
			]
		);
		
		$this->end_controls_section();
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_8_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}