<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContactBox3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-box-3';
	}
	
	public function get_title() {
		return esc_html__('Contact Box 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-inner-section';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_3_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'why choose us', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'contact_box_3_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_3_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'contact_box_3_element_video_img',
			[
				'label' 		=> esc_html__( 'Vidio call Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'contact_box_3_element_video_icon',
			[
				'label' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::ICONS,
				
			]
		);
		$this->add_control(
			'contact_box_3_element_video_title',
			[
				'label' 		=> esc_html__( 'Viteo Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Video Call Support', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_3_element_contact_us',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
				
			]
		);
	
		$this->add_control(
			'contact_box_3_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_3_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'default' 	=> [],
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
	
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'contact_box_3_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Comprehensive Specialties', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'contact_box_3_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Comprehensive Specialties', DZ_TH_DOMAIN ),
					],	
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Research and Development', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Emergency Services', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Advanced Imaging Services', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Intensive Care Units (ICUs)', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Rehabilitation Services', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Telemedicine Facilities', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Patient-Centric Approach', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Multidisciplinary Team', DZ_TH_DOMAIN ),
					],
					[	
						'contact_box_3_element_item_title' 		=> esc_html__( 'Health Information Technology', DZ_TH_DOMAIN ),
					],
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
			
		$this->add_control(
			'contact_box_3_element_rating_number',
			[
				'label' => esc_html__( 'Rating Number', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'step' => 1,
				'default' => 5,
			]
		);
		$this->add_control(
			'contact_box_3_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_3_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text' , DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_3_element_google_img',
			[
				'label' 		=> esc_html__( 'Google Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'contact_box_3_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_box_3_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}