<?php 
function dz_seo_fields($SeoFields){
	
			$SeoFields[] = array(
				'id' => 'meta_title',
				'type' => 'text',
				'title' => esc_html__('Meta Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text:  <title>This is the meta title tag. It can be 5-10 characters long</title>', DZ_TH_DOMAIN),
				 
			);
			$SeoFields[] = array(
				'id' => 'meta_description',
				'type' => 'textarea',
				'title' => esc_html__('Meta Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta name="description" content="This is the meta description. The maximum length is somewhere around 150-160 characters, but Google often pulls a description from your page content." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				
			);
			$SeoFields[] = array(
				'id' => 'keywords',
				'type' => 'textarea',
				'title' => esc_html__('Meta Keywords', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The keyword tag used to be one of the most essential SEO meta tags, as primitive search engines used this as the central feature for search result rankings.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="keywords" content="keyword 1, keyword 2, keyword 3"/>', DZ_TH_DOMAIN),	 
			);
			$SeoFields[] = array(
				'id' => 'author',
				'type' => 'text',
				'title' => esc_html__('Site Author', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The “Author” and “Copyright” meta tags can be found in the source code of an HTML page. They are used to record information such as who built the corresponding website and who copyright ownership belongs to.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="author" content="Author name" />', DZ_TH_DOMAIN),	 
				'default' => dz_get_current_user(),
			);
			
			$SeoFields[] = array(
				'id' => 'open-graph-tags-facebook',
				'type' => 'section',
				'title' => esc_html__('Open Graph Tags - Facebook', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The Open Graph protocol enables any web page to become a rich object in a social graph. For instance, this is used on Facebook to allow any web page to have the same functionality as any other object on Facebook.', DZ_TH_DOMAIN) ,
				'indent' => true
			);
			$SeoFields[] = array(
				'id' => 'og_title',
				'type' => 'text',
				'title' => esc_html__('Og Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:title" content="The Rock" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Add it to all shareable pages.').'<br><br>'.
									 esc_html__('2.	Focus on accuracy, value, and clickability.').'<br><br>'.
									 esc_html__('3.	Keep it short to prevent overflow. There’s no official guidance on this, but 40 characters for mobile and 60 for desktop is roughly the sweet spot.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('4. Use the raw title. Don’t include branding (e.g., your site name).', DZ_TH_DOMAIN)
					),
				 
			);
			$SeoFields[] = array(
				'id' => 'og_description',
				'type' => 'textarea',
				'title' => esc_html__('Og Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:description" content="Learn about 13 features that set Ahrefs apart from the competition." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Complement the title to make the snippet as appealing and click-worthy as possible.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('2.	Copy your meta description here if it makes sense.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('3. Keep it short and sweet. Facebook recommends 2-4 sentences, but that often truncates.',DZ_TH_DOMAIN)				
					),
			);
			$SeoFields[] = array(
				'id' => 'og_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Og Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <metaproperty="og:image"content="https://ahrefs.com/blog/wp-content/uploads/2020/01/fb-open-graph-1.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => get_template_directory_uri() . '/assets/images/social-image.png'
				),
				'hint' => array(
						'content' => esc_html__('1. Use custom images for shareable pages (e.g., homepage, articles, etc.)',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Use your logo or any other branded image for the rest of your pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	se images with a 1.91:1 ratio and minimum recommended dimensions of 1200x630 for optimal clarity across all devices.',DZ_TH_DOMAIN)
									
					),
				
			);
			$SeoFields[] = array(
				'id' => 'og_url',
				'type' => 'text',
				'title' => esc_html__('Og Url', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The canonical URL of your object that will be used as its permanent ID in the graph, e.g., "https://www.imdb.com/title/tt0117500/".', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:url" content="https://www.imdb.com/title/tt0117500/" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('The canonical URL for your page. This should be the undecorated URL, without session variables, user identifying parameters, or counters.',DZ_TH_DOMAIN)			
					),
				 
			);
			$SeoFields[] = array(
				'id' => 'og_type',
				'type' => 'select',
				'title' => esc_html__('Og type', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The type of object you’re sharing. (e.g., article, website, etc.)', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:type" content="article" />', DZ_TH_DOMAIN),
				'options' => dz_site_type_option(),
				'default' => 'website',
				'hint' => array(
						'title' => esc_html__('Status', DZ_TH_DOMAIN) ,
						'content' => esc_html__('1. website: Represents a general website.', DZ_TH_DOMAIN) . '<br><br>' . esc_html__('2. article: Represents a specific article or blog post.', DZ_TH_DOMAIN) . '<br><br>' . esc_html__('3. video: Represents a video content page.', DZ_TH_DOMAIN) . '<br><br> ' . esc_html__(' 4. music.song: Represents a song..', DZ_TH_DOMAIN). '<br><br> ' . esc_html__('5. product: Represents a product for sale.', DZ_TH_DOMAIN). '<br><br> ' . esc_html__('6. profile: Represents a person or entity s profile.', DZ_TH_DOMAIN)
					),
			);
			$SeoFields[] = array(
				'id' => 'og_audio',
				'type' => 'text',
				'title' => esc_html__('Og Audio', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A URL to an audio file to accompany this object.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:audio" content="https://example.com/bond/theme.mp3" />', DZ_TH_DOMAIN),	 
			);
			
			$SeoFields[] = array(
				'id' => 'og_locale',
				'type' => 'text',
				'title' => esc_html__('Og Locale', DZ_TH_DOMAIN) ,
				'default' => dz_get_locale(),
				'subtitle' => esc_html__('Defines the content language.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:locale" content="en_GB" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Use only for content not written in American English (en_US). Facebook assumes content without this tag is written in this language.',DZ_TH_DOMAIN)			
					), 
			);
			$SeoFields[] = array(
				'id' => 'og_site_name',
				'type' => 'text',
				'title' => esc_html__('Og Site Name', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('If your object is part of a larger web site, the name which should be displayed for the overall site.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:site_name" content="IMDb" />', DZ_TH_DOMAIN),	 
			);
			$SeoFields[] = array(
				'id' => 'og_video ',
				'type' => 'text',
				'title' => esc_html__('Og Video', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A URL to a video file that complements this object.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:video" content="https://example.com/bond/trailer.swf" />', DZ_TH_DOMAIN),	 
			);
           
			$SeoFields[] =	array(
				'id' => 'open-graph-tags-facebook-end',
				'type' => 'section',
				'indent' => false,
			);
			
			$SeoFields[] =	array(
				'id' => 'twitter-meta-tags',
				'type' => 'section',
				'title' => esc_html__('Twitter Meta Tags', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('To customize the appearance of your post specifically for Twitter, please fill out the "Twitter appearance" settings below. If you leave these settings untouched, the "Social media appearance" settings mentioned above will also be applied for sharing on Twitter.', DZ_TH_DOMAIN) ,
				'indent' => true
			);
			
			$SeoFields[] = array(
				'id' => 'twitter_title',
				'type' => 'text',
				'title' => esc_html__('Twitter Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="twitter:title" content="Sammy the Shark" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('twitter:title: the title you’d like used in the card. This could match what you’ve put in your <title> tags, but it doesn’t have to.',DZ_TH_DOMAIN)
					),
				 
			);
			$SeoFields[] = array(
				'id' => 'twitter_site',
				'type' => 'text',
				'title' => esc_html__('Twitter Site', DZ_TH_DOMAIN) ,
				'default' => esc_html__('@digitalocean', DZ_TH_DOMAIN),
				'desc' => esc_html__('help text: <meta name="twitter:site" content="@digitalocean" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('twitter:site: your Twitter username, or your site or company’s username.',DZ_TH_DOMAIN)
					),
				 
			);
			$SeoFields[] = array(
				'id' => 'twitter_description',
				'type' => 'textarea',
				'title' => esc_html__('Twitter Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta name="twitter:description" content="Senior Selachimorpha at DigitalOcean" />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('twitter:description: a brief description of the page that will be displayed under the title. This should be a maximum of 200 characters, and may be truncated even further when displayed.',DZ_TH_DOMAIN)
					),
			);
			$SeoFields[] = array(
				'id' => 'twitter_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Twitter Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta name="twitter:image" content="https://html.sammy-codes.com/images/large-profile.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => get_template_directory_uri() . '/assets/images/social-image.png'
				),
				'hint' => array(
						'content' => esc_html__('twitter:image: an image to show. Most standard image formats (JPG, PNG, GIF) are acceptable, but it must be less than 5MB in size. The image may be automatically cropped to display in differently sized cards, so it is a good idea to have the main focal point in the center.',DZ_TH_DOMAIN)				
					),
				
			);
					
			$SeoFields[] = array(
				'id' => 'twitter_card',
				'type' => 'select',
				'title' => esc_html__('Twitter Card', DZ_TH_DOMAIN) ,
				'options' => dz_twitter_card_option(),
				'default' => 'summary',
				'desc' => esc_html__('help text : <meta name="twitter:card" content="summary_large_image" />', DZ_TH_DOMAIN),
				'hint' => array(
						'title' => esc_html__('Status', DZ_TH_DOMAIN) ,
						'content' => esc_html__('1. summary: This is the default card type. It displays a title, description, and thumbnail image from the web page when shared on Twitter.', DZ_TH_DOMAIN) . '<br><br>' . esc_html__('2. app: Used for representing mobile applications. It displays the app s icon, name, and a call-to-action button for downloading the app.', DZ_TH_DOMAIN) . '<br><br>' . esc_html__('3. player: Used for video content. It includes a video player in the tweet with an optional title and description.', DZ_TH_DOMAIN) . '<br><br> ' . esc_html__(' 4. product: Used for displaying product information. It includes details like the product name, price, and availability.', DZ_TH_DOMAIN). '<br><br> ' . esc_html__('5. summary_large_image: Similar to the "summary" card but allows for a larger featured image.', DZ_TH_DOMAIN)
					),
			); 
			
			$SeoFields[] =	array(
				'id' => 'twitter-meta-tags-end',
				'type' => 'section',
				'indent' => false,
			);
			
			
			$SeoFields[] =	array(
				'id' => 'varification-code',
				'type' => 'section',
				'subtitle' => esc_html__('Verify your site with different tools. This will add a verification meta tag to your homepage. You can find instructions on how to verify your site for each platform by following the link in the description.', DZ_TH_DOMAIN) ,
				'title' => esc_html__('Varification Code', DZ_TH_DOMAIN) ,
				'indent' => true
			);
			$SeoFields[] = array(
				'id' => 'ahrefs_site_verification',
				'type' => 'text',
				'title' => esc_html__('Ahrefs', DZ_TH_DOMAIN) ,
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('More Details: ', DZ_TH_DOMAIN).'<a href="https://ahrefs.com/website-checker" target="_blank" rel="noopener noreferrer">https://ahrefs.com/website-checker</a>.' ,
				'hint' => array(
						'title' => esc_html__('Status', DZ_TH_DOMAIN) ,
						'content' => esc_html__('1. URL : https://ahrefs.com/website-checker', DZ_TH_DOMAIN) 
					),
			);
			$SeoFields[] = array(
				'id' => 'baidu_site_verification',
				'type' => 'text',
				'title' => esc_html__('Baidu', DZ_TH_DOMAIN) ,
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Get your verification code in ', DZ_TH_DOMAIN).'<a href="https://ziyuan.baidu.com/site" target="_blank" rel="noopener noreferrer">'.esc_html__(' Baidu Webmaster tools.', DZ_TH_DOMAIN).'</a>',
			);
			$SeoFields[] = array(
				'id' => 'bing_site_verification',
				'type' => 'text',
				'title' => esc_html__('Bing', DZ_TH_DOMAIN),
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Get your verification code in ', DZ_TH_DOMAIN).'<a href="https://www.bing.com/webmasters/home" target="_blank" rel="noopener noreferrer">'.esc_html__(' Bing Webmaster tools.', DZ_TH_DOMAIN).'</a>',
				
			);
			$SeoFields[] = array(
				'id' => 'dmca_site_verification',
				'type' => 'text',
				'title' => esc_html__('Dmca', DZ_TH_DOMAIN) ,
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Get your verification code in ', DZ_TH_DOMAIN).'<a href="https://www.dmca.com/" target="_blank" rel="noopener noreferrer">'.esc_html__(' Dmca Webmaster tools.', DZ_TH_DOMAIN).'</a>',
				
			);
			$SeoFields[] = array(
				'id' => 'facebook_domain_verification',
				'type' => 'text',
				'title' => esc_html__('Facebook', DZ_TH_DOMAIN),
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Get your verification code in ', DZ_TH_DOMAIN).'<a href="https://developers.facebook.com/docs/sharing/domain-verification/verifying-your-domain/" target="_blank" rel="noopener noreferrer">'.esc_html__(' Facebook Webmaster tools.', DZ_TH_DOMAIN).'</a>',
				
			);
			$SeoFields[] = array(
				'id' => 'google_site_verification',
				'type' => 'text',
				'title' => esc_html__('Google', DZ_TH_DOMAIN),
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Get your verification code in ', DZ_TH_DOMAIN).'<a href="https://search.google.com/search-console/users?hl=en&amp;tid=alternate&amp;siteUrl=https%3A%2F%2Fnitesh-pc%2Frnd%2Fpowerzone" target="_blank" rel="noopener noreferrer">'.esc_html__('Google Search console', DZ_TH_DOMAIN).'</a>',
				
			);
			$SeoFields[] = array(
				'id' => 'pinterest_site_verification',
				'type' => 'text',
				'title' => esc_html__('Pinterest', DZ_TH_DOMAIN) ,
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Claim your site over at ', DZ_TH_DOMAIN).'<a href="https://www.pinterest.com/settings/claim" target="_blank" rel="noopener noreferrer">'.esc_html__(' Pinterest', DZ_TH_DOMAIN).'</a>',
			);
			
			$SeoFields[] = array(
				'id' => 'yandex_site_verification',
				'type' => 'text',
				'title' => esc_html__('Yandex', DZ_TH_DOMAIN) ,
				'placeholder' =>  esc_html__('Add Verification Code', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('Yandex Webmaster tools. ', DZ_TH_DOMAIN).'<a href="https://webmaster.yandex.com/sites/add/" target="_blank" rel="noopener noreferrer">'.esc_html__(' Yandex Webmaster tools. ', DZ_TH_DOMAIN).'</a>',
			);
			
			$SeoFields[] =	array(
				'id' => 'varification-code-end',
				'type' => 'section',
				'indent' => false,
			);
			
	return $SeoFields;
} 
add_filter('dzcore_seo_fields','dz_seo_fields');	



function dz_site_type_option(){
	$output = array(
			'website'	=> esc_html__('Website',DZ_TH_DOMAIN), 
		    'article'	=> esc_html__('Article',DZ_TH_DOMAIN),
			'video' 	=> esc_html__('Video',DZ_TH_DOMAIN),
			'music.song'=> esc_html__('Music.song',DZ_TH_DOMAIN),
			'product'	=> esc_html__('Product',DZ_TH_DOMAIN),
            'profile'	=> esc_html__('Profile',DZ_TH_DOMAIN),
		);
	return $output;
}

function dz_twitter_card_option(){
	$output = array(
			'summary'	=> esc_html__('Summary',DZ_TH_DOMAIN), 
		    'app'		=> esc_html__('App',DZ_TH_DOMAIN),
			'video' 	=> esc_html__('Video',DZ_TH_DOMAIN),
			'player'	=> esc_html__('Player',DZ_TH_DOMAIN),
			'product'	=> esc_html__('Product',DZ_TH_DOMAIN),
            'summary_large_image'	=> esc_html__('Summary Large Image',DZ_TH_DOMAIN),
		);
	return $output;
}
function dz_get_current_user($key = null, $default = false){
	$output = '';
	if(is_user_logged_in()){
		$current_uesr = wp_get_current_user();
		if(!empty($key)){
			$output = $current_uesr->data->$key;
		}else if($default == true){
			$output = $current_uesr->data;
		}else{
			$output = $current_uesr->data->display_name;
		}
	}
	return $output;
}
function dz_get_locale(){
	$locale = get_locale();
	return $locale ;
}



function get_seo_meta_value_args(){
	
	$metas = array(
				array(
					'label'=>'itemprop',
					'value'=>'name',
					'content'=>'',
				),
				array(
					'label'=>'itemprop',
					'value'=>'description',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'keywords',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'author',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_title',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_description',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_image',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_url',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_type',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_audio',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_locale',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'site_name',
					'content'=>'',
				),
				array(
					'label'=>'property',
					'value'=>'og_video',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'twitter_title',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'twitter_site',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'twitter_description',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'twitter_image',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'twitter_card',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'ahrefs_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'baidu_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'bing_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'dmca_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'facebook_domain_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'google_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'pinterest_site_verification',
					'content'=>'',
				),
				array(
					'label'=>'name',
					'value'=>'yandex_site_verification',
					'content'=>'',
				),
			);
	if(is_page() || is_singular()){
		$post_id = get_the_ID();
		$type = 'page';
		if(is_single()){
			$type = 'post';
		}else if(is_singular('dz_portfolio')){
			$type = 'cpt_portfolio';
		}else if(is_singular('dz_team')){
			$type = 'cpt_team';
		}else if(is_singular('dz_service')){
			$type = 'cpt_service';
		}else if(is_singular('dz_faq')){
			$type = 'cpt_faq';
		}else if(is_singular('dz_testimonial')){
			$type = 'cpt_testimonial';
		}
		$post_data = dz_get_post_meta($post_id,
						array(
							$type.'_social_keywords',
							$type.'_social_author',
							$type.'_social_title',
							$type.'_social_description',
							$type.'_social_image'
						)
					);
		
		if(!empty($post_data[$type.'_social_keywords'])){
			$metas[2]['content'] = $post_data[$type.'_social_keywords'];
		}
		if(!empty($post_data[$type.'_social_author'])){
			$metas[3]['content'] = $post_data[$type.'_social_author'];
		}
		if(!empty($post_data[$type.'_social_title'])){
			$metas[4]['content'] = $post_data[$type.'_social_title'];
			$metas[13]['content'] = $post_data[$type.'_social_title'];
		}
		if(!empty($post_data[$type.'_social_description'])){
			$metas[5]['content'] = $post_data[$type.'_social_description'];
			$metas[15]['content'] = $post_data[$type.'_social_description'];
		}
		if(!empty($post_data[$type.'_social_image'])){
			if(is_serialized($post_data[$type.'_social_image'])){
				$image = unserialize($post_data[$type.'_social_image']);
			}else{
				$image = $post_data[$type.'_social_image'];
			}
			
			if(!empty($image['url'])){
				$metas[6]['content'] = ['url'=>$image['url']];
				$metas[16]['content'] = ['url'=>$image['url']];
			}
		}
		
	} 
	$options =array();
	$theme_options = dexignzone_dzbase()->option();		
	$content = '';
	foreach($metas as $key => $value){
		
		if(!empty($value['content'])){
			$content = $value['content'];
		}else{
			$content = dz_set($theme_options, $value['value']);
			if(!empty($content['url'])){
				$content = $content['url'];
			}
		}
		//pr(trim($content));
	//	$cont = $content);
		
		$name = str_replace("_",":",$value['value']);
		if(!empty($content)){
			$options[] = array(
				'label' => $value['label'],
				'value' => $name,
				'content' => $content,
				); 
		}
	}
	
	return 	$options;
}

/* Get Post Meta Data */
 function dz_get_post_meta( $post_id, $meta_key ) 
{
	if(is_array($meta_key)){
		$post_meta_data = array();
		$meta_data = get_post_meta($post_id);
		
		foreach($meta_key as $field_key){
			if(!empty($meta_data[$field_key])){
				if(count($meta_data[$field_key]) == 1){
					$post_meta_data[$field_key] = $meta_data[$field_key][0];	
				}else{
					$post_meta_data[$field_key] = $meta_data[$field_key];
				}
				
			}	
		}
		
		return $post_meta_data;
	}else{
		$value = get_post_meta($post_id,$meta_key);
		$value = !empty($value[0])?$value[0]:'';
		return $value;	
	}
	
}



function dz_page_options_register($metabox)
{
	$post_thumbnail_url = '';
	if(is_admin() && !empty($_GET['post'])){
		$post_id = $_GET['post'];
		$post_thumbnail_id = get_post_thumbnail_id($post_id);
		$post_thumbnail_url = wp_get_attachment_image_url( $post_thumbnail_id, 'large' );
	}
	
	$metabox->add_section('page', array(
        'title' => esc_html__('SEO Meta Tags', DZ_TH_DOMAIN) ,
        'desc' => esc_html__('Settings for seo meta tags.', DZ_TH_DOMAIN) ,
        'icon' => 'el el-search-alt',
        'fields' => array(
			array(
				'id' => 'page_social_title',
				'type' => 'text',
				'title' => esc_html__('Social Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:title" content="The Rock" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Add it to all shareable pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Focus on accuracy, value, and clickability.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	Keep it short to prevent overflow. There’s no official guidance on this, but 40 characters for mobile and 60 for desktop is roughly the sweet spot.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('4. Use the raw title. Don’t include branding (e.g., your site name).', DZ_TH_DOMAIN)
					),
				 
			),
			array(
				'id' => 'page_social_description',
				'type' => 'textarea',
				'title' => esc_html__('Social Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:description" content="Learn about 13 features that set Ahrefs apart from the competition." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Complement the title to make the snippet as appealing and click-worthy as possible.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('2.	Copy your meta description here if it makes sense.', DZ_TH_DOMAIN).'<br><br>'.esc_html__('3. Keep it short and sweet. Facebook recommends 2-4 sentences, but that often truncates.',DZ_TH_DOMAIN)				
					),
			),
			array(
				'id' => 'page_social_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Social Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <metaproperty="og:image"content="https://ahrefs.com/blog/wp-content/uploads/2020/01/fb-open-graph-1.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => esc_url($post_thumbnail_url),
				),
				'hint' => array(
						'content' => esc_html__('1. Use custom images for shareable pages (e.g., homepage, articles, etc.)',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Use your logo or any other branded image for the rest of your pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	se images with a 1.91:1 ratio and minimum recommended dimensions of 1200x630 for optimal clarity across all devices.',DZ_TH_DOMAIN)
									
					),
				
			),
			
			array(
				'id' => 'page_social_keywords',
				'type' => 'textarea',
				'title' => esc_html__('Social Keywords', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The keyword tag used to be one of the most essential SEO meta tags, as primitive search engines used this as the central feature for search result rankings.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="keywords" content="keyword 1, keyword 2, keyword 3"/>', DZ_TH_DOMAIN),	 
			),
			
			array(
				'id' => 'page_social_author',
				'type' => 'text',
				'title' => esc_html__('Social Author', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The “Author” and “Copyright” meta tags can be found in the source code of an HTML page. They are used to record information such as who built the corresponding website and who copyright ownership belongs to.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="author" content="Author name" />', DZ_TH_DOMAIN),	 
				'default' => dz_get_current_user(), 
			),
				
		)
	));
	$metabox->add_section('post', array(
        'title' => esc_html__('SEO Meta Tags', DZ_TH_DOMAIN) ,
        'desc' => esc_html__('Settings for seo meta tags.', DZ_TH_DOMAIN) ,
        'icon' => 'el el-search-alt',
        'fields' => array(
			array(
				'id' => 'post_social_title',
				'type' => 'text',
				'title' => esc_html__('Social Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:title" content="The Rock" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Add it to all shareable pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Focus on accuracy, value, and clickability.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	Keep it short to prevent overflow. There’s no official guidance on this, but 40 characters for mobile and 60 for desktop is roughly the sweet spot.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('4. Use the raw title. Don’t include branding (e.g., your site name).', DZ_TH_DOMAIN)
					),
				 
			),
			array(
				'id' => 'post_social_description',
				'type' => 'textarea',
				'title' => esc_html__('Social Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:description" content="Learn about 13 features that set Ahrefs apart from the competition." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Complement the title to make the snippet as appealing and click-worthy as possible.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('2.	Copy your meta description here if it makes sense.', DZ_TH_DOMAIN).'<br><br>'.esc_html__('3. Keep it short and sweet. Facebook recommends 2-4 sentences, but that often truncates.',DZ_TH_DOMAIN)				
					),
			),
			array(
				'id' => 'post_social_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Social Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <metaproperty="og:image"content="https://ahrefs.com/blog/wp-content/uploads/2020/01/fb-open-graph-1.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => esc_url($post_thumbnail_url),
				),
				'hint' => array(
						'content' => esc_html__('1. Use custom images for shareable pages (e.g., homepage, articles, etc.)',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Use your logo or any other branded image for the rest of your pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	se images with a 1.91:1 ratio and minimum recommended dimensions of 1200x630 for optimal clarity across all devices.',DZ_TH_DOMAIN)
									
					),
				
			),
			
			array(
				'id' => 'post_social_keywords',
				'type' => 'textarea',
				'title' => esc_html__('Social Keywords', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The keyword tag used to be one of the most essential SEO meta tags, as primitive search engines used this as the central feature for search result rankings.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="keywords" content="keyword 1, keyword 2, keyword 3"/>', DZ_TH_DOMAIN),	 
			),
			
			array(
				'id' => 'post_social_author',
				'type' => 'text',
				'title' => esc_html__('Social Author', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The “Author” and “Copyright” meta tags can be found in the source code of an HTML page. They are used to record information such as who built the corresponding website and who copyright ownership belongs to.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="author" content="Author name" />', DZ_TH_DOMAIN),	 
				'default' => dz_get_current_user(), 
			),
				
		)
	));
	$metabox->add_section('dz_service', array(
        'title' => esc_html__('SEO Meta Tags', DZ_TH_DOMAIN) ,
        'desc' => esc_html__('Settings for seo meta tags.', DZ_TH_DOMAIN) ,
        'icon' => 'el el-search-alt',
        'fields' => array(
			array(
				'id' => 'cpt_service_social_title',
				'type' => 'text',
				'title' => esc_html__('Social Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:title" content="The Rock" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Add it to all shareable pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Focus on accuracy, value, and clickability.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	Keep it short to prevent overflow. There’s no official guidance on this, but 40 characters for mobile and 60 for desktop is roughly the sweet spot.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('4. Use the raw title. Don’t include branding (e.g., your site name).', DZ_TH_DOMAIN)
					),
				 
			),
			array(
				'id' => 'cpt_service_social_description',
				'type' => 'textarea',
				'title' => esc_html__('Social Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:description" content="Learn about 13 features that set Ahrefs apart from the competition." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Complement the title to make the snippet as appealing and click-worthy as possible.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('2.	Copy your meta description here if it makes sense.', DZ_TH_DOMAIN).'<br><br>'.esc_html__('3. Keep it short and sweet. Facebook recommends 2-4 sentences, but that often truncates.',DZ_TH_DOMAIN)				
					),
			),
			array(
				'id' => 'cpt_service_social_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Social Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <metaproperty="og:image"content="https://ahrefs.com/blog/wp-content/uploads/2020/01/fb-open-graph-1.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => esc_url($post_thumbnail_url),
				),
				'hint' => array(
						'content' => esc_html__('1. Use custom images for shareable pages (e.g., homepage, articles, etc.)',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Use your logo or any other branded image for the rest of your pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	se images with a 1.91:1 ratio and minimum recommended dimensions of 1200x630 for optimal clarity across all devices.',DZ_TH_DOMAIN)
									
					),
				
			),
			
			array(
				'id' => 'cpt_service_social_keywords',
				'type' => 'textarea',
				'title' => esc_html__('Social Keywords', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The keyword tag used to be one of the most essential SEO meta tags, as primitive search engines used this as the central feature for search result rankings.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="keywords" content="keyword 1, keyword 2, keyword 3"/>', DZ_TH_DOMAIN),	 
			),
			
			array(
				'id' => 'cpt_service_social_author',
				'type' => 'text',
				'title' => esc_html__('Social Author', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The “Author” and “Copyright” meta tags can be found in the source code of an HTML page. They are used to record information such as who built the corresponding website and who copyright ownership belongs to.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="author" content="Author name" />', DZ_TH_DOMAIN),	 
				'default' => dz_get_current_user(), 
			),
				
		)
	));
	$metabox->add_section('dz_team', array(
        'title' => esc_html__('SEO Meta Tags', DZ_TH_DOMAIN) ,
        'desc' => esc_html__('Settings for seo meta tags.', DZ_TH_DOMAIN) ,
        'icon' => 'el el-search-alt',
        'fields' => array(
			array(
				'id' => 'cpt_team_social_title',
				'type' => 'text',
				'title' => esc_html__('Social Title', DZ_TH_DOMAIN) ,
				'default' => esc_html__('Multipurpose WordPress Theme for Medical Professionals & Clinics', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The title of your page.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta property="og:title" content="The Rock" />', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Add it to all shareable pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Focus on accuracy, value, and clickability.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	Keep it short to prevent overflow. There’s no official guidance on this, but 40 characters for mobile and 60 for desktop is roughly the sweet spot.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('4. Use the raw title. Don’t include branding (e.g., your site name).', DZ_TH_DOMAIN)
					),
				 
			),
			array(
				'id' => 'cpt_team_social_description',
				'type' => 'textarea',
				'title' => esc_html__('Social Description', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('A brief description of the content. ', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <meta property="og:description" content="Learn about 13 features that set Ahrefs apart from the competition." />', DZ_TH_DOMAIN),
				'default' => esc_html__('Unlock the full potential of your medical practice with our feature-packed Multipurpose WordPress Theme, designed specifically for small clinics and healthcare professionals. This responsive, SEO-optimized theme offers seamless appointment scheduling, service showcases, and patient testimonials. Customize it easily with no coding experience, and create a professional online presence that drives patient trust and boosts clinic growth. Ideal for doctors, dentists, therapists, and other healthcare providers!', DZ_TH_DOMAIN),
				'hint' => array(
						'content' => esc_html__('1. Complement the title to make the snippet as appealing and click-worthy as possible.',DZ_TH_DOMAIN).'<br><br>'.esc_html__('2.	Copy your meta description here if it makes sense.', DZ_TH_DOMAIN).'<br><br>'.esc_html__('3. Keep it short and sweet. Facebook recommends 2-4 sentences, but that often truncates.',DZ_TH_DOMAIN)				
					),
			),
			array(
				'id' => 'cpt_team_social_image',
				'type' => 'media',
                'url' => true,
				'title' => esc_html__('Social Image', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text : <metaproperty="og:image"content="https://ahrefs.com/blog/wp-content/uploads/2020/01/fb-open-graph-1.jpg" />', DZ_TH_DOMAIN),
				'subtitle' => esc_html__('The URL of an image for the social snippet. ', DZ_TH_DOMAIN) ,
				'default' => array(
					'url' => esc_url($post_thumbnail_url),
				),
				'hint' => array(
						'content' => esc_html__('1. Use custom images for shareable pages (e.g., homepage, articles, etc.)',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('2.	Use your logo or any other branded image for the rest of your pages.',DZ_TH_DOMAIN).'<br><br>'.
									 esc_html__('3.	se images with a 1.91:1 ratio and minimum recommended dimensions of 1200x630 for optimal clarity across all devices.',DZ_TH_DOMAIN)
									
					),
				
			),
			
			array(
				'id' => 'cpt_team_social_keywords',
				'type' => 'textarea',
				'title' => esc_html__('Social Keywords', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The keyword tag used to be one of the most essential SEO meta tags, as primitive search engines used this as the central feature for search result rankings.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="keywords" content="keyword 1, keyword 2, keyword 3"/>', DZ_TH_DOMAIN),	 
			),
			
			array(
				'id' => 'cpt_team_social_author',
				'type' => 'text',
				'title' => esc_html__('Social Author', DZ_TH_DOMAIN) ,
				'subtitle' => esc_html__('The “Author” and “Copyright” meta tags can be found in the source code of an HTML page. They are used to record information such as who built the corresponding website and who copyright ownership belongs to.', DZ_TH_DOMAIN) ,
				'desc' => esc_html__('help text: <meta name="author" content="Author name" />', DZ_TH_DOMAIN),	 
				'default' => dz_get_current_user(), 
			),
				
		)
	));
	
}

add_action('dsx_post_metabox_register', 'dz_page_options_register',10);