<?php
add_action('after_setup_theme', 'clinicmaster_bunch_theme_setup');

function clinicmaster_bunch_theme_setup()
{

	global $wp_version;
	$theme = wp_get_theme();


	if (!defined('CLINICMASTER_VERSION')) {
		define('CLINICMASTER_VERSION', '1.3');
	}
	if (!defined('CLINICMASTER_ROOT')) {
		define('CLINICMASTER_ROOT', get_template_directory() . '/');
	}
	if (!defined('CLINICMASTER_URL')) {
		define('CLINICMASTER_URL', get_template_directory_uri() . '/');
	}

	if (!defined('CLINICMASTER_COMINGSOON')) {
		define('CLINICMASTER_COMINGSOON', get_template_directory_uri() . '/assets/images/bg1.jpg');
	}
	if (!defined('CLINICMASTER_MAINTENANCE')) {
		define('CLINICMASTER_MAINTENANCE', get_template_directory_uri() . '/assets/images/bg2.jpg');
	}
	if (!defined('CLINICMASTER_MAINTENANCE_VLC')) {
		define('CLINICMASTER_MAINTENANCE_VLC', get_template_directory_uri() . '/assets/images/vlc.png');
	}

	if (!defined('CLINICMASTER_DEFAULT_LOGO')) {
		define('CLINICMASTER_DEFAULT_LOGO', get_template_directory_uri() . '/assets/images/logo-dark.png');
	}
	if (!defined('CLINICMASTER_DEFAULT_WHITE_LOGO')) {
		define('CLINICMASTER_DEFAULT_WHITE_LOGO', get_template_directory_uri() . '/assets/images/logo-light.png');
	}
	if (!defined('CLINICMASTER_BACKGROUND_IMAGE')) {
		define('CLINICMASTER_BACKGROUND_IMAGE', get_template_directory_uri() . '/assets/images/background/bg1.jpg');
	}
	if (!defined('CLINICMASTER_BACKGROUND_VIDEO')) {
		define('CLINICMASTER_BACKGROUND_VIDEO', get_template_directory_uri() . '/assets/images/background/bg-video.mp4');
	}
	if (!defined('CLINICMASTER_DEFAULT_TEXT_LOGO')) {
		define('CLINICMASTER_DEFAULT_TEXT_LOGO', $theme->get('Name'));
	}
	if (!defined('CLINICMASTER_DEFAULT_TAG')) {
		define('CLINICMASTER_DEFAULT_TAG', esc_html__('Personal Blog', 'clinicmaster'));
	}

	if (!defined('CLINICMASTER_BANNER')) {
		define('CLINICMASTER_BANNER', '');
	}
	if (!defined('CLINICMASTER_COPYWRITE_TEXT')) {
		define('CLINICMASTER_COPYWRITE_TEXT', esc_html__('© 2025 All Rights Reserved.', 'clinicmaster'));
	}

	if (!defined('CLINICMASTER_FAVICON')) {
		define('CLINICMASTER_FAVICON', get_template_directory_uri() . '/assets/images/favicon.png');
	}


	include_once get_template_directory() . '/dz-inc/loader.php';

	load_theme_textdomain('clinicmaster', get_template_directory() . '/languages');

	/*	ADD THUMBNAIL SUPPORT	*/
	add_theme_support('post-thumbnails');
	add_theme_support('automatic-feed-links'); /* Enables post and comment RSS feed links to head. */
	add_theme_support('widgets'); /* Add widgets and sidebar support */
	add_theme_support('title-tag');
	add_theme_support('custom-header');
	add_theme_support('custom-background');
	add_theme_support('wp-block-styles');
	add_theme_support('align-wide');
	add_theme_support('editor-styles');
	add_theme_support('responsive-embeds');
	

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support('html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	));

	/** Register wp_nav_menus */
	if (function_exists('register_nav_menus')) {
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu' => esc_html__('Main Menu', 'clinicmaster'),
			)
		);
	}

	if (!isset($content_width)) {
		$content_width = 960;
	}

	/** Image Size Setting For ClinicManter **/
	add_image_size( 'clinicmaster_600x600', 600, 600, true );


	/*** Post Images ***/
	
	/* Change default image thumbnail sizes in wordpress */
	//Thumbnail
	update_option('thumbnail_size_w', 200); /* Testimonial */
	update_option('thumbnail_size_h', 200);
	update_option('thumbnail_crop', 1);


	//Medium
	update_option('medium_size_w', 600);/* Blog category, half image blog,  blog grid */
	update_option('medium_size_h', 500);
	update_option('medium_crop', 1);

	//Large
	update_option('large_size_w', 1000); /* for portfolio-film-strip,  */
	update_option('large_size_h', 600);
	update_option('large_crop', 1);
	/** Image Size Setting For ClinicManter END **/
}


/**
 * Register sidebar
 */
function clinicmaster_sidebar()
{
	global $wp_registered_sidebars;

	register_sidebar( array(
		'name' => esc_html__('Blog Sidebar', 'clinicmaster'),
		'id' => 'dz_blog_sidebar',
		'description'   => esc_html__('Widgets in this area will be shown on the right-hand side.', 'clinicmaster'),
		'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s substitute-class">',
		'after_widget' => '</div>',
		'before_title' => '<div class="widget-title"><h3 class="title dz-widget-title">',
		'after_title' => '</h3></div>'
	));

	register_sidebar(array(
		'name' => esc_html__('Footer Sidebar', 'clinicmaster'),
		'id' => 'dz_footer_sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'clinicmaster'),
		'before_widget' => '<div id="%1$s" class="col-xl-3 col-sm-12 widget wow fadeInUp %2$s  footer-sidebar-1">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="footer-title">',
		'after_title' => '</h2>'
	));
	
	register_sidebar(array(
		'name' => esc_html__('Footer Sidebar 2', 'clinicmaster'),
		'id' => 'dz_footer_sidebar2',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'clinicmaster'),
		'before_widget' => '<div id="%1$s" class="col-xl-3 col-lg-6 col-sm-12 widget wow fadeInUp %2$s  footer-sidebar-2">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="footer-title">',
		'after_title' => '</h2>'
	));
	
	register_sidebar(array(
		'name' => esc_html__('Footer Sidebar 3', 'clinicmaster'),
		'id' => 'dz_footer_sidebar3',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'clinicmaster'),
		'before_widget' => '<div id="%1$s" class="col-xl-3 col-sm-12 widget wow fadeInUp %2$s  footer-sidebar-3">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="footer-title">',
		'after_title' => '</h2>'
	));

	
	/* "substitute-class" using for replace required class dynamically. */

	if (class_exists('ReduxFramework')) {

		$sidebar_input_arr = clinicmaster_get_opt('new_sidebar_input');

		if (!empty($sidebar_input_arr[0])) {
			foreach ($sidebar_input_arr as $sidebar_input) {
				$sidebarId = str_replace(' ', '_', $sidebar_input);

				register_sidebar(array(
					'name'          => ucfirst($sidebar_input),
					'id'            => sanitize_title('dz_' . $sidebarId),
					'description'   => esc_html__('Widgets in this area will be shown on the right-hand side.', 'clinicmaster'),
					'before_widget'	=> '<div id="%1$s" class="widget service_menu_nav  bg-secondary  sidebar-widget %2$s substitute-class">',
					'after_widget'	=> '</div>',
					'before_title' 	=> '<div class="widget-title"><h4 class="title">',
					'after_title' 	=> '</h4></div>'
				));
			}
		}
	}
	update_option('wp_registered_sidebars', $wp_registered_sidebars);
}
add_action('widgets_init', 'clinicmaster_sidebar');



function clinicmaster_load_head_scripts()
{
	$options = clinicmaster_dzbase()->option();
	if (!is_admin()) {
		$protocol = is_ssl() ? 'https://' : 'http://';
		$map_api_key = !empty($options['map_api_key']) ? $options['map_api_key'] : '';

		if (!empty($map_api_key)) {
			$map_path = '?key=' . (!empty($options['map_api_key']) ? $options['map_api_key'] : '');

			wp_enqueue_script('clinicmaster-map-api', '' . $protocol . 'maps.google.com/maps/api/js' . $map_path, array(), false, false);
		}
	}
}
add_action('wp_enqueue_scripts', 'clinicmaster_load_head_scripts');

/**
 * Check if Plugin is active
 **/
function clinicmaster_plugin_active($plugin)
{
	$active_plugins = apply_filters('active_plugins', get_option('active_plugins'));
	if (!empty($plugin) && !empty($active_plugins) && in_array($plugin, $active_plugins)) {
		return true;
	} else {
		return false;
	}
}

/* global variables */
function clinicmaster_bunch_global_variable()
{

	global $post;
	global $clinicmaster_option;
	$review_show_on_listing = $show_related_product = '';
	if (clinicmaster_plugin_active('redux-framework/redux-framework.php')) {
		$options = clinicmaster_dzbase()->option();
	} else {
		$options = array();
		$review_show_on_listing = $show_related_product = true;
	}
	
	$dzRes = array();
	$dzRes['allowed_html_tags']    = wp_kses_allowed_html('post');
	$dzRes['website_status']       = !empty($options['website_status']) ? $options['website_status'] : 'live_mode';
	$dzRes['theme_corner']         = !empty($options['theme_corner']) ? $options['theme_corner'] : 'sharped';
	$dzRes['theme_font_style']     = !empty($options['theme_font_style']) ? $options['theme_font_style'] : 'default';
	$dzRes['theme_corner_rounded'] = !empty($options['theme_corner_rounded']) ? $options['theme_corner_rounded'] : 'rounded';
	$dzRes['rtl_on']               = isset($options['rtl_on']) ? $options['rtl_on'] : null;
	$dzRes['theme_date_format']    = !empty($options['theme_date_format']) ? $options['theme_date_format'] : '';
	$dzRes['color_skin_setting']    = !empty($options['color_skin_setting']) ? $options['color_skin_setting'] : 'predefined_color_skin';
	$dzRes['predefined_color_skin']    = !empty($options['predefined_color_skin']) ? $options['predefined_color_skin'] : 'skin_1';

	if (function_exists('clinicmaster_get_ws_data')) {
		$extra_ws_data = clinicmaster_get_ws_data($options);
		$dzRes = array_merge($dzRes, $extra_ws_data);
	}

	/* stuff : header.php  */
	$dzRes['site_favicon'] = isset($options['favicon']) ? clinicmaster_set($options['favicon'], 'url', CLINICMASTER_FAVICON) : CLINICMASTER_FAVICON;

	/* preloading image */
	$dzRes['page_loading_on']          = !empty($options['page_loading_on']) ? $options['page_loading_on']    : null;
	$dzRes['page_loader_type']         = !empty($options['page_loader_type']) ? $options['page_loader_type']  : null;
	$dzRes['page_loader_image']        = !empty($options['page_loader_image']) ? $options['page_loader_image'] : 'loading1';
	$dzRes['custom_page_loader_image'] = !empty($options['custom_page_loader_image']) ? $options['custom_page_loader_image'] : null;

	if ($dzRes['page_loading_on'] == 1) {
		if ($dzRes['page_loader_type'] == 'loading_image') {
			if (!empty($options['custom_page_loader_image']['url'])) {
				$dzRes['preloader'] = get_template_directory_uri() . '/dz-inc/assets/images/loading-images/' . $dzRes['page_loader_image'] . '.svg';
			} else {
				$dzRes['preloader'] = get_template_directory_uri() . '/dz-inc/assets/images/loading-images/' . $dzRes['page_loader_image'] . '.svg';
			}
		} elseif ($dzRes['page_loader_type'] == 'advanced_loader') {
			$dzRes['preloader'] = !empty($options['advanced_page_loader_image']) ? $options['advanced_page_loader_image'] : '';
		}
	}

	/* header settings */

	$dzRes['header_style'] = !empty($options['header_style']) ? $options['header_style'] : 'header_4';
	/*Page Header: necessary to get here */
	if (is_page()) {
		$page_header_setting 	= 	clinicmaster_dzbase()->get_meta('page_header_setting');
		$page_header_setting	=	!empty($page_header_setting) ? $page_header_setting : 'theme_default';
		if ($page_header_setting == 'custom') {
			$page_header_style 	= clinicmaster_dzbase()->get_meta('page_header_style');
			$dzRes['header_style']	= !empty($page_header_style) ? $page_header_style : $dzRes['header_style'];
		}
	}
	if (is_single() || is_singular('dz_service')) {

		$post_type = 'post';
		if (is_singular('dz_service')) {
			$post_type = 'service_post';
		}
		$post_header_setting 	= 	clinicmaster_dzbase()->get_meta($post_type . '_header_setting');
		
		$post_header_setting	=	!empty($post_header_setting) ? $post_header_setting : 'theme_default';
		if ($post_header_setting == 'custom') {
			$post_header_style 	= clinicmaster_dzbase()->get_meta($post_type . '_header_style');
			$dzRes['header_style']	= !empty($post_header_style) ? $post_header_style : $dzRes['header_style'];
		}
	}
	if (clinicmaster_is_woocommerce_active() && (function_exists('is_product') && is_product())) {
		$product_header_setting 	= 	clinicmaster_dzbase()->get_meta('product_header_setting');
		$product_header_setting	=	!empty($product_header_setting) ? $product_header_setting : 'theme_default';
		if ($product_header_setting == 'custom') {
			$product_header_style 	= clinicmaster_dzbase()->get_meta('product_header_style');
			$dzRes['header_style']	= !empty($product_header_style) ? $product_header_style : $dzRes['header_style'];
		}
	}

	/* clinicmaster header global option   */
	$dzRes['show_login_registration']         = !empty($options['show_login_registration']) ? $options['show_login_registration'] : null;
	
	
	$dzRes['header_sticky_on']                = isset($options['header_sticky_on']) ? $options['header_sticky_on'] : true;
	
	
	$dzRes['preheaderbar_social_links_on']    = !empty($options[$dzRes['header_style'] . '_social_links_on']) ? $options[$dzRes['header_style'] . '_social_links_on'] : null;
	$dzRes['preheaderbar_social_links']       = !empty($options[$dzRes['header_style'] . '_social_links']) ? $options[$dzRes['header_style'] . '_social_links'] : null; 
	

	/*  theme setting  only page */


	/* header   */
	/* $dzRes['header_email_id']     = !empty($options[$dzRes['header_style'] . '_email_id']) ? $options[$dzRes['header_style'] . '_email_id'] : null;
	$dzRes['header_phone_number_on'] = !empty($options[$dzRes['header_style'] . '_phone_number_on']) ? $options[$dzRes['header_style'] . '_phone_number_on'] : null;
	$dzRes['header_phone_icon'] = !empty($options[$dzRes['header_style'] . '_phone_icon']) ? $options[$dzRes['header_style'] . '_phone_icon'] : '';
	 */
	
	$dzRes['header_topbar_info_on'] = !empty($options[$dzRes['header_style'] . '_topbar_info_on']) ? $options[$dzRes['header_style'] . '_topbar_info_on'] : '';
	$dzRes['header_button_1_on'] = !empty($options[$dzRes['header_style'] . '_button_1_on']) ? $options[$dzRes['header_style'] . '_button_1_on'] : '';
	$dzRes['header_button_1_text'] = !empty($options[$dzRes['header_style'] . '_button_1_text']) ? $options[$dzRes['header_style'] . '_button_1_text'] : '';
	$dzRes['header_button_1_url'] = !empty($options[$dzRes['header_style'] . '_button_1_url']) ? $options[$dzRes['header_style'] . '_button_1_url'] : '';
	$dzRes['header_button_1_target'] = !empty($options[$dzRes['header_style'] . '_button_1_target']) ? $options[$dzRes['header_style'] . '_button_1_target'] : '';
	$dzRes['header_sidebar_on'] = !empty($options[$dzRes['header_style'] . '_sidebar_on']) ? $options[$dzRes['header_style'] . '_sidebar_on'] : '';
	$dzRes['header_phone_number_on'] = !empty($options[$dzRes['header_style'] . '_phone_number_on']) ? $options[$dzRes['header_style'] . '_phone_number_on'] : '';
	$dzRes['header_menu_class'] = !empty($options[$dzRes['header_style'] . '_header_menu']) ? $options[$dzRes['header_style'] . '_header_menu'] : '';
	$dzRes['header_menu_class'] = !empty($options[$dzRes['header_style'] . '_header_menu']) ? $options[$dzRes['header_style'] . '_header_menu'] : '';
	

	/* clinicmaster header global option   */


	/* ------------------------------------------------------------------------------------- */

	$dzRes['show_social_icon']          = !empty($options['show_social_icon']) ? $options['show_social_icon'] : null;
	$dzRes['header_sticky_class']       = !empty($dzRes['header_sticky_on']) ? '  ' : 'sticky-header';

	$dzRes['header_search_on']          = !empty($options[$dzRes['header_style'] . '_search_on']) ? $options[$dzRes['header_style'] . '_search_on'] : false;


	/* Get general option --------------------------- */
	$dzRes['general_email_icon']         = !empty($options['general_email_icon']) ? $options['general_email_icon'] : null;
	$dzRes['general_email_text']         = !empty($options['general_email_text']) ? $options['general_email_text'] : null;
	$dzRes['general_email_address']      = !empty($options['general_email_address']) ? $options['general_email_address'] : null;
	$dzRes['general_phone_icon']         = !empty($options['general_phone_icon']) ? $options['general_phone_icon'] : null;
	$dzRes['general_phone_text']         = !empty($options['general_phone_text']) ? $options['general_phone_text'] : null;
	$dzRes['general_phone_number']       = !empty($options['general_phone_number']) ? $options['general_phone_number'] : null;
	$dzRes['general_time_icon']      	 = !empty($options['general_time_icon']) ? $options['general_time_icon'] : null;
	$dzRes['general_time_text']      	 = !empty($options['general_time_text']) ? $options['general_time_text'] : null;
	$dzRes['general_time_value']      	 = !empty($options['general_time_value']) ? $options['general_time_value'] : null;
	$dzRes['general_address_icon']       = !empty($options['general_address_icon']) ? $options['general_address_icon'] : null;
	$dzRes['general_address_text']       = !empty($options['general_address_text']) ? $options['general_address_text'] : null;
	$dzRes['general_address']            = !empty($options['general_address']) ? $options['general_address'] : null;
	$dzRes['general_about_us']           = !empty($options['general_about_us']) ? $options['general_about_us'] : null;
	$dzRes['mailchimp_title']            = !empty($options['mailchimp_title']) ? $options['mailchimp_title'] : null;
	$dzRes['mailchimp_description']      = !empty($options['mailchimp_description']) ? $options['mailchimp_description'] : null;
	$dzRes['mailchimp_button_text']      = !empty($options['mailchimp_button_text']) ? $options['mailchimp_button_text'] : null;
	
	$dzRes['general_opening_hours_text']      = !empty($options['general_opening_hours_text']) ? $options['general_opening_hours_text'] : null;
	$dzRes['general_opening_hours']      = !empty($options['general_opening_hours']) ? $options['general_opening_hours'] : null;
	$dzRes['sidebar_bg_color']      = !empty($options['sidebar_bg_color']) ? $options['sidebar_bg_color'] : 'dz-medical';

	/* WooCommerce Settings get option */
	$dzRes['review_show_on_listing']     = !empty($options['review_show_on_listing']) ? $options['review_show_on_listing'] : null;
	$dzRes['show_related_product']       = !empty($options['show_related_product']) ? $options['show_related_product'] : null;


	
	/* Get general option ---------------------------------- */



	/* Manage header Subscription Form */
	$dzRes['header_subscribe_on'] = !empty($options['header_subscribe_on']) ? $options['header_subscribe_on'] : null;

	/* Booking Page Url */
	$dzRes['booking_page_url'] = !empty($options['booking_page_url']) ? $options['booking_page_url'] : '';


	$header_style_options = clinicmaster_header_style_options();
	foreach ($header_style_options as $header) {
		$call_to_action_button     = !empty($header['param']['call_to_action_button']) ? $header['param']['call_to_action_button'] : 0;
		$info_fields_header         = !empty($header['param']['informative_fields_header']) ? $header['param']['informative_fields_header'] : 0;
		$extra_social_information   = !empty($header['param']['extra_social_information']) ? $header['param']['extra_social_information'] : 0;



		if ($call_to_action_button > 0) {
			for ($i = 1; $i <= $call_to_action_button; $i++) {
				$dzRes['header_button_' . $i . '_text']   = !empty($options[$dzRes['header_style'] . '_button_' . $i . '_text']) ? $options[$dzRes['header_style'] . '_button_' . $i . '_text'] : '';
				$dzRes['header_button_' . $i . '_url']    = !empty($options[$dzRes['header_style'] . '_button_' . $i . '_url']) ? $options[$dzRes['header_style'] . '_button_' . $i . '_url'] : '';
				$dzRes['header_button_' . $i . '_target'] = !empty($options[$dzRes['header_style'] . '_button_' . $i . '_target']) ? $options[$dzRes['header_style'] . '_button_' . $i . '_target'] : '';
			}
		}

		if ($info_fields_header > 0) {
			for ($i = 1; $i <= $info_fields_header; $i++) {
				$dzRes['header_info_' . $i . '_icon_class'] = !empty($options[$dzRes['header_style'] . '_info_field_' . $i . '_icon_class']) ? $options[$dzRes['header_style'] . '_info_field_' . $i . '_icon_class'] : '';
				$dzRes['header_info_' . $i . '_contact']    = !empty($options[$dzRes['header_style'] . '_info_field_' . $i . '_contact']) ? $options[$dzRes['header_style'] . '_info_field_' . $i . '_contact'] : '';
				$dzRes['header_info_' . $i . '_address']    = !empty($options[$dzRes['header_style'] . '_info_field_' . $i . '_address']) ? $options[$dzRes['header_style'] . '_info_field_' . $i . '_address'] : '';
			}
		}
	}
	/* ---------------------------------------- */
	
	$dzRes['mobile_header_login_on']        = !empty($options['mobile_header_login_on']) ? $options['mobile_header_login_on'] : '';
	$dzRes['mobile_header_register_on']     = !empty($options['mobile_header_register_on']) ? $options['mobile_header_register_on'] : '';
	$dzRes['mobile_header_social_links']    = !empty($options['mobile_header_social_links']) ? $options['mobile_header_social_links'] : '';
	$dzRes['mobile_search_on']              = !empty($options[$dzRes['header_style'] . '_mobile_search_on']) ? $options[$dzRes['header_style'] . '_mobile_search_on'] : '';

	/* ---------------------------------------------- */
	$dzRes['social_link_target'] = !empty($options['social_link_target']) ? $options['social_link_target'] : '';
	/* header settings END */

	/*Footer Header: necessary to get here */
	$dzRes['footer_on']     = isset($options['footer_on']) ? $options['footer_on'] : true;
	$dzRes['footer_style']  = !empty($options['footer_style']) ? $options['footer_style'] : 'footer_template_1';

	if (is_page()) {
		$page_footer_setting 	= clinicmaster_dzbase()->get_meta('page_footer_setting');
		$page_footer_setting	=	!empty($page_footer_setting) ? $page_footer_setting : 'theme_default';
		if ($page_footer_setting == 'custom') {
			$page_footer_style 		= clinicmaster_dzbase()->get_meta('page_footer_style');
			$dzRes['footer_on'] 	= clinicmaster_dzbase()->get_meta('page_footer_on');
			$dzRes['footer_style']	= !empty($page_footer_style) ? $page_footer_style : $dzRes['footer_style'];
		}
	}
	if (clinicmaster_is_woocommerce_active() && ((function_exists('is_shop') && is_shop()) || (function_exists('is_product_category') && is_product_category()))) {
		$page_footer_setting = clinicmaster_dzbase()->get_meta('page_footer_setting', get_option('woocommerce_shop_page_id'));
		$page_footer_setting	=	!empty($page_footer_setting) ? $page_footer_setting : 'theme_default';
		if ($page_footer_setting == 'custom') {
			$page_footer_style 	= clinicmaster_dzbase()->get_meta('page_footer_style', get_option('woocommerce_shop_page_id'));
			$dzRes['footer_on'] 	= clinicmaster_dzbase()->get_meta('page_footer_on', get_option('woocommerce_shop_page_id'));
			$dzRes['footer_style']	= !empty($page_footer_style) ? $page_footer_style : $dzRes['footer_style'];
		}

		
	}
	if (is_single() || is_singular('dz_service')) {
		$post_type = 'post';
		if (is_singular('dz_service')) {
			$post_type = 'service_post';
		}

		$post_footer_setting 	= 	clinicmaster_dzbase()->get_meta($post_type . '_footer_setting');
		$post_footer_setting	=	!empty($post_footer_setting) ? $post_footer_setting : 'theme_default';
		if ($post_footer_setting == 'custom') {
			$post_footer_style 	= clinicmaster_dzbase()->get_meta($post_type . '_footer_style');
			$dzRes['footer_on'] 	= clinicmaster_dzbase()->get_meta($post_type . '_footer_on');
			$dzRes['footer_style']	= !empty($post_footer_style) ? $post_footer_style : $dzRes['footer_style'];
		}
	}



	/*Footer Header: necessary to get here END */
	/* ----------------------------------------------------------- */
	/* Footer Settings Starts */
	$dzRes['footer_bg_image']           = !empty($options[$dzRes['footer_style'] . '_footer_bg_image']['url']) ? $options[$dzRes['footer_style'] . '_footer_bg_image']['url']          : '';
	
	$dzRes['footer_contact_us_on']      = isset($options[$dzRes['footer_style'] . '_footer_contact_us_on']) ? $options[$dzRes['footer_style'] . '_footer_contact_us_on'] : '';
	$dzRes['footer_contact_us_title']      = isset($options[$dzRes['footer_style'] . '_contact_us_title']) ? $options[$dzRes['footer_style'] . '_contact_us_title'] : '';
	$dzRes['footer_contact_us_text']      = isset($options[$dzRes['footer_style'] . '_contact_us_text']) ? $options[$dzRes['footer_style'] . '_contact_us_text'] : '';
	
	$dzRes['footer_subscribe_on']             = isset($options[$dzRes['footer_style'] . '_footer_subscribe_on']) ? $options[$dzRes['footer_style'] . '_footer_subscribe_on'] : '';
	$dzRes['footer_top_on']             = isset($options[$dzRes['footer_style'] . '_footer_top_on']) ? $options[$dzRes['footer_style'] . '_footer_top_on']       : true;
	$dzRes['footer_bottom_on']          = isset($options[$dzRes['footer_style'] . '_footer_bottom_on']) ? $options[$dzRes['footer_style'] . '_footer_bottom_on'] : true;
	$dzRes['footer_card_image']          = isset($options[$dzRes['footer_style'] . '_card_image']) ? $options[$dzRes['footer_style'] . '_card_image'] : false;
	$dzRes['footer_contact_image']          = isset($options[$dzRes['footer_style'] . '_contact_image']) ? $options[$dzRes['footer_style'] . '_contact_image'] : false;
	$dzRes['footer_star_rating']          = isset($options[$dzRes['footer_style'] . '_star_rating']) ? $options[$dzRes['footer_style'] . '_star_rating'] : false;
	$dzRes['footer_social_on']          = isset($options[$dzRes['footer_style'] . '_footer_social_on']) ? $options[$dzRes['footer_style'] . '_footer_social_on'] : false;
	$dzRes['footer_logo_on']            = !empty($options[$dzRes['footer_style'] . '_logo_on']) ? $options[$dzRes['footer_style'] . '_logo_on']                  : '';
	$dzRes['footer_button_text']            = !empty($options[$dzRes['footer_style'] . '_button_text']) ? $options[$dzRes['footer_style'] . '_button_text']  : '';
	$dzRes['footer_button_link']            = !empty($options[$dzRes['footer_style'] . '_button_link']) ? $options[$dzRes['footer_style'] . '_button_link']  : '';
	$dzRes['footer_button_text2']            = !empty($options[$dzRes['footer_style'] . '_button_text2']) ? $options[$dzRes['footer_style'] . '_button_text2']  : '';
	$dzRes['footer_button_link2']            = !empty($options[$dzRes['footer_style'] . '_button_link2']) ? $options[$dzRes['footer_style'] . '_button_link2']  : '';
	

	$dzRes['footer_top']                 = !empty($options['footer_top']) ? $options['footer_top'] : false;

	$dzRes['footer_copyright_text']      = isset($options[$dzRes['footer_style'] . '_footer_copyright_text']) ? $options[$dzRes['footer_style'] . '_footer_copyright_text'] : CLINICMASTER_COPYWRITE_TEXT;

	/* Footer Params Actions */
	$footer_style_options = clinicmaster_footer_style_options();
	foreach ($footer_style_options as $footer) {
		$call_to_action_button = !empty($footer['param']['call_to_action_button']) ? $footer['param']['call_to_action_button'] : 0;
		$bg_image              = !empty($footer['param']['bg_image']) ? $footer['param']['bg_image'] : 0;
		$informative_field     = !empty($footer['param']['informative_field']) ? $footer['param']['informative_field'] : 0;


		if ($dzRes['footer_style'] == $footer['id']) {
			if ($call_to_action_button > 0) {
				for ($i = 1; $i <= $call_to_action_button; $i++) {
					$dzRes['footer_button_' . $i . '_text']   = !empty($options[$dzRes['footer_style'] . '_button_' . $i . '_text']) ? $options[$dzRes['footer_style'] . '_button_' . $i . '_text'] : '';
					$dzRes['footer_button_' . $i . '_url']    = !empty($options[$dzRes['footer_style'] . '_button_' . $i . '_url']) ? $options[$dzRes['footer_style'] . '_button_' . $i . '_url'] : '';
					$dzRes['footer_button_' . $i . '_target'] = !empty($options[$dzRes['footer_style'] . '_button_' . $i . '_target']) ? $options[$dzRes['footer_style'] . '_button_' . $i . '_target'] : '';
				}
			}
		}
	}
	/* Footer Params Actions END */

	
	
	/* logo setting , adition logo settings for 'site_other_logo' for clinicmaster theme */
	$dzRes['logo_type']  = !empty($options['logo_type']) ? $options['logo_type']  : '';
	$dzRes['logo_title'] = !empty($options['logo_title']) ? $options['logo_title'] : CLINICMASTER_DEFAULT_TEXT_LOGO;
	$dzRes['tag_line']   = !empty($options['tag_line']) ? $options['tag_line']    : CLINICMASTER_DEFAULT_TAG;

	// Assuming CLINICMASTER_DEFAULT_TEXT_LOGO is a constant and not a variable
	$dzRes['logo_alt']   = !empty($options['logo_alt']) ? $options['logo_alt']    : CLINICMASTER_DEFAULT_TEXT_LOGO;


	if (isset($options['logo_type']) && $options['logo_type'] == 'image_logo') {
		$dzRes['logo'] = ($dzRes['header_style'] == 'header_2') ? clinicmaster_set($options['site_other_logo'], 'url', CLINICMASTER_DEFAULT_WHITE_LOGO) : clinicmaster_set($options['site_logo'], 'url', CLINICMASTER_DEFAULT_LOGO);
	} elseif (isset($options['logo_type']) && $options['logo_type'] == 'text_logo') {
		$dzRes['logo_text'] = !empty($dzRes['logo_text']) ? $dzRes['logo_text'] : CLINICMASTER_DEFAULT_TEXT_LOGO;
		$dzRes['logo_title'] = !empty($options['logo_title']) ? $options['logo_title'] : CLINICMASTER_DEFAULT_TEXT_LOGO;
	} else {
		$dzRes['logo'] = CLINICMASTER_DEFAULT_LOGO;
	}

	$dzRes['site_logo_icon'] = isset($options['site_logo_icon']['url']) ? $options['site_logo_icon']['url'] : get_template_directory_uri() . '/assets/images/logo-icon.png';
	$dzRes['site_logo'] = isset($options['site_logo']['url']) ? $options['site_logo']['url'] : CLINICMASTER_DEFAULT_LOGO;
	$dzRes['site_other_logo'] = isset($options['site_other_logo']['url']) ? $options['site_other_logo']['url'] : CLINICMASTER_DEFAULT_WHITE_LOGO;

	$dzRes['ratina_logo'] = isset($options['ratina_logo']['url']) ? $options['ratina_logo']['url'] : '';
	$dzRes['mobile_logo'] = isset($options['mobile_logo']['url']) ? $options['mobile_logo']['url'] : '';
	$dzRes['ratina_mobile_logo'] = isset($options['ratina_mobile_logo']['url']) ? $options['ratina_mobile_logo']['url'] : '';
	/* End logo setting  */


	/*************************************************************************************************/
	$dzRes['show_search_button'] = $dzRes['header_search_on'];
	$dzRes['hide_social_icons_mobile'] = $dzRes['mobile_header_social_links'];

	
	/* Post general setting */
	$dzRes['post_layout'] = !empty($options['post_general_layout']) ? $options['post_general_layout'] : 'standard';
	$dzRes['post_view_on'] = isset($options['post_view_on']) ? $options['post_view_on'] : '';
	$dzRes['post_start_view'] = !empty($options['post_start_view']) ? $options['post_start_view'] : 1;
	$dzRes['pre_next_post_on'] = isset($options['pre_next_post_on']) ? $options['pre_next_post_on'] : '';
	$dzRes['comment_view_on'] = isset($options['comment_view_on']) ? $options['comment_view_on'] : '';
	$dzRes['featured_img_on'] = isset($options['featured_img_on']) ? $options['featured_img_on'] : '';

	/* Post general setting end */

	/* Page banner setting */
	$dzRes['show_banner']               = isset($options['page_general_banner_on']) ? $options['page_general_banner_on'] : true;
	$dzRes['banner_type']               = 'image';
	$dzRes['banner_height']             = !empty($options['page_general_banner_height']) ? $options['page_general_banner_height']              : 'page_banner_big';
	$dzRes['page_title_position']       = !empty($options['page_title_position']) ? $options['page_title_position']                            : 'center';
	$dzRes['banner_custom_height']      = !empty($options['post_general_banner_custom_height']) ? $options['post_general_banner_custom_height'] : '100';
	$dzRes['post_general_banner_style'] = !empty($options['post_general_banner_style']) ? $options['post_general_banner_style']                : '';
	$dzRes['page_general_banner_style'] = !empty($options['page_general_banner_style']) ? $options['page_general_banner_style']                : '';

	$dzRes['banner_image']			    = isset($options['page_general_banner']) ? clinicmaster_set($options['page_general_banner'], 'url', CLINICMASTER_BANNER) : CLINICMASTER_BANNER;

	/* End Page banner setting */

	/* Sidebar and there layout */
	$dzRes['layout'] = 'right';
	$dzRes['sidebar'] = 'dz_blog_sidebar';
	$dzRes['show_sidebar'] = isset($options['page_general_show_sidebar']) ? $options['page_general_show_sidebar'] : true;
	if ($dzRes['show_sidebar']) {
		$dzRes['layout'] = !empty($options['page_general_sidebar_layout']) ? $options['page_general_sidebar_layout'] : 'right';
		$dzRes['sidebar'] = !empty($options['page_general_sidebar']) ? $options['page_general_sidebar'] : 'dz_blog_sidebar';
	}
	/* End Sidebar and there layout */

	$pagination = !empty($options['page_general_paging']) ? $options['page_general_paging'] : 'default';
	$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
	/*************************************************************************************************/



	$HomePagetemp = $dzRes;

	
	/* page.php */
	if (is_page()) {

		$page_level_keys = array(
			'page_header_setting',
			'page_header_style',
			'page_header_menu',
			'page_banner_height',
			'page_banner_on',
			'page_banner_hide',
			'page_banner',
			'page_banner_title',
			'page_banner_title_position',
			'banner_image',
			'page_show_sidebar',
			'page_sidebar_layout',
			'page_sidebar',
			
		);

		foreach ($page_level_keys as $value) {
			$page_settings[$value] =  clinicmaster_dzbase($page_level_keys)->get_meta($value);
		}

		/* Header & Logo Setting */

		$page_header_setting	=	!empty($page_settings['page_header_setting']) ? $page_settings['page_header_setting'] : 'theme_default';
		
		if($page_header_setting == 'custom'){ 
			$dzRes['header_menu_class'] = !empty($page_settings['page_header_menu']) ? $page_settings['page_header_menu'] : '' ;
			
		}

		$page_footer_setting	=	!empty($page_settings['page_footer_setting']) ? $page_settings['page_footer_setting'] : 'theme_default';

		
		$dzRes['header_top_bar_on'] = isset($options[$dzRes['header_style'] . '_top_bar_on']) ? $options[$dzRes['header_style'] . '_top_bar_on'] : '';
		$dzRes['header_search_on'] = isset($options[$dzRes['header_style'] . '_search_on']) ? $options[$dzRes['header_style'] . '_search_on'] : false;


		if ($dzRes['header_style'] == 'header_2') {
			$dzRes['logo'] = !empty($options['site_other_logo']) ? $options['site_other_logo'] : '';
			$dzRes['logo'] = !empty($dzRes['logo']['url']) ? $dzRes['logo']['url'] : CLINICMASTER_DEFAULT_WHITE_LOGO;
		} else {
			$dzRes['logo'] = !empty($options['site_logo']) ? $options['site_logo'] : '';
			$dzRes['logo'] = !empty($dzRes['logo']['url']) ? $dzRes['logo']['url'] : CLINICMASTER_DEFAULT_LOGO;
		}
		/* End Header & Logo Setting */

		/* Page banner setting */

		$dzRes['show_banner'] = isset($page_settings['page_banner_on']) ? $page_settings['page_banner_on'] : $dzRes['show_banner'];

		$dzRes['page_banner_title'] = !empty($page_settings['page_banner_title']) ? $page_settings['page_banner_title'] : false;
		$dzRes['page_title_position'] = !empty($page_settings['page_banner_title_position']) ? $page_settings['page_banner_title_position'] : $dzRes['page_title_position'];



		$dzRes['banner_height'] = !empty($page_settings['page_banner_height']) ? $page_settings['page_banner_height'] : $dzRes['banner_height'];
		$dzRes['banner_custom_height'] = !empty($page_settings['page_banner_custom_height']) ? $page_settings['page_banner_custom_height'] : $dzRes['banner_custom_height'];
		$dzRes['dont_use_banner_image'] = isset($page_settings['page_banner_hide']) ? $page_settings['page_banner_hide'] : 0;
		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($page_settings['page_general_banner']) ? clinicmaster_set($page_settings['page_general_banner'], 'url', $dzRes['banner_image']) : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End page banner setting */

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($page_settings['page_show_sidebar']) ? $page_settings['page_show_sidebar'] : $dzRes['show_sidebar'];
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($page_settings['page_sidebar_layout']) ? $page_settings['page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($page_settings['page_sidebar']) ? $page_settings['page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */

		$page_footer_setting	=	!empty($page_settings['page_footer_setting']) ? $page_settings['page_footer_setting'] : 'theme_default';
		if ($page_footer_setting == 'custom') {
			$dzRes['footer_style'] = !empty($page_settings['page_footer_style']) ? $page_settings['page_footer_style'] : $dzRes['footer_style'];
		}
	}

	/* single.php */
	if (is_single() || is_singular('dz_service') || (clinicmaster_is_woocommerce_active() && is_product())) {
		$post_type = 'post';
		if (is_singular('dz_service')) {
			$post_type = 'service_post';
		} /* elseif (clinicmaster_is_woocommerce_active() && is_product()) {
			$post_type = 'product';
		} */
		$page_level_keys = array(
			'featured_post',

			$post_type . '_header_setting',
			$post_type . '_header_style',
			$post_type . '_header_menu',
			'post_layout',
			'post_type_gallery1',
			'post_type_gallery2',
			'post_type_link',
			'post_type_video',
			'post_type_audio',
			'post_show_sidebar',
			'post_sidebar_layout',
			'post_sidebar',
		);
		foreach ($page_level_keys as $value) {
			$page_settings[$value] =  clinicmaster_dzbase($page_level_keys)->get_meta($value);
		}


		$dzRes['is_featured_post'] = clinicmaster_dzbase()->get_meta('featured_post');

		
		$dzRes['post_layout'] = !empty($page_settings['post_layout']) ? $page_settings['post_layout'] : $dzRes['post_layout'];
		$page_header_setting = !empty($page_settings[$post_type . '_header_setting']) ? $page_settings[$post_type . '_header_setting'] : 'theme_default';
		if($page_header_setting == 'custom'){ 
			$dzRes['header_menu_class'] = !empty($page_settings[$post_type . '_header_menu']) ? $page_settings[$post_type . '_header_menu'] : '' ;
		}
		if ($dzRes['post_layout'] == 'slider_post_1') {
			$dzRes['post_gallary_setting'] = clinicmaster_dzbase()->get_meta('post_type_gallery1');
		}
		if ($dzRes['post_layout'] == 'slider_post_2') {
			$dzRes['post_gallary_setting'] = clinicmaster_dzbase()->get_meta('post_type_gallery2');
		}
		$dzRes['external_link'] = clinicmaster_dzbase()->get_meta('post_type_link');
		$dzRes['youtube_link'] = clinicmaster_dzbase()->get_meta('post_type_video');
		$dzRes['audio_link'] = clinicmaster_dzbase()->get_meta('post_type_audio');

		/* Single post sidebar settings from post level. */
		if ($dzRes['post_layout'] == 'gutenberg') {
			$dzRes['sidebar'] = '';
			$dzRes['layout'] = 'full';
		} else {
			/* Sidebar and there layout */
			$dzRes['show_sidebar'] = !empty($page_settings['post_show_sidebar']) ? $page_settings['post_show_sidebar'] : $dzRes['show_sidebar'];
			
				$dzRes['layout'] = !empty($page_settings['post_sidebar_layout']) ? $page_settings['post_sidebar_layout'] : $dzRes['layout'];
				$dzRes['sidebar'] = !empty($page_settings['post_sidebar']) ? $page_settings['post_sidebar'] : $dzRes['sidebar'];
		
			/* End Sidebar and there layout */
		}
		/* Single post sidebar settings from post level end. */
		$dzRes['related_post_title'] = !empty($options['related_post_title']) ? $options['related_post_title'] : '';
		$dzRes['layout_class'] = (!is_active_sidebar($dzRes['sidebar']) || $dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true || !clinicmaster_is_theme_sidebar_active()) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
	}

	/* archive.php */
	if (is_archive()) {
		$options['archive_page_banner'] = '';
		$dzRes['page_title'] = !empty($options['archive_page_title']) ? $options['archive_page_title'] : esc_html__('Archive : ', 'clinicmaster');

		/* Page banner setting */
		$dzRes['show_banner']               = isset($options['archive_page_banner_on']) ? $options['archive_page_banner_on']         : $dzRes['show_banner'];
		$dzRes['archive_page_banner_style'] = isset($options['archive_page_banner_style']) ? $options['archive_page_banner_style']   : $dzRes['page_general_banner_style'];
		$dzRes['banner_height']             = !empty($options['archive_page_banner_height']) ? $options['archive_page_banner_height'] : $dzRes['banner_height'];
		$dzRes['dont_use_banner_image']     = !empty($options['archive_page_banner_hide']) ? $options['archive_page_banner_hide']    : '0';


		$dzRes['banner_custom_height'] = !empty($options['archive_page_banner_custom_height']) ? $options['archive_page_banner_custom_height'] : $dzRes['banner_custom_height'];

		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($options['archive_page_banner']) ? clinicmaster_set($options['archive_page_banner'], 'url', $dzRes['banner_image']) : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End Page banner setting */

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($options['archive_page_show_sidebar']) ? $options['archive_page_show_sidebar'] : true;
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($options['archive_page_sidebar_layout']) ? $options['archive_page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($options['archive_page_sidebar']) ? $options['archive_page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */
		$pagination = !empty($options['archive_page_paging']) ? $options['archive_page_paging'] : $dzRes['disable_ajax_pagination'];
		$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
	}

	/* tag.php */
	if (is_tag()) {
		$options['tag_page_banner'] = '';
		$dzRes['page_title'] = !empty($options['tag_page_title']) ? $options['tag_page_title'] : esc_html__('Tag : ', 'clinicmaster');

		/* Tag banner setting */
		$dzRes['show_banner'] = isset($options['tag_page_banner_on']) ? $options['tag_page_banner_on'] : $dzRes['show_banner'];
		$dzRes['banner_height'] = !empty($options['tag_page_banner_height']) ? $options['tag_page_banner_height'] : $dzRes['banner_height'];
		$dzRes['dont_use_banner_image'] = !empty($options['tag_page_banner_hide']) ? $options['tag_page_banner_hide'] : '0';
		$dzRes['tag_page_banner_style'] = isset($options['tag_page_banner_style']) ? $options['tag_page_banner_style'] : $dzRes['page_general_banner_style'];
		$dzRes['banner_custom_height'] = !empty($options['tag_page_banner_custom_height']) ? $options['tag_page_banner_custom_height'] : $dzRes['banner_custom_height'];

		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($options['tag_page_banner']) ? !empty($options['tag_page_banner']['url']) ? $options['tag_page_banner']['url'] : $dzRes['banner_image'] : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End Tag banner setting */

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($options['tag_page_show_sidebar']) ? $options['tag_page_show_sidebar'] : true;
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($options['tag_page_sidebar_layout']) ? $options['tag_page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($options['tag_page_sidebar']) ? $options['tag_page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */

		$pagination = !empty($options['tag_page_paging']) ? $options['tag_page_paging'] : $dzRes['disable_ajax_pagination'];
		$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
	}

	/* author.php */
	if (is_author()) {
		$options['author_page_banner'] = '';
		$dzRes['page_title'] = !empty($options['author_page_title']) ? $options['author_page_title'] : esc_html__('Author : ', 'clinicmaster');
		$dzRes['page_title'] = $dzRes['page_title'] . get_the_author_meta('display_name');
		$dzRes['author_page_banner_style'] = isset($options['author_page_banner_style']) ? $options['author_page_banner_style'] : $dzRes['page_general_banner_style'];
		/* Tag banner setting */

		$dzRes['show_banner'] = isset($options['author_page_banner_on']) ? $options['author_page_banner_on'] : $dzRes['show_banner'];

		$dzRes['banner_height'] = !empty($options['author_page_banner_height']) ? $options['author_page_banner_height'] : $dzRes['banner_height'];
		$dzRes['dont_use_banner_image'] = !empty($options['author_page_banner_hide']) ? $options['author_page_banner_hide'] : '0';
		$dzRes['banner_custom_height'] = !empty($options['author_page_banner_custom_height']) ? $options['author_page_banner_custom_height'] : $dzRes['banner_custom_height'];


		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($options['author_page_banner']) ? clinicmaster_set($options['author_page_banner'], 'url', $dzRes['banner_image']) : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End Tag banner setting */

		$dzRes['show_banner'] = !empty($options['author_page_banner_on']) ? $options['author_page_banner_on'] : $dzRes['show_banner'];
		if ($dzRes['show_banner'] == true) {
			$dzRes['banner_height'] = !empty($options['author_page_banner_height']) ? $options['author_page_banner_height'] : $dzRes['banner_height'];
			$dzRes['banner_image'] = isset($options['author_page_banner']['url']) ? $options['author_page_banner']['url'] : $dzRes['banner_image'];
			$dzRes['dont_use_banner_image'] = !empty($options['author_page_banner_hide']) ? $options['author_page_banner_hide'] : '0';
		}

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($options['author_page_show_sidebar']) ? $options['author_page_show_sidebar'] : true;
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($options['author_page_sidebar_layout']) ? $options['author_page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($options['author_page_sidebar']) ? $options['author_page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */

		$pagination = !empty($options['author_page_paging']) ? $options['author_page_paging'] : $dzRes['disable_ajax_pagination'];
		$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
	}

	/* index.php */
	if (is_home()) {
		$dzRes['page_title'] = !empty($options['blog_page_title']) ? $options['blog_page_title'] : esc_html__('ClinicMaster Personal Blog', 'clinicmaster');
	}

	/* search.php */
	if (is_search()) {
		$options['search_page_banner'] = '';
		$dzRes['page_title'] = !empty($options['search_page_title']) ? $options['search_page_title'] : esc_html__('Search : ', 'clinicmaster');
		/* Search banner setting */
		$dzRes['show_banner'] = isset($options['search_page_banner_on']) ? $options['search_page_banner_on'] : $dzRes['show_banner'];
		$dzRes['banner_height'] = !empty($options['search_page_banner_height']) ? $options['search_page_banner_height'] : $dzRes['banner_height'];
		$dzRes['dont_use_banner_image'] = !empty($options['search_page_banner_hide']) ? $options['search_page_banner_hide'] : '0';
		$dzRes['search_page_banner_style'] = isset($options['search_page_banner_style']) ? $options['search_page_banner_style'] : $dzRes['page_general_banner_style'];
		$dzRes['banner_custom_height'] = !empty($options['search_page_banner_custom_height']) ? $options['search_page_banner_custom_height'] : $dzRes['banner_custom_height'];


		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($options['search_page_banner']) ? clinicmaster_set($options['search_page_banner'], 'url', $dzRes['banner_image']) : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End Search banner setting */

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($options['search_page_show_sidebar']) ? $options['search_page_show_sidebar'] : true;
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($options['search_page_sidebar_layout']) ? $options['search_page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($options['search_page_sidebar']) ? $options['search_page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */

		$pagination = !empty($options['search_page_paging']) ? $options['search_page_paging'] : $dzRes['disable_ajax_pagination'];
		$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
	}

	if (is_page() || is_archive() || is_tag() || is_author() || is_home() || is_search() || is_404()) {

		$dzRes['banner_class'] = '';
		if ($dzRes['header_style'] == 'header_2') {
			$dzRes['banner_class'] .= ' tp-banner';
		}

		if (isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_big') {
			$dzRes['banner_class'] .= 'dlab-bnr-inr-lg';
		} elseif (isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_medium') {
			$dzRes['banner_class'] .= 'dlab-bnr-inr-md';
		}

		$dzRes['page_banner_style_attr'] = !empty($dzRes['banner_image']) ? 'background-image:url(' . esc_url($dzRes['banner_image']) . ')' : '';

		$dzRes['container_class'] = (!is_active_sidebar($dzRes['sidebar']) || $dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true) ? 'min-container' : 'container';
		$dzRes['layout_class'] = (!is_active_sidebar($dzRes['sidebar']) || $dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true || !clinicmaster_is_theme_sidebar_active()) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
	}

	/* category.php */
	if (is_category()) {
		$options['category_page_banner'] = '';
		$dzRes['banner_height'] = '';
		$dzRes['dont_use_banner_image'] = 0;
		$dzRes['page_title'] = !empty($options['category_page_title']) ? $options['category_page_title'] : esc_html__('Category : ', 'clinicmaster');
		$dzRes['category_page_banner_style'] = isset($options['category_page_banner_style']) ? $options['category_page_banner_style'] : $dzRes['page_general_banner_style'];
		/* Search banner setting */
		$dzRes['show_banner'] = isset($options['category_page_banner_on']) ? $options['category_page_banner_on'] : $dzRes['show_banner'];
		$dzRes['banner_height'] = !empty($options['category_page_banner_height']) ? $options['category_page_banner_height'] : $dzRes['banner_height'];
		$dzRes['dont_use_banner_image'] = !empty($options['category_page_banner_hide']) ? $options['category_page_banner_hide'] : '0';
		$dzRes['banner_custom_height'] = !empty($options['category_page_banner_custom_height']) ? $options['category_page_banner_custom_height'] : $dzRes['banner_custom_height'];


		if ($dzRes['dont_use_banner_image'] == 0) {
			$dzRes['banner_image'] = isset($options['category_page_banner']) ? clinicmaster_set($options['category_page_banner'], 'url', $dzRes['banner_image']) : $dzRes['banner_image'];
		} else {
			$dzRes['banner_image'] = '';
		}
		/* End Search banner setting */

		/* Sidebar and there layout */
		$dzRes['show_sidebar'] = isset($options['category_page_show_sidebar']) ? $options['category_page_show_sidebar'] : true;
		if ($dzRes['show_sidebar']) {
			$dzRes['layout'] = !empty($options['category_page_sidebar_layout']) ? $options['category_page_sidebar_layout'] : $dzRes['layout'];
			$dzRes['sidebar'] = !empty($options['category_page_sidebar']) ? $options['category_page_sidebar'] : $dzRes['sidebar'];
		}
		/* End Sidebar and there layout */

		/* To manage Category Page banner and layout settings */
		$dzRes['banner_class'] = '';
		if ($dzRes['header_style'] == 'header_2') {
			$dzRes['banner_class'] .= ' tp-banner';
		}

		if (isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_big') {
			$dzRes['banner_class'] .= 'dlab-bnr-inr-lg';
		} elseif (isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_medium') {
			$dzRes['banner_class'] .= 'dlab-bnr-inr-md';
		}

		$dzRes['page_banner_style_attr'] = !empty($dzRes['banner_image']) ? 'background-image:url(' . esc_url($dzRes['banner_image']) . ')' : '';

		$dzRes['container_class'] = (!is_active_sidebar($dzRes['sidebar']) || $dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true) ? 'min-container' : 'container';
		$dzRes['layout_class'] = (!is_active_sidebar($dzRes['sidebar']) || $dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true || !clinicmaster_is_theme_sidebar_active()) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
		/* End To manage Category Page banner and layout settings */

		$pagination = !empty($options['category_page_paging']) ? $options['category_page_paging'] : $dzRes['disable_ajax_pagination'];
		$dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
		/* all other variable will manage on category page from db. */
	}

	if (is_404()) {
		$dzRes['error_page_image'] = !empty($options['error_page_image']['url']) ? $options['error_page_image']['url'] : '';
		$dzRes['error_page_pattern_image'] = !empty($options['error_page_pattern_image']['url']) ? $options['error_page_pattern_image']['url'] : '';
		$dzRes['error_page_template'] = !empty($options['error_page_template']) ? $options['error_page_template'] : 'error_style_1';
		$dzRes['error_page_title'] = !empty($options['error_page_title']) ? $options['error_page_title'] : esc_html__('404', 'clinicmaster');
		$dzRes['error_page_subtitle'] = !empty($options['error_page_subtitle']) ? $options['error_page_subtitle'] : esc_html__('We are sorry. But the page you are looking for cannot be found.', 'clinicmaster');
		$dzRes['error_page_button_text'] = !empty($options['error_page_button_text']) ? $options['error_page_button_text'] : esc_html__('Back to Homepage', 'clinicmaster');
	}



	

	/* Set All Option Values to Global Variable */
	$clinicmaster_option = $dzRes;



	if ($clinicmaster_option['website_status'] != 'live_mode' && !is_home() && !is_front_page() && !is_user_logged_in()) {
		wp_redirect(home_url('/'));
	}
}
function clinicmaster_enqueue_scripts()
{
	$options = clinicmaster_dzbase()->option();
	$skin = !empty($options['predefined_color_skin']) ? $options['predefined_color_skin'] : 'skin_1';
	
	$color_skin_setting = !empty($options['color_skin_setting']) ? $options['color_skin_setting'] : 'predefined_color_skin';

	/* style */
	
	
	
	wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.css');
	wp_enqueue_style('swiper-bundle', get_template_directory_uri() . '/assets/css/swiper-bundle-min.css');
	wp_enqueue_style('bootstrap-select', get_template_directory_uri() . '/assets/css/bootstrap-select-min.css');
	wp_enqueue_style('twentytwenty', get_template_directory_uri() . '/assets/css/twentytwenty.css');
	wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup-min.css');
	wp_enqueue_style('tempus-dominus', get_template_directory_uri() . '/assets/css/tempus-dominus-min.css');
	wp_enqueue_style('lightgallery', get_template_directory_uri() . '/assets/css/lightgallery.css');
	wp_enqueue_style('lg-thumbnail', get_template_directory_uri() . '/assets/css/lg-thumbnail.css');
	wp_enqueue_style('lg-zoom', get_template_directory_uri() . '/assets/css/lg-zoom.css');
	wp_enqueue_style('iconfont', get_template_directory_uri() . '/assets/css/iconfont.css');
	wp_enqueue_style('font-awesome-4-shims', get_template_directory_uri() . '/assets/css/font-awesome-min.css');
	wp_enqueue_style('dzmaster-clinicmaster', get_template_directory_uri() . '/assets/css/dzmaster-clinicmaster.css');
	wp_enqueue_style('line-awesome', get_template_directory_uri() . '/assets/css/line-awesome-min.css');
	
	

	if (is_child_theme()) {
		wp_enqueue_style('clinicmaster-parent-style', get_template_directory_uri() . '/style.css');
		wp_enqueue_style('clinicmaster-main-style', get_stylesheet_uri());
	} else {
		wp_enqueue_style('clinicmaster-main-style', get_stylesheet_uri());
	}
	
	wp_enqueue_style('clinicmaster-style', get_template_directory_uri() . '/assets/css/style.css');
	
	wp_enqueue_style('clinicmaster-custom', get_template_directory_uri() . '/assets/css/custom.css');
	
	if($color_skin_setting == 'predefined_color_skin'){
		wp_enqueue_style( 'clinicmaster-skin', get_template_directory_uri() . '/assets/css/skin/'.$skin.'.css' );
	}else{
		wp_enqueue_style( 'clinicmaster-skin', get_template_directory_uri() . '/assets/css/skin/theme.css' );
	}

	/* scripts */
	wp_enqueue_script('jquery-ui-core');


	


	wp_enqueue_script('dz-global', get_template_directory_uri() . '/assets/js/dz-global.js', array('jquery'), '1.0', true);
	wp_enqueue_script('bootstrap-touchspin', get_template_directory_uri() . '/assets/js/bootstrap-touchspin.js', array('jquery'), '1.0', true);
	wp_enqueue_script('swiper-bundle', get_template_directory_uri() . '/assets/js/swiper-bundle-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('imagesloaded', '', array(), false, true); /* Pre-packaged Library */
	wp_enqueue_script('isotope-pkgd', get_template_directory_uri() . '/assets/js/isotope-pkgd-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('jquery-event-move', get_template_directory_uri() . '/assets/js/jquery-event-move.js', array('jquery'), '1.0', true);
	wp_enqueue_script('jquery-twentytwenty', get_template_directory_uri() . '/assets/js/jquery-twentytwenty.js', array('jquery'), '1.0', true);
	wp_enqueue_script('popper', get_template_directory_uri() . '/assets/js/popper-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('tempus-dominus', get_template_directory_uri() . '/assets/js/tempus-dominus-min.js', array('jquery'), '6.4.3', true);
	wp_enqueue_script('wNumb', get_template_directory_uri() . '/assets/js/wnumb.js', array('jquery'), '1.0', true);
	wp_enqueue_script('jquery-countdown', get_template_directory_uri() . '/assets/js/jquery-countdown.js', array('jquery'), '1.0', true);
	wp_enqueue_script('lightgallery', get_template_directory_uri() . '/assets/js/lightgallery-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('lg-thumbnail', get_template_directory_uri() . '/assets/js/lg-thumbnail-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('lg-zoom', get_template_directory_uri() . '/assets/js/lg-zoom-min.js', array('jquery'), '1.0', true);
	wp_enqueue_script('apexchart', get_template_directory_uri() . '/assets/js/apexchart.js', array('jquery'), '1.0', true);
	wp_enqueue_script('init-apexchart', get_template_directory_uri() . '/assets/js/init-apexchart.js', array('jquery'), '1.0', true);
	
	

	wp_enqueue_script('clinicmaster-custom', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true);

	wp_enqueue_script('clinicmaster-wp-script', get_template_directory_uri() . '/assets/js/wp-script.js', array('jquery'), '1.0', true);
	wp_enqueue_script('clinicmaster-dz-carousel', get_template_directory_uri() . '/assets/js/dz-carousel.js', array('jquery'), '1.0', true);
	
	
	
	if (is_singular()) wp_enqueue_script('comment-reply');
}

add_action('wp_enqueue_scripts', 'clinicmaster_enqueue_scripts');

/*--------------------------------------------------------------*/


/**
 * Enqueue Scripts on plugin
 */
add_action('admin_enqueue_scripts', 'clinicmaster_admin_script');

/**
 * Function register admin on plugin
 */
function clinicmaster_admin_script()
{
	if (is_admin()) {
		wp_enqueue_style('admin-style', get_template_directory_uri() . '/dz-inc/admin/css/admin.css', array(), '1.0.0');
		wp_enqueue_style('admin-font-awesome', get_template_directory_uri() . '/dz-inc/admin/css/font-awesome-min.css', array(), '4.7.0');
		wp_enqueue_style('dz-icon', get_template_directory_uri() . '/assets/css/dz-icon.css');
		
	}
}

function clinicmaster_theme_slug_fonts_url()
{
	$fonts_url = '';
	/* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
	$Poppins = _x('on', 'Poppins font: on or off', 'clinicmaster');
	

	$font_families = array();

	if ('off' !== $Poppins) {
		$font_families[] = 'Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	}
	


	$font_families = array_unique($font_families);

	$font_url_string = '';
	foreach ($font_families as $font_family) {
		$font_url_string .= $font_family;
	}

	$query_args = array(
		'family' => $font_url_string,
		'display' => 'swap',
	);

	$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css2');

	return esc_url_raw($fonts_url);
}

function clinicmaster_theme_slug_scripts_styles()
{
	wp_enqueue_style('clinicmaster-theme-slug-fonts', clinicmaster_theme_slug_fonts_url(), array(), null);
}
add_action('wp_enqueue_scripts', 'clinicmaster_theme_slug_scripts_styles');

function clinicmaster_add_editor_styles()
{
	add_editor_style('custom-editor-style.css');
}
add_action('admin_init', 'clinicmaster_add_editor_styles');


function clinicmaster_setup_theme_supported_features()
{
	add_theme_support('editor-color-palette', array(
		array(
			'name' => esc_html__('strong magenta', 'clinicmaster'),
			'slug' => 'strong-magenta',
			'color' => '#a156b4',
		),
		array(
			'name' => esc_html__('light grayish magenta', 'clinicmaster'),
			'slug' => 'light-grayish-magenta',
			'color' => '#d0a5db',
		),
		array(
			'name' => esc_html__('very light gray', 'clinicmaster'),
			'slug' => 'very-light-gray',
			'color' => '#eee',
		),
		array(
			'name' => esc_html__('very dark gray', 'clinicmaster'),
			'slug' => 'very-dark-gray',
			'color' => '#444',
		),
	));
}

add_action('after_setup_theme', 'clinicmaster_setup_theme_supported_features');

/*js Template Path */
function clinicmaster_set_js_var()
{

	global $clinicmaster_option;


	$theme_options 	= clinicmaster_get_theme_option();

	
	$header_style = $footer_style = $page_banner_layout = $skin = '';
	$skin = !empty($theme_options['predefined_color_skin']) ? $theme_options['predefined_color_skin'] : 'skin_1';
	$skin_data =	str_replace("_","-",$skin);
	
	$js_data_array = array(
		'template_directory_uri' => get_template_directory_uri(),
		'admin_ajax_url' => admin_url('admin-ajax.php'),
		'ajax_security_nonce' => wp_create_nonce('ajax_security_key'),
		'header_style' => $header_style,
		'footer_style' => $footer_style,
		'page_banner_layout' => $page_banner_layout,
		'skin' => $skin_data,

	);
	wp_localize_script('jquery', 'clinicmaster_js_data', $js_data_array);
}
add_action('wp_enqueue_scripts', 'clinicmaster_set_js_var');

function clinicmaster_load_admin_things()
{
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
}
add_action('admin_enqueue_scripts', 'clinicmaster_load_admin_things');


function clinicmaster_get_attachment($attachment_id)
{
	$attachment = get_post($attachment_id);
	return array(
		'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
		'caption' => $attachment->post_excerpt,
		'description' => $attachment->post_content,
		'href' => get_permalink($attachment->ID),
		'src' => $attachment->guid,
		'title' => $attachment->post_title
	);
}

function clinicmaster_website_status()
{

	$website_status = clinicmaster_get_opt('website_status');

	if ($website_status == 'comingsoon_mode' && !is_user_logged_in()) {
		get_template_part('dz-inc/elements/comingsoon/comingsoon_1');
	} elseif ($website_status == 'maintenance_mode' && !is_user_logged_in()) {
		get_template_part('dz-inc/elements/maintinance/maintinance_1');
	}
}
add_action('clinicmaster_website_status', 'clinicmaster_website_status');

//Remove Gutenberg Block Library CSS from loading on the frontend
function clinicmaster_remove_wp_block_library_css()
{
	wp_dequeue_style('wp-block-library-theme');
}
add_action('wp_enqueue_scripts', 'clinicmaster_remove_wp_block_library_css', 100);

add_filter('body_class', function (array $classes) {
	if (in_array('post', $classes)) {
		unset($classes[array_search('post', $classes)]);
	}
	if (in_array('page', $classes)) {
		unset($classes[array_search('page', $classes)]);
	}
	return $classes;
});
